/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvMemStorage;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvMemStorage
extends Pointer {
    public AbstractCvMemStorage(Pointer p) {
        super(p);
    }

    public static CvMemStorage create(int block_size) {
        CvMemStorage m = opencv_core.cvCreateMemStorage(block_size);
        if (m != null) {
            m.deallocator(new ReleaseDeallocator(m));
        }
        return m;
    }

    public static CvMemStorage create() {
        return AbstractCvMemStorage.create(0);
    }

    public void release() {
        this.deallocate();
    }

    static {
        Loader.load();
    }

    protected static class ReleaseDeallocator
    extends CvMemStorage
    implements Pointer.Deallocator {
        ReleaseDeallocator(CvMemStorage p) {
            super(p);
        }

        public void deallocate() {
            opencv_core.cvReleaseMemStorage(this);
        }
    }
}

