/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.WeightedPattern;
import net.algart.math.patterns.WeightedPatterns;
import net.algart.matrices.linearfiltering.Convolution;

public enum DerivativeOperation {
    DX_PAIR(0, 0, 1, 0, new double[]{1.0, -1.0}),
    DY_PAIR(0, 0, 0, 1, new double[]{1.0, -1.0}),
    DX(-1, 0, 1, 0, new double[]{0.5, 0.0, -0.5}),
    DY(0, -1, 0, 1, new double[]{0.5, 0.0, -0.5}),
    SOBEL_X(-1, -1, 1, 1, new double[]{1.0, 0.0, -1.0, 2.0, 0.0, -2.0, 1.0, 0.0, -1.0}),
    SOBEL_Y(-1, -1, 1, 1, new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0}),
    SCALED_SOBEL_X(-1, -1, 1, 1, new double[]{0.125, 0.0, -0.125, 0.25, 0.0, -0.25, 0.125, 0.0, -0.125}),
    SCALED_SOBEL_Y(-1, -1, 1, 1, new double[]{0.125, 0.25, 0.125, 0.0, 0.0, 0.0, -0.125, -0.25, -0.125}),
    SCHARR_X(-1, -1, 1, 1, new double[]{3.0, 0.0, -3.0, 10.0, 0.0, -10.0, 3.0, 0.0, -3.0}),
    SCHARR_Y(-1, -1, 1, 1, new double[]{3.0, 10.0, 3.0, 0.0, 0.0, 0.0, -3.0, -10.0, -3.0}),
    SCALED_SCHARR_X(-1, -1, 1, 1, new double[]{0.09375, 0.0, -0.09375, 0.3125, 0.0, -0.3125, 0.09375, 0.0, -0.09375}),
    SCALED_SCHARR_Y(-1, -1, 1, 1, new double[]{0.09375, 0.3125, 0.09375, 0.0, 0.0, 0.0, -0.09375, -0.3125, -0.09375}),
    ROBERTS_CROSS_QUADRANT_1(0, 0, 1, 1, new double[]{1.0, 0.0, 0.0, -1.0}),
    ROBERTS_CROSS_QUADRANT_2(0, 0, 1, 1, new double[]{0.0, 1.0, -1.0, 0.0}),
    SCALED_ROBERTS_CROSS_QUADRANT_1(0, 0, 1, 1, new double[]{1.0 / StrictMath.sqrt(2.0), 0.0, 0.0, -1.0 / StrictMath.sqrt(2.0)}),
    SCALED_ROBERTS_CROSS_QUADRANT_2(0, 0, 1, 1, new double[]{0.0, 1.0 / StrictMath.sqrt(2.0), -1.0 / StrictMath.sqrt(2.0), 0.0}),
    D2_DX2(-1, 0, 1, 0, new double[]{1.0, -2.0, 1.0}),
    D2_DY2(0, -1, 0, 1, new double[]{1.0, -2.0, 1.0}),
    D2_DXDY(-1, -1, 1, 1, new double[]{0.25, 0.0, -0.25, 0.0, 0.0, 0.0, -0.25, 0.0, 0.25}),
    LAPLACIAN(-1, -1, 1, 1, new double[]{0.0, 1.0, 0.0, 1.0, -4.0, 1.0, 0.0, 1.0, 0.0});

    private final WeightedPattern weightedPattern;

    private DerivativeOperation(int minX, int minY, int maxX, int maxY, double[] weights) {
        this.weightedPattern = WeightedPatterns.newPattern((Pattern)Patterns.newRectangularIntegerPattern((IPoint)IPoint.of((long)minX, (long)minY), (IPoint)IPoint.of((long)maxX, (long)maxY)), (double[])weights);
    }

    public <T extends PArray> Matrix<? extends T> process(Class<? extends T> requiredType, Convolution convolution, Matrix<? extends PArray> matrix) {
        return convolution.convolution(requiredType, matrix, this.weightedPattern);
    }
}

