/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.executors.modules.cv.matrices.derivatives.CombiningMatricesMetric;
import net.algart.executors.modules.cv.matrices.derivatives.DerivativeOperation;
import net.algart.executors.modules.cv.matrices.derivatives.GradientOperation;
import net.algart.executors.modules.cv.matrices.derivatives.MultichannelDerivativesFilter;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class Gradient
extends MultichannelDerivativesFilter {
    public static final String OUTPUT_DX = "dx";
    public static final String OUTPUT_DY = "dy";
    private GradientOperation operation = GradientOperation.SIMPLE_PAIR;
    private CombiningMatricesMetric combiningDerivativesMetric = CombiningMatricesMetric.NORMALIZED_EUCLIDEAN;
    private MultiMatrix2D gradientDX = null;
    private MultiMatrix2D gradientDY = null;
    private MultiMatrix2D gradientMagnitude = null;

    public Gradient() {
        this.addOutputMat(OUTPUT_DX);
        this.addOutputMat(OUTPUT_DY);
    }

    public GradientOperation getOperation() {
        return this.operation;
    }

    public void setOperation(GradientOperation operation) {
        this.operation = (GradientOperation)((Object)Gradient.nonNull((Object)((Object)operation)));
    }

    public CombiningMatricesMetric getCombiningDerivativesMetric() {
        return this.combiningDerivativesMetric;
    }

    public void setCombiningDerivativesMetric(CombiningMatricesMetric combiningDerivativesMetric) {
        Gradient.nonNull((Object)((Object)combiningDerivativesMetric));
        if (combiningDerivativesMetric.isSingleChannel()) {
            throw new IllegalArgumentException("Cannot use single-channel metric for combining x/y-derivatives");
        }
        this.combiningDerivativesMetric = combiningDerivativesMetric;
    }

    public MultiMatrix2D gradientDX() {
        return this.gradientDX;
    }

    public MultiMatrix2D gradientDY() {
        return this.gradientDY;
    }

    public MultiMatrix2D magnitude() {
        return this.gradientMagnitude;
    }

    @Override
    public MultiMatrix2D process(MultiMatrix2D source) {
        source = this.preprocess(source);
        List sourceChannels = source.allChannels();
        ArrayList<Matrix<? extends PArray>> processed = new ArrayList<Matrix<? extends PArray>>();
        ArrayList<Matrix<? extends PArray>> additionalResult1 = new ArrayList<Matrix<? extends PArray>>();
        ArrayList<Matrix<? extends PArray>> additionalResult2 = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix sourceChannel : sourceChannels) {
            processed.add(this.processChannel((Matrix<? extends PArray>)sourceChannel, additionalResult1, additionalResult2));
        }
        this.gradientMagnitude = MultiMatrix.of2DMono(this.combineResult(source.arrayType(), processed));
        this.gradientDX = MultiMatrix.of2DMono(this.combineResult(source.arrayType(), additionalResult1));
        this.gradientDY = MultiMatrix.of2DMono(this.combineResult(source.arrayType(), additionalResult2));
        this.getMat(OUTPUT_DX).setTo((MultiMatrix)this.gradientDX);
        this.getMat(OUTPUT_DY).setTo((MultiMatrix)this.gradientDY);
        return this.gradientMagnitude;
    }

    private Matrix<? extends PFloatingArray> processChannel(Matrix<? extends PArray> m, List<Matrix<? extends PArray>> additionalResult1, List<Matrix<? extends PArray>> additionalResult2) {
        Class<? extends PFloatingArray> requiredType = Gradient.floatingType(m.elementType());
        ArrayList<Matrix<? extends PArray>> derivatives = new ArrayList<Matrix<? extends PArray>>();
        for (DerivativeOperation derivativeOperation : this.operation.derivatives()) {
            derivatives.add(derivativeOperation.process(requiredType, this.createConvolution(), m));
        }
        assert (derivatives.size() >= 2);
        additionalResult1.add((Matrix<? extends PArray>)((Matrix)derivatives.get(0)));
        additionalResult2.add((Matrix<? extends PArray>)((Matrix)derivatives.get(1)));
        return this.combiningDerivativesMetric.combine(requiredType, derivatives, new double[0], 1.0);
    }
}

