/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator1Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator2Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator3Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator4Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator5Channels;

abstract class CardinalitiesAndSumsOfSquaresCalculator
extends CardinalitiesAndSumsCalculator {
    final double[][][] threadSumsOfSquares;
    private final double[][][] requestedSumsOfSquares;
    double[] sumsOfSquares;

    CardinalitiesAndSumsOfSquaresCalculator(int[] labels, int numberOfChannels) {
        super(labels, numberOfChannels);
        this.requestedSumsOfSquares = CardinalitiesAndSumsOfSquaresCalculator.requestClearedDoubleArrays(this.numberOfTasks(), numberOfChannels);
        this.threadSumsOfSquares = new double[this.requestedSumsOfSquares.length][][];
        for (int k = 0; k < this.requestedSumsOfSquares.length; ++k) {
            this.threadSumsOfSquares[k] = (double[][])this.requestedSumsOfSquares[k].clone();
        }
    }

    static CardinalitiesAndSumsOfSquaresCalculator getInstance(int[] labels, Object[] channels) {
        Objects.requireNonNull(labels, "Null labels");
        Objects.requireNonNull(channels, "Null channels");
        if (channels.length == 0) {
            throw new IllegalArgumentException("Empty channels array");
        }
        Object channel0 = channels[0];
        if (!CardinalitiesAndSumsOfSquaresCalculator.isArraySupported(channel0)) {
            throw new IllegalArgumentException("Illegal array type: " + String.valueOf(channel0));
        }
        for (int k = 1; k < channels.length; ++k) {
            if (channels[k].getClass() == channel0.getClass()) continue;
            throw new IllegalArgumentException("Different type of channels: " + String.valueOf(channels[k].getClass()) + " != " + String.valueOf(channel0.getClass()));
        }
        switch (channels.length) {
            case 1: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator1Channels.ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator1Channels.ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator1Channels.ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator1Channels.ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator1Channels.ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 2: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator2Channels.ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator2Channels.ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator2Channels.ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator2Channels.ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator2Channels.ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 3: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator3Channels.ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator3Channels.ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator3Channels.ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator3Channels.ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator3Channels.ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 4: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator4Channels.ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator4Channels.ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator4Channels.ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator4Channels.ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator4Channels.ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 5: {
                if (channel0 instanceof byte[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator5Channels.ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator5Channels.ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator5Channels.ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator5Channels.ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new CardinalitiesAndSumsOfSquaresCalculator5Channels.ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
                }
                throw new AssertionError();
            }
        }
        if (channel0 instanceof byte[]) {
            return new ForBytes(labels, CardinalitiesAndSumsOfSquaresCalculator.castToByte(channels));
        }
        if (channel0 instanceof short[]) {
            return new ForShorts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToShort(channels));
        }
        if (channel0 instanceof int[]) {
            return new ForInts(labels, CardinalitiesAndSumsOfSquaresCalculator.castToInt(channels));
        }
        if (channel0 instanceof float[]) {
            return new ForFloats(labels, CardinalitiesAndSumsOfSquaresCalculator.castToFloat(channels));
        }
        if (channel0 instanceof double[]) {
            return new ForDoubles(labels, CardinalitiesAndSumsOfSquaresCalculator.castToDouble(channels));
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        super.close();
        CardinalitiesAndSumsOfSquaresCalculator.releaseAndClearDoubleArrays(this.requestedSumsOfSquares, this.maxLabel + 1);
    }

    @Override
    protected void finish() {
        super.finish();
        this.sumsOfSquares = new double[this.numberOfChannels * this.maxLabel];
        for (double[][] sumsOfSquares : this.threadSumsOfSquares) {
            for (int c = 0; c < this.numberOfChannels; ++c) {
                if (sumsOfSquares[c].length != sumsOfSquares[0].length) {
                    throw new AssertionError((Object)"Different sums-of-squares length for different channels!");
                }
                int length = Math.min(this.maxLabel, sumsOfSquares[c].length - 1);
                int k = 1;
                int disp = c;
                while (k <= length) {
                    int n = disp;
                    this.sumsOfSquares[n] = this.sumsOfSquares[n] + sumsOfSquares[c][k];
                    ++k;
                    disp += this.numberOfChannels;
                }
            }
        }
    }

    private static class ForBytes
    extends CardinalitiesAndSumsOfSquaresCalculator {
        private final byte[][] data;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double value = this.data[c][k] & 0xFF;
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = sumsOfSquares[c];
                    int n3 = label;
                    dArray2[n3] = dArray2[n3] + value * value;
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForShorts
    extends CardinalitiesAndSumsOfSquaresCalculator {
        private final short[][] data;

        public ForShorts(int[] labels, short[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double value = this.data[c][k] & 0xFFFF;
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = sumsOfSquares[c];
                    int n3 = label;
                    dArray2[n3] = dArray2[n3] + value * value;
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForInts
    extends CardinalitiesAndSumsOfSquaresCalculator {
        private final int[][] data;

        public ForInts(int[] labels, int[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double value = this.data[c][k];
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = sumsOfSquares[c];
                    int n3 = label;
                    dArray2[n3] = dArray2[n3] + value * value;
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForFloats
    extends CardinalitiesAndSumsOfSquaresCalculator {
        private final float[][] data;

        public ForFloats(int[] labels, float[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double value = this.data[c][k];
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = sumsOfSquares[c];
                    int n3 = label;
                    dArray2[n3] = dArray2[n3] + value * value;
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    private static class ForDoubles
    extends CardinalitiesAndSumsOfSquaresCalculator {
        private final double[][] data;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels, data.length);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                for (int c = 0; c < this.numberOfChannels; ++c) {
                    double value = this.data[c][k];
                    double[] dArray = sums[c];
                    int n2 = label;
                    dArray[n2] = dArray[n2] + value;
                    double[] dArray2 = sumsOfSquares[c];
                    int n3 = label;
                    dArray2[n3] = dArray2[n3] + value * value;
                }
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

