/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

abstract class LabelledObjectsProcessorForFloat2Channels
extends LabelledObjectsProcessorForFloat {
    LabelledObjectsProcessorForFloat2Channels(int[] lists, int[] listHeads, SingleObjectProcessor processor) {
        super(lists, listHeads, processor, 2);
    }

    static class ForDoubles
    extends LabelledObjectsProcessorForFloat2Channels {
        private final double[] data0;
        private final double[] data1;

        public ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                    }
                    objectData0[pixelCount] = (float)this.data0[index];
                    objectData1[pixelCount] = (float)this.data1[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForFloats
    extends LabelledObjectsProcessorForFloat2Channels {
        private final float[] data0;
        private final float[] data1;

        public ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForInts
    extends LabelledObjectsProcessorForFloat2Channels {
        private final int[] data0;
        private final int[] data1;

        public ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForShorts
    extends LabelledObjectsProcessorForFloat2Channels {
        private final short[] data0;
        private final short[] data1;

        public ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                    }
                    objectData0[pixelCount] = this.data0[index] & 0xFFFF;
                    objectData1[pixelCount] = this.data1[index] & 0xFFFF;
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForBytes
    extends LabelledObjectsProcessorForFloat2Channels {
        private final byte[] data0;
        private final byte[] data1;

        public ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                    }
                    objectData0[pixelCount] = this.data0[index] & 0xFF;
                    objectData1[pixelCount] = this.data1[index] & 0xFF;
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

