/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

abstract class LabelledObjectsProcessorForFloat5Channels
extends LabelledObjectsProcessorForFloat {
    LabelledObjectsProcessorForFloat5Channels(int[] lists, int[] listHeads, SingleObjectProcessor processor) {
        super(lists, listHeads, processor, 5);
    }

    static class ForDoubles
    extends LabelledObjectsProcessorForFloat5Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;
        private final double[] data3;
        private final double[] data4;

        public ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = (float)this.data0[index];
                    objectData1[pixelCount] = (float)this.data1[index];
                    objectData2[pixelCount] = (float)this.data2[index];
                    objectData3[pixelCount] = (float)this.data3[index];
                    objectData4[pixelCount] = (float)this.data4[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForFloats
    extends LabelledObjectsProcessorForFloat5Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;
        private final float[] data3;
        private final float[] data4;

        public ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    objectData4[pixelCount] = this.data4[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForInts
    extends LabelledObjectsProcessorForFloat5Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;
        private final int[] data3;
        private final int[] data4;

        public ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = this.data0[index];
                    objectData1[pixelCount] = this.data1[index];
                    objectData2[pixelCount] = this.data2[index];
                    objectData3[pixelCount] = this.data3[index];
                    objectData4[pixelCount] = this.data4[index];
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForShorts
    extends LabelledObjectsProcessorForFloat5Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;
        private final short[] data3;
        private final short[] data4;

        public ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = this.data0[index] & 0xFFFF;
                    objectData1[pixelCount] = this.data1[index] & 0xFFFF;
                    objectData2[pixelCount] = this.data2[index] & 0xFFFF;
                    objectData3[pixelCount] = this.data3[index] & 0xFFFF;
                    objectData4[pixelCount] = this.data4[index] & 0xFFFF;
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForBytes
    extends LabelledObjectsProcessorForFloat5Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;
        private final byte[] data3;
        private final byte[] data4;

        public ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = this.data0[index] & 0xFF;
                    objectData1[pixelCount] = this.data1[index] & 0xFF;
                    objectData2[pixelCount] = this.data2[index] & 0xFF;
                    objectData3[pixelCount] = this.data3[index] & 0xFF;
                    objectData4[pixelCount] = this.data4[index] & 0xFF;
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

