/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.algart.executors.modules.opencv.matrices.ml.MLPredictor;
import net.algart.executors.modules.opencv.matrices.ml.MLStatModelTrainer;
import org.bytedeco.opencv.opencv_ml.ANN_MLP;
import org.bytedeco.opencv.opencv_ml.Boost;
import org.bytedeco.opencv.opencv_ml.NormalBayesClassifier;
import org.bytedeco.opencv.opencv_ml.RTrees;
import org.bytedeco.opencv.opencv_ml.SVM;
import org.bytedeco.opencv.opencv_ml.SVMSGD;
import org.bytedeco.opencv.opencv_ml.StatModel;

public interface MLKind {
    public String modelName();

    public MLPredictor loadPredictor(Path var1) throws IOException;

    public static enum StatModelBased implements MLKind
    {
        ANN_MLP("ANN_MLP", ANN_MLP::load),
        BOOST("Boost", Boost::load),
        R_TREES("RTrees", RTrees::load),
        NORMAL_BAYES_CLASSIFIER("NormalBayesClassifier ", NormalBayesClassifier::load),
        SVM("SVM", SVM::load),
        SVM_SGD("SVM_SGD", SVMSGD::load);

        private final String modelName;
        private final Function<String, StatModel> openCVLoader;

        private StatModelBased(String modelName, Function<String, StatModel> openCVLoader) {
            this.modelName = modelName;
            this.openCVLoader = openCVLoader;
        }

        @Override
        public String modelName() {
            return this.modelName;
        }

        @Override
        public MLPredictor loadPredictor(Path modelFile) throws IOException {
            return MLStatModelTrainer.loadOpenCVTrainer(modelFile, this.openCVLoader, this);
        }

        public String toString() {
            return this.modelName;
        }

        public static Optional<MLKind> of(String modelName) {
            Objects.requireNonNull(modelName, "Null modelName");
            for (StatModelBased kind : StatModelBased.values()) {
                if (!kind.modelName.equals(modelName)) continue;
                return Optional.of(kind);
            }
            return Optional.empty();
        }
    }
}

