/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.util.ConvertibleMat;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.opencv_core.UMat;

public final class ConvertibleUMat
extends SMat.Convertible {
    private volatile UMat mat;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    public ConvertibleUMat(UMat mat) {
        this.mat = Objects.requireNonNull(mat, "Null mat");
    }

    public UMat mat() {
        this.checkMat();
        return this.mat;
    }

    public SMat.Convertible copy() {
        this.checkMat();
        return new ConvertibleUMat(this.mat.clone());
    }

    public SMat.Convertible copyToMemoryAndDisposePrevious() {
        this.checkMat();
        ConvertibleMat result = new ConvertibleMat(OTools.toMat(this.mat));
        this.dispose();
        return result;
    }

    public ByteBuffer toByteBuffer(SMat thisMatrix) {
        this.checkMat();
        return OTools.toByteBuffer(this.mat);
    }

    public void dispose() {
        if (this.disposed.getAndSet(true)) {
            return;
        }
        this.mat.close();
        this.mat = null;
    }

    public String toString() {
        return "reference to " + OTools.toString(this.mat);
    }

    private void checkMat() {
        if (this.disposed.get()) {
            throw new IllegalStateException("mat is already deallocated");
        }
    }
}

