/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.grpc;

import com.siams.stare.api.StareApi;
import com.siams.stare.grpc.StareGrpcFutureStubImpl;
import com.siams.stare.grpc.StareServiceApiV2Grpc;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class StareGrpc {
    public static StareApi create(String host, int port, Consumer<ConnectivityState> channelStageChanged) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)host, (int)port);
        builder.maxInboundMetadataSize(Integer.MAX_VALUE);
        builder.maxInboundMessageSize(Integer.MAX_VALUE);
        builder.usePlaintext();
        builder.idleTimeout(5L, TimeUnit.SECONDS);
        ManagedChannel channel = builder.build();
        channel.getState(true);
        StareGrpc.RegisterStateChanged(channel, channelStageChanged);
        StareServiceApiV2Grpc.StareServiceApiV2Stub stub = StareServiceApiV2Grpc.newStub((Channel)channel);
        return new StareGrpcFutureStubImpl(stub);
    }

    private static void RegisterStateChanged(ManagedChannel channel, Consumer<ConnectivityState> channelStageChanged) {
        channel.notifyWhenStateChanged(channel.getState(true), () -> {
            if (channelStageChanged != null) {
                channelStageChanged.accept(channel.getState(true));
            }
            StareGrpc.RegisterStateChanged(channel, channelStageChanged);
        });
    }
}

