/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.grpc;

import com.google.protobuf.ByteString;
import com.siams.stare.api.Any;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.ObjectStatus;
import com.siams.stare.api.ResourceFilter;
import com.siams.stare.api.StareApi;
import com.siams.stare.grpc.CommandStatusObserver;
import com.siams.stare.grpc.CreateLinkObserver;
import com.siams.stare.grpc.CreateProjectObserver;
import com.siams.stare.grpc.CreateWorkerObserver;
import com.siams.stare.grpc.ExistsObserver;
import com.siams.stare.grpc.GetDataListObserver;
import com.siams.stare.grpc.GetDataObserver;
import com.siams.stare.grpc.GetListStreamObserver;
import com.siams.stare.grpc.GetProjectConfigurationObserver;
import com.siams.stare.grpc.GetProjectConfigurationSettingsObserver;
import com.siams.stare.grpc.MultiplyExistsObserver;
import com.siams.stare.grpc.MultiplyRemoveObserver;
import com.siams.stare.grpc.StareServiceApiV2Grpc;
import com.siams.stare.grpc.VoidObserver;
import com.siams.stare.grpc.message.datatype.GAnyData;
import com.siams.stare.grpc.message.datatype.GElementType;
import com.siams.stare.grpc.message.datatype.GFile;
import com.siams.stare.grpc.message.datatype.GMat;
import com.siams.stare.grpc.message.datatype.GNumbers;
import com.siams.stare.grpc.message.datatype.GResourceFilter;
import com.siams.stare.grpc.message.rqrs2.Command;
import com.siams.stare.grpc.message.rqrs2.CreateLinkRequest;
import com.siams.stare.grpc.message.rqrs2.CreateProjectRequest;
import com.siams.stare.grpc.message.rqrs2.CreateSessionRequest;
import com.siams.stare.grpc.message.rqrs2.CreateSessionResponse;
import com.siams.stare.grpc.message.rqrs2.CreateWorkerRequest;
import com.siams.stare.grpc.message.rqrs2.ExecuteCommandRequest;
import com.siams.stare.grpc.message.rqrs2.ExecuteCommandResponse;
import com.siams.stare.grpc.message.rqrs2.ExistsRequest;
import com.siams.stare.grpc.message.rqrs2.GetDataRequest;
import com.siams.stare.grpc.message.rqrs2.GetListRequest;
import com.siams.stare.grpc.message.rqrs2.GetProjectConfigurationRequest;
import com.siams.stare.grpc.message.rqrs2.GetProjectConfigurationSettingsRequest;
import com.siams.stare.grpc.message.rqrs2.LoadSolutionRequest;
import com.siams.stare.grpc.message.rqrs2.LoadSolutionResponse;
import com.siams.stare.grpc.message.rqrs2.LoadSolutionTemplateRequest;
import com.siams.stare.grpc.message.rqrs2.LoadSolutionTemplateResponse;
import com.siams.stare.grpc.message.rqrs2.RemoveRequest;
import com.siams.stare.grpc.message.rqrs2.SetDataRequest;
import com.siams.stare.grpc.message.rqrs2.SetDataResponse;
import com.siams.stare.grpc.message.rqrs2.UpdateLinkRequest;
import com.siams.stare.grpc.message.rqrs2.UpdateLinkResponse;
import com.siams.stare.grpc.message.rqrs2.UploadProjectConfigurationRequest;
import com.siams.stare.grpc.message.rqrs2.UploadProjectConfigurationResponse;
import com.siams.stare.grpc.message.rqrs2.UploadProjectRequest;
import com.siams.stare.grpc.message.rqrs2.UploadProjectResponse;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;

public class StareGrpcFutureStubImpl
implements StareApi {
    private final Logger logger = Logger.getLogger(StareGrpcFutureStubImpl.class.getName());
    private final StareServiceApiV2Grpc.StareServiceApiV2Stub stub;
    private Function<String, String> urlModifier = null;

    public StareGrpcFutureStubImpl(StareServiceApiV2Grpc.StareServiceApiV2Stub stub) {
        this.stub = stub;
    }

    public void setUrlModifier(Function<String, String> urlModifier) {
        this.urlModifier = urlModifier;
    }

    private String modifyUrlIfNecessary(String url) {
        return this.urlModifier != null ? this.urlModifier.apply(url) : url;
    }

    public CompletableFuture<Void> updateLink(String url, String srcUrl, String dstUrl) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] updateLink, url=%s, srcUrl=%s, dstUrl=%s", url, srcUrl, dstUrl));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.updateLink(UpdateLinkRequest.newBuilder().setUrl(url).setSrcUrl(srcUrl).setDstUrl(dstUrl).build(), new VoidObserver<UpdateLinkResponse>(future));
        return future;
    }

    public CompletableFuture<String> createLink(String url, String srcUrl, String dstUrl) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] createLink, url=%s, srcUrl=%s, dstUrl=%s", url, srcUrl, dstUrl));
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.stub.createLink(CreateLinkRequest.newBuilder().setUrl(url).setSrcUrl(srcUrl).setDstUrl(dstUrl).build(), new CreateLinkObserver(future));
        return future;
    }

    public CompletableFuture<String> createWorker(String url, String modelUrl) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] createWorker, url=%s, modelUrl=%s", url, modelUrl));
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.stub.createWorker(CreateWorkerRequest.newBuilder().setUrl(url).setModelUrl(modelUrl).build(), new CreateWorkerObserver(future));
        return future;
    }

    public CompletableFuture<Void> createSession(String sessionId) {
        this.logger.log(Level.FINE, String.format("[Request] createSession, sessionId=%s", sessionId));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.createSession(CreateSessionRequest.newBuilder().setId(sessionId).build(), new VoidObserver<CreateSessionResponse>(future));
        return future;
    }

    public CompletableFuture<String> createProject(String url) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] createProject, url=%s", url));
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.stub.createProject(CreateProjectRequest.newBuilder().setUrl(url).build(), new CreateProjectObserver(future));
        return future;
    }

    public CompletableFuture<Void> uploadProject(String url, File project) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] uploadProject, url=%s", url));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            byte[] bytes = Files.readAllBytes(project.toPath());
            this.stub.uploadProject(UploadProjectRequest.newBuilder().setUrl(url).setFile(GFile.newBuilder().setData(ByteString.copyFrom((byte[])bytes)).setPath(project.getAbsolutePath()).build()).build(), new VoidObserver<UploadProjectResponse>(future));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Void> loadSolution(String projectUrl, String solutionId) {
        return this.loadSolution(projectUrl, solutionId, "");
    }

    public CompletableFuture<Void> loadSolution(String projectUrl, String solutionId, String solutionTemplateId) {
        projectUrl = this.modifyUrlIfNecessary(projectUrl);
        this.logger.log(Level.FINE, String.format("[Request] loadSolution, projectUrl=%s, solutionId=%s", projectUrl, solutionId));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.stub.loadSolution(LoadSolutionRequest.newBuilder().setProjectUrl(projectUrl).setSolutionId(solutionId).setSolutionTemplateId(solutionTemplateId).build(), new VoidObserver<LoadSolutionResponse>(future));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Void> loadSolutionTemplate(String projectUrl, String solutionTemplateId) {
        projectUrl = this.modifyUrlIfNecessary(projectUrl);
        this.logger.log(Level.FINE, String.format("[Request] loadSolutionTemplate, projectUrl=%s, solutionTemplateId=%s", projectUrl, solutionTemplateId));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.stub.loadSolutionTemplate(LoadSolutionTemplateRequest.newBuilder().setProjectUrl(projectUrl).setSolutionTemplateId(solutionTemplateId).build(), new VoidObserver<LoadSolutionTemplateResponse>(future));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<List<String>> getList(String url) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] getList, url=%s", url));
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.stub.getList(GetListRequest.newBuilder().setUrl(url).build(), new GetListStreamObserver(future));
        return future;
    }

    public CompletableFuture<List<String>> getList(String url, ResourceFilter filter) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] getList, url=%s", url));
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.stub.getList(GetListRequest.newBuilder().setUrl(url).setResourceFilter(GResourceFilter.newBuilder().setModifiedAfter(filter.getModifiedAfter()).build()).build(), new GetListStreamObserver(future));
        return future;
    }

    public CompletableFuture<Boolean> exists(String url) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] exists, url=%s", url));
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.stub.exists(ExistsRequest.newBuilder().addUrl(url).build(), new ExistsObserver(future));
        return future;
    }

    public CompletableFuture<List<Any>> exists(List<String> urls) {
        urls = urls.stream().map(this.urlModifier).collect(Collectors.toList());
        this.logger.log(Level.FINE, String.format("[Request] exists, urls:%d", urls.size()));
        CompletableFuture<List<Any>> future = new CompletableFuture<List<Any>>();
        this.stub.exists(ExistsRequest.newBuilder().addAllUrl(urls).build(), new MultiplyExistsObserver(future));
        return future;
    }

    public CompletableFuture<CommandStatus> executeCommand(String url, com.siams.stare.api.Command command) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] executeCommand, url=%s, command=%s", url, command));
        CompletableFuture<CommandStatus> future = new CompletableFuture<CommandStatus>();
        ExecuteCommandRequest request = ExecuteCommandRequest.newBuilder().addUrl(url).setCommand(Command.valueOf(command.toString())).build();
        this.stub.executeCommand(request, new CommandStatusObserver(future));
        return future;
    }

    public CompletableFuture<Void> executeCommand(List<String> urls, com.siams.stare.api.Command command) {
        urls = urls.stream().map(this.urlModifier).collect(Collectors.toList());
        this.logger.log(Level.FINE, String.format("[Request] executeCommand, urls count=%d, command=%s", urls.size(), command));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.executeCommand(ExecuteCommandRequest.newBuilder().addAllUrl(urls).setCommand(Command.valueOf(command.toString())).build(), new VoidObserver<ExecuteCommandResponse>(future));
        return future;
    }

    public CompletableFuture<List<String>> remove(List<String> urls) {
        urls = urls.stream().map(this.urlModifier).collect(Collectors.toList());
        this.logger.log(Level.FINE, String.format("[Request] remove, urls=%s", String.join((CharSequence)",", urls)));
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.stub.remove(RemoveRequest.newBuilder().addAllUrl(urls).build(), new MultiplyRemoveObserver(future));
        return future;
    }

    public CompletableFuture<List<String>> remove(String url) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] remove, url=%s", url));
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.stub.remove(RemoveRequest.newBuilder().addUrl(url).build(), new MultiplyRemoveObserver(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, boolean data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setBoolVal(data).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, int data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setInt32Val(data).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, double data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setDoubleVal(data).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, long data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setInt64Val(data).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, String data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setStringVal(data).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, byte[] data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=[byte array]", url));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(GAnyData.newBuilder().setUrl(url).setBuffer(ByteString.copyFrom((byte[])data)).build()).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, Object data) {
        url = this.modifyUrlIfNecessary(url);
        if (data instanceof Boolean) {
            return this.setData(url, (Boolean)data);
        }
        if (data instanceof Integer) {
            return this.setData(url, (Integer)data);
        }
        if (data instanceof Double) {
            return this.setData(url, (Double)data);
        }
        if (data instanceof Long) {
            return this.setData(url, (Long)data);
        }
        if (data instanceof SNumbers) {
            return this.setData(url, (SNumbers)data);
        }
        if (data instanceof SMat) {
            return this.setData(url, (SMat)data);
        }
        if (data instanceof String) {
            return this.setData(url, (String)data);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally(new IllegalArgumentException(String.format("Unsupported data type, url: %s, data: %s", url, data)));
        return future;
    }

    private static GElementType toElementType(Class<?> elementType) {
        if (elementType == Byte.TYPE) {
            return GElementType.kByte;
        }
        if (elementType == Short.TYPE) {
            return GElementType.kShort;
        }
        if (elementType == Integer.TYPE) {
            return GElementType.kInt32;
        }
        if (elementType == Long.TYPE) {
            return GElementType.kInt64;
        }
        if (elementType == Float.TYPE) {
            return GElementType.kFloat;
        }
        if (elementType == Double.TYPE) {
            return GElementType.kDouble;
        }
        throw new IllegalArgumentException("The element type " + String.valueOf(elementType) + " is not supported");
    }

    public CompletableFuture<Void> setData(String url, SNumbers data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        GNumbers.Builder gNumbers = GNumbers.newBuilder();
        GElementType gElementType = StareGrpcFutureStubImpl.toElementType(data.elementType());
        switch (gElementType) {
            case kUnknown: {
                break;
            }
            case kByte: {
                gNumbers.setBuffer(ByteString.copyFrom((byte[])((byte[])data.getArray())));
                break;
            }
            case kShort: {
                Object[] array = (short[])data.getArray();
                ByteBuffer buffer = ByteBuffer.allocate(2 * array.length);
                for (short value : array) {
                    buffer.putShort(value);
                }
                buffer.rewind();
                gNumbers.setBuffer(ByteString.copyFrom((ByteBuffer)buffer));
                break;
            }
            case kInt32: {
                Object[] array = (int[])data.getArray();
                ByteBuffer buffer = ByteBuffer.allocate(4 * array.length);
                for (short value : array) {
                    buffer.putInt(value);
                }
                buffer.rewind();
                gNumbers.setBuffer(ByteString.copyFrom((ByteBuffer)buffer));
                break;
            }
            case kInt64: {
                Object[] array = (long[])data.getArray();
                ByteBuffer buffer = ByteBuffer.allocate(8 * array.length);
                for (short value : array) {
                    buffer.putLong(value);
                }
                buffer.rewind();
                gNumbers.setBuffer(ByteString.copyFrom((ByteBuffer)buffer));
                break;
            }
            case kFloat: {
                Object[] array = (float[])data.getArray();
                ByteBuffer buffer = ByteBuffer.allocate(4 * array.length);
                for (short value : array) {
                    buffer.putFloat(value);
                }
                buffer.rewind();
                gNumbers.setBuffer(ByteString.copyFrom((ByteBuffer)buffer));
                break;
            }
            case kDouble: {
                Object[] array = (double[])data.getArray();
                ByteBuffer buffer = ByteBuffer.allocate(8 * array.length);
                for (short value : array) {
                    buffer.putDouble(value);
                }
                buffer.rewind();
                gNumbers.setBuffer(ByteString.copyFrom((ByteBuffer)buffer));
                break;
            }
        }
        gNumbers.setBlockLength(data.getBlockLength());
        gNumbers.setElementType(gElementType);
        GAnyData.Builder gAnyDataBuilder = GAnyData.newBuilder();
        gAnyDataBuilder.setUrl(url);
        gAnyDataBuilder.setNumbers(gNumbers);
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(gAnyDataBuilder).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<Void> setData(String url, SMat data) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] setData, url=%s, data=%s", url, data));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        GMat.Builder gMat = GMat.newBuilder();
        gMat.setChannels(data.getNumberOfChannels());
        gMat.setDepthValue(data.getDepthCode());
        for (int i = 0; i < data.getDimCount(); ++i) {
            gMat.addDims(data.getDim(i));
        }
        ByteBuffer byteBuffer = data.getByteBuffer();
        byteBuffer.rewind();
        gMat.setBuffer(ByteString.copyFrom((ByteBuffer)byteBuffer));
        GAnyData.Builder gAnyDataBuilder = GAnyData.newBuilder();
        gAnyDataBuilder.setUrl(url);
        gAnyDataBuilder.setMat(gMat);
        this.stub.setData(SetDataRequest.newBuilder().setUrl(url).setData(gAnyDataBuilder).build(), new VoidObserver<SetDataResponse>(future));
        return future;
    }

    public CompletableFuture<List<Any>> getData(List<String> urls) {
        urls = urls.stream().map(this::modifyUrlIfNecessary).collect(Collectors.toList());
        this.logger.log(Level.FINE, String.format("[Request] getData, urls count=%d", urls.size()));
        CompletableFuture<List<Any>> future = new CompletableFuture<List<Any>>();
        this.stub.getData(GetDataRequest.newBuilder().addAllUrl(urls).build(), new GetDataListObserver(future));
        return future;
    }

    public CompletableFuture<Any> getData(String url) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] getData, url=%s", url));
        CompletableFuture<Any> future = new CompletableFuture<Any>();
        this.stub.getData(GetDataRequest.newBuilder().addUrl(url).build(), new GetDataObserver(future));
        return future;
    }

    public CompletableFuture<ObjectStatus> getObjectStatus(String url) {
        return this.getData(String.format("%s/status", url)).thenApply(any -> any.getData(String.class).map(ObjectStatus::from).orElseThrow(() -> new RuntimeException("String.class status expected")));
    }

    public CompletableFuture<List<Any>> getObjectsStatus(List<String> urls) {
        return this.getData(urls.stream().map(s -> s + "/status").collect(Collectors.toList())).thenApply(anies -> anies.stream().peek(any -> {
            String statusName = (String)any.getData(String.class).orElseThrow(() -> new RuntimeException("String.class status expected"));
            any.setData((Object)ObjectStatus.from((String)statusName));
        }).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> uploadConfiguration(String url, File config) {
        url = this.modifyUrlIfNecessary(url);
        this.logger.log(Level.FINE, String.format("[Request] uploadConfiguration, url=%s", url));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            byte[] bytes = Files.readAllBytes(config.toPath());
            this.stub.uploadProject(UploadProjectRequest.newBuilder().setUrl(url).setFile(GFile.newBuilder().setData(ByteString.copyFrom((byte[])bytes)).setPath(config.getAbsolutePath()).build()).build(), new VoidObserver<UploadProjectResponse>(future));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Void> uploadProjectConfiguration(String projectUrl, File config) {
        projectUrl = this.modifyUrlIfNecessary(projectUrl);
        this.logger.log(Level.FINE, String.format("[Request] uploadProjectConfiguration, url=%s", projectUrl));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            byte[] bytes = Files.readAllBytes(config.toPath());
            this.stub.uploadProjectConfiguration(UploadProjectConfigurationRequest.newBuilder().setUrl(projectUrl).setFile(GFile.newBuilder().setData(ByteString.copyFrom((byte[])bytes)).setPath(config.getAbsolutePath()).build()).build(), new VoidObserver<UploadProjectConfigurationResponse>(future));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Any> getProjectConfiguration(String projectUrl) {
        projectUrl = this.modifyUrlIfNecessary(projectUrl);
        this.logger.log(Level.FINE, String.format("[Request] getConfiguration, url=%s", projectUrl));
        CompletableFuture<Any> future = new CompletableFuture<Any>();
        this.stub.getProjectConfiguration(GetProjectConfigurationRequest.newBuilder().setUrl(projectUrl).build(), new GetProjectConfigurationObserver(future));
        return future;
    }

    public CompletableFuture<Any> getProjectConfigurationSettings(String projectUrl) {
        projectUrl = this.modifyUrlIfNecessary(projectUrl);
        this.logger.log(Level.FINE, String.format("[Request] getConfiguration, url=%s", projectUrl));
        CompletableFuture<Any> future = new CompletableFuture<Any>();
        this.stub.getProjectConfigurationSettings(GetProjectConfigurationSettingsRequest.newBuilder().setUrl(projectUrl).build(), new GetProjectConfigurationSettingsObserver(future));
        return future;
    }
}

