/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.DefaultThreadPoolFactory;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.ThreadPoolFactory;

public abstract class AbstractArrayContext
implements ArrayContext {
    @Override
    public ArrayContext part(double fromPart, double toPart) {
        if (fromPart < 0.0) {
            throw new IllegalArgumentException("Illegal fromPart=" + fromPart + " (must be in range 0.0..1.0)");
        }
        if (toPart > 1.0) {
            throw new IllegalArgumentException("Illegal toPart=" + toPart + " (must be in range 0.0..1.0)");
        }
        if (fromPart > toPart) {
            throw new IllegalArgumentException("Illegal fromPart=" + fromPart + " or toPart=" + toPart + " (fromPart must not be greater than toPart)");
        }
        if (this instanceof NoProgressVersion || this instanceof Default) {
            return this;
        }
        return new Subtask(fromPart, toPart);
    }

    @Override
    public ArrayContext part(long from, long to, long total) {
        if (total < 0L) {
            throw new IllegalArgumentException("Negative total=" + total);
        }
        if (from < 0L) {
            throw new IllegalArgumentException("Illegal from=" + from + " (must be in range 0.." + total + ")");
        }
        if (to > total) {
            throw new IllegalArgumentException("Illegal to=" + to + " (must be in range 0.." + total + ")");
        }
        if (from > to) {
            throw new IllegalArgumentException("Illegal from=" + from + " or to=" + to + " (\"from\" must not be greater than \"to\")");
        }
        if (total == 0L) {
            return this.part(0.0, 1.0);
        }
        return this.part((double)from / (double)total, to == total ? 1.0 : (double)to / (double)total);
    }

    @Override
    public ArrayContext part(int from, int to, int total) {
        return this.part((long)from, (long)to, (long)total);
    }

    @Override
    public ArrayContext noProgressVersion() {
        return new NoProgressVersion();
    }

    @Override
    public ArrayContext singleThreadVersion() {
        return new SingleThreadVersion();
    }

    @Override
    public ArrayContext multithreadingVersion(int currentThreadIndex, int numberOfThreads) {
        if (numberOfThreads <= 0) {
            throw new IllegalArgumentException("Zero or negative number of threads " + numberOfThreads + " while creating multithreading array context");
        }
        if (currentThreadIndex < 0) {
            throw new IllegalArgumentException("Negative index of the current thread " + currentThreadIndex + " while creating multithreading array context");
        }
        if (currentThreadIndex >= numberOfThreads) {
            throw new IllegalArgumentException("Index of the current thread " + currentThreadIndex + " is out of range 0..(numberOfThreads-1)=" + (numberOfThreads - 1) + " while creating multithreading array context");
        }
        if (currentThreadIndex == this.currentThreadIndex() && numberOfThreads == this.numberOfThreads()) {
            return this;
        }
        return new MultithreadingVersion(currentThreadIndex, numberOfThreads);
    }

    @Override
    public ArrayContext customDataVersion(Object customData) {
        if (customData == this.customData()) {
            return this;
        }
        return new CustomDataVersion(customData);
    }

    @Override
    public abstract MemoryModel getMemoryModel();

    @Override
    public abstract ThreadPoolFactory getThreadPoolFactory();

    @Override
    public abstract void checkInterruption() throws RuntimeException;

    @Override
    public abstract void updateProgress(ArrayContext.Event var1);

    @Override
    public final void checkInterruptionAndUpdateProgress(Class<?> elementType, long readyCount, long length) {
        this.checkInterruption();
        this.updateProgress(new ArrayContext.Event(elementType, readyCount, length));
    }

    @Override
    public int currentThreadIndex() {
        return 0;
    }

    @Override
    public int numberOfThreads() {
        return 1;
    }

    @Override
    public Object customData() {
        return null;
    }

    private class NoProgressVersion
    extends AbstractArrayContext
    implements ArrayContext {
        private NoProgressVersion() {
        }

        @Override
        public ArrayContext noProgressVersion() {
            return this;
        }

        @Override
        public MemoryModel getMemoryModel() {
            return AbstractArrayContext.this.getMemoryModel();
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return AbstractArrayContext.this.getThreadPoolFactory().singleThreadVersion();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
            AbstractArrayContext.this.checkInterruption();
        }

        @Override
        public void updateProgress(ArrayContext.Event event) {
        }

        @Override
        public int currentThreadIndex() {
            return AbstractArrayContext.this.currentThreadIndex();
        }

        @Override
        public int numberOfThreads() {
            return AbstractArrayContext.this.numberOfThreads();
        }

        @Override
        public Object customData() {
            return AbstractArrayContext.this.customData();
        }

        public String toString() {
            return "no-progress version of " + String.valueOf(AbstractArrayContext.this);
        }
    }

    static class Default
    extends AbstractArrayContext
    implements ArrayContext {
        private final MemoryModel memoryModel;

        public Default() {
            this(SimpleMemoryModel.getInstance());
        }

        public Default(MemoryModel memoryModel) {
            this.memoryModel = Objects.requireNonNull(memoryModel, "Null memory model");
        }

        @Override
        public ArrayContext noProgressVersion() {
            return this;
        }

        @Override
        public ArrayContext singleThreadVersion() {
            return this.memoryModel == SimpleMemoryModel.getInstance() ? DEFAULT_SINGLE_THREAD : new DefaultSingleThread(this.memoryModel);
        }

        @Override
        public MemoryModel getMemoryModel() {
            return this.memoryModel;
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return DefaultThreadPoolFactory.getDefaultThreadPoolFactory();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
        }

        @Override
        public void updateProgress(ArrayContext.Event event) {
        }

        public String toString() {
            return "default array context";
        }
    }

    private class Subtask
    extends AbstractArrayContext
    implements ArrayContext {
        private final double fromPart;
        private final double toPart;

        private Subtask(double fromPart, double toPart) {
            this.fromPart = fromPart;
            this.toPart = toPart;
        }

        @Override
        public MemoryModel getMemoryModel() {
            return AbstractArrayContext.this.getMemoryModel();
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return AbstractArrayContext.this.getThreadPoolFactory();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
            AbstractArrayContext.this.checkInterruption();
        }

        @Override
        public void updateProgress(final ArrayContext.Event event) {
            AbstractArrayContext.this.updateProgress(new ArrayContext.Event(event.elementType(), event.readyCountPerTask(), event.lengthPerTask()){

                @Override
                public double readyPart() {
                    return Subtask.this.fromPart + event.readyPart() * (Subtask.this.toPart - Subtask.this.fromPart);
                }
            });
        }

        @Override
        public int currentThreadIndex() {
            return AbstractArrayContext.this.currentThreadIndex();
        }

        @Override
        public int numberOfThreads() {
            return AbstractArrayContext.this.numberOfThreads();
        }

        @Override
        public Object customData() {
            return AbstractArrayContext.this.customData();
        }

        public String toString() {
            return String.format(Locale.US, "sub-task context %.3f..%.3f of %s", this.fromPart, this.toPart, AbstractArrayContext.this);
        }
    }

    private class SingleThreadVersion
    extends AbstractArrayContext
    implements ArrayContext {
        private SingleThreadVersion() {
        }

        @Override
        public ArrayContext singleThreadVersion() {
            return this;
        }

        @Override
        public MemoryModel getMemoryModel() {
            return AbstractArrayContext.this.getMemoryModel();
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return AbstractArrayContext.this.getThreadPoolFactory().singleThreadVersion();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
            AbstractArrayContext.this.checkInterruption();
        }

        @Override
        public void updateProgress(ArrayContext.Event event) {
            AbstractArrayContext.this.updateProgress(event);
        }

        @Override
        public int currentThreadIndex() {
            return AbstractArrayContext.this.currentThreadIndex();
        }

        @Override
        public int numberOfThreads() {
            return AbstractArrayContext.this.numberOfThreads();
        }

        @Override
        public Object customData() {
            return AbstractArrayContext.this.customData();
        }

        public String toString() {
            return "single-thread version of " + String.valueOf(AbstractArrayContext.this);
        }
    }

    private class MultithreadingVersion
    extends AbstractArrayContext
    implements ArrayContext {
        private final int currentThreadIndex;
        private final int numberOfThreads;

        private MultithreadingVersion(int currentThreadIndex, int numberOfThreads) {
            assert (currentThreadIndex >= 0 && currentThreadIndex < numberOfThreads);
            this.currentThreadIndex = currentThreadIndex;
            this.numberOfThreads = numberOfThreads;
        }

        @Override
        public MemoryModel getMemoryModel() {
            return AbstractArrayContext.this.getMemoryModel();
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return AbstractArrayContext.this.getThreadPoolFactory();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
            AbstractArrayContext.this.checkInterruption();
        }

        @Override
        public void updateProgress(ArrayContext.Event event) {
            AbstractArrayContext.this.updateProgress(event);
        }

        @Override
        public int currentThreadIndex() {
            return this.currentThreadIndex;
        }

        @Override
        public int numberOfThreads() {
            return this.numberOfThreads;
        }

        @Override
        public Object customData() {
            return AbstractArrayContext.this.customData();
        }
    }

    private class CustomDataVersion
    extends AbstractArrayContext
    implements ArrayContext {
        private final Object customData;

        private CustomDataVersion(Object customData) {
            this.customData = customData;
        }

        @Override
        public MemoryModel getMemoryModel() {
            return AbstractArrayContext.this.getMemoryModel();
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return AbstractArrayContext.this.getThreadPoolFactory();
        }

        @Override
        public void checkInterruption() throws RuntimeException {
            AbstractArrayContext.this.checkInterruption();
        }

        @Override
        public void updateProgress(ArrayContext.Event event) {
            AbstractArrayContext.this.updateProgress(event);
        }

        @Override
        public int currentThreadIndex() {
            return AbstractArrayContext.this.currentThreadIndex();
        }

        @Override
        public int numberOfThreads() {
            return AbstractArrayContext.this.numberOfThreads();
        }

        @Override
        public Object customData() {
            return this.customData;
        }
    }

    static class DefaultSingleThread
    extends Default
    implements ArrayContext {
        public DefaultSingleThread() {
        }

        public DefaultSingleThread(MemoryModel memoryModel) {
            super(memoryModel);
        }

        @Override
        public ThreadPoolFactory getThreadPoolFactory() {
            return DefaultThreadPoolFactory.getDefaultThreadPoolFactory(1);
        }

        @Override
        public String toString() {
            return "default single-thread array context";
        }
    }
}

