/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.PArray;

abstract class AbstractInterleavingBandsOperation
extends Arrays.ParallelExecutor
implements AutoCloseable {
    private static final int BUFFER_SIZE = 32768;
    static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 32768);
    static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 32768);
    static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 32768);
    static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 32768);
    static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 32768);
    static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 32768);
    static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 32768);
    static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 32768);

    AbstractInterleavingBandsOperation(ArrayContext context, PArray[] bands, PArray packed) {
        super(context, null, bands[0], 32768 / bands.length, 0, 0L);
        assert (this.blockSize * bands.length <= 32768);
        assert (bands[0].elementType() == packed.elementType());
        assert (packed.length() == (long)bands.length * bands[0].length());
    }

    @Override
    public abstract void close();

    @Override
    protected abstract void processSubArr(long var1, int var3, int var4);

    static boolean allBandsDirect(PArray[] bands) {
        for (PArray band : bands) {
            DirectAccessible da;
            if (band instanceof DirectAccessible && (da = (DirectAccessible)((Object)band)).hasJavaArray()) continue;
            return false;
        }
        return true;
    }
}

