/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;

public abstract class AbstractIterativeArrayProcessor<T>
implements IterativeArrayProcessor<T> {
    protected final ArrayContext context;
    protected final MemoryModel memoryModel;

    protected AbstractIterativeArrayProcessor(ArrayContext context) {
        this.context = context;
        this.memoryModel = context == null ? SimpleMemoryModel.getInstance() : context.getMemoryModel();
    }

    @Override
    public abstract void performIteration(ArrayContext var1);

    @Override
    public abstract boolean done();

    @Override
    public abstract long estimatedNumberOfIterations();

    @Override
    public abstract T result();

    @Override
    public abstract void freeResources(ArrayContext var1);

    @Override
    public ArrayContext context() {
        return this.context;
    }

    public static ArrayContext part(ArrayContext context, double fromPart, double toPart) {
        return context == null ? null : context.part(fromPart, toPart);
    }

    @Override
    public T process() {
        long t2;
        long t1 = Arrays.CONFIG_LOGGABLE ? System.nanoTime() : 0L;
        long totalCount = -1L;
        long remainingCount = -1L;
        double unknownRemains = this instanceof LimitedIterations ? 0.0 : 0.2;
        double unknownStep = 0.01;
        ArrayContext estimatedContext = AbstractIterativeArrayProcessor.part(this.context, 0.0, 1.0 - unknownRemains);
        boolean done = this.done();
        T result = done ? (T)this.result() : null;
        long count = 0L;
        while (!done) {
            Array resultArray;
            if (totalCount <= 0L) {
                assert (remainingCount <= 0L);
                totalCount = this.estimatedNumberOfIterations();
                if (totalCount > 0L) {
                    remainingCount = totalCount;
                }
            }
            ArrayContext subContext = estimatedContext;
            if (remainingCount > 0L) {
                assert (totalCount > 0L);
                assert (remainingCount <= totalCount);
                double fromPart = (double)(totalCount - remainingCount) / (double)totalCount;
                double toPart = Math.min(1.0, (double)(totalCount - --remainingCount) / (double)totalCount);
                subContext = AbstractIterativeArrayProcessor.part(subContext, fromPart, toPart);
            }
            this.performIteration(subContext);
            done = this.done();
            if (remainingCount == 0L && !done) {
                if (unknownRemains <= unknownStep * 1.05) {
                    unknownStep *= 0.05;
                }
                estimatedContext = AbstractIterativeArrayProcessor.part(this.context, 1.0 - unknownRemains, 1.0 - (unknownRemains - unknownStep));
                unknownRemains -= unknownStep;
                totalCount = 0L;
            }
            result = this.result();
            if (this.context != null) {
                this.context.checkInterruption();
            }
            if ((resultArray = AbstractIterativeArrayProcessor.resultArray(result)) != null) {
                ArrayContext c;
                long len = resultArray.length();
                ArrayContext arrayContext = c = done ? this.context : subContext;
                if (c != null) {
                    c.updateProgress(new ArrayContext.Event(resultArray.elementType(), len, len));
                }
            }
            ++count;
        }
        if (Arrays.CONFIG_LOGGABLE && Arrays.SystemSettings.profilingMode() && (t2 = System.nanoTime()) - t1 > 3000000000L) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuilder stackInfo = new StringBuilder();
            for (int k = 1; k < stack.length; ++k) {
                String methodName = stack[k].getMethodName();
                String className = stack[k].getClassName();
                if (stackInfo.isEmpty()) {
                    if ("process".equals(methodName) && AbstractIterativeArrayProcessor.class.getName().equals(className)) {
                        continue;
                    }
                } else {
                    stackInfo.append("/");
                }
                stackInfo.append(stack[k].getMethodName());
            }
            Array resultArray = AbstractIterativeArrayProcessor.resultArray(result);
            Arrays.LOGGER.config(String.format(Locale.US, "Array / matrix is processed in %d iterations in %.3f ms (%.4f ms/iteration" + (result == null ? "" : ", %.3f ns/element") + ") by " + String.valueOf(this) + (String)(resultArray == null ? " " : " [" + String.valueOf(result) + "] ") + "in " + String.valueOf(stackInfo), count, 1.0E-6 * (double)(t2 - t1), 1.0E-6 * (double)(t2 - t1) / Math.max(1.0, (double)count), resultArray == null ? null : Double.valueOf((double)(t2 - t1) / Math.max(1.0, (double)count) / (double)resultArray.length())));
        }
        return result;
    }

    @Override
    public IterativeArrayProcessor<T> limitIterations(long maxNumberOfIterations) {
        if (maxNumberOfIterations < 0L) {
            return this;
        }
        return new LimitedIterations(this, maxNumberOfIterations);
    }

    @Override
    public IterativeArrayProcessor<T> chain(IterativeArrayProcessor<T> followingProcessor, double weight) {
        Objects.requireNonNull(followingProcessor, "Null followingProcessor argument");
        if (weight < 0.0) {
            throw new IllegalArgumentException("Negative weight");
        }
        return new Chain<T>(this, followingProcessor, weight);
    }

    private static Array resultArray(Object result) {
        if (result instanceof Array) {
            return (Array)result;
        }
        if (result instanceof Matrix) {
            return ((Matrix)result).array();
        }
        return null;
    }

    private static class LimitedIterations<T>
    extends AbstractIterativeArrayProcessor<T> {
        private final IterativeArrayProcessor<T> proc;
        private final long maxNumberOfIterations;
        private long numberOfIterations;

        private LimitedIterations(IterativeArrayProcessor<T> proc, long maxNumberOfIterations) {
            super(proc.context());
            assert (maxNumberOfIterations >= 0L) : "Negative maxNumberOfIterations";
            this.proc = proc;
            this.maxNumberOfIterations = maxNumberOfIterations;
            this.numberOfIterations = maxNumberOfIterations;
        }

        @Override
        public void performIteration(ArrayContext context) {
            this.proc.performIteration(context);
            if (this.numberOfIterations > 0L) {
                --this.numberOfIterations;
            }
        }

        @Override
        public boolean done() {
            assert (this.numberOfIterations >= 0L) : "negative numberOfIterations = " + this.numberOfIterations;
            return this.numberOfIterations == 0L || this.proc.done();
        }

        @Override
        public long estimatedNumberOfIterations() {
            return this.numberOfIterations;
        }

        @Override
        public T result() {
            return this.proc.result();
        }

        @Override
        public void freeResources(ArrayContext context) {
            this.proc.freeResources(context);
        }

        public String toString() {
            return this.proc.toString() + ", limited by " + this.maxNumberOfIterations + " iterations";
        }
    }

    private static class Chain<T>
    extends AbstractIterativeArrayProcessor<T> {
        private final IterativeArrayProcessor<T> proc1;
        private final IterativeArrayProcessor<T> proc2;
        private final double weight2;

        private Chain(IterativeArrayProcessor<T> proc1, IterativeArrayProcessor<T> proc2, double weight2) {
            super(proc1.context());
            assert (proc2 != null) : "Null proc2";
            assert (weight2 >= 0.0) : "Negative weight2";
            this.proc1 = proc1;
            this.proc2 = proc2;
            this.weight2 = weight2;
        }

        @Override
        public void performIteration(ArrayContext context) {
            if (!this.proc1.done()) {
                this.proc1.performIteration(context);
            } else {
                this.proc2.performIteration(context);
            }
        }

        @Override
        public boolean done() {
            return this.proc1.done() && this.proc2.done();
        }

        @Override
        public long estimatedNumberOfIterations() {
            if (!this.proc1.done()) {
                long n1 = this.proc1.estimatedNumberOfIterations();
                long n2 = this.proc2.estimatedNumberOfIterations();
                if (n1 <= 0L || n2 <= 0L) {
                    return 0L;
                }
                return n1 + Math.round(this.weight2 * (double)n2);
            }
            return this.proc2.estimatedNumberOfIterations();
        }

        @Override
        public T result() {
            return !this.proc1.done() ? this.proc1.result() : this.proc2.result();
        }

        @Override
        public void freeResources(ArrayContext context) {
            this.proc1.freeResources(context == null ? null : context.part(0.0, 0.5));
            this.proc2.freeResources(context == null ? null : context.part(0.5, 1.0));
        }

        public String toString() {
            return "chain " + this.proc1.toString() + " | [weight " + this.weight2 + "] " + this.proc2.toString();
        }
    }
}

