/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteOrder;
import java.util.EmptyStackException;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBitStorage;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DirectDataStorages;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.LongArray;
import net.algart.arrays.MappedDataStorages;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableShortArray;

class BufferArraysImpl {
    BufferArraysImpl() {
    }

    static void forgetOnDeallocation(AbstractBufferArray a) {
        if (!(a.storage instanceof DirectDataStorages.DirectStorage)) {
            LargeMemoryModel.globalArrayFinalizer.invokeOnDeallocation(a, new AbstractBufferArrayFinalizer(a));
        }
    }

    static abstract class AbstractBufferArray
    extends AbstractArray {
        protected DataStorage storage;
        protected long offset = 0L;
        protected boolean copyOnNextWrite = false;
        protected AbstractBufferArray underlyingArray;
        boolean attached;
        volatile AbstractBufferArrayFinalizer finalizer = null;
        private final ReentrantLock lock = new ReentrantLock();

        AbstractBufferArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(initialCapacity, initialLength);
            this.offset = initialOffset;
            this.storage = storage;
            this.storage.attachArray(this);
            this.attached = true;
            if (doAllocate) {
                if (!(this instanceof UpdatableArray)) {
                    throw new AssertionError((Object)"doAllocate argument may be true only in updatable arrays");
                }
                this.storage.allocate(initialCapacity, this.isUnresizable());
                this.setNewStatus();
            }
        }

        AbstractBufferArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(initialCapacity, initialLength);
            this.offset = initialOffset;
            this.storage = storage;
            if (underlyingArray == null) {
                if (!(this instanceof UpdatableArray)) {
                    throw new AssertionError((Object)"underlyingArray argument may be null only in updatable arrays");
                }
                this.storage.attachArray(this);
                this.attached = true;
                this.storage.allocate(initialCapacity, this.isUnresizable());
                this.setNewStatus();
            } else {
                this.attached = false;
            }
            this.underlyingArray = underlyingArray;
        }

        final void switchStorage(DataStorage newStorage) {
            this.lock.lock();
            try {
                boolean alreadyAttached = this.attached;
                if (alreadyAttached) {
                    this.storage.forgetArray(System.identityHashCode(this));
                    if (!(this.storage instanceof DirectDataStorages.DirectStorage)) {
                        assert (this.finalizer != null) : "Null AbstractBufferArray.finalizer field";
                        this.finalizer.storageRef = newStorage;
                    }
                }
                this.attached = true;
                this.underlyingArray = null;
                this.storage = newStorage;
                this.storage.attachArray(this);
                if (!alreadyAttached) {
                    BufferArraysImpl.forgetOnDeallocation(this);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        final void reallocateStorage() {
            if (this.isImmutable() || !(this instanceof UpdatableArray)) {
                throw new AssertionError((Object)"Internal error in Buffer/LargeMemoryModel implementation (unallowed reallocation)");
            }
            boolean unresizable = this.isUnresizable();
            DataStorage newStorage = this.storage.newCompatibleEmptyStorage(unresizable);
            newStorage.allocate(this.length, unresizable);
            if (!newStorage.copy(this.storage, this.offset, 0L, this.length)) {
                throw new AssertionError((Object)"Cannot reallocateStorage(): newCompatibleEmptyStorage cannot be copied from this storage");
            }
            this.switchStorage(newStorage);
            this.offset = 0L;
            this.copyOnNextWrite = false;
            this.setNewStatus();
        }

        @Override
        public ByteOrder byteOrder() {
            return this.storage.byteOrder();
        }

        @Override
        public final void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.storage.getData(this.offset + arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public final void getData(long arrayPos, Object destArray) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(destArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            this.storage.getData(this.offset + arrayPos, destArray, 0, count);
        }

        @Override
        public boolean isJavaArrayWrapper() {
            return false;
        }

        public final void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            if (!(this instanceof BitArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed getBits)");
            }
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - count) {
                throw this.rangeException(arrayPos + count - 1L);
            }
            ((DataBitStorage)((Object)this.storage)).getBits(this.offset + arrayPos, destArray, destArrayOffset, count);
        }

        public long nextQuickPosition(long from) {
            if (from >= this.length) {
                return -1L;
            }
            long result = (this.offset + (from < 0L ? 63L : from + 63L) & 0xFFFFFFFFFFFFFFC0L) - this.offset;
            assert ((this.offset + result) % 64L == 0L);
            if (result < 0L || result >= this.length) {
                return -1L;
            }
            return result;
        }

        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed setData)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            this.storage.setData(this.offset + arrayPos, srcArray, srcArrayOffset, count);
            return (UpdatableArray)((Object)this);
        }

        public UpdatableArray setData(long arrayPos, Object srcArray) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed setData)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (arrayPos < 0L || arrayPos > this.length) {
                throw this.rangeException(arrayPos);
            }
            int count = java.lang.reflect.Array.getLength(srcArray);
            if ((long)count > this.length - arrayPos) {
                count = (int)(this.length - arrayPos);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            this.storage.setData(this.offset + arrayPos, srcArray, 0, count);
            return (UpdatableArray)((Object)this);
        }

        public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            if (!(this instanceof UpdatableBitArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed setBits)");
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - count) {
                throw this.rangeException(arrayPos + count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            ((DataBitStorage)((Object)this.storage)).setBits(this.offset + arrayPos, srcArray, srcArrayOffset, count);
            return (UpdatableBitArray)((Object)this);
        }

        public final void copy(long destIndex, long srcIndex, long count) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed copy)");
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (srcIndex < 0L) {
                throw this.rangeException(srcIndex);
            }
            if (srcIndex > this.length - count) {
                throw this.rangeException(srcIndex + count - 1L);
            }
            if (destIndex < 0L) {
                throw this.rangeException(destIndex);
            }
            if (destIndex > this.length - count) {
                throw this.rangeException(destIndex + count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            this.storage.copy(this.storage, this.offset + srcIndex, this.offset + destIndex, count);
        }

        public final void swap(long firstIndex, long secondIndex, long count) {
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (firstIndex < 0L) {
                throw this.rangeException(firstIndex);
            }
            if (firstIndex > this.length - count) {
                throw this.rangeException(firstIndex + count - 1L);
            }
            if (secondIndex < 0L) {
                throw this.rangeException(secondIndex);
            }
            if (secondIndex > this.length - count) {
                throw this.rangeException(secondIndex + count - 1L);
            }
            if (this.isCopyOnNextWrite()) {
                this.reallocateStorage();
            }
            this.storage.swap(this.storage, this.offset + firstIndex, this.offset + secondIndex, count);
        }

        public UpdatableArray copy(Array src) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed copy)");
            }
            if (src instanceof AbstractBufferArray) {
                AbstractBufferArray a = (AbstractBufferArray)src;
                long count = Math.min(a.length, this.length);
                if (a.storage.getClass() == this.storage.getClass()) {
                    AbstractBufferArray.checkCopyArguments((UpdatableArray)((Object)this), src);
                    if (this.isCopyOnNextWrite()) {
                        this.reallocateStorage();
                    }
                    if (this.storage.copy(a.storage, a.offset, this.offset, count)) {
                        return (UpdatableArray)((Object)this);
                    }
                }
            }
            AbstractBufferArray.defaultCopy((UpdatableArray)((Object)this), src);
            return (UpdatableArray)((Object)this);
        }

        public UpdatableArray swap(UpdatableArray another) {
            if (!(this instanceof UpdatableArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed swap)");
            }
            AbstractBufferArray.defaultSwap((UpdatableArray)((Object)this), another);
            return (UpdatableArray)((Object)this);
        }

        public void setNonNew() {
            this.setNewStatus(false);
        }

        final void ensureCapacityImpl(long minCapacity) {
            long currentCapacity = this.capacity();
            if (minCapacity > currentCapacity) {
                DataStorage newStorage;
                long newCapacity = this.storage instanceof MappedDataStorages.MappedStorage ? minCapacity + 255L & 0xFFFFFFFFFFFFFF00L : Math.min(DataStorage.maxSupportedLengthImpl(this.elementType()), currentCapacity < 10000L ? currentCapacity * 3L : (currentCapacity < 500000L ? currentCapacity * 2L : currentCapacity * 3L / 2L + 1L));
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                if ((newStorage = this.storage.changeCapacity(newCapacity, this.offset, this.length)) != this.storage) {
                    this.switchStorage(newStorage);
                    this.copyOnNextWrite = false;
                    this.offset = 0L;
                }
                this.capacity = newCapacity;
            }
        }

        final void lengthImpl(long newLength) {
            long oldLength = this.length;
            if (newLength != oldLength) {
                this.ensureCapacityImpl(newLength);
                this.length = newLength;
                if (this.isCopyOnNextWrite()) {
                    this.reallocateStorage();
                } else if (newLength < oldLength) {
                    this.storage.clearData(this.offset + newLength, oldLength - newLength);
                }
            }
        }

        final void trimImpl() {
            if (this.length < this.capacity()) {
                DataStorage newStorage = this.storage.changeCapacity(this.length, 0L, this.length);
                if (newStorage != this.storage) {
                    this.switchStorage(newStorage);
                    this.copyOnNextWrite = false;
                    this.offset = 0L;
                }
                this.capacity = this.length;
            }
        }

        public final MutableCharArray append(String value) {
            if (!(this instanceof MutableCharArray)) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed append)");
            }
            char[] chars = new char[value.length()];
            value.getChars(0, chars.length, chars, 0);
            return ((MutableCharArray)((Object)this)).append(SimpleMemoryModel.asUpdatableCharArray(chars));
        }

        @Override
        public final boolean isCopyOnNextWrite() {
            return this.copyOnNextWrite;
        }

        @Override
        public final void checkUnallowedMutation() throws UnallowedMutationError {
        }

        @Override
        public final void loadResources(ArrayContext context) {
            this.storage.loadResources(this.offset, this.offset + this.length);
        }

        @Override
        public final void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
            this.storage.actualizeLazyFilling(context, this.offset, this.offset + this.length);
            this.storage.flushResources(this.offset, this.offset + this.length, forcePhysicalWriting);
        }

        @Override
        public final void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
            this.storage.actualizeLazyFilling(context, this.offset, this.offset + this.length);
            this.storage.freeResources(this, forcePhysicalWriting);
        }
    }

    private static class AbstractBufferArrayFinalizer
    implements Runnable {
        final int id;
        volatile DataStorage storageRef;

        AbstractBufferArrayFinalizer(AbstractBufferArray a) {
            this.id = System.identityHashCode(a);
            this.storageRef = a.storage;
            a.finalizer = this;
        }

        @Override
        public void run() {
            this.storageRef.forgetArray(this.id);
        }
    }

    static final class MutableBufferBitArray
    extends UpdatableBufferBitArray
    implements MutableBitArray {
        MutableBufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableBitArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableBitArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableBitArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableBitArray append(Array appendedArray) {
            MutableBufferBitArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popBit();
        }

        @Override
        public void pushElement(Object value) {
            this.pushBit((Boolean)value);
        }

        @Override
        public double popDouble() {
            return this.popBit() ? 1.0 : 0.0;
        }

        @Override
        public long popLong() {
            return this.popBit() ? 1L : 0L;
        }

        @Override
        public int popInt() {
            return this.popBit() ? 1 : 0;
        }

        @Override
        public void addDouble(double value) {
            this.pushBit(value != 0.0);
        }

        @Override
        public void addLong(long value) {
            this.pushBit(value != 0L);
        }

        @Override
        public void addInt(int value) {
            this.pushBit(value != 0);
        }

        @Override
        public boolean popBit() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            boolean result = this.getBit(this.length - 1L);
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return result;
        }

        @Override
        public void pushBit(boolean value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.setBit(newLength - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableBitArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableBitArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableBitArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableBitArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferBitArray result = new MutableBufferBitArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            UpdatableBufferBitArray result = new UpdatableBufferBitArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableBitArray shallowClone() {
            return (MutableBufferBitArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array bit[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferBitArray
    extends BufferBitArray
    implements UpdatableBitArray {
        UpdatableBufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setBit(index, (Boolean)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setBit(index, value != 0.0);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setBit(index, value != 0L);
        }

        @Override
        public final void setInt(long index, int value) {
            this.setBit(index, value != 0);
        }

        @Override
        public final void setBit(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBit(this.offset + index, value);
        }

        @Override
        public final void setBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBit(this.offset + index, true);
        }

        @Override
        public final void clearBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBit(this.offset + index, false);
        }

        @Override
        public void setBitNoSync(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBitNoSync(this.offset + index, value);
        }

        @Override
        public void setBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBitNoSync(this.offset + index, true);
        }

        @Override
        public void clearBitNoSync(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setBitNoSync(this.offset + index, false);
        }

        @Override
        public void setBits64(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.storage.setBits64(this.offset + arrayPos, bits, count);
        }

        @Override
        public void setBits64NoSync(long arrayPos, long bits, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot set > 64 bits in setBits64NoSync method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.storage.setBits64NoSync(this.offset + arrayPos, bits, count);
        }

        @Override
        public UpdatableBitArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, double value) {
            return this.fill(position, count, value != 0.0);
        }

        @Override
        public UpdatableBitArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, long value) {
            return this.fill(position, count, value != 0L);
        }

        @Override
        public UpdatableBitArray fill(boolean value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, boolean value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.fillData(this.offset + position, count, value);
            return this;
        }

        @Override
        public UpdatableBitArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferBitArray result = new UpdatableBufferBitArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableBitArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferBitArray result = new UpdatableBufferBitArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final BitArray asImmutable() {
            return new BufferBitArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferBitArray result = new UpdatableBufferBitArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableBitArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferBitArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array bit[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferBitArray
    extends AbstractBufferArray
    implements BitArray {
        BufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferBitArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Boolean.TYPE;
        }

        @Override
        public Class<? extends BitArray> type() {
            return BitArray.class;
        }

        @Override
        public Class<? extends UpdatableBitArray> updatableType() {
            return UpdatableBitArray.class;
        }

        @Override
        public Class<? extends MutableBitArray> mutableType() {
            return MutableBitArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getBit(index);
        }

        @Override
        public final long bitsPerElement() {
            return 1L;
        }

        @Override
        public double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public long minPossibleValue() {
            return 0L;
        }

        @Override
        public long maxPossibleValue() {
            return 1L;
        }

        @Override
        public final double getDouble(long index) {
            return this.getBit(index) ? 1.0 : 0.0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.indexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == 0.0 || value == 1.0 ? this.lastIndexOf(lowIndex, highIndex, value != 0.0) : -1L;
        }

        @Override
        public final long getLong(long index) {
            return this.getBit(index) ? 1L : 0L;
        }

        @Override
        public final int getInt(long index) {
            return this.getBit(index) ? 1 : 0;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.indexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == 0L || value == 1L ? this.lastIndexOf(lowIndex, highIndex, value != 0L) : -1L;
        }

        @Override
        public final boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getBit(this.offset + index);
        }

        @Override
        public long getBits64(long arrayPos, int count) {
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (count < 0) {
                throw new IllegalArgumentException("Negative count argument: " + count);
            }
            if (count > 64) {
                throw new IllegalArgumentException("Too large count argument: " + count + "; we cannot get > 64 bits in getBits64 method");
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            return this.storage.getBits64(this.offset + arrayPos, count);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfBit(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfBit(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferBitArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferBitArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataBitBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataBitBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataBitBuffer)super.buffer(mode);
        }

        @Override
        public DataBitBuffer buffer(long capacity) {
            return (DataBitBuffer)super.buffer(capacity);
        }

        @Override
        public DataBitBuffer buffer() {
            return (DataBitBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public BitArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final BitArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableBitArray mutableClone(MemoryModel memoryModel) {
            return (MutableBitArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableBitArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableBitArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferBitArray result = (BufferBitArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public boolean[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array bit [" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferDoubleArray
    extends UpdatableBufferDoubleArray
    implements MutableDoubleArray {
        MutableBufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableDoubleArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableDoubleArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableDoubleArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableDoubleArray append(Array appendedArray) {
            MutableBufferDoubleArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popDouble();
        }

        @Override
        public void pushElement(Object value) {
            this.pushDouble((Double)value);
        }

        public long popLong() {
            return (long)this.popDouble();
        }

        public int popInt() {
            return (int)this.popDouble();
        }

        @Override
        public void addDouble(double value) {
            this.pushDouble(value);
        }

        @Override
        public void addLong(long value) {
            this.pushDouble(value);
        }

        @Override
        public void addInt(int value) {
            this.pushDouble(value);
        }

        @Override
        public double popDouble() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getDouble(this.offset + this.length);
        }

        @Override
        public void pushDouble(double value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setDouble(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableDoubleArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableDoubleArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableDoubleArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableDoubleArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferDoubleArray result = new MutableBufferDoubleArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            UpdatableBufferDoubleArray result = new UpdatableBufferDoubleArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableDoubleArray shallowClone() {
            return (MutableBufferDoubleArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array double[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferDoubleArray
    extends BufferDoubleArray
    implements UpdatableDoubleArray {
        UpdatableBufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setDouble(index, (Double)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setDouble(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setDouble(this.offset + index, value);
        }

        @Override
        public final void setDouble(long index, double value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setDouble(this.offset + index, value);
        }

        @Override
        public UpdatableDoubleArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, long value) {
            return this.fill(position, count, (double)value);
        }

        @Override
        public UpdatableDoubleArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, double value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Double filler = value;
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableDoubleArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferDoubleArray result = new UpdatableBufferDoubleArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableDoubleArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferDoubleArray result = new UpdatableBufferDoubleArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final DoubleArray asImmutable() {
            return new BufferDoubleArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferDoubleArray result = new UpdatableBufferDoubleArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableDoubleArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferDoubleArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array double[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferDoubleArray
    extends AbstractBufferArray
    implements DoubleArray {
        BufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferDoubleArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Double.TYPE;
        }

        @Override
        public Class<? extends DoubleArray> type() {
            return DoubleArray.class;
        }

        @Override
        public Class<? extends UpdatableDoubleArray> updatableType() {
            return UpdatableDoubleArray.class;
        }

        @Override
        public Class<? extends MutableDoubleArray> mutableType() {
            return MutableDoubleArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getDouble(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final long minPossibleValue() {
            return -157777L;
        }

        public final long maxPossibleValue() {
            return 157778L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.storage.getDouble(this.offset + index);
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.storage.getDouble(this.offset + index);
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.indexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (double)value == (double)value ? this.lastIndexOf(lowIndex, highIndex, (double)value) : -1L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getDouble(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfDouble(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfDouble(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferDoubleArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferDoubleArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataDoubleBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataDoubleBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataDoubleBuffer)super.buffer(mode);
        }

        @Override
        public DataDoubleBuffer buffer(long capacity) {
            return (DataDoubleBuffer)super.buffer(capacity);
        }

        @Override
        public DataDoubleBuffer buffer() {
            return (DataDoubleBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public DoubleArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final DoubleArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableDoubleArray mutableClone(MemoryModel memoryModel) {
            return (MutableDoubleArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableDoubleArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableDoubleArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferDoubleArray result = (BufferDoubleArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public double[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array double[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferLongArray
    extends UpdatableBufferLongArray
    implements MutableLongArray {
        MutableBufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableLongArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableLongArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableLongArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableLongArray append(Array appendedArray) {
            MutableBufferLongArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popLong();
        }

        @Override
        public void pushElement(Object value) {
            this.pushLong((Long)value);
        }

        @Override
        public double popDouble() {
            return this.popLong();
        }

        @Override
        public int popInt() {
            return Arrays.truncateLongToInt(this.popLong());
        }

        @Override
        public void addDouble(double value) {
            this.pushLong((long)value);
        }

        @Override
        public void addLong(long value) {
            this.pushLong(value);
        }

        @Override
        public void addInt(int value) {
            this.pushLong(value);
        }

        @Override
        public long popLong() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getLong(this.offset + this.length);
        }

        @Override
        public void pushLong(long value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setLong(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableLongArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableLongArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableLongArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableLongArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferLongArray result = new MutableBufferLongArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            UpdatableBufferLongArray result = new UpdatableBufferLongArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableLongArray shallowClone() {
            return (MutableBufferLongArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array long[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferLongArray
    extends BufferLongArray
    implements UpdatableLongArray {
        UpdatableBufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setLong(index, (Long)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setLong(index, (long)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setLong(this.offset + index, value);
        }

        @Override
        public final void setLong(long index, long value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setLong(this.offset + index, value);
        }

        @Override
        public UpdatableLongArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, double value) {
            return this.fill(position, count, (long)value);
        }

        @Override
        public UpdatableLongArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, long value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Long filler = value;
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableLongArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferLongArray result = new UpdatableBufferLongArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableLongArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferLongArray result = new UpdatableBufferLongArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final LongArray asImmutable() {
            return new BufferLongArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferLongArray result = new UpdatableBufferLongArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableLongArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferLongArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array long[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferLongArray
    extends AbstractBufferArray
    implements LongArray {
        BufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferLongArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Long.TYPE;
        }

        @Override
        public Class<? extends LongArray> type() {
            return LongArray.class;
        }

        @Override
        public Class<? extends UpdatableLongArray> updatableType() {
            return UpdatableLongArray.class;
        }

        @Override
        public Class<? extends MutableLongArray> mutableType() {
            return MutableLongArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getLong(index);
        }

        @Override
        public final long bitsPerElement() {
            return 64L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public final long maxPossibleValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getLong(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.indexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((long)value) ? this.lastIndexOf(lowIndex, highIndex, (long)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return Arrays.truncateLongToInt(this.storage.getLong(this.offset + index));
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getLong(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfLong(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfLong(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferLongArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferLongArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataLongBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataLongBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataLongBuffer)super.buffer(mode);
        }

        @Override
        public DataLongBuffer buffer(long capacity) {
            return (DataLongBuffer)super.buffer(capacity);
        }

        @Override
        public DataLongBuffer buffer() {
            return (DataLongBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public LongArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final LongArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableLongArray mutableClone(MemoryModel memoryModel) {
            return (MutableLongArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableLongArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableLongArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferLongArray result = (BufferLongArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public long[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array long[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferIntArray
    extends UpdatableBufferIntArray
    implements MutableIntArray {
        MutableBufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableIntArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableIntArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableIntArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableIntArray append(Array appendedArray) {
            MutableBufferIntArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popInt();
        }

        @Override
        public void pushElement(Object value) {
            this.pushInt((Integer)value);
        }

        @Override
        public double popDouble() {
            return this.popInt();
        }

        @Override
        public long popLong() {
            return this.popInt();
        }

        @Override
        public void addDouble(double value) {
            this.pushInt((int)value);
        }

        @Override
        public void addLong(long value) {
            this.pushInt((int)value);
        }

        @Override
        public void addInt(int value) {
            this.pushInt(value);
        }

        @Override
        public int popInt() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getInt(this.offset + this.length);
        }

        @Override
        public void pushInt(int value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setInt(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableIntArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableIntArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableIntArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableIntArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferIntArray result = new MutableBufferIntArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            UpdatableBufferIntArray result = new UpdatableBufferIntArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableIntArray shallowClone() {
            return (MutableBufferIntArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array int[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferIntArray
    extends BufferIntArray
    implements UpdatableIntArray {
        UpdatableBufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setInt(index, (Integer)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setInt(index, (int)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setInt(this.offset + index, value);
        }

        @Override
        public UpdatableIntArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, double value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, long value) {
            return this.fill(position, count, (int)value);
        }

        @Override
        public UpdatableIntArray fill(int value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, int value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Integer filler = value;
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableIntArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferIntArray result = new UpdatableBufferIntArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableIntArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferIntArray result = new UpdatableBufferIntArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final IntArray asImmutable() {
            return new BufferIntArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferIntArray result = new UpdatableBufferIntArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableIntArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferIntArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array int[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferIntArray
    extends AbstractBufferArray
    implements IntArray {
        BufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferIntArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Integer.TYPE;
        }

        @Override
        public Class<? extends IntArray> type() {
            return IntArray.class;
        }

        @Override
        public Class<? extends UpdatableIntArray> updatableType() {
            return UpdatableIntArray.class;
        }

        @Override
        public Class<? extends MutableIntArray> mutableType() {
            return MutableIntArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return this.getInt(index);
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public final long maxPossibleValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getInt(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getInt(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.indexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value) ? this.lastIndexOf(lowIndex, highIndex, (int)value) : -1L;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getInt(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfInt(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, int value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfInt(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferIntArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferIntArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataIntBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataIntBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataIntBuffer)super.buffer(mode);
        }

        @Override
        public DataIntBuffer buffer(long capacity) {
            return (DataIntBuffer)super.buffer(capacity);
        }

        @Override
        public DataIntBuffer buffer() {
            return (DataIntBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public IntArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final IntArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableIntArray mutableClone(MemoryModel memoryModel) {
            return (MutableIntArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableIntArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableIntArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferIntArray result = (BufferIntArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public int[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array int[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferShortArray
    extends UpdatableBufferShortArray
    implements MutableShortArray {
        MutableBufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableShortArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableShortArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableShortArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableShortArray append(Array appendedArray) {
            MutableBufferShortArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popShort();
        }

        @Override
        public void pushElement(Object value) {
            this.pushShort((Short)value);
        }

        @Override
        public double popDouble() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public long popLong() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public int popInt() {
            return this.popShort() & 0xFFFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushShort((short)value);
        }

        @Override
        public void addLong(long value) {
            this.pushShort((short)value);
        }

        @Override
        public void addInt(int value) {
            this.pushShort((short)value);
        }

        @Override
        public short popShort() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getShort(this.offset + this.length);
        }

        @Override
        public void pushShort(short value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setShort(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableShortArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableShortArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableShortArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableShortArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferShortArray result = new MutableBufferShortArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            UpdatableBufferShortArray result = new UpdatableBufferShortArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableShortArray shallowClone() {
            return (MutableBufferShortArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array short[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferShortArray
    extends BufferShortArray
    implements UpdatableShortArray {
        UpdatableBufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setShort(index, (Short)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setShort(index, (short)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setShort(this.offset + index, (short)value);
        }

        @Override
        public final void setShort(long index, short value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setShort(this.offset + index, value);
        }

        @Override
        public UpdatableShortArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, double value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, long value) {
            return this.fill(position, count, (short)value);
        }

        @Override
        public UpdatableShortArray fill(short value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, short value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Short filler = value;
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableShortArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferShortArray result = new UpdatableBufferShortArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableShortArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferShortArray result = new UpdatableBufferShortArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final ShortArray asImmutable() {
            return new BufferShortArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferShortArray result = new UpdatableBufferShortArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableShortArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferShortArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array short[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferShortArray
    extends AbstractBufferArray
    implements ShortArray {
        BufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferShortArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Short.TYPE;
        }

        @Override
        public Class<? extends ShortArray> type() {
            return ShortArray.class;
        }

        @Override
        public Class<? extends UpdatableShortArray> updatableType() {
            return UpdatableShortArray.class;
        }

        @Override
        public Class<? extends MutableShortArray> mutableType() {
            return MutableShortArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (short)this.getShort(index);
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getShort(this.offset + index) & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getShort(this.offset + index) & 0xFFFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getShort(this.offset + index) & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.indexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFFFF) ? this.lastIndexOf(lowIndex, highIndex, (short)value) : -1L;
        }

        @Override
        public final int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getShort(this.offset + index) & 0xFFFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfShort(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, short value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfShort(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferShortArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferShortArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataShortBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataShortBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataShortBuffer)super.buffer(mode);
        }

        @Override
        public DataShortBuffer buffer(long capacity) {
            return (DataShortBuffer)super.buffer(capacity);
        }

        @Override
        public DataShortBuffer buffer() {
            return (DataShortBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ShortArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final ShortArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableShortArray mutableClone(MemoryModel memoryModel) {
            return (MutableShortArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableShortArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableShortArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferShortArray result = (BufferShortArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public short[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array short[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferByteArray
    extends UpdatableBufferByteArray
    implements MutableByteArray {
        MutableBufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableByteArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableByteArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableByteArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableByteArray append(Array appendedArray) {
            MutableBufferByteArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return this.popByte();
        }

        @Override
        public void pushElement(Object value) {
            this.pushByte((Byte)value);
        }

        @Override
        public double popDouble() {
            return this.popByte() & 0xFF;
        }

        @Override
        public long popLong() {
            return this.popByte() & 0xFF;
        }

        @Override
        public int popInt() {
            return this.popByte() & 0xFF;
        }

        @Override
        public void addDouble(double value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addLong(long value) {
            this.pushByte((byte)value);
        }

        @Override
        public void addInt(int value) {
            this.pushByte((byte)value);
        }

        @Override
        public byte popByte() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getByte(this.offset + this.length);
        }

        @Override
        public void pushByte(byte value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setByte(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableByteArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableByteArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableByteArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableByteArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferByteArray result = new MutableBufferByteArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            UpdatableBufferByteArray result = new UpdatableBufferByteArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableByteArray shallowClone() {
            return (MutableBufferByteArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array byte[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferByteArray
    extends BufferByteArray
    implements UpdatableByteArray {
        UpdatableBufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setByte(index, (Byte)value);
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setByte(index, (byte)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setByte(this.offset + index, (byte)value);
        }

        @Override
        public final void setByte(long index, byte value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setByte(this.offset + index, value);
        }

        @Override
        public UpdatableByteArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, double value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, long value) {
            return this.fill(position, count, (byte)value);
        }

        @Override
        public UpdatableByteArray fill(byte value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, byte value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Byte filler = value;
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableByteArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferByteArray result = new UpdatableBufferByteArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableByteArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferByteArray result = new UpdatableBufferByteArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final ByteArray asImmutable() {
            return new BufferByteArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferByteArray result = new UpdatableBufferByteArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableByteArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferByteArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array byte[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferByteArray
    extends AbstractBufferArray
    implements ByteArray {
        BufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferByteArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Byte.TYPE;
        }

        @Override
        public Class<? extends ByteArray> type() {
            return ByteArray.class;
        }

        @Override
        public Class<? extends UpdatableByteArray> updatableType() {
            return UpdatableByteArray.class;
        }

        @Override
        public Class<? extends MutableByteArray> mutableType() {
            return MutableByteArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return (byte)this.getByte(index);
        }

        @Override
        public final long bitsPerElement() {
            return 8L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 255L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getByte(this.offset + index) & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getByte(this.offset + index) & 0xFF;
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getByte(this.offset + index) & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.indexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((int)value & 0xFF) ? this.lastIndexOf(lowIndex, highIndex, (byte)value) : -1L;
        }

        @Override
        public final int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getByte(this.offset + index) & 0xFF;
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfByte(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, byte value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfByte(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferByteArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferByteArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataByteBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataByteBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataByteBuffer)super.buffer(mode);
        }

        @Override
        public DataByteBuffer buffer(long capacity) {
            return (DataByteBuffer)super.buffer(capacity);
        }

        @Override
        public DataByteBuffer buffer() {
            return (DataByteBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public ByteArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final ByteArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableByteArray mutableClone(MemoryModel memoryModel) {
            return (MutableByteArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableByteArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableByteArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferByteArray result = (BufferByteArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public byte[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array byte[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferCharArray
    extends UpdatableBufferCharArray
    implements MutableCharArray {
        MutableBufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableCharArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableCharArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableCharArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableCharArray append(Array appendedArray) {
            MutableBufferCharArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Character.valueOf(this.popChar());
        }

        @Override
        public void pushElement(Object value) {
            this.pushChar(((Character)value).charValue());
        }

        @Override
        public double popDouble() {
            return this.popChar();
        }

        @Override
        public long popLong() {
            return this.popChar();
        }

        @Override
        public int popInt() {
            return this.popChar();
        }

        @Override
        public void addDouble(double value) {
            this.pushChar((char)value);
        }

        @Override
        public void addLong(long value) {
            this.pushChar((char)value);
        }

        @Override
        public void addInt(int value) {
            this.pushChar((char)value);
        }

        @Override
        public char popChar() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getChar(this.offset + this.length);
        }

        @Override
        public void pushChar(char value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setChar(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableCharArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableCharArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableCharArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableCharArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferCharArray result = new MutableBufferCharArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            UpdatableBufferCharArray result = new UpdatableBufferCharArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableCharArray shallowClone() {
            return (MutableBufferCharArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array char[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferCharArray
    extends BufferCharArray
    implements UpdatableCharArray {
        UpdatableBufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setChar(index, ((Character)value).charValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setChar(index, (char)value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setChar(this.offset + index, (char)value);
        }

        @Override
        public final void setChar(long index, char value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setChar(this.offset + index, value);
        }

        @Override
        public UpdatableCharArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, double value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, long value) {
            return this.fill(position, count, (char)value);
        }

        @Override
        public UpdatableCharArray fill(char value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, char value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Character filler = Character.valueOf(value);
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableCharArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferCharArray result = new UpdatableBufferCharArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableCharArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferCharArray result = new UpdatableBufferCharArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final CharArray asImmutable() {
            return new BufferCharArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferCharArray result = new UpdatableBufferCharArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableCharArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferCharArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array char[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferCharArray
    extends AbstractBufferArray
    implements CharArray {
        BufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferCharArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Character.TYPE;
        }

        @Override
        public Class<? extends CharArray> type() {
            return CharArray.class;
        }

        @Override
        public Class<? extends UpdatableCharArray> updatableType() {
            return UpdatableCharArray.class;
        }

        @Override
        public Class<? extends MutableCharArray> mutableType() {
            return MutableCharArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Character.valueOf(this.getChar(index));
        }

        @Override
        public final long bitsPerElement() {
            return 16L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return this.minPossibleValue();
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return this.maxPossibleValue();
        }

        @Override
        public final long minPossibleValue() {
            return 0L;
        }

        @Override
        public final long maxPossibleValue() {
            return 65535L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getChar(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getChar(this.offset + index);
        }

        @Override
        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getChar(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return value == (long)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
        }

        @Override
        public final char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getChar(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfChar(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, char value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfChar(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferCharArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferCharArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataCharBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataCharBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataCharBuffer)super.buffer(mode);
        }

        @Override
        public DataCharBuffer buffer(long capacity) {
            return (DataCharBuffer)super.buffer(capacity);
        }

        @Override
        public DataCharBuffer buffer() {
            return (DataCharBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public CharArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final CharArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableCharArray mutableClone(MemoryModel memoryModel) {
            return (MutableCharArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableCharArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableCharArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferCharArray result = (BufferCharArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public char[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array char[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }

    static final class MutableBufferFloatArray
    extends UpdatableBufferFloatArray
    implements MutableFloatArray {
        MutableBufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        MutableBufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public MutableFloatArray length(long newLength) {
            if (this.length < 0L) {
                throw new IllegalArgumentException("Negative desired array length");
            }
            this.lengthImpl(newLength);
            return this;
        }

        @Override
        public MutableFloatArray ensureCapacity(long minCapacity) {
            if (minCapacity < 0L) {
                throw new IllegalArgumentException("Negative desired array minimal capacity");
            }
            this.ensureCapacityImpl(minCapacity);
            return this;
        }

        @Override
        public MutableFloatArray trim() {
            this.trimImpl();
            return this;
        }

        @Override
        public MutableFloatArray append(Array appendedArray) {
            MutableBufferFloatArray.defaultAppend(this, appendedArray);
            return this;
        }

        @Override
        public Object popElement() {
            return Float.valueOf(this.popFloat());
        }

        @Override
        public void pushElement(Object value) {
            this.pushFloat(((Float)value).floatValue());
        }

        @Override
        public double popDouble() {
            return this.popFloat();
        }

        public long popLong() {
            return (long)this.popFloat();
        }

        public int popInt() {
            return (int)this.popFloat();
        }

        @Override
        public void addDouble(double value) {
            this.pushFloat((float)value);
        }

        @Override
        public void addLong(long value) {
            this.pushFloat(value);
        }

        @Override
        public void addInt(int value) {
            this.pushFloat(value);
        }

        @Override
        public float popFloat() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            return this.storage.getFloat(this.offset + this.length);
        }

        @Override
        public void pushFloat(float value) {
            long newLength = this.length + 1L;
            if (newLength < 0L) {
                assert (newLength == Long.MIN_VALUE);
                throw new TooLargeArrayException("Too large desired array length (2^63)");
            }
            if (newLength > this.capacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.length = newLength;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setFloat(this.offset + this.length - 1L, value);
        }

        @Override
        public void removeTop() {
            if (this.length == 0L) {
                throw new EmptyStackException();
            }
            --this.length;
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            super.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public MutableFloatArray setData(long arrayPos, Object srcArray) {
            super.setData(arrayPos, srcArray);
            return this;
        }

        @Override
        public MutableFloatArray copy(Array src) {
            super.copy(src);
            return this;
        }

        @Override
        public MutableFloatArray swap(UpdatableArray another) {
            super.swap(another);
            return this;
        }

        @Override
        public MutableFloatArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            MutableBufferFloatArray result = new MutableBufferFloatArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public boolean isUnresizable() {
            return false;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            UpdatableBufferFloatArray result = new UpdatableBufferFloatArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public MutableFloatArray shallowClone() {
            return (MutableBufferFloatArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "mutable AlgART array float[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class UpdatableBufferFloatArray
    extends BufferFloatArray
    implements UpdatableFloatArray {
        UpdatableBufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        UpdatableBufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final void setElement(long index, Object value) {
            this.setFloat(index, ((Float)value).floatValue());
        }

        @Override
        public final void copy(long destIndex, long srcIndex) {
            if (srcIndex < 0L || srcIndex >= this.length) {
                throw this.rangeException(srcIndex);
            }
            if (destIndex < 0L || destIndex >= this.length) {
                throw this.rangeException(destIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.copy(this.offset + destIndex, this.offset + srcIndex);
        }

        @Override
        public final void swap(long firstIndex, long secondIndex) {
            if (firstIndex < 0L || firstIndex >= this.length) {
                throw this.rangeException(firstIndex);
            }
            if (secondIndex < 0L || secondIndex >= this.length) {
                throw this.rangeException(secondIndex);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.swap(this.offset + firstIndex, this.offset + secondIndex);
        }

        @Override
        public final void setDouble(long index, double value) {
            this.setFloat(index, (float)value);
        }

        @Override
        public final void setLong(long index, long value) {
            this.setFloat(index, value);
        }

        @Override
        public final void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setFloat(this.offset + index, value);
        }

        @Override
        public final void setFloat(long index, float value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            this.storage.setFloat(this.offset + index, value);
        }

        @Override
        public UpdatableFloatArray fill(double value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, double value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(long value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, long value) {
            return this.fill(position, count, (float)value);
        }

        @Override
        public UpdatableFloatArray fill(float value) {
            return this.fill(0L, this.length, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, float value) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            if (this.copyOnNextWrite) {
                this.reallocateStorage();
            }
            Float filler = Float.valueOf(value);
            this.storage.fillData(this.offset + position, count, filler);
            return this;
        }

        @Override
        public UpdatableFloatArray subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            UpdatableBufferFloatArray result = new UpdatableBufferFloatArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public UpdatableFloatArray subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            UpdatableBufferFloatArray result = new UpdatableBufferFloatArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = this.copyOnNextWrite;
            return result;
        }

        @Override
        public final FloatArray asImmutable() {
            return new BufferFloatArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public final boolean isImmutable() {
            return false;
        }

        @Override
        public UpdatableArray asCopyOnNextWrite() {
            if (this.isCopyOnNextWrite()) {
                return this;
            }
            UpdatableBufferFloatArray result = new UpdatableBufferFloatArray(this.storage, this.capacity, this.length, this.offset, this.underlyingArray == null ? this : this.underlyingArray);
            result.copyOnNextWrite = true;
            return result;
        }

        @Override
        public UpdatableFloatArray asUnresizable() {
            return this;
        }

        @Override
        public UpdatableArray shallowClone() {
            return (UpdatableBufferFloatArray)super.shallowClone();
        }

        @Override
        public String toString() {
            assert (!this.isNewReadOnlyView());
            return "unresizable AlgART array float[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isCopyOnNextWrite() ? ", copy on next write" : "") + (this.isNew() ? ", new" : ", view");
        }
    }

    static class BufferFloatArray
    extends AbstractBufferArray
    implements FloatArray {
        BufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, boolean doAllocate) {
            super(storage, initialCapacity, initialLength, initialOffset, doAllocate);
        }

        BufferFloatArray(DataStorage storage, long initialCapacity, long initialLength, long initialOffset, AbstractBufferArray underlyingArray) {
            super(storage, initialCapacity, initialLength, initialOffset, underlyingArray);
        }

        @Override
        public final Class<?> elementType() {
            return Float.TYPE;
        }

        @Override
        public Class<? extends FloatArray> type() {
            return FloatArray.class;
        }

        @Override
        public Class<? extends UpdatableFloatArray> updatableType() {
            return UpdatableFloatArray.class;
        }

        @Override
        public Class<? extends MutableFloatArray> mutableType() {
            return MutableFloatArray.class;
        }

        @Override
        public final Object getElement(long index) {
            return Float.valueOf(this.getFloat(index));
        }

        @Override
        public final long bitsPerElement() {
            return 32L;
        }

        @Override
        public final double minPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        @Override
        public final double maxPossibleValue(double valueForFloatingPoint) {
            return valueForFloatingPoint;
        }

        public final long minPossibleValue() {
            return -157777L;
        }

        public final long maxPossibleValue() {
            return 157778L;
        }

        @Override
        public final double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getFloat(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, double value) {
            return value == (double)((float)value) ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (long)this.storage.getFloat(this.offset + index);
        }

        public final int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (int)this.storage.getFloat(this.offset + index);
        }

        public final long indexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.indexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        public final long lastIndexOf(long lowIndex, long highIndex, long value) {
            return (float)value == (float)value ? this.lastIndexOf(lowIndex, highIndex, (float)value) : -1L;
        }

        @Override
        public final float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return this.storage.getFloat(this.offset + index);
        }

        @Override
        public final long indexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.indexOfFloat(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public final long lastIndexOf(long lowIndex, long highIndex, float value) {
            if (lowIndex < 0L) {
                lowIndex = 0L;
            }
            if (highIndex > this.length) {
                highIndex = this.length;
            }
            if (highIndex <= lowIndex) {
                return -1L;
            }
            long i = this.storage.lastIndexOfFloat(this.offset + lowIndex, this.offset + highIndex, value);
            return i == -1L ? -1L : i - this.offset;
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            if (fromIndex < 0L) {
                throw this.rangeException(fromIndex);
            }
            if (toIndex > this.length) {
                throw this.rangeException(toIndex - 1L);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
            }
            return new BufferFloatArray(this.storage, toIndex - fromIndex, toIndex - fromIndex, this.offset + fromIndex, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public Array subArr(long position, long count) {
            if (position < 0L) {
                throw this.rangeException(position);
            }
            if (count < 0L) {
                throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
            }
            if (position > this.length - count) {
                throw this.rangeException(position + count - 1L);
            }
            return new BufferFloatArray(this.storage, count, count, this.offset + position, this.underlyingArray == null ? this : this.underlyingArray);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
            return (DataFloatBuffer)super.buffer(mode, capacity);
        }

        @Override
        public DataFloatBuffer buffer(DataBuffer.AccessMode mode) {
            return (DataFloatBuffer)super.buffer(mode);
        }

        @Override
        public DataFloatBuffer buffer(long capacity) {
            return (DataFloatBuffer)super.buffer(capacity);
        }

        @Override
        public DataFloatBuffer buffer() {
            return (DataFloatBuffer)super.buffer();
        }

        @Override
        public boolean isUnresizable() {
            return true;
        }

        @Override
        public FloatArray asImmutable() {
            return this;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public final FloatArray asTrustedImmutable() {
            return this.asImmutable();
        }

        @Override
        public Array asCopyOnNextWrite() {
            return this;
        }

        @Override
        public final MutableFloatArray mutableClone(MemoryModel memoryModel) {
            return (MutableFloatArray)super.mutableClone(memoryModel);
        }

        @Override
        public final UpdatableFloatArray updatableClone(MemoryModel memoryModel) {
            return (UpdatableFloatArray)super.updatableClone(memoryModel);
        }

        @Override
        public Array shallowClone() {
            BufferFloatArray result = (BufferFloatArray)this.standardObjectClone();
            if (this.underlyingArray == null) {
                result.storage.attachArray(result);
                BufferArraysImpl.forgetOnDeallocation(result);
            }
            return result;
        }

        @Override
        public float[] ja() {
            return this.toJavaArray();
        }

        @Override
        public String toString() {
            return "immutable AlgART array float[" + this.length() + "], @<" + String.valueOf(this.storage) + ">, capacity " + this.capacity() + (String)(this.offset == 0L ? "" : ", offset = " + this.offset) + (this.isNew() ? ", new" : (this.isNewReadOnlyView() ? ", new read-only view" : ", view"));
        }
    }
}

