/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Arrays;
import net.algart.arrays.ArraySelector;

public class ByteArraySelector {
    private static final int MAX_LENGTH_FOR_PARTIAL_CLEARING = 100;
    private final int[] histogram = new int[256];
    private final int[] histogram16 = new int[16];

    public void select(byte[] results, int[] percentileIndexes, byte[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        for (int k = 0; k < length; ++k) {
            int v;
            int n = v = array[k] & 0xFF;
            this.histogram[n] = this.histogram[n] + 1;
            int n2 = v >> 4;
            this.histogram16[n2] = this.histogram16[n2] + 1;
        }
        int i = 0;
        int j = 0;
        int acc16 = 0;
        int acc = 0;
        for (int levelIndex = 0; levelIndex < percentileIndexes.length; ++levelIndex) {
            int h;
            int newAcc;
            int h16;
            int newAcc16;
            int requiredArrayIndex = percentileIndexes[levelIndex];
            assert (requiredArrayIndex >= 0);
            assert (requiredArrayIndex < length);
            while (requiredArrayIndex >= (newAcc16 = acc16 + (h16 = this.histogram16[i]))) {
                acc = acc16 = newAcc16;
                j = 0;
                ++i;
            }
            int start = i << 4;
            int p = start + j;
            while (requiredArrayIndex >= (newAcc = acc + (h = this.histogram[p]))) {
                acc = newAcc;
                ++p;
            }
            results[levelIndex] = (byte)p;
            j = p - start;
        }
        if (length <= 100) {
            for (int k = 0; k < length; ++k) {
                this.histogram[array[k] & 0xFF] = 0;
            }
        } else {
            Arrays.fill(this.histogram, 0);
        }
        Arrays.fill(this.histogram16, 0);
    }

    public void select(byte[] results, double[] percentileLevels, byte[] array, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements = " + length);
        }
        if (length > array.length) {
            throw new IllegalArgumentException("length = " + length + " > array.length = " + array.length);
        }
        for (int k = 0; k < length; ++k) {
            int v;
            int n = v = array[k] & 0xFF;
            this.histogram[n] = this.histogram[n] + 1;
            int n2 = v >> 4;
            this.histogram16[n2] = this.histogram16[n2] + 1;
        }
        int i = 0;
        int j = 0;
        int acc16 = 0;
        int acc = 0;
        for (int levelIndex = 0; levelIndex < percentileLevels.length; ++levelIndex) {
            int h;
            int newAcc;
            int h16;
            int newAcc16;
            int requiredArrayIndex = ArraySelector.percentileIndex(percentileLevels[levelIndex], length);
            assert (requiredArrayIndex >= 0);
            assert (requiredArrayIndex < length);
            while (requiredArrayIndex >= (newAcc16 = acc16 + (h16 = this.histogram16[i]))) {
                acc = acc16 = newAcc16;
                j = 0;
                ++i;
            }
            int start = i << 4;
            int p = start + j;
            while (requiredArrayIndex >= (newAcc = acc + (h = this.histogram[p]))) {
                acc = newAcc;
                ++p;
            }
            results[levelIndex] = (byte)p;
            j = p - start;
        }
        if (length <= 100) {
            for (int k = 0; k < length; ++k) {
                this.histogram[array[k] & 0xFF] = 0;
            }
        } else {
            Arrays.fill(this.histogram, 0);
        }
        Arrays.fill(this.histogram16, 0);
    }
}

