/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public final class JArrayPool {
    private final Class<?> elementType;
    private final int arrayLength;
    private final List<Reference<Object>> freeArrays = new LinkedList<Reference<Object>>();
    private final ReentrantLock lock = new ReentrantLock();

    private JArrayPool(Class<?> elementType, int arrayLength) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (arrayLength < 0) {
            throw new IllegalArgumentException("Negative arrayLength");
        }
        this.elementType = elementType;
        this.arrayLength = arrayLength;
    }

    public static JArrayPool getInstance(Class<?> elementType, int arrayLength) {
        return new JArrayPool(elementType, arrayLength);
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public int arrayLength() {
        return this.arrayLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requestArray() {
        this.lock.lock();
        try {
            Iterator<Reference<Object>> iterator = this.freeArrays.iterator();
            while (iterator.hasNext()) {
                Reference<Object> ref = iterator.next();
                Object array = ref.get();
                iterator.remove();
                if (array == null) continue;
                Object object = array;
                return object;
            }
            Object object = this.newJavaArray();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseArray(Object array) {
        if (array == null) {
            return;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The array argument is not a Java array");
        }
        if (array.getClass().getComponentType() != this.elementType) {
            throw new IllegalArgumentException("The type of array elements does not match this Java array pool");
        }
        if (Array.getLength(array) != this.arrayLength) {
            throw new IllegalArgumentException("The array length does not match this Java array pool");
        }
        this.lock.lock();
        try {
            this.freeArrays.add(new SoftReference<Object>(array));
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "Java array pool for storing " + this.elementType.getCanonicalName() + "[" + this.arrayLength + "] (" + this.freeArrays.size() + " arrays in the cache)";
    }

    private Object newJavaArray() {
        return Array.newInstance(this.elementType, this.arrayLength);
    }
}

