/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableLongArray;

public interface LongArray
extends PIntegerArray {
    public Class<? extends LongArray> type();

    public Class<? extends UpdatableLongArray> updatableType();

    public Class<? extends MutableLongArray> mutableType();

    @Override
    public long getLong(long var1);

    default public long[] newJavaArray(int length) {
        return new long[length];
    }

    @Override
    public long indexOf(long var1, long var3, long var5);

    @Override
    public long lastIndexOf(long var1, long var3, long var5);

    @Override
    public DataLongBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataLongBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataLongBuffer buffer(long var1);

    @Override
    public DataLongBuffer buffer();

    @Override
    public LongArray asImmutable();

    @Override
    public LongArray asTrustedImmutable();

    @Override
    public MutableLongArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableLongArray updatableClone(MemoryModel var1);

    default public long[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to long[] Java array, because it is too large: " + String.valueOf(this));
        }
        long[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public long[] ja();

    default public Matrix<? extends LongArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public long[] toLong() {
        return this.toJavaArray();
    }

    @Override
    default public long[] jaLong() {
        return this.ja();
    }

    public static UpdatableLongArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableLongArray(length);
    }

    public static UpdatableLongArray newArray(long length) {
        return Arrays.SMM.newUnresizableLongArray(length);
    }

    @Override
    public int getInt(long var1);

    public static UpdatableLongArray as(long[] array) {
        return SimpleMemoryModel.asUpdatableLongArray(array);
    }
}

