/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.IOError;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBitStorage;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFile;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DefaultDataFileModel;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.JBuffers;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.PackedBitBuffers;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.StandardIODataFileModel;
import net.algart.arrays.TooLargeArrayException;

class MappedDataStorages {
    static final Set<MappedStorage> allNonFinalizedMappedStorages = Collections.synchronizedSet(new HashSet());
    private static boolean tempCleanerInstalled = false;
    private static final boolean configLoggable = LargeMemoryModel.LOGGER.isLoggable(Level.CONFIG);
    private static final boolean warningLoggable = LargeMemoryModel.LOGGER.isLoggable(Level.WARNING);
    private static final boolean finestLoggable = LargeMemoryModel.LOGGER.isLoggable(Level.FINEST);
    static volatile boolean shutdownInProgress = false;

    private MappedDataStorages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void installTempCleaner() {
        Map<WeakReference<DataFileModel<?>>, Object> map = LargeMemoryModel.allUsedDataFileModelsWithAutoDeletion;
        synchronized (map) {
            if (!tempCleanerInstalled) {
                InternalUtils.addShutdownTask(new TempCleaner(), null);
                tempCleanerInstalled = true;
            }
        }
    }

    private static void severeEvenInHook(String msg, Throwable thrown) {
        if (!shutdownInProgress) {
            LargeMemoryModel.LOGGER.log(Level.SEVERE, msg, thrown);
        }
        System.err.println("SEVERE: " + msg);
        System.err.println(thrown);
    }

    private static void configEvenInHook(String msg) {
        if (!shutdownInProgress) {
            LargeMemoryModel.LOGGER.config(msg);
        } else if (configLoggable) {
            System.err.println("CONFIG: " + msg);
        }
    }

    private static void warningEvenInHook(String msg) {
        if (!shutdownInProgress) {
            LargeMemoryModel.LOGGER.warning(msg);
        } else if (warningLoggable) {
            System.err.println("WARNING: " + msg);
        }
    }

    private static void finestEvenInHook(String msg) {
        if (!shutdownInProgress) {
            LargeMemoryModel.LOGGER.finest(msg);
        } else if (finestLoggable) {
            System.out.println("FINEST: " + msg);
        }
    }

    private static String finalizationTasksInfo() {
        return LargeMemoryModel.globalArrayFinalizer.activeTasksCount() + " array tasks, " + LargeMemoryModel.globalMappingFinalizer.activeTasksCount() + " mapping tasks, " + LargeMemoryModel.globalStorageFinalizer.activeTasksCount() + " storage tasks";
    }

    private static boolean deleteWithSeveralAttempts(DataFileModel<?> dfm, DataFile df, int timeoutInMillis) {
        if (timeoutInMillis < 0) {
            throw new IllegalArgumentException("Negative timeout");
        }
        while (timeoutInMillis > 0) {
            try {
                return dfm.delete(df);
            }
            catch (Error e) {
                Error error = e;
                try {
                    Thread.sleep(Math.min(100, timeoutInMillis));
                }
                catch (InterruptedException ex) {
                    throw error;
                }
                timeoutInMillis -= 100;
                continue;
            }
            break;
        }
        return dfm.delete(df);
    }

    private static class TempCleaner
    implements Runnable {
        private TempCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            shutdownInProgress = true;
            int lastNumberOfFiles = -1;
            for (int attemptCount = 1; attemptCount <= 4; ++attemptCount) {
                HashSet<MappedStorage> all;
                Set<MappedStorage> set = allNonFinalizedMappedStorages;
                synchronized (set) {
                    all = new HashSet<MappedStorage>(allNonFinalizedMappedStorages);
                }
                int failedCount = 0;
                for (MappedStorage mappedStorage : all) {
                    boolean ok = false;
                    try {
                        mappedStorage.dispose(MappedStorage.DisposeCaller.SHUTDOWN_HOOK);
                        ok = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (ok) {
                        allNonFinalizedMappedStorages.remove(mappedStorage);
                        continue;
                    }
                    ++failedCount;
                }
                if (failedCount == 0) break;
                int successfulCount = all.size() - failedCount;
                MappedDataStorages.warningEvenInHook(failedCount + " storage files were not deleted in the attempt #" + attemptCount + (String)(successfulCount > 0 ? " (but " + successfulCount + " were deleted)" : "") + "; we shall sleep for 100 ms and try again");
                if (all.size() == lastNumberOfFiles) break;
                lastNumberOfFiles = all.size();
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "Standard AlgART shutdown cleaner";
        }
    }

    static class MappedDoubleStorage
    extends MappedStorage {
        private final DoubleBuffer[] db;
        private final DataDoubleBuffer dbuf;

        MappedDoubleStorage(MappingSettings<?> ms) {
            super(ms);
            this.db = (DoubleBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataDoubleBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedDoubleStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        @Override
        final double getDouble(long index) {
            DoubleBuffer db0 = this.db[0];
            if (this.syncNecessary || db0 != this.validSingleSpecBufForThisThread || db0 == null) {
                return this.getDoubleSync(index);
            }
            return db0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getDoubleSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                double d = this.db[0].get((int)i);
                return d;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setDouble(long index, double value) {
            DoubleBuffer db1 = this.db[1];
            if (this.syncNecessary || db1 != this.validSingleSpecBufForThisThread || db1 == null) {
                this.setDoubleSync(index, value);
            } else {
                db1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setDoubleSync(long index, double value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.db[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfDouble(long lowIndex, long highIndex, double value) {
            long result;
            DoubleBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.db[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfDouble(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.db[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfDouble(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
            long result;
            DoubleBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.db[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfDouble(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.db[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfDouble(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            DoubleBuffer db0 = this.db[0];
            DoubleBuffer db1 = this.db[1];
            if (this.syncNecessary || db0 != this.validSingleSpecBufForThisThread || db1 != db0 || db0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                db1.put((int)destIndex, db0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setDouble(destIndex, this.getDouble(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            DoubleBuffer db0 = this.db[0];
            DoubleBuffer db1 = this.db[1];
            if (this.syncNecessary || db0 != this.validSingleSpecBufForThisThread || db1 != db0 || db0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                double v1 = db0.get(i1);
                double v2 = db1.get(i2);
                db0.put(i1, v2);
                db1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                double v1 = this.db[0].get(i1);
                double v2 = this.db[1].get(i2);
                this.db[0].put(i1, v2);
                this.db[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.db[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asDoubleBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, doubleZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            DoubleBuffer dup = ((DoubleBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((double[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            DoubleBuffer dup = ((DoubleBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((double[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillDoubleBuffer(this.db[0], ofs, cnt, (Double)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyDoubleBuffer(this.db[copyToSecondBank ? 1 : 0], destOfs, ((MappedDoubleStorage)src).db[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapDoubleBuffer(((MappedDoubleStorage)another).db[0], anotherOfs, this.db[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minDoubleArrayAndBuffer((double[])destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxDoubleArrayAndBuffer((double[])destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addDoubleBufferToArray(destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addDoubleBufferToArray(destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractDoubleBufferFromArray((double[])destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfDoubleArrayAndBuffer((double[])destArray, destArrayOffset, (DoubleBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                DoubleBuffer bankSpecBuf = bankBB.asDoubleBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 3, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedFloatStorage
    extends MappedStorage {
        private final FloatBuffer[] fb;
        private final DataFloatBuffer dbuf;

        MappedFloatStorage(MappingSettings<?> ms) {
            super(ms);
            this.fb = (FloatBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataFloatBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedFloatStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 2;
        }

        @Override
        final float getFloat(long index) {
            FloatBuffer fb0 = this.fb[0];
            if (this.syncNecessary || fb0 != this.validSingleSpecBufForThisThread || fb0 == null) {
                return this.getFloatSync(index);
            }
            return fb0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getFloatSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                float f = this.fb[0].get((int)i);
                return f;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setFloat(long index, float value) {
            FloatBuffer fb1 = this.fb[1];
            if (this.syncNecessary || fb1 != this.validSingleSpecBufForThisThread || fb1 == null) {
                this.setFloatSync(index, value);
            } else {
                fb1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFloatSync(long index, float value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.fb[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfFloat(long lowIndex, long highIndex, float value) {
            long result;
            FloatBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.fb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfFloat(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.fb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfFloat(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
            long result;
            FloatBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.fb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfFloat(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.fb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfFloat(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            FloatBuffer fb0 = this.fb[0];
            FloatBuffer fb1 = this.fb[1];
            if (this.syncNecessary || fb0 != this.validSingleSpecBufForThisThread || fb1 != fb0 || fb0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                fb1.put((int)destIndex, fb0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setFloat(destIndex, this.getFloat(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            FloatBuffer fb0 = this.fb[0];
            FloatBuffer fb1 = this.fb[1];
            if (this.syncNecessary || fb0 != this.validSingleSpecBufForThisThread || fb1 != fb0 || fb0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                float v1 = fb0.get(i1);
                float v2 = fb1.get(i2);
                fb0.put(i1, v2);
                fb1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                float v1 = this.fb[0].get(i1);
                float v2 = this.fb[1].get(i2);
                this.fb[0].put(i1, v2);
                this.fb[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.fb[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asFloatBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, floatZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            FloatBuffer dup = ((FloatBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((float[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            FloatBuffer dup = ((FloatBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((float[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillFloatBuffer(this.fb[0], ofs, cnt, ((Float)fillerWrapper).floatValue());
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyFloatBuffer(this.fb[copyToSecondBank ? 1 : 0], destOfs, ((MappedFloatStorage)src).fb[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapFloatBuffer(((MappedFloatStorage)another).fb[0], anotherOfs, this.fb[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minFloatArrayAndBuffer((float[])destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxFloatArrayAndBuffer((float[])destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addFloatBufferToArray(destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addFloatBufferToArray(destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractFloatBufferFromArray((float[])destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfFloatArrayAndBuffer((float[])destArray, destArrayOffset, (FloatBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                FloatBuffer bankSpecBuf = bankBB.asFloatBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 2, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedLongStorage
    extends MappedStorage {
        private final LongBuffer[] lb;
        private final DataLongBuffer dbuf;

        MappedLongStorage(MappingSettings<?> ms) {
            super(ms);
            this.lb = (LongBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataLongBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedLongStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        @Override
        final long getLong(long index) {
            LongBuffer lb0 = this.lb[0];
            if (this.syncNecessary || lb0 != this.validSingleSpecBufForThisThread || lb0 == null) {
                return this.getLongSync(index);
            }
            return lb0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getLongSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                long l = this.lb[0].get((int)i);
                return l;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setLong(long index, long value) {
            LongBuffer lb1 = this.lb[1];
            if (this.syncNecessary || lb1 != this.validSingleSpecBufForThisThread || lb1 == null) {
                this.setLongSync(index, value);
            } else {
                lb1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setLongSync(long index, long value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.lb[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfLong(long lowIndex, long highIndex, long value) {
            long result;
            LongBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfLong(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfLong(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfLong(long lowIndex, long highIndex, long value) {
            long result;
            LongBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfLong(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfLong(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            LongBuffer lb0 = this.lb[0];
            LongBuffer lb1 = this.lb[1];
            if (this.syncNecessary || lb0 != this.validSingleSpecBufForThisThread || lb1 != lb0 || lb0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                lb1.put((int)destIndex, lb0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setLong(destIndex, this.getLong(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            LongBuffer lb0 = this.lb[0];
            LongBuffer lb1 = this.lb[1];
            if (this.syncNecessary || lb0 != this.validSingleSpecBufForThisThread || lb1 != lb0 || lb0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                long v1 = lb0.get(i1);
                long v2 = lb1.get(i2);
                lb0.put(i1, v2);
                lb1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                long v1 = this.lb[0].get(i1);
                long v2 = this.lb[1].get(i2);
                this.lb[0].put(i1, v2);
                this.lb[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.lb[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asLongBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, longZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            LongBuffer dup = ((LongBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((long[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            LongBuffer dup = ((LongBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((long[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillLongBuffer(this.lb[0], ofs, cnt, (Long)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyLongBuffer(this.lb[copyToSecondBank ? 1 : 0], destOfs, ((MappedLongStorage)src).lb[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapLongBuffer(((MappedLongStorage)another).lb[0], anotherOfs, this.lb[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minLongArrayAndBuffer((long[])destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxLongArrayAndBuffer((long[])destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addLongBufferToArray(destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addLongBufferToArray(destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractLongBufferFromArray((long[])destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfLongArrayAndBuffer((long[])destArray, destArrayOffset, (LongBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                LongBuffer bankSpecBuf = bankBB.asLongBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 3, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedIntStorage
    extends MappedStorage {
        private final IntBuffer[] ib;
        private final DataIntBuffer dbuf;

        MappedIntStorage(MappingSettings<?> ms) {
            super(ms);
            this.ib = (IntBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataIntBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedIntStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 2;
        }

        @Override
        final int getInt(long index) {
            IntBuffer ib0 = this.ib[0];
            if (this.syncNecessary || ib0 != this.validSingleSpecBufForThisThread || ib0 == null) {
                return this.getIntSync(index);
            }
            return ib0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getIntSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                int n = this.ib[0].get((int)i);
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setInt(long index, int value) {
            IntBuffer ib1 = this.ib[1];
            if (this.syncNecessary || ib1 != this.validSingleSpecBufForThisThread || ib1 == null) {
                this.setIntSync(index, value);
            } else {
                ib1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setIntSync(long index, int value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.ib[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfInt(long lowIndex, long highIndex, int value) {
            long result;
            IntBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.ib[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfInt(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.ib[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfInt(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfInt(long lowIndex, long highIndex, int value) {
            long result;
            IntBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.ib[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfInt(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.ib[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfInt(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            IntBuffer ib0 = this.ib[0];
            IntBuffer ib1 = this.ib[1];
            if (this.syncNecessary || ib0 != this.validSingleSpecBufForThisThread || ib1 != ib0 || ib0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                ib1.put((int)destIndex, ib0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setInt(destIndex, this.getInt(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            IntBuffer ib0 = this.ib[0];
            IntBuffer ib1 = this.ib[1];
            if (this.syncNecessary || ib0 != this.validSingleSpecBufForThisThread || ib1 != ib0 || ib0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                int v1 = ib0.get(i1);
                int v2 = ib1.get(i2);
                ib0.put(i1, v2);
                ib1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                int v1 = this.ib[0].get(i1);
                int v2 = this.ib[1].get(i2);
                this.ib[0].put(i1, v2);
                this.ib[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.ib[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asIntBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, intZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            IntBuffer dup = ((IntBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((int[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            IntBuffer dup = ((IntBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((int[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillIntBuffer(this.ib[0], ofs, cnt, (Integer)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyIntBuffer(this.ib[copyToSecondBank ? 1 : 0], destOfs, ((MappedIntStorage)src).ib[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapIntBuffer(((MappedIntStorage)another).ib[0], anotherOfs, this.ib[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minIntArrayAndBuffer((int[])destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxIntArrayAndBuffer((int[])destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addIntBufferToArray(destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addIntBufferToArray(destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractIntBufferFromArray((int[])destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count, truncateOverflows);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfIntArrayAndBuffer((int[])destArray, destArrayOffset, (IntBuffer)buf, (int)firstBankOffset, count, truncateOverflows);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                IntBuffer bankSpecBuf = bankBB.asIntBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 2, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedShortStorage
    extends MappedStorage {
        private final ShortBuffer[] sb;
        private final DataShortBuffer dbuf;

        MappedShortStorage(MappingSettings<?> ms) {
            super(ms);
            this.sb = (ShortBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataShortBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedShortStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 1;
        }

        @Override
        final short getShort(long index) {
            ShortBuffer sb0 = this.sb[0];
            if (this.syncNecessary || sb0 != this.validSingleSpecBufForThisThread || sb0 == null) {
                return this.getShortSync(index);
            }
            return sb0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short getShortSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                short s = this.sb[0].get((int)i);
                return s;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setShort(long index, short value) {
            ShortBuffer sb1 = this.sb[1];
            if (this.syncNecessary || sb1 != this.validSingleSpecBufForThisThread || sb1 == null) {
                this.setShortSync(index, value);
            } else {
                sb1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setShortSync(long index, short value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.sb[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfShort(long lowIndex, long highIndex, short value) {
            long result;
            ShortBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.sb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfShort(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.sb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfShort(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfShort(long lowIndex, long highIndex, short value) {
            long result;
            ShortBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.sb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfShort(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.sb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfShort(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            ShortBuffer sb0 = this.sb[0];
            ShortBuffer sb1 = this.sb[1];
            if (this.syncNecessary || sb0 != this.validSingleSpecBufForThisThread || sb1 != sb0 || sb0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                sb1.put((int)destIndex, sb0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setShort(destIndex, this.getShort(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            ShortBuffer sb0 = this.sb[0];
            ShortBuffer sb1 = this.sb[1];
            if (this.syncNecessary || sb0 != this.validSingleSpecBufForThisThread || sb1 != sb0 || sb0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                short v1 = sb0.get(i1);
                short v2 = sb1.get(i2);
                sb0.put(i1, v2);
                sb1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                short v1 = this.sb[0].get(i1);
                short v2 = this.sb[1].get(i2);
                this.sb[0].put(i1, v2);
                this.sb[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.sb[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asShortBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, shortZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            ShortBuffer dup = ((ShortBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((short[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            ShortBuffer dup = ((ShortBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((short[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillShortBuffer(this.sb[0], ofs, cnt, (Short)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyShortBuffer(this.sb[copyToSecondBank ? 1 : 0], destOfs, ((MappedShortStorage)src).sb[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapShortBuffer(((MappedShortStorage)another).sb[0], anotherOfs, this.sb[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minShortArrayAndBuffer((short[])destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxShortArrayAndBuffer((short[])destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addShortBufferToArray(destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addShortBufferToArray(destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractShortBufferFromArray((short[])destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count, truncateOverflows);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfShortArrayAndBuffer((short[])destArray, destArrayOffset, (ShortBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                ShortBuffer bankSpecBuf = bankBB.asShortBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 1, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedCharStorage
    extends MappedStorage {
        private final CharBuffer[] cb;
        private final DataCharBuffer dbuf;

        MappedCharStorage(MappingSettings<?> ms) {
            super(ms);
            this.cb = (CharBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataCharBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedCharStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 1;
        }

        @Override
        final char getChar(long index) {
            CharBuffer cb0 = this.cb[0];
            if (this.syncNecessary || cb0 != this.validSingleSpecBufForThisThread || cb0 == null) {
                return this.getCharSync(index);
            }
            return cb0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private char getCharSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                char c = this.cb[0].get((int)i);
                return c;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setChar(long index, char value) {
            CharBuffer cb1 = this.cb[1];
            if (this.syncNecessary || cb1 != this.validSingleSpecBufForThisThread || cb1 == null) {
                this.setCharSync(index, value);
            } else {
                cb1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setCharSync(long index, char value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.cb[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfChar(long lowIndex, long highIndex, char value) {
            long result;
            CharBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.cb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfChar(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.cb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfChar(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfChar(long lowIndex, long highIndex, char value) {
            long result;
            CharBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.cb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfChar(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.cb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfChar(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            CharBuffer cb0 = this.cb[0];
            CharBuffer cb1 = this.cb[1];
            if (this.syncNecessary || cb0 != this.validSingleSpecBufForThisThread || cb1 != cb0 || cb0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                cb1.put((int)destIndex, cb0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setChar(destIndex, this.getChar(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            CharBuffer cb0 = this.cb[0];
            CharBuffer cb1 = this.cb[1];
            if (this.syncNecessary || cb0 != this.validSingleSpecBufForThisThread || cb1 != cb0 || cb0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                char v1 = cb0.get(i1);
                char v2 = cb1.get(i2);
                cb0.put(i1, v2);
                cb1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                char v1 = this.cb[0].get(i1);
                char v2 = this.cb[1].get(i2);
                this.cb[0].put(i1, v2);
                this.cb[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.cb[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asCharBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, charZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            CharBuffer dup = ((CharBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((char[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            CharBuffer dup = ((CharBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((char[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillCharBuffer(this.cb[0], ofs, cnt, ((Character)fillerWrapper).charValue());
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyCharBuffer(this.cb[copyToSecondBank ? 1 : 0], destOfs, ((MappedCharStorage)src).cb[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapCharBuffer(((MappedCharStorage)another).cb[0], anotherOfs, this.cb[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minCharArrayAndBuffer((char[])destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxCharArrayAndBuffer((char[])destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addCharBufferToArray(destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addCharBufferToArray(destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractCharBufferFromArray((char[])destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count, truncateOverflows);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfCharArrayAndBuffer((char[])destArray, destArrayOffset, (CharBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                CharBuffer bankSpecBuf = bankBB.asCharBuffer();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 1, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedByteStorage
    extends MappedStorage {
        private final ByteBuffer[] bb;
        private final DataByteBuffer dbuf;

        MappedByteStorage(MappingSettings<?> ms) {
            super(ms);
            this.bb = (ByteBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataByteBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedByteStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 0;
        }

        @Override
        final byte getByte(long index) {
            ByteBuffer bb0 = this.bb[0];
            if (this.syncNecessary || bb0 != this.validSingleSpecBufForThisThread || bb0 == null) {
                return this.getByteSync(index);
            }
            return bb0.get((int)index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte getByteSync(long index) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                byte by = this.bb[0].get((int)i);
                return by;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void setByte(long index, byte value) {
            ByteBuffer bb1 = this.bb[1];
            if (this.syncNecessary || bb1 != this.validSingleSpecBufForThisThread || bb1 == null) {
                this.setByteSync(index, value);
            } else {
                bb1.put((int)index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setByteSync(long index, byte value) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                this.bb[1].put((int)i, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfByte(long lowIndex, long highIndex, byte value) {
            long result;
            ByteBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(lowIndex);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(bse - ofs));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.bb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.indexOfByte(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.bb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.indexOfByte(buf, 0, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
            long result;
            ByteBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            int ofs = (int)this.offset(highIndex - 1L);
            assert (ofs >= 0);
            long count = highIndex - lowIndex;
            int bse = (int)this.ms.bankSizeInElements;
            assert ((long)bse == this.ms.bankSizeInElements);
            int len = this.singleMapping ? (int)count : (int)Math.min(count, (long)(ofs + 1));
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == (long)ofs);
                    buf = this.bb[0];
                }
                finally {
                    lock.unlock();
                }
                result = JBuffers.lastIndexOfByte(buf, ofs - len + 1, ofs + 1, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - (long)ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= (long)len;
            count -= (long)len;
            while (count > 0L) {
                len = (int)Math.min(count, (long)bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == (long)(bse - 1));
                        buf = this.bb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = JBuffers.lastIndexOfByte(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - (long)bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= (long)bse;
                count -= (long)bse;
            }
            return -1L;
        }

        @Override
        final void copy(long destIndex, long srcIndex) {
            ByteBuffer bb0 = this.bb[0];
            ByteBuffer bb1 = this.bb[1];
            if (this.syncNecessary || bb0 != this.validSingleSpecBufForThisThread || bb1 != bb0 || bb0 == null) {
                this.copySync(destIndex, srcIndex);
            } else {
                bb1.put((int)destIndex, bb0.get((int)srcIndex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copySync(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setByte(destIndex, this.getByte(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        final void swap(long firstIndex, long secondIndex) {
            ByteBuffer bb0 = this.bb[0];
            ByteBuffer bb1 = this.bb[1];
            if (this.syncNecessary || bb0 != this.validSingleSpecBufForThisThread || bb1 != bb0 || bb0 == null) {
                this.swapSync(firstIndex, secondIndex);
            } else {
                int i1 = (int)firstIndex;
                int i2 = (int)secondIndex;
                byte v1 = bb0.get(i1);
                byte v2 = bb1.get(i2);
                bb0.put(i1, v2);
                bb1.put(i2, v1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void swapSync(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i1 = (int)this.translateIndex(firstIndex);
                assert (i1 >= 0);
                int i2 = (int)this.translateIndex(secondIndex, true);
                assert (i2 >= 0);
                byte v1 = this.bb[0].get(i1);
                byte v2 = this.bb[1].get(i2);
                this.bb[0].put(i1, v2);
                this.bb[1].put(i2, v1);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.bb[bank] = this.bh[bank] == null ? null : this.bh[bank].data();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, byteZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            ByteBuffer dup = ((ByteBuffer)buf).duplicate();
            dup.position(ofs);
            dup.get((byte[])destArray, destArrayOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            int ofs = (int)firstBankOffset;
            assert (firstBankOffset == (long)ofs);
            ByteBuffer dup = ((ByteBuffer)buf).duplicate();
            dup.position(ofs);
            dup.put((byte[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            int ofs = (int)destOffset;
            int cnt = (int)count;
            assert (destOffset == (long)ofs);
            assert (count == (long)cnt);
            JBuffers.fillByteBuffer(this.bb[0], ofs, cnt, (Byte)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            int srcOfs = (int)srcOffset;
            int destOfs = (int)destOffset;
            int cnt = (int)count;
            assert (srcOffset == (long)srcOfs);
            assert (destOffset == (long)destOfs);
            assert (count == (long)cnt);
            JBuffers.copyByteBuffer(this.bb[copyToSecondBank ? 1 : 0], destOfs, ((MappedByteStorage)src).bb[0], srcOfs, cnt, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            int anotherOfs = (int)anotherOffset;
            int thisOfs = (int)thisOffset;
            int cnt = (int)count;
            assert (anotherOffset == (long)anotherOfs);
            assert (thisOffset == (long)thisOfs);
            assert (count == (long)cnt);
            JBuffers.swapByteBuffer(((MappedByteStorage)another).bb[0], anotherOfs, this.bb[swapWithSecondBank ? 1 : 0], thisOfs, cnt);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.minByteArrayAndBuffer((byte[])destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            JBuffers.maxByteArrayAndBuffer((byte[])destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            JBuffers.addByteBufferToArray(destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            JBuffers.addByteBufferToArray(destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count, mult);
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.subtractByteBufferFromArray((byte[])destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count, truncateOverflows);
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            JBuffers.absDiffOfByteArrayAndBuffer((byte[])destArray, destArrayOffset, (ByteBuffer)buf, (int)firstBankOffset, count);
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 7L) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                int len;
                ByteBuffer bankSpecBuf = bankBB.duplicate();
                int count = bankSpecBuf.limit();
                if ((long)count > length - elementIndex) {
                    count = (int)(length - elementIndex);
                    this.actualizeLazyZeroFillingBank(bankBB, count << 0, bankBB.limit());
                }
                for (long ofs = 0L; ofs < (long)count; ofs += (long)len) {
                    this.dbuf.map(elementIndex + ofs, (long)count - ofs);
                    len = this.dbuf.cnt();
                    assert (len > 0);
                    bankSpecBuf.put(this.dbuf.data(), this.dbuf.from(), len);
                }
            }
        }
    }

    static class MappedBitStorage
    extends MappedStorage
    implements DataBitStorage {
        private final LongBuffer[] lb;
        private final DataBitBuffer dbuf;

        MappedBitStorage(MappingSettings<?> ms) {
            super(ms);
            this.lb = (LongBuffer[])this.specBufs;
            this.dbuf = ms.lazyFillingPattern == null ? null : (DataBitBuffer)Arrays.bufferInternal(ms.lazyFillingPattern, DataBuffer.AccessMode.READ);
        }

        @Override
        DataStorage newCompatibleEmptyStorage(boolean unresizable) {
            return new MappedBitStorage(this.ms.getCompatibleInstanceForNewTemporaryFile(unresizable));
        }

        @Override
        int bytesPerBufferElementLog() {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean getBit(long index) {
            boolean sync;
            ReentrantLock lock = this.lock;
            LongBuffer lb0 = this.lb[0];
            boolean bl = sync = this.syncNecessary || lb0 != this.validSingleSpecBufForThisThread || lb0 == null;
            if (sync) {
                lock.lock();
            }
            try {
                long i;
                if (sync) {
                    i = (index & this.indexHighBits) == this.bankPos[0] ? index - this.bankPos[0] : this.translateFailedIndex(index, false, MappedStorage.LoadingMode.DEFAULT);
                    lb0 = this.lb[0];
                } else {
                    i = index;
                }
                int ii = (int)(i >>> 6);
                int bit = (int)i & 0x3F;
                boolean bl2 = (lb0.get(ii) & 1L << bit) != 0L;
                return bl2;
            }
            finally {
                if (sync) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void setBit(long index, boolean value) {
            boolean sync;
            ReentrantLock lock = this.lock;
            LongBuffer lb1 = this.lb[1];
            boolean bl = sync = this.syncNecessary || lb1 != this.validSingleSpecBufForThisThread || lb1 == null;
            if (sync) {
                lock.lock();
            }
            try {
                long i;
                if (sync) {
                    i = (index & this.indexHighBits) == this.bankPos[1] ? index - this.bankPos[1] : this.translateFailedIndex(index, true, MappedStorage.LoadingMode.DEFAULT);
                    lb1 = this.lb[1];
                } else {
                    i = index;
                }
                int ii = (int)(i >>> 6);
                int bit = (int)i & 0x3F;
                LongBuffer longBuffer = lb1;
                synchronized (longBuffer) {
                    if (value) {
                        lb1.put(ii, lb1.get(ii) | 1L << bit);
                    } else {
                        lb1.put(ii, lb1.get(ii) & (1L << bit ^ 0xFFFFFFFFFFFFFFFFL));
                    }
                }
            }
            finally {
                if (sync) {
                    lock.unlock();
                }
            }
        }

        @Override
        long getBits64(long arrayPos, int count) {
            long[] array = new long[1];
            this.getBits(arrayPos, array, 0L, count);
            return array[0];
        }

        @Override
        void setBits64(long arrayPos, long bits, int count) {
            long[] array = new long[]{bits};
            this.setBits(arrayPos, array, 0L, count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long indexOfBit(long lowIndex, long highIndex, boolean value) {
            long result;
            LongBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(lowIndex);
            assert (ofs >= 0L);
            long count = highIndex - lowIndex;
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(lowIndex);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                result = PackedBitBuffers.indexOfBit(buf, ofs, ofs + len, value);
                if (result != -1L) {
                    long l = result + lowIndex - ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            lowIndex += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(lowIndex);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = PackedBitBuffers.indexOfBit(buf, 0L, len, value);
                    if (result != -1L) {
                        long l = result + lowIndex;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                lowIndex += bse;
                count -= bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
            long result;
            LongBuffer buf;
            long translateIndexResult;
            if (highIndex <= lowIndex) {
                return -1L;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(highIndex - 1L);
            assert (ofs >= 0L);
            long count = highIndex - lowIndex;
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, ofs + 1L);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(highIndex - 1L);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                result = PackedBitBuffers.lastIndexOfBit(buf, ofs - len + 1L, ofs + 1L, value);
                if (result != -1L) {
                    long l = result + highIndex - 1L - ofs;
                    return l;
                }
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            highIndex -= len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(highIndex - 1L);
                        assert (translateIndexResult == bse - 1L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    result = PackedBitBuffers.lastIndexOfBit(buf, bse - len, bse, value);
                    if (result != -1L) {
                        long l = result + highIndex - bse;
                        return l;
                    }
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                highIndex -= bse;
                count -= bse;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getBits(long pos, long[] destArray, long destArrayOffset, long count) {
            LongBuffer buf;
            long translateIndexResult;
            long len;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            long l = len = this.singleMapping ? count : Math.min(count, bse - ofs);
            if (this.isBankLazyAndNotFilledYet(pos)) {
                this.getUninitializedLazyBitsFromBank(pos, destArray, destArrayOffset, len);
            } else {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == ofs);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.getBitsFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
            }
            destArrayOffset += len;
            pos += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                if (this.isBankLazyAndNotFilledYet(pos)) {
                    this.getUninitializedLazyBitsFromBank(pos, destArray, destArrayOffset, len);
                } else {
                    this.incrementMappingInUseCounter();
                    try {
                        lock.lock();
                        try {
                            translateIndexResult = this.translateIndex(pos);
                            assert (translateIndexResult == 0L);
                            buf = this.lb[0];
                        }
                        finally {
                            lock.unlock();
                        }
                        this.getBitsFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                    }
                    finally {
                        this.decrementMappingInUseCounter();
                    }
                }
                pos += bse;
                destArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBits(long pos, long[] srcArray, long srcArrayOffset, long count) {
            LongBuffer buf;
            long len;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long bse = this.ms.bankSizeInElements;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long l = len = this.singleMapping ? count : Math.min(count, bse - ofs);
            if (this.singleMapping || ofs > 0L) {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        long o = this.translateIndex(pos);
                        assert (o == ofs);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.setBitsInFirstBank(buf, ofs, srcArray, srcArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                srcArrayOffset += len;
                pos += len;
                count -= len;
            }
            while (count > 0L) {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        if (count >= bse) {
                            len = (int)bse;
                            ofs = this.translateIndexWO(pos);
                        } else {
                            len = count;
                            ofs = this.translateIndex(pos);
                        }
                        assert (ofs == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.setBitsInFirstBank(buf, 0L, srcArray, srcArrayOffset, Math.min(count, bse));
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                srcArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void andBits(long pos, long[] destArray, long destArrayOffset, long count) {
            LongBuffer buf;
            long translateIndexResult;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                this.andBitsFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.andBitsFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void orBits(long pos, long[] destArray, long destArrayOffset, long count) {
            LongBuffer buf;
            long translateIndexResult;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                this.orBitsFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.orBitsFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void xorBits(long pos, long[] destArray, long destArrayOffset, long count) {
            LongBuffer buf;
            long translateIndexResult;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                this.xorBitsFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.xorBitsFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void andNotBits(long pos, long[] destArray, long destArrayOffset, long count) {
            LongBuffer buf;
            long translateIndexResult;
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            long len = this.singleMapping ? count : Math.min(count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.lb[0];
                }
                finally {
                    lock.unlock();
                }
                this.andNotBitsFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += len;
            count -= len;
            while (count > 0L) {
                len = Math.min(count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.lb[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.andNotBitsFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += bse;
                count -= bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void copy(long destIndex, long srcIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.setBit(destIndex, this.getBit(srcIndex));
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void swap(long firstIndex, long secondIndex) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long i1 = this.translateIndex(firstIndex);
                assert (i1 >= 0L);
                int ii1 = (int)(i1 >>> 6);
                int bit1 = (int)i1 & 0x3F;
                long i2 = this.translateIndex(secondIndex, true);
                assert (i2 >= 0L);
                int ii2 = (int)(i2 >>> 6);
                int bit2 = (int)i2 & 0x3F;
                LongBuffer[] longBufferArray = this.lb;
                synchronized (this.lb) {
                    boolean v2;
                    long l1 = this.lb[0].get(ii1);
                    long l2 = this.lb[1].get(ii2);
                    boolean v1 = (l1 & 1L << bit1) != 0L;
                    boolean bl = v2 = (l2 & 1L << bit2) != 0L;
                    if (v1 != v2) {
                        if (v2) {
                            this.lb[0].put(ii1, l1 | 1L << bit1);
                        } else {
                            this.lb[0].put(ii1, l1 & (1L << bit1 ^ 0xFFFFFFFFFFFFFFFFL));
                        }
                        l2 = this.lb[1].get(ii2);
                        if (v1) {
                            this.lb[1].put(ii2, l2 | 1L << bit2);
                        } else {
                            this.lb[1].put(ii2, l2 & (1L << bit2 ^ 0xFFFFFFFFFFFFFFFFL));
                        }
                    }
                    // ** MonitorExit[var14_10] (shouldn't be in output)
                }
            }
            finally {
                lock.unlock();
            }
            {
                return;
            }
        }

        @Override
        void setSpecificBuffer(int bank) {
            this.lb[bank] = this.bh[bank] == null ? null : this.bh[bank].data().asLongBuffer();
        }

        @Override
        void clearData(long pos, long count) {
            this.fillData(pos, count, booleanZero);
        }

        @Override
        void getDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            PackedBitBuffers.unpackBits((boolean[])destArray, destArrayOffset, (LongBuffer)buf, firstBankOffset, count);
        }

        @Override
        void setDataInFirstBank(Buffer buf, long firstBankOffset, Object srcArray, int srcArrayOffset, int count) {
            PackedBitBuffers.packBits((LongBuffer)buf, firstBankOffset, (boolean[])srcArray, srcArrayOffset, count);
        }

        @Override
        void fillDataInFirstBank(long destOffset, long count, Object fillerWrapper) {
            PackedBitBuffers.fillBits(this.lb[0], destOffset, count, (Boolean)fillerWrapper);
        }

        @Override
        void copyFirstBank(MappedStorage src, long srcOffset, long destOffset, long count, boolean reverseOrder, boolean copyToSecondBank) {
            PackedBitBuffers.copyBits(this.lb[copyToSecondBank ? 1 : 0], destOffset, ((MappedBitStorage)src).lb[0], srcOffset, count, reverseOrder);
        }

        @Override
        void swapFirstBank(MappedStorage another, long anotherOffset, long thisOffset, long count, boolean swapWithSecondBank) {
            PackedBitBuffers.swapBits(((MappedBitStorage)another).lb[0], anotherOffset, this.lb[swapWithSecondBank ? 1 : 0], thisOffset, count);
        }

        @Override
        void minDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("minDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void maxDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("maxDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, int[] destArray, int destArrayOffset, int count) {
            throw new UnsupportedOperationException("addDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void addDataFromFirstBank(Buffer buf, long firstBankOffset, double[] destArray, int destArrayOffset, int count, double mult) {
            throw new UnsupportedOperationException("addDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void subtractDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            throw new UnsupportedOperationException("subtractDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void absDiffDataFromFirstBank(Buffer buf, long firstBankOffset, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            throw new UnsupportedOperationException("absDiffDataFromFirstBank is not supported for bit storages");
        }

        @Override
        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            long length;
            assert (this.lock.isHeldByCurrentThread()) : "actualizeLazyFillingBank is called from non-synchronized code";
            assert ((elementIndex & 0x3FL) == 0L);
            if (this.ms.lazyFillingPattern == null || (length = this.ms.lazyFillingPattern.length()) <= elementIndex) {
                this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
            } else {
                long len;
                LongBuffer bankSpecBuf = bankBB.asLongBuffer();
                long count = (long)bankSpecBuf.limit() << 6;
                if (count > length - elementIndex) {
                    count = length - elementIndex;
                    this.actualizeLazyZeroFillingBank(bankBB, (int)(count >> 3), bankBB.limit());
                }
                for (long ofs = 0L; ofs < count; ofs += len) {
                    this.dbuf.map(elementIndex + ofs, count - ofs);
                    len = this.dbuf.count();
                    assert (len > 0L);
                    PackedBitBuffers.copyBits(bankSpecBuf, ofs, LongBuffer.wrap(this.dbuf.data()), this.dbuf.from(), len);
                }
            }
        }

        private void getUninitializedLazyBitsFromBank(long pos, long[] destArray, long destArrayOffset, long count) {
            long length;
            long l = length = this.ms.lazyFillingPattern == null ? 0L : this.ms.lazyFillingPattern.length();
            if (count > length - pos) {
                long newCount = length < pos ? 0L : length - pos;
                PackedBitArrays.fillBits(destArray, destArrayOffset + newCount, count - newCount, false);
                count = newCount;
            }
            if (count > 0L) {
                ((BitArray)this.ms.lazyFillingPattern).getBits(pos, destArray, destArrayOffset, count);
            }
        }

        private void getBitsFromFirstBank(LongBuffer buf, long firstBankOffset, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.copyBits(LongBuffer.wrap(destArray), destArrayOffset, buf, firstBankOffset, count);
        }

        private void setBitsInFirstBank(LongBuffer buf, long firstBankOffset, long[] srcArray, long srcArrayOffset, long count) {
            PackedBitBuffers.copyBits(buf, firstBankOffset, LongBuffer.wrap(srcArray), srcArrayOffset, count);
        }

        private void andBitsFromFirstBank(LongBuffer buf, long firstBankOffset, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.andBits(destArray, destArrayOffset, buf, firstBankOffset, count);
        }

        private void orBitsFromFirstBank(LongBuffer buf, long firstBankOffset, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.orBits(destArray, destArrayOffset, buf, firstBankOffset, count);
        }

        private void xorBitsFromFirstBank(LongBuffer buf, long firstBankOffset, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.xorBits(destArray, destArrayOffset, buf, firstBankOffset, count);
        }

        private void andNotBitsFromFirstBank(LongBuffer buf, long firstBankOffset, long[] destArray, long destArrayOffset, long count) {
            PackedBitBuffers.andNotBits(destArray, destArrayOffset, buf, firstBankOffset, count);
        }
    }

    static abstract class MappedStorage
    extends DataStorage {
        final MappingSettings<?> ms;
        private volatile boolean autoDeleted;
        long indexHighBits;
        private int bankCount = 0;
        final DataFile.BufferHolder[] bh;
        final Buffer[] specBufs;
        final long[] bankPos;
        private final int[] bankIndexes;
        private MutableBitArray lazyFillMapOfBanks;
        private long lazyFillPosInBytes;
        boolean singleMapping = false;
        boolean syncNecessary = true;
        volatile Object validSingleSpecBufForThisThread = new Object();
        private int arrayCounter = 0;
        private int mappingCounter = 0;
        private final AtomicInteger mappingInUseCounter = new AtomicInteger(0);
        private volatile boolean mappingInUseCounterOverflow = false;
        private volatile DataFile dataFile = null;
        private volatile DataFile dataFileForDeletion = null;
        private boolean disposeCalled = false;
        private volatile boolean deletionErrorWhileFinalization = false;
        private int countOfFailedDeletionsWhileFinalization = 0;
        private volatile boolean deletedWhileShutdown = false;
        private long dataFileLength;
        private final Object dataFilePath;
        private boolean unresizable = false;
        final ReentrantLock lock = new ReentrantLock();
        private final ReentrantLock lockForGc = new ReentrantLock();
        private volatile Object finalizationHolder = null;
        private final boolean finerLoggable = LargeMemoryModel.LOGGER.isLoggable(Level.FINER);
        private final boolean finestLoggable = LargeMemoryModel.LOGGER.isLoggable(Level.FINEST);
        private final ArrayComparator bankOrderComparator = new ArrayComparator(){

            @Override
            public boolean less(long firstIndex, long secondIndex) {
                int first = (int)firstIndex;
                int second = (int)secondIndex;
                return bh[first] != null && (bh[second] == null || bankPos[first] < bankPos[second]);
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MappedStorage(MappingSettings<?> ms) {
            assert (ms.temporary == (ms.existingDataFile == null)) : "ms.temporary != (ms.existingDataFile == null)";
            if (ms.temporary) assert (!ms.readOnly) : "ms.readOnly cannot be true for temporary files";
            this.ms = ms;
            this.indexHighBits = ms.bankSizeInElements - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            this.bh = new DataFile.BufferHolder[ms.numberOfBanks];
            if (this instanceof MappedBitStorage) {
                this.specBufs = new LongBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedByteStorage) {
                this.specBufs = new ByteBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedCharStorage) {
                this.specBufs = new CharBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedShortStorage) {
                this.specBufs = new ShortBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedIntStorage) {
                this.specBufs = new IntBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedLongStorage) {
                this.specBufs = new LongBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedFloatStorage) {
                this.specBufs = new FloatBuffer[ms.numberOfBanks];
            } else if (this instanceof MappedDoubleStorage) {
                this.specBufs = new DoubleBuffer[ms.numberOfBanks];
            } else {
                throw new AssertionError((Object)("Illegal inheritor " + String.valueOf(this.getClass())));
            }
            this.bankPos = new long[ms.numberOfBanks];
            for (int k = 0; k < this.bankPos.length; ++k) {
                this.bankPos[k] = -1L;
            }
            this.bankIndexes = new int[ms.numberOfBanks];
            ReentrantLock lock = this.lock;
            lock.lock();
            Set<MappedStorage> set = allNonFinalizedMappedStorages;
            synchronized (set) {
                try {
                    if (shutdownInProgress) {
                        throw new IOError(new IllegalStateException("Cannot allocate new AlgART array: shutdown is in progress"));
                    }
                    if (!ms.temporary) {
                        this.dataFileForDeletion = this.dataFile = ms.existingDataFile;
                        this.unresizable = true;
                        this.dataFile.open(ms.readOnly);
                    } else {
                        this.dataFileForDeletion = this.dataFile = ms.dataFileModel.createTemporary(ms.unresizable);
                        this.dataFile.open(false);
                        this.dataFile.length(ms.dataFileStartOffset);
                        this.lazyFillPosInBytes = ms.dataFileStartOffset;
                        this.lazyFillMapOfBanks = SimpleMemoryModel.getInstance().newEmptyBitArray(1024L);
                        LargeMemoryModel.LOGGER.fine("Temporary array storage file " + String.valueOf(this.dataFile) + " is successfully created");
                    }
                    this.dataFilePath = ms.dataFileModel.getPath(this.dataFile);
                    this.dataFileLength = this.dataFile.length();
                    if (!ms.temporary) {
                        this.setSingleMappingModeIfNecessary();
                    }
                    this.autoDeleted = ms.temporary;
                    allNonFinalizedMappedStorages.add(this);
                }
                finally {
                    lock.unlock();
                }
            }
            this.scheduleFinalizationForAllStorage();
        }

        public boolean isAutoDeleted() {
            return this.autoDeleted;
        }

        public void setAutoDeleted(boolean value) {
            DataFile df = this.dataFile;
            this.autoDeleted = value;
            if (df != null) {
                this.ms.dataFileModel.setTemporary(df, value);
            }
        }

        public DataFileModel<?> getDataFileModel() {
            return this.ms.dataFileModel;
        }

        public Object getDataFilePath() {
            return this.ms.dataFileModel.getPath(this.dataFile);
        }

        public String toString() {
            return "mapped" + (this.ms.lazyFillingPattern == null ? "" : " lazy") + " file (" + String.valueOf(this.dataFilePath) + (this.dataFile == null ? ": DISPOSED" : "") + (this.isAutoDeleted() ? ", temporary)" : ", external)");
        }

        @Override
        MemoryModel newCompatibleMemoryModel() {
            return LargeMemoryModel.getInstance((DataFileModel)InternalUtils.cast(this.ms.dataFileModel));
        }

        final long offset(long index) {
            return index & (this.indexHighBits ^ 0xFFFFFFFFFFFFFFFFL);
        }

        final long translateIndex(long index) {
            if ((index & this.indexHighBits) == this.bankPos[0]) {
                assert (this instanceof MappedBitStorage || index - this.bankPos[0] <= Integer.MAX_VALUE);
                return index - this.bankPos[0];
            }
            return this.translateFailedIndex(index, false, LoadingMode.DEFAULT);
        }

        final long translateIndex(long index, boolean useSecondBank) {
            int bank;
            int n = bank = useSecondBank ? 1 : 0;
            if ((index & this.indexHighBits) == this.bankPos[bank]) {
                assert (this instanceof MappedBitStorage || index - this.bankPos[bank] <= Integer.MAX_VALUE);
                return index - this.bankPos[bank];
            }
            return this.translateFailedIndex(index, useSecondBank, LoadingMode.DEFAULT);
        }

        final long translateIndexWO(long index) {
            if ((index & this.indexHighBits) == this.bankPos[0]) {
                assert (this instanceof MappedBitStorage || index - this.bankPos[0] <= Integer.MAX_VALUE);
                return index - this.bankPos[0];
            }
            return this.translateFailedIndex(index, false, LoadingMode.NOT_LOAD_DATA_FROM_FILE);
        }

        final long translateIndexWO(long index, boolean useSecondBank) {
            int bank;
            int n = bank = useSecondBank ? 1 : 0;
            if ((index & this.indexHighBits) == this.bankPos[bank]) {
                assert (this instanceof MappedBitStorage || index - this.bankPos[bank] <= Integer.MAX_VALUE);
                return index - this.bankPos[bank];
            }
            return this.translateFailedIndex(index, useSecondBank, LoadingMode.NOT_LOAD_DATA_FROM_FILE);
        }

        final long translateIndex(long index, boolean useSecondBank, boolean notLoadDataFromFile) {
            int bank;
            int n = bank = useSecondBank ? 1 : 0;
            if ((index & this.indexHighBits) == this.bankPos[bank]) {
                assert (this instanceof MappedBitStorage || index - this.bankPos[bank] <= Integer.MAX_VALUE);
                return index - this.bankPos[bank];
            }
            return this.translateFailedIndex(index, useSecondBank, notLoadDataFromFile ? LoadingMode.NOT_LOAD_DATA_FROM_FILE : LoadingMode.DEFAULT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final long translateFailedIndex(long index, boolean useSecondBank, LoadingMode loadingMode) {
            assert (index >= 0L) : "Negative index " + index;
            assert (this.bh.length >= 2) : "Too low total number of banks: " + this.bh.length;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                AssertionError ae;
                long result;
                boolean holeAt0;
                int b;
                int firstBank;
                boolean bankWasLoaded = false;
                int n = firstBank = useSecondBank ? 1 : 0;
                if ((index & this.indexHighBits) == this.bankPos[firstBank]) {
                    long l = index - this.bankPos[firstBank];
                    return l;
                }
                long foundBankPos = -1L;
                DataFile.BufferHolder foundBh = null;
                Buffer foundSpecBuf = null;
                for (b = firstBank + 1; b < this.bankCount; ++b) {
                    foundBankPos = this.bankPos[b];
                    if ((index & this.indexHighBits) != foundBankPos) continue;
                    foundBh = this.bh[b];
                    foundSpecBuf = this.specBufs[b];
                    break;
                }
                boolean firstTwoBanksAreSame = this.bankPos[0] == this.bankPos[1];
                boolean bl = holeAt0 = !useSecondBank && this.bh[0] == null;
                if (firstTwoBanksAreSame || holeAt0) {
                    if (foundBh != null) {
                        this.bh[firstBank] = foundBh;
                        this.specBufs[firstBank] = foundSpecBuf;
                        this.bankPos[firstBank] = foundBankPos;
                        assert (this.bankCount >= firstBank + 2) : "bankCount < firstBank + 2";
                        if (b == 1) {
                            assert (firstBank == 0) : "firstBank != 0";
                            assert (holeAt0) : "here should be hole at #0";
                            result = index - foundBankPos;
                        } else {
                            --this.bankCount;
                            while (b < this.bankCount) {
                                this.bh[b] = this.bh[b + 1];
                                this.specBufs[b] = this.specBufs[b + 1];
                                this.bankPos[b] = this.bankPos[b + 1];
                                ++b;
                            }
                            this.bh[this.bankCount] = null;
                            this.specBufs[this.bankCount] = null;
                            this.bankPos[this.bankCount] = -1L;
                            result = index - foundBankPos;
                        }
                    } else {
                        this.bankCount = Math.max(this.bankCount, firstBank + 1);
                        this.mapBank(index & this.indexHighBits, useSecondBank, loadingMode);
                        bankWasLoaded = true;
                        result = index - this.bankPos[firstBank];
                    }
                } else {
                    assert (foundBh != null || b == Math.max(this.bankCount, firstBank + 1)) : "bank not found, but b=" + b + " != max(bankCount,firstBank+1)=max(" + this.bankCount + "," + (firstBank + 1) + ")";
                    if (foundBh == null && b == this.bh.length) {
                        if (this.unmapBank(--b, ReleaseMode.DATA_MUST_STAY_ALIVE, false)) {
                            --this.bankCount;
                        }
                        assert (b == this.bankCount);
                        assert (b == this.bh.length - 1);
                    }
                    while (b > firstBank) {
                        this.bh[b] = this.bh[b - 1];
                        this.specBufs[b] = this.specBufs[b - 1];
                        this.bankPos[b] = this.bankPos[b - 1];
                        --b;
                    }
                    if (foundBh != null) {
                        this.bh[firstBank] = foundBh;
                        this.specBufs[firstBank] = foundSpecBuf;
                        this.bankPos[firstBank] = foundBankPos;
                        result = index - foundBankPos;
                    } else if (useSecondBank && (index & this.indexHighBits) == this.bankPos[0]) {
                        this.bh[1] = this.bh[0];
                        this.bankPos[1] = this.bankPos[0];
                        this.specBufs[1] = this.specBufs[0];
                        ++this.bankCount;
                        result = index - this.bankPos[1];
                    } else {
                        ++this.bankCount;
                        this.mapBank(index & this.indexHighBits, useSecondBank, loadingMode);
                        bankWasLoaded = true;
                        result = index - this.bankPos[firstBank];
                    }
                }
                assert (result >= 0L);
                assert (this instanceof MappedBitStorage || result <= Integer.MAX_VALUE);
                assert (!this.finestLoggable || bankWasLoaded || (ae = this.logAndCheckBanks(index, useSecondBank, firstTwoBanksAreSame ? LogAllBanksCallPlace.translateFailedIndexSame : (holeAt0 ? LogAllBanksCallPlace.translateFailedIndexHole : LogAllBanksCallPlace.translateFailedIndex), Level.FINEST)) == null) : ((Throwable)((Object)ae)).getMessage();
                long l = result;
                return l;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        ByteOrder byteOrder() {
            return this.dataFile.byteOrder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void allocate(long capacity, boolean unresizable) {
            this.lock.lock();
            try {
                this.changeCapacity(capacity, 0L, 0L, unresizable);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataStorage changeCapacity(long newCapacity, long offset, long length) {
            this.lock.lock();
            try {
                this.changeCapacity(newCapacity, offset, length, false);
                MappedStorage mappedStorage = this;
                return mappedStorage;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void getData(long pos, Object destArray, int destArrayOffset, int count) {
            Buffer buf;
            long translateIndexResult;
            int len;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int n = len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            if (this.isBankLazyAndNotFilledYet(pos)) {
                this.getUninitializedLazyDataFromBank(pos, destArray, destArrayOffset, len);
            } else {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == ofs);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.getDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                if (this.isBankLazyAndNotFilledYet(pos)) {
                    this.getUninitializedLazyDataFromBank(pos, destArray, destArrayOffset, len);
                } else {
                    this.incrementMappingInUseCounter();
                    try {
                        lock.lock();
                        try {
                            translateIndexResult = this.translateIndex(pos);
                            assert (translateIndexResult == 0L);
                            buf = this.specBufs[0];
                        }
                        finally {
                            lock.unlock();
                        }
                        this.getDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                    }
                    finally {
                        this.decrementMappingInUseCounter();
                    }
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setData(long pos, Object srcArray, int srcArrayOffset, int count) {
            Buffer buf;
            int len;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long bse = this.ms.bankSizeInElements;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            int n = len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            if (this.singleMapping || ofs > 0L) {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        long o = this.translateIndex(pos);
                        assert (o == ofs);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.setDataInFirstBank(buf, ofs, srcArray, srcArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                srcArrayOffset += len;
                pos += (long)len;
                count -= len;
            }
            while (count > 0) {
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        if ((long)count >= bse) {
                            len = (int)bse;
                            ofs = this.translateIndexWO(pos);
                        } else {
                            len = count;
                            ofs = this.translateIndex(pos);
                        }
                        assert (ofs == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.setDataInFirstBank(buf, 0L, srcArray, srcArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                srcArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void fillData(long pos, long count, Object fillerWrapper) {
            if (count == 0L) {
                return;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                long len;
                long bse = this.ms.bankSizeInElements;
                long ofs = this.offset(pos);
                assert (ofs >= 0L);
                long l = len = this.singleMapping ? count : Math.min(count, bse - ofs);
                if (this.singleMapping || ofs > 0L) {
                    long o = this.translateIndex(pos);
                    assert (o == ofs);
                    this.fillDataInFirstBank(ofs, len, fillerWrapper);
                    pos += len;
                    count -= len;
                }
                while (count > 0L) {
                    if (count >= bse) {
                        len = bse;
                        ofs = this.translateIndexWO(pos);
                    } else {
                        len = count;
                        ofs = this.translateIndex(pos);
                    }
                    assert (ofs == 0L);
                    this.fillDataInFirstBank(0L, len, fillerWrapper);
                    pos += bse;
                    count -= bse;
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean copy(DataStorage src, long srcPos, long destPos, long count) {
            block34: {
                if (count == 0L) {
                    return true;
                }
                if (src == this && srcPos == destPos) {
                    return true;
                }
                if (!(src instanceof MappedStorage)) {
                    return false;
                }
                MappedStorage stor = (MappedStorage)src;
                boolean useSecondBank = src == this;
                this.lock.lock();
                stor.lock.lock();
                try {
                    long destBlock;
                    assert (srcPos >= 0L);
                    assert (destPos >= 0L);
                    assert (count >= 0L);
                    long srcBlock = stor.singleMapping ? Long.MAX_VALUE : stor.ms.bankSizeInElements;
                    long l = destBlock = this.singleMapping ? Long.MAX_VALUE : this.ms.bankSizeInElements;
                    if (src == this && srcPos <= destPos && srcPos + count > destPos) {
                        long srcOfs = stor.translateIndex((srcPos += count) - 1L);
                        long destOfs = this.offset((destPos += count) - 1L);
                        long destO = this.translateIndex(destPos - 1L, true, destOfs == destBlock - 1L && count >= destBlock);
                        assert (destO == destOfs);
                        while (true) {
                            assert (srcOfs >= 0L);
                            assert (destOfs >= 0L);
                            long srcLen = srcOfs + 1L;
                            long destLen = destOfs + 1L;
                            assert (srcLen >= 0L);
                            assert (destLen >= 0L);
                            if (srcLen < destLen) {
                                if (srcLen >= count) {
                                    this.copyFirstBank(stor, srcLen - count, destLen - count, count, true, true);
                                    break block34;
                                }
                                assert (!stor.singleMapping);
                                this.copyFirstBank(stor, 0L, destLen - srcLen, srcLen, true, true);
                                destPos -= srcLen;
                                count -= srcLen;
                                srcOfs = stor.translateIndex((srcPos -= srcLen) - 1L);
                                assert (srcOfs == srcBlock - 1L);
                                destOfs -= srcLen;
                                this.translateIndex(destPos, true);
                                continue;
                            }
                            if (destLen >= count) {
                                this.copyFirstBank(stor, srcLen - count, destLen - count, count, true, true);
                                break block34;
                            }
                            assert (!this.singleMapping);
                            this.copyFirstBank(stor, srcLen - destLen, 0L, destLen, true, true);
                            srcOfs = srcLen == destLen ? stor.translateIndex((srcPos -= destLen) - 1L) : (srcOfs -= destLen);
                            destOfs = this.translateIndex((destPos -= destLen) - 1L, true, (count -= destLen) >= destBlock);
                            if (!$assertionsDisabled && destOfs != destBlock - 1L) break;
                        }
                        throw new AssertionError();
                    }
                    long srcOfs = stor.translateIndex(srcPos);
                    long destOfs = this.offset(destPos);
                    long destO = this.translateIndex(destPos, useSecondBank, destOfs == 0L && count >= destBlock);
                    assert (destO == destOfs);
                    while (true) {
                        assert (srcOfs >= 0L);
                        assert (destOfs >= 0L);
                        long srcLen = srcBlock - srcOfs;
                        long destLen = destBlock - destOfs;
                        assert (srcLen >= 0L);
                        assert (destLen >= 0L);
                        if (srcLen < destLen) {
                            if (srcLen >= count) {
                                this.copyFirstBank(stor, srcOfs, destOfs, count, false, useSecondBank);
                                break block34;
                            }
                            assert (!stor.singleMapping);
                            this.copyFirstBank(stor, srcOfs, destOfs, srcLen, false, useSecondBank);
                            destPos += srcLen;
                            count -= srcLen;
                            srcOfs = stor.translateIndex(srcPos += srcLen);
                            assert (srcOfs == 0L);
                            destOfs += srcLen;
                            if (!useSecondBank) continue;
                            this.translateIndex(destPos, true);
                            continue;
                        }
                        if (destLen >= count) {
                            this.copyFirstBank(stor, srcOfs, destOfs, count, false, useSecondBank);
                            break block34;
                        }
                        assert (!this.singleMapping);
                        this.copyFirstBank(stor, srcOfs, destOfs, destLen, false, useSecondBank);
                        srcOfs = srcLen == destLen ? stor.translateIndex(srcPos += destLen) : (srcOfs += destLen);
                        destOfs = this.translateIndex(destPos += destLen, useSecondBank, (count -= destLen) >= destBlock);
                        if (!$assertionsDisabled && destOfs != 0L) break;
                    }
                    throw new AssertionError();
                }
                finally {
                    stor.lock.unlock();
                    this.lock.unlock();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean swap(DataStorage another, long anotherPos, long thisPos, long count) {
            block20: {
                if (count == 0L) {
                    return true;
                }
                if (another == this && anotherPos == thisPos) {
                    return true;
                }
                if (!(another instanceof MappedStorage)) {
                    return false;
                }
                MappedStorage stor = (MappedStorage)another;
                boolean useSecondBank = another == this;
                this.lock.lock();
                stor.lock.lock();
                try {
                    assert (anotherPos >= 0L);
                    assert (thisPos >= 0L);
                    assert (count >= 0L);
                    long anotherBlock = stor.singleMapping ? Long.MAX_VALUE : stor.ms.bankSizeInElements;
                    long thisBlock = this.singleMapping ? Long.MAX_VALUE : this.ms.bankSizeInElements;
                    long anotherOfs = stor.translateIndex(anotherPos);
                    long thisOfs = this.translateIndex(thisPos, useSecondBank);
                    while (true) {
                        assert (anotherOfs >= 0L);
                        assert (thisOfs >= 0L);
                        long anotherLen = anotherBlock - anotherOfs;
                        long thisLen = thisBlock - thisOfs;
                        assert (anotherLen >= 0L);
                        assert (thisLen >= 0L);
                        if (anotherLen < thisLen) {
                            if (anotherLen >= count) {
                                this.swapFirstBank(stor, anotherOfs, thisOfs, count, useSecondBank);
                                break block20;
                            }
                            assert (!stor.singleMapping);
                            this.swapFirstBank(stor, anotherOfs, thisOfs, anotherLen, useSecondBank);
                            thisPos += anotherLen;
                            count -= anotherLen;
                            anotherOfs = stor.translateIndex(anotherPos += anotherLen);
                            assert (anotherOfs == 0L);
                            thisOfs += anotherLen;
                            this.translateIndex(thisPos, true);
                            continue;
                        }
                        if (thisLen >= count) {
                            this.swapFirstBank(stor, anotherOfs, thisOfs, count, useSecondBank);
                            break block20;
                        }
                        assert (!this.singleMapping);
                        this.swapFirstBank(stor, anotherOfs, thisOfs, thisLen, useSecondBank);
                        count -= thisLen;
                        anotherOfs = anotherLen == thisLen ? stor.translateIndex(anotherPos += thisLen) : (anotherOfs += thisLen);
                        thisOfs = this.translateIndex(thisPos += thisLen, useSecondBank);
                        if (!$assertionsDisabled && thisOfs != 0L) break;
                    }
                    throw new AssertionError();
                }
                finally {
                    stor.lock.unlock();
                    this.lock.unlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void minData(long pos, Object destArray, int destArrayOffset, int count) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.minDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.minDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void maxData(long pos, Object destArray, int destArrayOffset, int count) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.maxDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.maxDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void addData(long pos, int[] destArray, int destArrayOffset, int count) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.addDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.addDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void addData(long pos, double[] destArray, int destArrayOffset, int count, double mult) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.addDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len, mult);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.addDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len, mult);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void subtractData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.subtractDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len, truncateOverflows);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.subtractDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len, truncateOverflows);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void absDiffData(long pos, Object destArray, int destArrayOffset, int count, boolean truncateOverflows) {
            Buffer buf;
            long translateIndexResult;
            if (count == 0) {
                return;
            }
            ReentrantLock lock = this.lock;
            long ofs = this.offset(pos);
            assert (ofs >= 0L);
            long bse = this.ms.bankSizeInElements;
            int len = this.singleMapping ? count : (int)Math.min((long)count, bse - ofs);
            this.incrementMappingInUseCounter();
            try {
                lock.lock();
                try {
                    translateIndexResult = this.translateIndex(pos);
                    assert (translateIndexResult == ofs);
                    buf = this.specBufs[0];
                }
                finally {
                    lock.unlock();
                }
                this.absDiffDataFromFirstBank(buf, ofs, destArray, destArrayOffset, len, truncateOverflows);
            }
            finally {
                this.decrementMappingInUseCounter();
            }
            destArrayOffset += len;
            pos += (long)len;
            count -= len;
            while (count > 0) {
                len = (int)Math.min((long)count, bse);
                this.incrementMappingInUseCounter();
                try {
                    lock.lock();
                    try {
                        translateIndexResult = this.translateIndex(pos);
                        assert (translateIndexResult == 0L);
                        buf = this.specBufs[0];
                    }
                    finally {
                        lock.unlock();
                    }
                    this.absDiffDataFromFirstBank(buf, 0L, destArray, destArrayOffset, len, truncateOverflows);
                }
                finally {
                    this.decrementMappingInUseCounter();
                }
                pos += bse;
                destArrayOffset += (int)bse;
                count -= (int)bse;
            }
        }

        @Override
        void attachArray(Array a) {
            this.lockForGc.lock();
            try {
                ++this.arrayCounter;
            }
            finally {
                this.lockForGc.unlock();
            }
            if (this.finerLoggable) {
                LargeMemoryModel.LOGGER.finer("++++ Array " + Integer.toHexString(System.identityHashCode(a)) + " is attached to " + String.valueOf(this) + ": " + this.arrayCounter + " arrays, " + this.mappingCounter + " mappings (" + MappedDataStorages.finalizationTasksInfo() + ") [" + String.valueOf(a) + "]");
            }
        }

        @Override
        void forgetArray(int arrayIdentityHashCode) {
            this.decreaseArrayOrMappingCounter(CounterKind.ARRAY_COUNTER);
            if (this.finerLoggable) {
                LargeMemoryModel.LOGGER.finer("---- Array " + Integer.toHexString(arrayIdentityHashCode) + " is deattached from " + String.valueOf(this) + ": " + this.arrayCounter + " arrays, " + this.mappingCounter + " mappings (" + MappedDataStorages.finalizationTasksInfo() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void actualizeLazyFilling(ArrayContext context, long fromIndex, long toIndex) {
            long k;
            if (fromIndex == toIndex) {
                return;
            }
            if (!this.ms.temporary) {
                return;
            }
            ReentrantLock lock = this.lock;
            long bankFromIndex = fromIndex >> this.ms.bankSizeInElementsLog;
            long bankToIndex = (toIndex - 1L >>> this.ms.bankSizeInElementsLog) + 1L;
            long bankAfterMapIndex = Math.min(bankToIndex, this.lazyFillMapOfBanks.length());
            long lazyFillBankIndex = Math.max(bankAfterMapIndex, this.lazyFillPosInBytes - this.ms.dataFileStartOffset >> this.ms.bankSizeInBytesLog);
            long totalCount = Math.max(0L, bankAfterMapIndex - bankFromIndex) + Math.max(0L, bankToIndex - lazyFillBankIndex);
            for (k = bankFromIndex; k < bankAfterMapIndex; ++k) {
                boolean filled = false;
                lock.lock();
                try {
                    if (this.lazyFillMapOfBanks.getBit(k)) {
                        this.translateIndex(k << this.ms.bankSizeInElementsLog);
                        if (this.lazyFillMapOfBanks.getBit(k)) {
                            throw new AssertionError((Object)("The lazyFillMapOfBanks[" + k + "] bit was not cleared!"));
                        }
                        filled = true;
                    }
                }
                finally {
                    lock.unlock();
                }
                if (context == null || !filled && k != bankToIndex - 1L) continue;
                context.checkInterruptionAndUpdateProgress(this.ms.arrayElementClass, k - bankFromIndex << this.ms.bankSizeInElementsLog, totalCount << this.ms.bankSizeInElementsLog);
            }
            for (k = lazyFillBankIndex; k < bankToIndex; ++k) {
                lock.lock();
                try {
                    this.translateIndex(k << this.ms.bankSizeInElementsLog);
                }
                finally {
                    lock.unlock();
                }
                if (context == null) continue;
                context.checkInterruptionAndUpdateProgress(this.ms.arrayElementClass, Math.max(0L, bankAfterMapIndex - bankFromIndex) + (k - lazyFillBankIndex) << this.ms.bankSizeInElementsLog, totalCount << this.ms.bankSizeInElementsLog);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void loadResources(long fromIndex, long toIndex) {
            if (fromIndex == toIndex) {
                return;
            }
            assert (fromIndex < toIndex);
            this.lock.lock();
            try {
                if ((fromIndex & this.indexHighBits) == this.bankPos[0]) {
                    assert (this instanceof MappedBitStorage || fromIndex - this.bankPos[0] <= Integer.MAX_VALUE);
                } else {
                    this.translateFailedIndex(fromIndex, false, LoadingMode.DEFAULT);
                }
                this.bh[0].load();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void flushResources(long fromIndex, long toIndex, boolean forcePhysicalWriting) {
            long t1;
            assert (fromIndex <= toIndex);
            long t2 = t1 = System.nanoTime();
            ReentrantLock lock = this.lock;
            int count = 0;
            lock.lock();
            try {
                this.checkIsDataFileDisposedOrShutdownInProgress();
                if (forcePhysicalWriting) {
                    this.dataFile.force();
                }
                t2 = System.nanoTime();
                for (int k = 0; k < this.bankIndexes.length; ++k) {
                    this.bankIndexes[k] = k;
                }
                ArraySorter.getQuickSorter().sortIndexes(this.bankIndexes, 0, this.bankIndexes.length, this.bankOrderComparator);
                for (int k : this.bankIndexes) {
                    DataFile.Range r;
                    if (this.bh[k] == null) continue;
                    long fromByte = this instanceof MappedBitStorage ? fromIndex >>> 3 : fromIndex << this.bytesPerBufferElementLog();
                    long toByte = this instanceof MappedBitStorage ? toIndex + 7L >>> 3 : toIndex << this.bytesPerBufferElementLog();
                    if (toByte <= (r = this.bh[k].range()).position() || fromByte >= r.position() + r.length()) continue;
                    this.bh[k].flush(forcePhysicalWriting);
                    ++count;
                }
            }
            finally {
                lock.unlock();
            }
            long t3 = System.nanoTime();
            LargeMemoryModel.LOGGER.fine(String.valueOf(this) + " is successfully flushed (" + count + " banks, " + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms flushing data file, " + String.format(Locale.US, "%.3f", (double)(t3 - t2) * 1.0E-6) + " ms flushing active banks)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void freeResources(Array a, boolean forcePhysicalWriting) {
            long t1 = System.nanoTime();
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.checkIsDataFileDisposedOrShutdownInProgress();
                if (forcePhysicalWriting) {
                    this.dataFile.force();
                }
                this.releaseFileAndMapping(ReleaseMode.DATA_MUST_STAY_ALIVE, forcePhysicalWriting);
            }
            finally {
                lock.unlock();
            }
            long t2 = System.nanoTime();
            LargeMemoryModel.LOGGER.fine(String.valueOf(this) + " is successfully released (" + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms)");
        }

        @Override
        void dispose() {
            this.dispose(DisposeCaller.DISPOSE_METHOD);
        }

        final void incrementMappingInUseCounter() {
        }

        final void decrementMappingInUseCounter() {
        }

        final int mappingInUseCounter() {
            return this.mappingInUseCounterOverflow ? Integer.MAX_VALUE : this.mappingInUseCounter.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose(DisposeCaller caller) {
            int timeout = caller.timeout;
            Object dfp = null;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.releaseFileAndMapping(ReleaseMode.DATA_MAY_BE_LOST, false);
                DataFile df = this.dataFileForDeletion;
                this.deletedWhileShutdown = caller == DisposeCaller.SHUTDOWN_HOOK;
                this.dataFile = null;
                if (df == null) {
                    return;
                }
                dfp = this.ms.dataFileModel.getPath(df);
                if (this.autoDeleted) {
                    if (df instanceof DefaultDataFileModel.MappableFile) {
                        DefaultDataFileModel.MappableFile mdf = (DefaultDataFileModel.MappableFile)df;
                        if (!(df instanceof StandardIODataFileModel.StandardIOFile)) {
                            boolean unmapped = false;
                            if (caller == DisposeCaller.SHUTDOWN_HOOK) {
                                // empty if block
                            }
                            if (caller == DisposeCaller.SHUTDOWN_HOOK && !unmapped) {
                                timeout = 0;
                            }
                        }
                    }
                    try {
                        if (MappedDataStorages.deleteWithSeveralAttempts(this.ms.dataFileModel, df, timeout)) {
                            MappedDataStorages.configEvenInHook(String.valueOf((Object)caller) + " has successfully deleted temporary array storage file " + String.valueOf(df));
                        } else {
                            MappedDataStorages.configEvenInHook(String.valueOf((Object)caller) + " has not found temporary array storage file " + String.valueOf(df));
                        }
                    }
                    catch (Throwable e) {
                        if (caller == DisposeCaller.SHUTDOWN_HOOK) {
                            MappedDataStorages.configEvenInHook(String.valueOf((Object)caller) + " cannot delete temporary array storage file " + String.valueOf(df) + (String)(caller.timeout > 0 ? " in " + caller.timeout + " ms" : "") + " (" + String.valueOf(e) + ")");
                        }
                        Arrays.throwUncheckedException(e);
                    }
                }
                this.disposeCalled = true;
                this.dataFileForDeletion = null;
            }
            finally {
                lock.unlock();
            }
            if (caller == DisposeCaller.SHUTDOWN_HOOK && dfp != null) {
                this.ms.finalizationNotify(dfp, true);
            }
        }

        abstract void setSpecificBuffer(int var1);

        abstract void getDataFromFirstBank(Buffer var1, long var2, Object var4, int var5, int var6);

        abstract void setDataInFirstBank(Buffer var1, long var2, Object var4, int var5, int var6);

        abstract void fillDataInFirstBank(long var1, long var3, Object var5);

        abstract void copyFirstBank(MappedStorage var1, long var2, long var4, long var6, boolean var8, boolean var9);

        abstract void swapFirstBank(MappedStorage var1, long var2, long var4, long var6, boolean var8);

        abstract void minDataFromFirstBank(Buffer var1, long var2, Object var4, int var5, int var6);

        abstract void maxDataFromFirstBank(Buffer var1, long var2, Object var4, int var5, int var6);

        abstract void addDataFromFirstBank(Buffer var1, long var2, int[] var4, int var5, int var6);

        abstract void addDataFromFirstBank(Buffer var1, long var2, double[] var4, int var5, int var6, double var7);

        abstract void subtractDataFromFirstBank(Buffer var1, long var2, Object var4, int var5, int var6, boolean var7);

        abstract void absDiffDataFromFirstBank(Buffer var1, long var2, Object var4, int var5, int var6, boolean var7);

        final boolean isBankLazyAndNotFilledYet(long index) {
            long bankIndex;
            if (!DO_LAZY_INIT || !this.ms.temporary) {
                return false;
            }
            long mappingPosition = this.ms.dataFileStartOffset + (this instanceof MappedBitStorage ? index >>> 3 : (index &= this.indexHighBits) << this.bytesPerBufferElementLog());
            if (mappingPosition >= this.lazyFillPosInBytes) {
                return true;
            }
            long l = bankIndex = this.singleMapping ? 0L : index >> this.ms.bankSizeInElementsLog;
            return bankIndex < this.lazyFillMapOfBanks.length() && this.lazyFillMapOfBanks.getBit(bankIndex);
        }

        void actualizeLazyFillingBank(ByteBuffer bankBB, long elementIndex) {
            this.actualizeLazyZeroFillingBank(bankBB, 0, bankBB.limit());
        }

        final void actualizeLazyZeroFillingBank(ByteBuffer bankByteBuffer, int from, int to) {
            assert (from <= to);
            JBuffers.fillByteBuffer(bankByteBuffer, from, to - from, ZERO_INIT_FILLER);
        }

        private void getUninitializedLazyDataFromBank(long pos, Object destArray, int destArrayOffset, int count) {
            long length;
            long l = length = this.ms.lazyFillingPattern == null ? 0L : this.ms.lazyFillingPattern.length();
            if ((long)count > length - pos) {
                int newCount = (int)(length < pos ? 0L : length - pos);
                JArrays.zeroFillArray(destArray, destArrayOffset + newCount, count - newCount);
                count = newCount;
            }
            if (count > 0) {
                this.ms.lazyFillingPattern.getData(pos, destArray, destArrayOffset, count);
            }
        }

        private void setSingleMappingModeIfNecessary() {
            if (this.unresizable && Math.min(this.dataFileLength, this.ms.dataFileEndOffset) <= this.ms.dataFileStartOffset + (long)this.ms.dataFileModel.recommendedSingleMappingLimit()) {
                this.lock.lock();
                try {
                    this.indexHighBits = 0L;
                    this.singleMapping = true;
                    this.syncNecessary = false;
                }
                finally {
                    this.lock.unlock();
                }
                if (LargeMemoryModel.LOGGER.isLoggable(Level.FINE)) {
                    LargeMemoryModel.LOGGER.fine("Single mapping mode is set for data file " + String.valueOf(this.dataFile) + " (its length " + this.dataFileLength + " or the specified end offset " + this.ms.dataFileEndOffset + " does not exceed the limit " + this.ms.dataFileModel.recommendedSingleMappingLimit() + (String)(this.ms.dataFileStartOffset == 0L ? "" : " after start offset " + this.ms.dataFileStartOffset) + ")");
                }
            }
        }

        private void changeCapacity(long newCapacity, long offset, long length, boolean unresizable) {
            long maxBytes;
            assert (newCapacity >= 0L);
            assert (offset >= 0L);
            assert (length >= 0L);
            assert (this.lock.isHeldByCurrentThread()) : "changeCapacity is called from non-synchronized code";
            if (this.unresizable) {
                throw new InternalError("Internal error in Buffer/LargeMemoryModel implementation (unallowed changeCapacity)");
            }
            long requiredElements = offset + newCapacity;
            if (requiredElements < 0L) {
                throw new TooLargeArrayException("Too large desired capacity: " + ((double)offset + (double)newCapacity) + " > 2^63-1");
            }
            if (!(this instanceof MappedBitStorage) && requiredElements > Long.MAX_VALUE >> this.bytesPerBufferElementLog()) {
                throw new TooLargeArrayException("Too large desired capacity: " + requiredElements + " > 2^" + (63 - this.bytesPerBufferElementLog()) + "-1");
            }
            long requiredBytes = this instanceof MappedBitStorage ? requiredElements + 7L >>> 3 : requiredElements << this.bytesPerBufferElementLog();
            if (requiredBytes > (maxBytes = Long.MAX_VALUE - this.ms.dataFileStartOffset - (long)this.ms.bankSizeInBytes + 1L)) {
                throw new TooLargeArrayException("Too large desired capacity in bytes: " + this.ms.dataFileStartOffset + " + " + requiredBytes + " > " + (Long.MAX_VALUE - (long)this.ms.bankSizeInBytes + 1L));
            }
            requiredBytes = unresizable ? requiredBytes + 31L & 0xFFFFFFFFFFFFFFE0L : requiredBytes + (long)this.ms.bankSizeInBytes - 1L & (long)(~(this.ms.bankSizeInBytes - 1));
            long newFileLength = this.ms.dataFileStartOffset + requiredBytes;
            long oldFileLength = this.dataFileLength;
            boolean autoResizing = this.ms.dataFileModel.autoResizingOnMapping();
            if (newFileLength > oldFileLength) {
                this.checkIsDataFileDisposedOrShutdownInProgress();
                this.flushResources(0L, Long.MAX_VALUE, false);
                this.dataFile.open(false);
                if (!autoResizing) {
                    this.dataFile.length(newFileLength);
                }
                this.dataFileLength = newFileLength;
            }
            if (newFileLength > oldFileLength ? this.finerLoggable : this.finestLoggable) {
                LargeMemoryModel.LOGGER.log(newFileLength > oldFileLength ? Level.FINER : Level.FINEST, "Data file " + String.valueOf(this.dataFile) + (newFileLength <= oldFileLength ? " is not resized (current length is " + oldFileLength + "=0x" + Long.toHexString(oldFileLength) + " bytes, required is " + newFileLength + "=0x" + Long.toHexString(newFileLength) + " bytes)" : (autoResizing ? " will be automatically resized from " + oldFileLength + "=0x" + Long.toHexString(oldFileLength) + " to " + newFileLength + "=0x" + Long.toHexString(newFileLength) + " bytes" : " is resized from " + oldFileLength + "=0x" + Long.toHexString(oldFileLength) + " to " + newFileLength + "=0x" + Long.toHexString(newFileLength) + " bytes")) + " (desired capacity is " + newCapacity + ")");
            }
            this.unresizable = unresizable;
            this.setSingleMappingModeIfNecessary();
        }

        private void mapBank(long position, boolean loadIntoSecondBank, LoadingMode loadingMode) {
            AssertionError ae;
            boolean fromCache;
            long mappingSize;
            assert ((position & (this.indexHighBits ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "loadBank is called for not-aligned position " + position + " (mask " + this.indexHighBits + "=0x" + Long.toHexString(this.indexHighBits) + ")";
            assert (!this.singleMapping || position == 0L);
            assert (this.lock.isHeldByCurrentThread()) : "mapBank is called from non-synchronized code";
            int bank = loadIntoSecondBank ? 1 : 0;
            long t1 = 0L;
            if (this.finerLoggable) {
                t1 = System.nanoTime();
            }
            this.checkIsDataFileDisposedOrShutdownInProgress();
            this.dataFile.open(this.ms.readOnly);
            long mappingPosition = this.ms.dataFileStartOffset + (this instanceof MappedBitStorage ? position >>> 3 : position << this.bytesPerBufferElementLog());
            long l = mappingSize = this.singleMapping ? Math.min(this.dataFileLength, this.ms.dataFileEndOffset) - this.ms.dataFileStartOffset : Math.min((long)this.ms.bankSizeInBytes, Math.min(this.dataFileLength, this.ms.dataFileEndOffset) - mappingPosition);
            assert (mappingPosition >= 0L && mappingSize > 0L && mappingSize <= Integer.MAX_VALUE) : "Illegal mappingPosition " + mappingPosition + " or mappingSize " + mappingSize + " (position = " + position + ", bankSizeInBytes = " + this.ms.bankSizeInBytes + ", dataFileLength = " + this.dataFileLength + ", dataFileStartOffset = " + this.ms.dataFileStartOffset + ", singleMapping = " + this.singleMapping + ")";
            assert ((mappingPosition - this.ms.dataFileStartOffset & (long)(this.ms.bankSizeInBytes - 1)) == 0L) : "non-aligned mapping position " + mappingPosition + " (bank size in bytes is " + this.ms.bankSizeInBytes + "=0x" + Long.toHexString(this.ms.bankSizeInBytes) + ")";
            if (this.ms.temporary) {
                assert ((this.lazyFillPosInBytes - this.ms.dataFileStartOffset & (long)(this.ms.bankSizeInBytes - 1)) == 0L) : "non-aligned lazyFillPosInBytes-ms.dataFileStartOffset=" + (this.lazyFillPosInBytes - this.ms.dataFileStartOffset) + " (bank size in bytes is " + this.ms.bankSizeInBytes + "=0x" + Long.toHexString(this.ms.bankSizeInBytes) + ")";
                assert (this.ms.dataFileStartOffset + (this.lazyFillMapOfBanks.length() << this.ms.bankSizeInBytesLog) <= this.lazyFillPosInBytes) : "too large lazyFillMapOfBanks: " + this.lazyFillMapOfBanks.length() + " bits (bank size in bytes is " + this.ms.bankSizeInBytes + "=0x" + Long.toHexString(this.ms.bankSizeInBytes) + ")";
            }
            long thisBankIndex = DO_LAZY_INIT && this.ms.temporary && !this.singleMapping ? mappingPosition - this.ms.dataFileStartOffset >> this.ms.bankSizeInBytesLog : 0L;
            if (DO_LAZY_INIT && this.ms.temporary && this.lazyFillPosInBytes < mappingPosition) {
                long lazyFillPos;
                t1 = System.nanoTime();
                assert (!this.singleMapping) : "illegal singleMapping with low lazyFillPosInBytes=" + this.lazyFillPosInBytes;
                long needfulFillMapSize = thisBankIndex;
                assert (this.lazyFillMapOfBanks.length() < needfulFillMapSize) : "illegal lazyFillMapOfBanks.length()=" + this.lazyFillMapOfBanks.length();
                long newFillMapSize = Math.min(needfulFillMapSize, (long)LargeMemoryModel.MAX_NUMBER_OF_BANKS_IN_LAZY_FILL_MAP);
                this.lazyFillMapOfBanks.length(newFillMapSize);
                long lazyFillBankIndex = this.lazyFillPosInBytes - this.ms.dataFileStartOffset >> this.ms.bankSizeInBytesLog;
                if (lazyFillBankIndex < newFillMapSize) {
                    this.lazyFillMapOfBanks.subArray(lazyFillBankIndex, newFillMapSize).fill(true);
                }
                this.lazyFillPosInBytes = Math.max(this.lazyFillPosInBytes, this.ms.dataFileStartOffset + (newFillMapSize << this.ms.bankSizeInBytesLog));
                long l2 = lazyFillPos = this instanceof MappedBitStorage ? this.lazyFillPosInBytes - this.ms.dataFileStartOffset << 3 : this.lazyFillPosInBytes - this.ms.dataFileStartOffset >> this.bytesPerBufferElementLog();
                assert (lazyFillPos >= 0L) : "negative array index " + lazyFillPos + ", corresponding to lazy fill position " + this.lazyFillPosInBytes;
                long p = lazyFillPos;
                for (long mp = this.lazyFillPosInBytes; mp < mappingPosition; mp += (long)this.ms.bankSizeInBytes) {
                    assert (newFillMapSize < needfulFillMapSize) : "extra lazy filling loop";
                    assert (p < position) : "p>=position";
                    DataFile.BufferHolder tempBh = this.dataFile.map(DataFile.Range.of(mp, this.ms.bankSizeInBytes), true);
                    this.scheduleFinalizationForMapping(tempBh);
                    this.actualizeLazyFillingBank(tempBh.data(), p);
                    tempBh.unmap(false);
                    this.checkIsDataFileDisposedOrShutdownInProgress();
                    p += this.ms.bankSizeInElements;
                }
                long t2 = System.nanoTime();
                if (this.finerLoggable) {
                    LargeMemoryModel.LOGGER.finer("**** The region #" + Long.toHexString(this.lazyFillPosInBytes) + "h.." + Long.toHexString(mappingPosition) + "h of " + String.valueOf(this.dataFilePath) + "is cleared (" + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms) (" + MappedDataStorages.finalizationTasksInfo() + ")");
                }
                t1 = t2;
            }
            boolean lazyFillBit = false;
            boolean thisBankMustBeFilled = DO_LAZY_INIT && this.ms.temporary && (mappingPosition >= this.lazyFillPosInBytes || (lazyFillBit = thisBankIndex < this.lazyFillMapOfBanks.length() && this.lazyFillMapOfBanks.getBit(thisBankIndex)));
            this.bh[bank] = this.dataFile.map(DataFile.Range.of(mappingPosition, mappingSize), loadingMode == LoadingMode.NOT_LOAD_DATA_FROM_FILE || thisBankMustBeFilled);
            if (loadingMode == LoadingMode.PRELOAD_DATA_FROM_FILE) {
                this.bh[bank].load();
            }
            if (thisBankMustBeFilled) {
                this.actualizeLazyFillingBank(this.bh[bank].data(), position);
                if (lazyFillBit) {
                    this.lazyFillMapOfBanks.clearBit(thisBankIndex);
                }
            }
            this.lazyFillPosInBytes = Math.max(this.lazyFillPosInBytes, mappingPosition + (long)this.ms.bankSizeInBytes);
            this.bankPos[bank] = position;
            this.setSpecificBuffer(bank);
            if (!this.syncNecessary) {
                assert (this.singleMapping);
                this.validSingleSpecBufForThisThread = this.specBufs[bank];
                assert (this.validSingleSpecBufForThisThread != null);
            }
            boolean loggable = (fromCache = this.bh[bank].isLoadedFromCache()) ? this.finestLoggable : this.finerLoggable;
            int id = System.identityHashCode(this.bh[bank].mappingObject());
            if (loggable) {
                long t2 = System.nanoTime();
                LargeMemoryModel.LOGGER.log(fromCache ? Level.FINEST : Level.FINER, "**** The bank #" + bank + " is mapped" + (fromCache ? " (quickly): " + String.valueOf(this.bh[bank]) : ": " + String.valueOf(this.bh[bank]) + " @" + Integer.toHexString(id)) + " (" + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms) (" + MappedDataStorages.finalizationTasksInfo() + ")");
            }
            if ((ae = this.logAndCheckBanks(position, loadIntoSecondBank, LogAllBanksCallPlace.loadBank, fromCache ? Level.FINEST : Level.FINER)) != null) {
                throw ae;
            }
            this.scheduleFinalizationForMapping(this.bh[bank]);
            this.scheduleFinalizationForAllStorage();
        }

        private boolean unmapBank(int bank, ReleaseMode mode, boolean forcePhysicalWriting) {
            DataFile.BufferHolder tempBh = this.bh[bank];
            if (tempBh != null) {
                long t1 = 0L;
                if (this.finerLoggable) {
                    t1 = System.nanoTime();
                }
                if (mode == ReleaseMode.DATA_MUST_STAY_ALIVE) {
                    tempBh.unmap(forcePhysicalWriting);
                } else {
                    tempBh.dispose();
                }
                this.bh[bank] = null;
                this.specBufs[bank] = null;
                if (this.finerLoggable) {
                    long t2 = System.nanoTime();
                    LargeMemoryModel.LOGGER.finer("**** The bank #" + bank + ": " + String.valueOf(tempBh) + " is " + (mode == ReleaseMode.DATA_MUST_STAY_ALIVE ? "unmapped (" : "disposed (") + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms)");
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleFinalizationForMapping(DataFile.BufferHolder bufferHolder) {
            Object checkedData = bufferHolder.mappingObject();
            if (checkedData != null) {
                boolean loggable = bufferHolder.isLoadedFromCache() ? this.finestLoggable : this.finerLoggable;
                String bhToString = loggable ? bufferHolder.toString() : null;
                int id = System.identityHashCode(checkedData);
                this.lockForGc.lock();
                try {
                    ++this.mappingCounter;
                }
                finally {
                    this.lockForGc.unlock();
                }
                LargeMemoryModel.globalMappingFinalizer.invokeOnDeallocation(checkedData, () -> {
                    if (bhToString != null) {
                        LargeMemoryModel.LOGGER.finer("~~~~ " + bhToString + " @" + Integer.toHexString(id) + " is deallocated (" + MappedDataStorages.finalizationTasksInfo() + ")");
                    }
                    this.decreaseArrayOrMappingCounter(CounterKind.MAPPING_COUNTER);
                });
            }
        }

        private void scheduleFinalizationForAllStorage() {
            if (this.finalizationHolder == null) {
                this.finalizationHolder = new Object();
                this.lockForGc.lock();
                try {
                    ++this.mappingCounter;
                }
                finally {
                    this.lockForGc.unlock();
                }
                LargeMemoryModel.LOGGER.fine("FF++ " + String.valueOf(this) + ": finalization is scheduled (" + MappedDataStorages.finalizationTasksInfo() + ")");
                LargeMemoryModel.globalStorageFinalizer.invokeOnDeallocation(this.finalizationHolder, new Runnable(){

                    @Override
                    public void run() {
                        LargeMemoryModel.LOGGER.fine("FF-- " + String.valueOf(this) + " is released (" + MappedDataStorages.finalizationTasksInfo() + ")");
                        this.decreaseArrayOrMappingCounter(CounterKind.MAPPING_COUNTER);
                    }
                });
            }
        }

        private AssertionError logAndCheckBanks(long index, boolean useSecondBank, LogAllBanksCallPlace whereCalled, Level level) {
            String msg;
            block16: {
                msg = null;
                if (this.bankCount < 0 || this.bankCount > this.bh.length) {
                    msg = "invalid bankCount = " + this.bankCount;
                } else {
                    int k;
                    for (k = 1; k < this.bankCount; ++k) {
                        if (this.bh[k] == null) {
                            msg = "bh[" + k + "] is null, but " + (this.bankPos[k] != -1L ? "bankPos[" + k + "] != -1" : "bankCount is " + this.bankCount);
                        } else {
                            if (this.bankPos[k] != -1L) continue;
                            msg = "bankPos[" + k + "] is -1, but " + (this.bh[k] != null ? "bh[" + k + "] != null" : "bankCount is " + this.bankCount);
                        }
                        break block16;
                    }
                    for (k = this.bankCount; k < this.bh.length; ++k) {
                        if (this.bh[k] != null) {
                            msg = "bh[" + k + "] is not null, but bankCount is " + this.bankCount;
                        } else {
                            if (this.bankPos[k] == -1L) continue;
                            msg = "bankPos[" + k + "] is not -1, but bankCount is " + this.bankCount;
                        }
                        break block16;
                    }
                    block2: for (k = 0; k < this.bankCount; ++k) {
                        if (k < 2 || this.bankPos[k] == -1L) continue;
                        for (int j = 0; j < k; ++j) {
                            if (this.bankPos[k] != this.bankPos[j]) continue;
                            msg = "banks #" + j + " and #" + k + " are duplicates";
                            break block2;
                        }
                    }
                }
            }
            AssertionError result = null;
            if (msg != null) {
                result = new AssertionError((Object)("Internal error found in " + String.valueOf((Object)whereCalled) + ": " + msg));
                level = Level.SEVERE;
            }
            if (LargeMemoryModel.LOGGER.isLoggable(level)) {
                StringBuilder sb = new StringBuilder(this.bankCount + " banks, accessing index " + Long.toHexString(index) + "h");
                for (int k = 0; k < (result == null ? this.bankCount : this.bh.length); ++k) {
                    sb.append(InternalUtils.LF).append("    [").append((Object)whereCalled).append("] mapping ").append(useSecondBank ? "(at second bank) " : "").append(k).append(": ").append(this.bh[k]);
                }
                sb.append(InternalUtils.LF).append("The reason:");
                StackTraceElement[] se = Thread.currentThread().getStackTrace();
                for (int k = 2; k < se.length; ++k) {
                    sb.append(InternalUtils.LF).append("    ").append(se[k]);
                }
                if (result == null) {
                    LargeMemoryModel.LOGGER.log(level, sb.toString());
                } else {
                    LargeMemoryModel.LOGGER.log(level, sb.toString(), (Throwable)((Object)result));
                }
            }
            return result;
        }

        private void releaseFileAndMapping(ReleaseMode mode, boolean forcePhysicalWriting) {
            DataFile df;
            assert (this.lock.isHeldByCurrentThread()) : "releaseFileAndMapping is called from non-synchronized code";
            long t1 = System.nanoTime();
            int count = 0;
            int bStart = 0;
            if (!this.syncNecessary) {
                this.validSingleSpecBufForThisThread = null;
            }
            if (this.bankPos[0] == this.bankPos[1]) {
                this.bankPos[0] = -1L;
                this.bh[0] = null;
                this.specBufs[0] = null;
                ++bStart;
            }
            for (int k = 0; k < this.bankIndexes.length; ++k) {
                this.bankIndexes[k] = k;
            }
            ArraySorter.getQuickSorter().sortIndexes(this.bankIndexes, bStart, this.bankIndexes.length, this.bankOrderComparator);
            for (int b = bStart; b < this.bh.length; ++b) {
                int k = this.bankIndexes[b];
                assert (k >= bStart && k < this.bh.length);
                this.bankPos[k] = -1L;
                if (!this.unmapBank(k, mode, forcePhysicalWriting)) continue;
                ++count;
            }
            this.finalizationHolder = null;
            this.bankCount = 0;
            long t2 = System.nanoTime();
            if (count > 0 && this.finerLoggable) {
                LargeMemoryModel.LOGGER.finer("All buffers are released (" + count + " banks, " + String.format(Locale.US, "%.3f", (double)(t2 - t1) * 1.0E-6) + " ms)");
            }
            if ((df = this.dataFile) != null) {
                df.close();
                if (this.finerLoggable) {
                    LargeMemoryModel.LOGGER.finer("Data file " + String.valueOf(df) + " is closed");
                }
            }
        }

        private void checkIsDataFileDisposedOrShutdownInProgress() {
            if (shutdownInProgress) {
                throw new IOError(new IllegalStateException("AlgART array @<" + String.valueOf(this) + "> is inaccessible: system shutdown in progress"));
            }
            if (this.dataFile == null) {
                throw new IOError(new IllegalStateException("AlgART array @<" + String.valueOf(this) + "> is inaccessible: the storage was already disposed and deleted"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decreaseArrayOrMappingCounter(CounterKind counterKind) {
            boolean needToForgetStorage;
            Object dfp;
            block32: {
                ReentrantLock lock;
                boolean needToDeleteFile;
                DataFile df;
                block31: {
                    df = null;
                    dfp = null;
                    boolean needToClearBanks = false;
                    needToDeleteFile = false;
                    needToForgetStorage = false;
                    this.lockForGc.lock();
                    try {
                        if (counterKind == CounterKind.ARRAY_COUNTER) {
                            --this.arrayCounter;
                        }
                        if (this.arrayCounter < 0) {
                            throw new AssertionError((Object)"Negative number of attached arrays!");
                        }
                        if (counterKind == CounterKind.MAPPING_COUNTER) {
                            --this.mappingCounter;
                        }
                        if (this.mappingCounter < 0) {
                            throw new AssertionError((Object)"Negative number of mappings!");
                        }
                        if (counterKind == CounterKind.ARRAY_COUNTER && this.arrayCounter == 0 && this.mappingCounter > 0) {
                            needToClearBanks = true;
                        }
                        if (this.arrayCounter == 0 && this.mappingCounter == 0) {
                            df = this.dataFileForDeletion;
                            dfp = this.dataFilePath;
                            this.dataFile = null;
                            needToDeleteFile = this.autoDeleted && df != null;
                            needToForgetStorage = true;
                        }
                        if (this.finerLoggable) {
                            LargeMemoryModel.LOGGER.finer("~~-- Decreasing " + (counterKind == CounterKind.ARRAY_COUNTER ? "array" : "mapping") + " counter: " + this.arrayCounter + " arrays, " + this.mappingCounter + " mappings (" + MappedDataStorages.finalizationTasksInfo() + ")" + (String)(needToDeleteFile ? "; file " + String.valueOf(df) + " should be deleted" : ""));
                        }
                    }
                    finally {
                        this.lockForGc.unlock();
                    }
                    try {
                        if (!needToClearBanks) break block31;
                        lock = this.lock;
                        lock.lock();
                        try {
                            this.releaseFileAndMapping(ReleaseMode.DATA_MAY_BE_LOST, false);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Throwable ex) {
                        LargeMemoryModel.LOGGER.log(Level.SEVERE, "Cannot release array file/mapping resources", ex);
                        return;
                    }
                }
                if (needToDeleteFile) {
                    lock = this.lock;
                    lock.lock();
                    try {
                        if (this.disposeCalled) break block32;
                        int timeout = LargeMemoryModel.DELETION_TIMEOUT_IN_FINALIZATION;
                        try {
                            if (MappedDataStorages.deleteWithSeveralAttempts(this.ms.dataFileModel, df, timeout)) {
                                LargeMemoryModel.LOGGER.fine("Finalization: temporary array storage file " + String.valueOf(df) + " is successfully deleted" + (String)(this.countOfFailedDeletionsWhileFinalization > 0 ? " (" + this.countOfFailedDeletionsWhileFinalization + " attempts)" : ""));
                            } else {
                                LargeMemoryModel.LOGGER.finer("Finalization: no temporary array storage file " + String.valueOf(df));
                            }
                        }
                        catch (Throwable ex) {
                            String msg = "Finalization: cannot delete temporary array storage file " + String.valueOf(df) + (String)(timeout > 0 ? " in " + timeout + " ms" : "");
                            if (ex instanceof IOError) {
                                if (++this.countOfFailedDeletionsWhileFinalization >= 100) {
                                    MappedDataStorages.warningEvenInHook(msg + " (" + String.valueOf(ex) + "). It was the attempt #" + this.countOfFailedDeletionsWhileFinalization + ": deletion of this file by the finalizer is canceled!");
                                } else {
                                    LargeMemoryModel.LOGGER.fine(msg + ". Deletion is scheduled on the next garbage collector execution. (" + String.valueOf(ex) + ")");
                                    this.scheduleFinalizationForAllStorage();
                                    this.finalizationHolder = null;
                                    dfp = null;
                                }
                            } else {
                                LargeMemoryModel.LOGGER.log(Level.SEVERE, msg + " (Unexpected exception!)", ex);
                            }
                            this.deletionErrorWhileFinalization = true;
                            lock.unlock();
                            return;
                        }
                        this.dataFileForDeletion = null;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            if (needToForgetStorage) {
                allNonFinalizedMappedStorages.remove(this);
                if (dfp != null) {
                    this.ms.finalizationNotify(dfp, false);
                }
            }
        }

        static enum LoadingMode {
            DEFAULT,
            PRELOAD_DATA_FROM_FILE,
            NOT_LOAD_DATA_FROM_FILE;

        }

        private static enum ReleaseMode {
            DATA_MUST_STAY_ALIVE,
            DATA_MAY_BE_LOST;

        }

        private static enum LogAllBanksCallPlace {
            translateFailedIndex,
            translateFailedIndexSame,
            translateFailedIndexHole,
            loadBank;

        }

        private static enum CounterKind {
            ARRAY_COUNTER,
            MAPPING_COUNTER;

        }

        private static enum DisposeCaller {
            SHUTDOWN_HOOK("AlgART cleaner", LargeMemoryModel.DELETION_TIMEOUT_IN_CLEANER),
            DISPOSE_METHOD("dispose method", LargeMemoryModel.DELETION_TIMEOUT_IN_DISPOSE);

            private final String name;
            final int timeout;

            private DisposeCaller(String name, int timeout) {
                this.name = name;
                this.timeout = timeout;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    static class MappingSettings<P> {
        final DataFileModel<P> dataFileModel;
        final DataFile existingDataFile;
        final long dataFileStartOffset;
        final long dataFileEndOffset;
        final boolean temporary;
        final boolean readOnly;
        final boolean unresizable;
        final int numberOfBanks;
        final long bankSizeInElements;
        final int bankSizeInElementsLog;
        final int bankSizeInBytes;
        final int bankSizeInBytesLog;
        final PArray lazyFillingPattern;
        private final Class<?> arrayElementClass;

        private MappingSettings(DataFileModel<P> dataFileModel, DataFile dataFile, long dataFileStartOffset, long dataFileEndOffset, boolean temporary, boolean readOnly, boolean unresizable, Class<?> arrayElementClass, PArray lazyFillingPattern) {
            Objects.requireNonNull(dataFileModel, "Null dataFileModel argument");
            int numberOfBanks = dataFileModel.recommendedNumberOfBanks();
            int bankSizeInBytes = dataFileModel.recommendedBankSize(unresizable);
            MappingSettings.checkBankArguments(numberOfBanks, bankSizeInBytes);
            this.dataFileModel = dataFileModel;
            this.existingDataFile = dataFile;
            this.dataFileStartOffset = dataFileStartOffset;
            this.dataFileEndOffset = dataFileEndOffset;
            this.temporary = temporary;
            this.readOnly = readOnly;
            this.unresizable = unresizable;
            this.numberOfBanks = numberOfBanks;
            this.bankSizeInBytes = bankSizeInBytes;
            this.bankSizeInBytesLog = 31 - Integer.numberOfLeadingZeros(bankSizeInBytes);
            assert (this.bankSizeInBytes == 1 << this.bankSizeInBytesLog);
            this.arrayElementClass = arrayElementClass;
            PArray pArray = this.lazyFillingPattern = lazyFillingPattern == null ? null : lazyFillingPattern.asImmutable();
            if (lazyFillingPattern != null && arrayElementClass != lazyFillingPattern.elementType()) {
                throw new AssertionError((Object)("Illegal arrayElementClass argument: " + String.valueOf(arrayElementClass) + " (must be equal to the element type of the pattern array)"));
            }
            long l = arrayElementClass == Boolean.TYPE ? (long)bankSizeInBytes << 3 : (arrayElementClass == Character.TYPE ? (long)(bankSizeInBytes >> 1) : (arrayElementClass == Byte.TYPE ? (long)bankSizeInBytes : (arrayElementClass == Short.TYPE ? (long)(bankSizeInBytes >> 1) : (arrayElementClass == Integer.TYPE ? (long)(bankSizeInBytes >> 2) : (arrayElementClass == Long.TYPE ? (long)(bankSizeInBytes >> 3) : (arrayElementClass == Float.TYPE ? (long)(bankSizeInBytes >> 2) : (this.bankSizeInElements = arrayElementClass == Double.TYPE ? (long)(bankSizeInBytes >> 3) : -1L)))))));
            if (this.bankSizeInElements == -1L) {
                throw new AssertionError((Object)("Illegal arrayElementClass argument: " + String.valueOf(arrayElementClass)));
            }
            this.bankSizeInElementsLog = 63 - Long.numberOfLeadingZeros(this.bankSizeInElements);
            assert (this.bankSizeInElements == 1L << this.bankSizeInElementsLog);
        }

        static <P> MappingSettings<P> getInstanceForExistingFile(DataFileModel<P> dataFileModel, DataFile dataFile, long dataFileStartOffset, long dataFileEndOffset, boolean readOnly, Class<?> arrayElementClass) {
            Objects.requireNonNull(dataFile, "Null dataFile argument");
            return new MappingSettings<P>(dataFileModel, dataFile, dataFileStartOffset, dataFileEndOffset, false, readOnly, true, arrayElementClass, null);
        }

        static <P> MappingSettings<P> getInstanceForTemporaryFile(DataFileModel<P> dataFileModel, Class<?> arrayElementClass, boolean unresizable, PArray lazyFillingPattern) {
            Objects.requireNonNull(dataFileModel, "Null dataFileModel argument");
            return new MappingSettings<P>(dataFileModel, null, Math.max(0L, dataFileModel.recommendedPrefixSize()), Long.MAX_VALUE, true, false, unresizable, arrayElementClass, lazyFillingPattern);
        }

        MappingSettings<P> getCompatibleInstanceForNewTemporaryFile(boolean unresizable) {
            return new MappingSettings<P>(this.dataFileModel, null, this.dataFileStartOffset, Long.MAX_VALUE, true, false, unresizable, this.arrayElementClass, null);
        }

        void finalizationNotify(Object dataFilePath, boolean isApplicationShutdown) {
            this.dataFileModel.finalizationNotify(InternalUtils.cast(dataFilePath), isApplicationShutdown);
        }

        static void checkBankArguments(int numberOfBanks, int bankSizeInBytes) {
            if (numberOfBanks < 2) {
                throw new IllegalArgumentException("Number of banks should be 2 or greater");
            }
            if (bankSizeInBytes < 256) {
                throw new IllegalArgumentException("Bank size should be 256 or greater");
            }
            if ((bankSizeInBytes & bankSizeInBytes - 1) != 0) {
                throw new IllegalArgumentException("Bank size should be 2^k");
            }
        }

        static int nearestCorrectNumberOfBanks(int numberOfBanks) {
            return Math.max(numberOfBanks, 2);
        }

        static int nearestCorrectBankSize(int bankSizeInBytes) {
            return Integer.highestOneBit(Math.max(bankSizeInBytes, 256));
        }
    }
}

