/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.Stack;
import net.algart.arrays.UpdatableArray;

public interface MutableArray
extends Stack,
UpdatableArray {
    public MutableArray length(long var1);

    @Override
    default public MutableArray clear() {
        return this.length(0L);
    }

    public MutableArray ensureCapacity(long var1);

    public MutableArray trim();

    public MutableArray append(Array var1);

    @Override
    public MutableArray setData(long var1, Object var3, int var4, int var5);

    @Override
    public MutableArray setData(long var1, Object var3);

    @Override
    public MutableArray copy(Array var1);

    @Override
    public MutableArray swap(UpdatableArray var1);

    @Override
    public MutableArray asCopyOnNextWrite();

    @Override
    public MutableArray shallowClone();

    public static MutableArray newArray(MemoryModel memoryModel, Class<?> elementType) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newEmptyArray(elementType);
    }

    public static UpdatableArray newArray(Class<?> elementType) {
        return Arrays.SMM.newEmptyArray(elementType);
    }
}

