/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.contours.ContourHeader;
import net.algart.contours.ContourLength;
import net.algart.contours.Contours;

public final class ContourFiller {
    private static final int START_INTERSECTIONS_CAPACITY = 512;
    private final Contours contours;
    private final UpdatablePArray labels;
    private final int[][] intersectionsWithHorizontal;
    private final int[][] initialIntersectionsWithHorizontal;
    private final int[] intersectionsCount;
    private final int startX;
    private final int startY;
    private final int dimX;
    private final int dimY;
    private final int[] contourIndexes;
    private int numberOfNecessaryContours = 0;
    private int minContourY;
    private int maxContourY;
    private final ContourLength contourLength = new ContourLength();
    private int[] unpackedContour = null;
    private IntPredicate needToFill = null;
    private boolean needToUnpack = true;
    private boolean needToUnpackDiagonals = true;
    private int[] labelsMap = null;
    private int indexingBase = 0;
    private IntUnaryOperator labelToFillerDefault = value -> value;

    private ContourFiller(Contours contours, Class<?> elementType, long startX, long startY, long dimX, long dimY) {
        this.contours = Objects.requireNonNull(contours, "Null contours");
        if (startX < -1073741824L || startX > 0x3FFFFFFFL || startY < -1073741824L || startY > 0x3FFFFFFFL) {
            throw new IllegalArgumentException("Start coordinates (" + startX + ", " + startY + ") are out of allowed range -1073741824..1073741823");
        }
        if (dimX < 0L || dimY < 0L) {
            throw new IllegalArgumentException("Negative dimX or dimY");
        }
        if (dimX > Integer.MAX_VALUE || dimY > Integer.MAX_VALUE || dimX * dimY > Integer.MAX_VALUE || dimY * 512L > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot fill contours for matrix " + dimX + "x" + dimY + ": it is too large");
        }
        if (net.algart.arrays.Arrays.sizeOf(elementType) < 0.0) {
            throw new IllegalArgumentException("Unsupported element type " + String.valueOf(elementType) + ": it must be primitive");
        }
        this.startX = (int)startX;
        this.startY = (int)startY;
        this.dimX = (int)dimX;
        this.dimY = (int)dimY;
        this.labels = (UpdatablePArray)net.algart.arrays.Arrays.SMM.newUnresizableArray(elementType, dimX * dimY);
        this.intersectionsWithHorizontal = new int[this.dimY][512];
        this.initialIntersectionsWithHorizontal = (int[][])this.intersectionsWithHorizontal.clone();
        this.intersectionsCount = new int[this.dimY];
        this.contourIndexes = new int[contours.numberOfContours()];
    }

    public static ContourFiller newInstance(Contours contours, long startX, long startY, long dimX, long dimY) {
        return new ContourFiller(contours, Integer.TYPE, startX, startY, dimX, dimY);
    }

    public static ContourFiller newInstance(Contours contours, Class<?> elementType, long startX, long startY, long dimX, long dimY) {
        return new ContourFiller(contours, elementType, startX, startY, dimX, dimY);
    }

    public IntPredicate getNeedToFill() {
        return this.needToFill;
    }

    public ContourFiller setNeedToFill(IntPredicate needToFill) {
        this.needToFill = needToFill;
        return this;
    }

    public boolean isNeedToUnpack() {
        return this.needToUnpack;
    }

    public ContourFiller setNeedToUnpack(boolean needToUnpack) {
        this.needToUnpack = needToUnpack;
        return this;
    }

    public boolean isNeedToUnpackDiagonals() {
        return this.needToUnpackDiagonals;
    }

    public ContourFiller setNeedToUnpackDiagonals(boolean needToUnpackDiagonals) {
        this.needToUnpackDiagonals = needToUnpackDiagonals;
        return this;
    }

    public int[] getLabelsMap() {
        return this.labelsMap;
    }

    public ContourFiller setLabelsMap(int[] labelsMap) {
        this.labelsMap = labelsMap;
        return this;
    }

    public int getIndexingBase() {
        return this.indexingBase;
    }

    public ContourFiller setIndexingBase(int indexingBase) {
        if (indexingBase < 0) {
            throw new IllegalArgumentException("Indexing base cannot be negative: " + indexingBase);
        }
        this.indexingBase = indexingBase;
        return this;
    }

    public IntUnaryOperator getLabelToFillerDefault() {
        return Objects.requireNonNull(this.labelToFillerDefault, "Null default value function");
    }

    public ContourFiller setLabelToFillerDefault(IntUnaryOperator labelToFillerDefault) {
        this.labelToFillerDefault = labelToFillerDefault;
        return this;
    }

    public int dimX() {
        return this.dimX;
    }

    public int dimY() {
        return this.dimY;
    }

    public void findAndSortNecessaryContours() {
        int n = this.contours.numberOfContours();
        int[] contourSize = new int[n];
        MutableIntArray maxSizeForLabel = net.algart.arrays.Arrays.SMM.newEmptyIntArray();
        ContourHeader header = new ContourHeader();
        int count = 0;
        for (int k = 0; k < n; ++k) {
            if (this.needToFill != null && !this.needToFill.test(k)) continue;
            this.contours.getHeader(header, k);
            int minX = header.minX();
            int maxX = header.maxX();
            int minY = header.minY();
            int maxY = header.maxY();
            if (maxX < this.startX || minX >= this.startX + this.dimX || maxY < this.startY || minY >= this.startY + this.dimY) continue;
            int diffY = maxY - minY;
            if (diffY < 0) {
                throw new AssertionError((Object)("Overflow in sizes of containing rectangle for contour #" + k + "; it must be impossible due to check of Contour2DArray.MAX_ABSOLUTE_COORDINATE"));
            }
            int label = this.contours.getObjectLabel(k);
            if (label >= 0) {
                if ((long)label >= maxSizeForLabel.length()) {
                    maxSizeForLabel.length((long)label + 1L);
                }
                if (diffY > maxSizeForLabel.getInt(label)) {
                    maxSizeForLabel.setInt(label, diffY);
                }
            }
            contourSize[count] = diffY;
            this.contourIndexes[count] = k;
            ++count;
        }
        this.numberOfNecessaryContours = count;
        ArraySorter.getQuickSorter().sortIndexes(this.contourIndexes, 0, count, (firstIndex, secondIndex) -> {
            boolean secondInternal;
            int secondLabel;
            int firstLabel = this.contours.getObjectLabel(firstIndex);
            if (firstLabel != (secondLabel = this.contours.getObjectLabel(secondIndex))) {
                int secondSize;
                if (firstLabel < 0 || secondLabel < 0) {
                    return firstLabel < secondLabel;
                }
                int firstSize = maxSizeForLabel.getInt(firstLabel);
                if (firstSize != (secondSize = maxSizeForLabel.getInt(secondLabel))) {
                    return firstSize > secondSize;
                }
                return firstLabel < secondLabel;
            }
            boolean firstInternal = this.contours.isInternalContour(firstIndex);
            if (firstInternal != (secondInternal = this.contours.isInternalContour(secondIndex))) {
                return secondInternal;
            }
            return contourSize[firstIndex] < contourSize[secondIndex];
        });
    }

    public int numberOfNecessaryContours() {
        return this.numberOfNecessaryContours;
    }

    public void fillNecessaryContours() {
        int maxTranslatedLabelPlus1 = this.labelsMap == null ? Integer.MIN_VALUE : this.labelsMap.length + this.indexingBase;
        int from = 0;
        while (from < this.numberOfNecessaryContours) {
            int translatedLabel;
            int to;
            int label = this.contours.getObjectLabel(this.contourIndexes[from]);
            for (to = from + 1; to < this.numberOfNecessaryContours && this.contours.getObjectLabel(this.contourIndexes[to]) == label; ++to) {
            }
            if (label < maxTranslatedLabelPlus1 && label >= this.indexingBase) {
                assert (this.labelsMap != null);
                translatedLabel = this.labelsMap[label - this.indexingBase];
            } else {
                translatedLabel = this.labelToFillerDefault.applyAsInt(label);
            }
            this.fillContours(this.contourIndexes, from, to, translatedLabel);
            from = to;
        }
    }

    public void fillContours(int[] contourIndexes, int from, int to, int label) {
        this.openContour();
        for (int k = from; k < to; ++k) {
            int contourIndex = contourIndexes[k];
            int[] nArray = this.unpackedContour = this.needToUnpack ? this.contours.unpackContourAndReallocateResult(this.unpackedContour, this.contourLength, contourIndex, this.needToUnpackDiagonals) : this.contours.getContourPointsAndReallocateResult(this.unpackedContour, this.contourLength, contourIndex);
            if (this.contourLength.isDegenerated()) continue;
            this.addIntersectionsWithContour(this.unpackedContour, this.contourLength.getArrayLength());
        }
        this.fillAndCloseContour(label);
    }

    public Matrix<? extends PArray> getLabels() {
        return Matrices.matrix(this.labels, this.dimX, this.dimY);
    }

    private void openContour() {
        this.maxContourY = Integer.MIN_VALUE;
        this.minContourY = Integer.MAX_VALUE;
    }

    private void addIntersectionsWithContour(int[] contour, int arrayLength) {
        int dimY = this.dimY;
        int startX = this.startX;
        int startY = this.startY;
        int i = 0;
        while (i < arrayLength) {
            int lessFromTwoY;
            int x = contour[i] - startX;
            int y = contour[i + 1] - startY;
            if (y < 0 || y > dimY) {
                int distance = y < 0 ? -y : y - dimY;
                i += distance << 1;
                continue;
            }
            int lastI = i == 0 ? arrayLength - 2 : i - 2;
            int lastX = contour[lastI] - startX;
            int lastY = contour[lastI + 1] - startY;
            i += 2;
            int dx = x - lastX;
            int dy = y - lastY;
            if (dy == 0 ? dx != -1 && dx != 1 : dx != 0 || dy != -1 && dy != 1) {
                if (this.needToUnpack) {
                    throw new AssertionError((Object)("Invalid segment in unpacked contour: " + lastX + "," + lastY + " -> " + x + "," + y + "; cannot appear in unpacked contours"));
                }
                throw new IllegalArgumentException("Invalid segment in the contour: " + lastX + "," + lastY + " -> " + x + "," + y + "; you must use setNeedToUnpack(true) (default mode) to process such contours");
            }
            if (dx != 0 || (lessFromTwoY = dy < 0 ? y : lastY) < 0 || lessFromTwoY >= dimY) continue;
            this.addIntersection(x, lessFromTwoY);
        }
    }

    private void fillAndCloseContour(int label) {
        int dimX = this.dimX;
        int y = this.minContourY;
        int disp = y * dimX;
        while (y <= this.maxContourY) {
            int count = this.intersectionsCount[y];
            assert ((count & 1) == 0) : "odd number of intersection with y=" + y + " (impossible for connected curve)";
            int[] intersections = this.intersectionsWithHorizontal[y];
            Arrays.sort(intersections, 0, count);
            for (int k = 0; k < count; k += 2) {
                int fromX = intersections[k];
                int toX = intersections[k + 1];
                if (toX <= 0) continue;
                if (fromX >= dimX) break;
                if (fromX < 0) {
                    fromX = 0;
                }
                if (toX > dimX) {
                    toX = dimX;
                }
                assert (fromX <= toX);
                this.labels.fill((long)disp + (long)fromX, (long)toX - (long)fromX, label);
            }
            this.removeAllIntersections(y);
            ++y;
            disp += dimX;
        }
    }

    private void addIntersection(int x, int y) {
        if (y < this.minContourY) {
            this.minContourY = y;
        }
        if (y > this.maxContourY) {
            this.maxContourY = y;
        }
        int n = y;
        int n2 = this.intersectionsCount[n];
        this.intersectionsCount[n] = n2 + 1;
        int count = n2;
        int[] intersections = this.intersectionsWithHorizontal[y];
        if (count >= intersections.length) {
            intersections = this.ensureCapacity(y, (long)count + 1L);
        }
        intersections[count] = x;
    }

    private void removeAllIntersections(int y) {
        this.intersectionsCount[y] = 0;
        if (this.intersectionsWithHorizontal[y].length > 512) {
            this.intersectionsWithHorizontal[y] = this.initialIntersectionsWithHorizontal[y];
        }
    }

    private int[] ensureCapacity(int y, long newCount) {
        if (newCount > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large array required");
        }
        int length = this.intersectionsWithHorizontal[y].length;
        if (newCount > (long)length) {
            int newLength = Math.max(512, Math.max((int)newCount, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)length))));
            this.intersectionsWithHorizontal[y] = Arrays.copyOf(this.intersectionsWithHorizontal[y], newLength);
            return this.intersectionsWithHorizontal[y];
        }
        return this.intersectionsWithHorizontal[y];
    }
}

