/*
 * Decompiled with CFR 0.152.
 */
package net.algart.contours;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.contours.Contours;
import net.algart.contours.InsideContourStatus;
import net.algart.math.rectangles.IRectangleFinder;

public class ContourNestingAnalyser {
    private final Contours contours;
    private final boolean allContoursSurelyUnpacked;
    private boolean nestingLevelNecessary = true;
    private final int[] allMinX;
    private final int[] allMaxX;
    private final int[] allMinY;
    private final int[] allMaxY;
    private final long[] allOrientedAreas;
    private final IRectangleFinder rectanglesFinder;
    private final int[] contourNestingLevels;
    private final int[] contourNestingParents;
    private int totalNumberOfNestingContours = 0;
    private int totalNumberOfCheckedContours = 0;
    private long totalSummaryContoursLength = 0L;

    private ContourNestingAnalyser(Contours contours, boolean allContoursSurelyUnpacked, long[] areasToCompare) {
        this.contours = Objects.requireNonNull(contours, "Null contours");
        this.allContoursSurelyUnpacked = allContoursSurelyUnpacked;
        int numberOfContours = contours.numberOfContours();
        if (areasToCompare != null && areasToCompare.length < numberOfContours) {
            throw new IllegalArgumentException("Too short areasToCompare array: its length " + areasToCompare.length + " < number of contours = " + numberOfContours);
        }
        this.allMinX = new int[numberOfContours];
        this.allMaxX = new int[numberOfContours];
        this.allMinY = new int[numberOfContours];
        this.allMaxY = new int[numberOfContours];
        this.allOrientedAreas = areasToCompare != null ? areasToCompare : new long[numberOfContours];
        this.contourNestingLevels = new int[numberOfContours];
        this.contourNestingParents = new int[numberOfContours];
        IntStream.range(0, numberOfContours + 15 >>> 4).parallel().forEach(areasToCompare == null ? block -> {
            int i;
            int to = (int)Math.min((long)i + 16L, (long)numberOfContours);
            for (i = block << 4; i < to; ++i) {
                int headerOffset = contours.getSerializedHeaderOffset(i);
                this.setMinMax(contours, i, headerOffset);
                this.allOrientedAreas[i] = contours.preciseDoubledArea(i);
            }
        } : block -> {
            int i;
            int to = (int)Math.min((long)i + 16L, (long)numberOfContours);
            for (i = block << 4; i < to; ++i) {
                int headerOffset = contours.getSerializedHeaderOffset(i);
                this.setMinMax(contours, i, headerOffset);
            }
        });
        this.rectanglesFinder = IRectangleFinder.getInstance(this.allMinX, this.allMaxX, this.allMinY, this.allMaxY);
    }

    public static ContourNestingAnalyser newInstance(Contours contours, boolean allContoursSurelyUnpacked, long[] areasToCompare) {
        return new ContourNestingAnalyser(contours, allContoursSurelyUnpacked, areasToCompare);
    }

    public static ContourNestingAnalyser newInstanceForUnpackedContours(Contours contours, long[] areasToCompare) {
        return new ContourNestingAnalyser(contours, true, areasToCompare);
    }

    public static ContourNestingAnalyser newInstance(Contours contours, long[] areasToCompare) {
        return new ContourNestingAnalyser(contours, false, areasToCompare);
    }

    public static ContourNestingAnalyser newInstance(Contours contours) {
        return new ContourNestingAnalyser(contours, false, null);
    }

    public boolean isNestingLevelNecessary() {
        return this.nestingLevelNecessary;
    }

    public ContourNestingAnalyser setNestingLevelNecessary(boolean nestingLevelNecessary) {
        this.nestingLevelNecessary = nestingLevelNecessary;
        return this;
    }

    public Contours contours() {
        return this.contours;
    }

    public boolean allContoursSurelyUnpacked() {
        return this.allContoursSurelyUnpacked;
    }

    public void findRectanglesContainingPoint(double x, double y, IntConsumer indexConsumer) {
        Objects.requireNonNull(indexConsumer, "Null consumer");
        if (ContourNestingAnalyser.pointOutOfRange(x, y)) {
            return;
        }
        int roundX = (int)Math.round(x);
        int roundY = (int)Math.round(y);
        this.rectanglesFinder.findContaining(roundX, roundY, indexConsumer);
    }

    public void findContoursContainingInside(double x, double y, IntConsumer indexConsumer) {
        Objects.requireNonNull(indexConsumer, "Null consumer");
        this.findRectanglesContainingPoint(x, y, index -> {
            if (this.contours.isPointStrictlyInside(index, x, y)) {
                indexConsumer.accept(index);
            }
        });
    }

    public NestingInformation analysePoint(double x, double y) {
        return this.analysePoint(null, x, y);
    }

    public NestingInformation analysePoint(NestingInformation result, double x, double y) {
        if (result == null) {
            result = new NestingInformation();
        }
        MinimalContourFinder finder = this.getFinder().initializeCheckedPoint(x, y);
        this.findContainingRectangles(finder);
        result.nestingLevel = finder.getNestingLevel();
        result.nestingParent = finder.getNestingParent();
        return result;
    }

    public ContourNestingAnalyser analyseAllContours() {
        int n = this.contours.numberOfContours();
        int cpuCount = Arrays.SystemSettings.cpuCount();
        int numberOfRanges = cpuCount == 1 ? 1 : (int)Math.min((long)n, 4L * (long)cpuCount);
        int[] splitters = new int[numberOfRanges + 1];
        net.algart.arrays.Arrays.splitToRanges(splitters, n);
        MinimalContourFinder[] finders = new MinimalContourFinder[numberOfRanges];
        Arrays.setAll(finders, value -> this.getFinder());
        IntStream stream = Arrays.SystemSettings.cpuCount() > 1 ? IntStream.range(0, numberOfRanges).parallel() : IntStream.range(0, numberOfRanges);
        stream.forEach(rangeIndex -> {
            MinimalContourFinder finder = finders[rangeIndex];
            int from = splitters[rangeIndex];
            int to = splitters[rangeIndex + 1];
            for (int k = from; k < to; ++k) {
                finder.initializeCheckedContour(k);
                this.findContainingRectangles(finder);
                this.contourNestingLevels[k] = finder.getNestingLevel();
                this.contourNestingParents[k] = finder.getNestingParent();
            }
        });
        for (MinimalContourFinder finder : finders) {
            this.totalNumberOfNestingContours += finder.numberOfNestingContours;
            this.totalNumberOfCheckedContours += finder.numberOfCheckedContours;
            this.totalSummaryContoursLength += finder.summaryContoursLength;
        }
        return this;
    }

    public int[] getContourNestingLevels() {
        return this.contourNestingLevels;
    }

    public int[] getContourNestingParents() {
        return this.contourNestingParents;
    }

    public int numberOfNestingContours() {
        return this.totalNumberOfNestingContours;
    }

    public int numberOfCheckedContours() {
        return this.totalNumberOfCheckedContours;
    }

    public long summaryContoursLength() {
        return this.totalSummaryContoursLength;
    }

    public String toString() {
        return "nesting analyser for " + String.valueOf(this.contours) + ", using " + String.valueOf(this.rectanglesFinder);
    }

    private void setMinMax(Contours contours, int i, int headerOffset) {
        this.allMinX[i] = contours.minX(headerOffset);
        this.allMaxX[i] = contours.maxX(headerOffset);
        this.allMinY[i] = contours.minY(headerOffset);
        this.allMaxY[i] = contours.maxY(headerOffset);
    }

    private void findContainingRectangles(MinimalContourFinder finder) {
        Objects.requireNonNull(finder, "Null finder");
        if (finder.isOutOfRange()) {
            return;
        }
        this.rectanglesFinder.findContaining(finder.roundX(), finder.roundY(), (IntConsumer)finder);
    }

    private static boolean pointOutOfRange(double x, double y) {
        return x < -2.147483648E9 || x > 2.147483647E9 || y < -2.147483648E9 || y > 2.147483647E9;
    }

    private MinimalContourFinder getFinder() {
        return this.nestingLevelNecessary ? new MinimalContourWithLevelFinder() : new MinimalContourFinder();
    }

    public static class NestingInformation {
        private int nestingLevel = -1;
        private int nestingParent = -1;

        public int getNestingLevel() {
            return this.nestingLevel;
        }

        public int getNestingParent() {
            return this.nestingParent;
        }
    }

    private class MinimalContourFinder
    implements IntConsumer {
        long minimalCheckedArea;
        long minimalCheckedAreaAbs;
        double x;
        double y;
        private boolean outOfRange;
        private int roundX;
        private int roundY;
        int nestingLevel;
        long minArea;
        int nestingParent;
        int numberOfNestingContours = 0;
        int numberOfCheckedContours = 0;
        long summaryContoursLength = 0L;
        private final Point2D representative = new Point2D.Double();

        private MinimalContourFinder() {
        }

        MinimalContourFinder initializeCheckedPoint(double x, double y) {
            this.initializeCommon();
            this.minimalCheckedAreaAbs = Long.MAX_VALUE;
            this.minimalCheckedArea = Long.MAX_VALUE;
            this.x = x;
            this.y = y;
            this.outOfRange = ContourNestingAnalyser.pointOutOfRange(x, y);
            this.roundPoint();
            return this;
        }

        MinimalContourFinder initializeCheckedContour(int checkedContourIndex) {
            this.initializeCommon();
            this.minimalCheckedArea = ContourNestingAnalyser.this.allOrientedAreas[checkedContourIndex];
            this.minimalCheckedAreaAbs = Math.abs(this.minimalCheckedArea);
            ContourNestingAnalyser.this.contours.findSomePointInside(this.representative, checkedContourIndex, ContourNestingAnalyser.this.allContoursSurelyUnpacked);
            this.x = this.representative.getX();
            this.y = this.representative.getY();
            this.outOfRange = false;
            this.roundPoint();
            return this;
        }

        private void initializeCommon() {
            this.nestingLevel = 0;
            this.minArea = Long.MAX_VALUE;
            this.nestingParent = -1;
        }

        private void roundPoint() {
            this.roundX = (int)Math.round(this.x);
            this.roundY = (int)Math.round(this.y);
        }

        int roundX() {
            return this.roundX;
        }

        int roundY() {
            return this.roundY;
        }

        boolean isOutOfRange() {
            return this.outOfRange;
        }

        @Override
        public void accept(int index) {
            int length;
            long area = ContourNestingAnalyser.this.allOrientedAreas[index];
            long areaAbs = Math.abs(area);
            if (areaAbs < this.minimalCheckedAreaAbs || areaAbs == this.minimalCheckedAreaAbs && area >= this.minimalCheckedArea) {
                return;
            }
            if (areaAbs >= this.minArea) {
                return;
            }
            long lengthAndOffset = ContourNestingAnalyser.this.contours.getContourLengthAndOffset(index);
            int offset = Contours.extractOffset(lengthAndOffset);
            if (InsideContourStatus.isStrictlyInside(Contours.pointInsideContourInformation(ContourNestingAnalyser.this.contours.points, offset, length = Contours.extractLength(lengthAndOffset), this.x, this.y, ContourNestingAnalyser.this.allContoursSurelyUnpacked, -1))) {
                this.minArea = areaAbs;
                this.nestingParent = index;
                ++this.numberOfNestingContours;
            }
            ++this.numberOfCheckedContours;
            this.summaryContoursLength += (long)length;
        }

        public int getNestingLevel() {
            return this.nestingLevel;
        }

        public int getNestingParent() {
            return this.nestingParent;
        }
    }

    private class MinimalContourWithLevelFinder
    extends MinimalContourFinder {
        private MinimalContourWithLevelFinder() {
        }

        @Override
        public void accept(int index) {
            int length;
            long area = ContourNestingAnalyser.this.allOrientedAreas[index];
            long areaAbs = Math.abs(area);
            if (areaAbs < this.minimalCheckedAreaAbs || areaAbs == this.minimalCheckedAreaAbs && area >= this.minimalCheckedArea) {
                return;
            }
            long lengthAndOffset = ContourNestingAnalyser.this.contours.getContourLengthAndOffset(index);
            int offset = Contours.extractOffset(lengthAndOffset);
            if (InsideContourStatus.isStrictlyInside(Contours.pointInsideContourInformation(ContourNestingAnalyser.this.contours.points, offset, length = Contours.extractLength(lengthAndOffset), this.x, this.y, ContourNestingAnalyser.this.allContoursSurelyUnpacked, -1))) {
                if (areaAbs < this.minArea) {
                    this.minArea = areaAbs;
                    this.nestingParent = index;
                }
                ++this.nestingLevel;
                ++this.numberOfNestingContours;
            }
            ++this.numberOfCheckedContours;
            this.summaryContoursLength += (long)length;
        }
    }
}

