/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.function.IntConsumer;
import net.algart.math.IRangeConsumer;
import net.algart.math.IRangeFinder;

class IRangeFinderWithoutOptimization
extends IRangeFinder {
    IRangeFinderWithoutOptimization() {
    }

    @Override
    public IRangeFinderWithoutOptimization build() {
        return this;
    }

    @Override
    public IRangeFinderWithoutOptimization compact() {
        return this;
    }

    @Override
    public void findContaining(int point, IRangeConsumer rangeConsumer) {
        this.findIntersectingWithoutOptimization(point, point, rangeConsumer);
    }

    @Override
    public void findContaining(int point, IntConsumer indexConsumer) {
        this.findIntersectingWithoutOptimization(point, point, indexConsumer);
    }

    @Override
    public void findIntersecting(int min, int max, IRangeConsumer rangeConsumer) {
        if (max < min) {
            max = min;
        }
        this.findIntersectingWithoutOptimization(min, max, rangeConsumer);
    }

    @Override
    public void findIntersecting(int min, int max, IntConsumer indexConsumer) {
        if (max < min) {
            max = min;
        }
        this.findIntersectingWithoutOptimization(min, max, indexConsumer);
    }

    @Override
    public String toString() {
        return "unoptimized integer ranges finder for " + this.n + " ranges";
    }

    private void findIntersectingWithoutOptimization(int min, int max, IRangeConsumer rangeConsumer) {
        for (int k = 0; k < this.n; ++k) {
            int right;
            int left = this.left(k);
            if (left > max || (right = this.right(k)) < min || !this.indexActual(k)) continue;
            rangeConsumer.accept(k, left, right);
        }
    }

    private void findIntersectingWithoutOptimization(int min, int max, IntConsumer indexConsumer) {
        for (int k = 0; k < this.n; ++k) {
            if (this.left(k) > max || this.right(k) < min || !this.indexActual(k)) continue;
            indexConsumer.accept(k);
        }
    }
}

