/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public abstract class PowerFunc
implements Func {
    private final boolean binary;
    final double c;
    final double scale;

    private PowerFunc(Double c, double scale) {
        this.binary = c != null;
        this.c = c == null ? 157.0 : c;
        this.scale = scale;
    }

    public static PowerFunc getBinaryInstance(double scale) {
        return new PowerFunc(null, scale){

            @Override
            public double get(double ... x) {
                return this.scale * Math.pow(x[0], x[1]);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 2 arguments required");
            }

            @Override
            public double get(double x0) {
                throw new IndexOutOfBoundsException("At least 2 arguments required");
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * Math.pow(x0, x1);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * Math.pow(x0, x1);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * Math.pow(x0, x1);
            }
        };
    }

    public static PowerFunc getStrictBinaryInstance(double scale) {
        return new PowerFunc(null, scale){

            @Override
            public double get(double ... x) {
                return this.scale * StrictMath.pow(x[0], x[1]);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 2 arguments required");
            }

            @Override
            public double get(double x0) {
                throw new IndexOutOfBoundsException("At least 2 arguments required");
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * StrictMath.pow(x0, x1);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * StrictMath.pow(x0, x1);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * StrictMath.pow(x0, x1);
            }
        };
    }

    public static PowerFunc getInstance(double c, double scale) {
        if (c == 1.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0;
                }
            };
        }
        if (c == 2.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0;
                }
            };
        }
        if (c == 3.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0 * x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0 * x0;
                }
            };
        }
        if (c == 0.5) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return Math.sqrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return Math.sqrt(x0);
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * Math.sqrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * Math.sqrt(x0);
                }
            };
        }
        if (c == 0.3333333333333333) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return Math.cbrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return Math.cbrt(x0);
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * Math.cbrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * Math.cbrt(x0);
                }
            };
        }
        if (scale == 1.0) {
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return Math.pow(x[0], this.c);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return Math.pow(x0, this.c);
                }
            };
        }
        return new PowerFunc(c, scale){

            @Override
            public double get(double ... x) {
                return this.scale * Math.pow(x[0], this.c);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }

            @Override
            public double get(double x0) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * Math.pow(x0, this.c);
            }
        };
    }

    public static PowerFunc getInstance(double c) {
        return PowerFunc.getInstance(c, 1.0);
    }

    public static PowerFunc getStrictInstance(double c, double scale) {
        if (c == 1.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0;
                }
            };
        }
        if (c == 2.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0;
                }
            };
        }
        if (c == 3.0) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0 * x0;
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0 * x0;
                }
            };
        }
        if (c == 0.5) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return StrictMath.sqrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return StrictMath.sqrt(x0);
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * StrictMath.sqrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * StrictMath.sqrt(x0);
                }
            };
        }
        if (c == 0.3333333333333333) {
            if (scale == 1.0) {
                return new PowerFunc(c, scale){

                    @Override
                    public double get(double ... x) {
                        return StrictMath.cbrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return StrictMath.cbrt(x0);
                    }
                };
            }
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * StrictMath.cbrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * StrictMath.cbrt(x0);
                }
            };
        }
        if (scale == 1.0) {
            return new PowerFunc(c, scale){

                @Override
                public double get(double ... x) {
                    return StrictMath.pow(x[0], this.c);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return StrictMath.pow(x0, this.c);
                }
            };
        }
        return new PowerFunc(c, scale){

            @Override
            public double get(double ... x) {
                return this.scale * StrictMath.pow(x[0], this.c);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }

            @Override
            public double get(double x0) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * StrictMath.pow(x0, this.c);
            }
        };
    }

    public static PowerFunc getStrictInstance(double c) {
        return PowerFunc.getStrictInstance(c, 1.0);
    }

    public static Updatable getUpdatableInstance(double c, double scale) {
        if (c == 1.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = this.scaleInv * newResult;
                }
            };
        }
        if (c == 2.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = Math.sqrt(newResult);
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = Math.sqrt(this.scaleInv * newResult);
                }
            };
        }
        if (c == 3.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = Math.cbrt(newResult);
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = Math.cbrt(this.scaleInv * newResult);
                }
            };
        }
        if (c == 0.5) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return Math.sqrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return Math.sqrt(x0);
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult * newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * Math.sqrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * Math.sqrt(x0);
                }

                @Override
                public void set(double[] x, double newResult) {
                    double temp = this.scaleInv * newResult;
                    x[0] = temp * temp;
                }
            };
        }
        if (c == 0.3333333333333333) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return Math.cbrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return Math.cbrt(x0);
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult * newResult * newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * Math.cbrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * Math.cbrt(x0);
                }

                @Override
                public void set(double[] x, double newResult) {
                    double temp = this.scaleInv * newResult;
                    x[0] = temp * temp * temp;
                }
            };
        }
        if (scale == 1.0) {
            return new Updatable(c, scale){
                private final double cInv;
                {
                    this.cInv = 1.0 / this.c;
                }

                @Override
                public double get(double ... x) {
                    return Math.pow(x[0], this.c);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return Math.pow(x0, this.c);
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = Math.pow(newResult, this.cInv);
                }
            };
        }
        return new Updatable(c, scale){
            private final double cInv;
            {
                this.cInv = 1.0 / this.c;
            }

            @Override
            public double get(double ... x) {
                return this.scale * Math.pow(x[0], this.c);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }

            @Override
            public double get(double x0) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * Math.pow(x0, this.c);
            }

            @Override
            public void set(double[] x, double newResult) {
                x[0] = Math.pow(this.scaleInv * newResult, this.cInv);
            }
        };
    }

    public static Updatable getUpdatableStrictInstance(double c, double scale) {
        if (c == 1.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = this.scaleInv * newResult;
                }
            };
        }
        if (c == 2.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = StrictMath.sqrt(newResult);
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = StrictMath.sqrt(this.scaleInv * newResult);
                }
            };
        }
        if (c == 3.0) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return x[0] * x[0] * x[0];
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return x0 * x0 * x0;
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = StrictMath.cbrt(newResult);
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * x[0] * x[0] * x[0];
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * x0 * x0 * x0;
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = StrictMath.cbrt(this.scaleInv * newResult);
                }
            };
        }
        if (c == 0.5) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return StrictMath.sqrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return StrictMath.sqrt(x0);
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult * newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * StrictMath.sqrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * StrictMath.sqrt(x0);
                }

                @Override
                public void set(double[] x, double newResult) {
                    double temp = this.scaleInv * newResult;
                    x[0] = temp * temp;
                }
            };
        }
        if (c == 0.3333333333333333) {
            if (scale == 1.0) {
                return new Updatable(c, scale){

                    @Override
                    public double get(double ... x) {
                        return StrictMath.cbrt(x[0]);
                    }

                    @Override
                    public double get() {
                        throw new IndexOutOfBoundsException("At least 1 argument required");
                    }

                    @Override
                    public double get(double x0) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public double get(double x0, double x1, double x2, double x3) {
                        return StrictMath.cbrt(x0);
                    }

                    @Override
                    public void set(double[] x, double newResult) {
                        x[0] = newResult * newResult * newResult;
                    }
                };
            }
            return new Updatable(c, scale){

                @Override
                public double get(double ... x) {
                    return this.scale * StrictMath.cbrt(x[0]);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return this.scale * StrictMath.cbrt(x0);
                }

                @Override
                public void set(double[] x, double newResult) {
                    double temp = this.scaleInv * newResult;
                    x[0] = temp * temp * temp;
                }
            };
        }
        if (scale == 1.0) {
            return new Updatable(c, scale){
                private final double cInv;
                {
                    this.cInv = 1.0 / this.c;
                }

                @Override
                public double get(double ... x) {
                    return StrictMath.pow(x[0], this.c);
                }

                @Override
                public double get() {
                    throw new IndexOutOfBoundsException("At least 1 argument required");
                }

                @Override
                public double get(double x0) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return StrictMath.pow(x0, this.c);
                }

                @Override
                public void set(double[] x, double newResult) {
                    x[0] = StrictMath.pow(newResult, this.cInv);
                }
            };
        }
        return new Updatable(c, scale){
            private final double cInv;
            {
                this.cInv = 1.0 / this.c;
            }

            @Override
            public double get(double ... x) {
                return this.scale * StrictMath.pow(x[0], this.c);
            }

            @Override
            public double get() {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }

            @Override
            public double get(double x0) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return this.scale * StrictMath.pow(x0, this.c);
            }

            @Override
            public void set(double[] x, double newResult) {
                x[0] = StrictMath.pow(this.scaleInv * newResult, this.cInv);
            }
        };
    }

    @Override
    public abstract double get(double ... var1);

    @Override
    public abstract double get();

    @Override
    public abstract double get(double var1);

    @Override
    public abstract double get(double var1, double var3);

    @Override
    public abstract double get(double var1, double var3, double var5);

    public String toString() {
        if (this.binary) {
            return "power function f(x,y)=" + (String)(this.scale == 1.0 ? "" : this.scale + "*x^y");
        }
        return "power function f(x)=" + String.valueOf(this.scale == 1.0 ? "" : Double.valueOf(this.scale)) + "x^" + this.c;
    }

    public static abstract class Updatable
    extends PowerFunc
    implements Func.Updatable {
        final double scaleInv;

        private Updatable(Double c, double scale) {
            super(c, scale);
            this.scaleInv = 1.0 / scale;
        }

        @Override
        public abstract void set(double[] var1, double var2);

        @Override
        public String toString() {
            return "updatable " + super.toString();
        }
    }
}

