/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public final class SelectConstantFunc
implements Func {
    private final double[] values;

    private SelectConstantFunc(double[] values) {
        this.values = (double[])values.clone();
    }

    public static SelectConstantFunc getInstance(double ... values) {
        return new SelectConstantFunc(values);
    }

    public double[] values() {
        return (double[])this.values.clone();
    }

    @Override
    public double get(double ... x) {
        return this.values[(int)x[0]];
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 1 argument required");
    }

    @Override
    public double get(double x0) {
        return this.values[(int)x0];
    }

    @Override
    public double get(double x0, double x1) {
        return this.values[(int)x0];
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.values[(int)x0];
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.values[(int)x0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("selecting constant function f(x0,x1,...)=values[(int)x0], values={");
        for (int k = 0; k < this.values.length; ++k) {
            if (k > 0) {
                sb.append(", ");
            }
            if (k >= 2 && k < this.values.length - 2) {
                sb.append("...");
                k = this.values.length - 2;
                continue;
            }
            sb.append(LinearFunc.goodFormat(this.values[k]));
        }
        sb.append("}");
        return sb.toString();
    }
}

