/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public final class WeightedMeanFunc
implements Func {
    private final double scale;

    private WeightedMeanFunc(double scale) {
        this.scale = scale;
    }

    public static WeightedMeanFunc getInstance(double scale) {
        return new WeightedMeanFunc(scale);
    }

    @Override
    public double get(double ... x) {
        return this.scale * x[0] * (x[1] - x[2]) + x[2];
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public double get(double x0) {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public double get(double x0, double x1) {
        throw new IndexOutOfBoundsException("At least 3 arguments required");
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.scale * x0 * (x1 - x2) + x2;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.scale * x0 * (x1 - x2) + x2;
    }

    public String toString() {
        return "weighted mean function f(x0,x1,...)=" + this.scale + "*x0*x1+(1-" + this.scale + "*x0)*x2";
    }
}

