/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.patterns.BasicDirectPointSetUniformGridPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.SimplePattern;
import net.algart.math.patterns.TooLargePatternCoordinatesException;
import net.algart.math.patterns.UniformGridPattern;

public abstract class AbstractPattern
implements Pattern {
    volatile Boolean surelyOrigin = null;
    volatile Boolean surelyInteger = null;
    final Range[] coordRanges;
    final Pattern[] minBound;
    final Pattern[] maxBound;
    protected final int dimCount;

    protected AbstractPattern(int dimCount) {
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Negative or zero dimCount=" + dimCount);
        }
        this.dimCount = dimCount;
        this.coordRanges = new Range[dimCount];
        this.minBound = new Pattern[dimCount];
        this.maxBound = new Pattern[dimCount];
    }

    @Override
    public final int dimCount() {
        return this.dimCount;
    }

    @Override
    public abstract long pointCount();

    @Override
    public double largePointCount() {
        return this.pointCount();
    }

    public boolean isPointCountVeryLarge() {
        return false;
    }

    @Override
    public abstract Set<Point> points();

    @Override
    public Set<IPoint> roundedPoints() {
        HashSet<IPoint> result = new HashSet<IPoint>();
        for (Point p : this.points()) {
            result.add(p.toRoundedPoint());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public abstract Range coordRange(int var1);

    @Override
    public RectangularArea coordArea() {
        Range[] result = new Range[this.dimCount];
        for (int k = 0; k < result.length; ++k) {
            result[k] = this.coordRange(k);
        }
        return RectangularArea.of(result);
    }

    @Override
    public Point coordMin() {
        double[] coordinates = new double[this.dimCount];
        for (int k = 0; k < coordinates.length; ++k) {
            coordinates[k] = this.coordRange(k).min();
        }
        return Point.of(coordinates);
    }

    @Override
    public Point coordMax() {
        double[] coordinates = new double[this.dimCount];
        for (int k = 0; k < coordinates.length; ++k) {
            coordinates[k] = this.coordRange(k).max();
        }
        return Point.of(coordinates);
    }

    @Override
    public IRange roundedCoordRange(int coordIndex) {
        return this.coordRange(coordIndex).toRoundedRange();
    }

    @Override
    public IRectangularArea roundedCoordArea() {
        IRange[] result = new IRange[this.dimCount];
        for (int k = 0; k < result.length; ++k) {
            result[k] = this.roundedCoordRange(k);
        }
        return IRectangularArea.of(result);
    }

    @Override
    public abstract boolean isSurelySinglePoint();

    @Override
    public boolean isSurelyOriginPoint() {
        if (this.surelyOrigin == null) {
            this.surelyOrigin = this.isSurelySinglePoint() && this.points().iterator().next().isOrigin();
        }
        return this.surelyOrigin;
    }

    @Override
    public boolean isSurelyInteger() {
        if (this.surelyInteger == null) {
            boolean allInteger = true;
            for (Point p : this.points()) {
                if (p.isInteger()) continue;
                allInteger = false;
                break;
            }
            this.surelyInteger = allInteger;
        }
        return this.surelyInteger;
    }

    @Override
    public UniformGridPattern round() {
        return new BasicDirectPointSetUniformGridPattern(this.dimCount, this.roundedPoints());
    }

    @Override
    public abstract Pattern projectionAlongAxis(int var1);

    @Override
    public Pattern minBound(int coordIndex) {
        return this.minBound(coordIndex, false);
    }

    @Override
    public Pattern maxBound(int coordIndex) {
        return this.maxBound(coordIndex, false);
    }

    @Override
    public Pattern carcass() {
        return this;
    }

    @Override
    public int maxCarcassMultiplier() {
        return 2;
    }

    @Override
    public abstract Pattern shift(Point var1);

    @Override
    public Pattern symmetric() {
        return this.multiply(-1.0);
    }

    @Override
    public Pattern multiply(double multiplier) {
        double[] multipliers = new double[this.dimCount];
        Arrays.fill(multipliers, multiplier);
        return this.scale(multipliers);
    }

    @Override
    public abstract Pattern scale(double ... var1);

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        Objects.requireNonNull(added, "Null added argument");
        if (added.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + added.dimCount() + " instead of " + this.dimCount);
        }
        long addedPointCount = added.pointCount();
        if (addedPointCount == 1L) {
            return this.shift(added.coordMin());
        }
        HashSet<Point> resultPoints = new HashSet<Point>();
        Set<Point> points = this.points();
        Set<Point> addedPoints = added.points();
        for (Point p : points) {
            for (Point q : addedPoints) {
                resultPoints.add(p.add(q));
            }
        }
        return new SimplePattern(resultPoints);
    }

    @Override
    public Pattern minkowskiSubtract(Pattern subtracted) {
        Objects.requireNonNull(subtracted, "Null subtracted argument");
        if (subtracted.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + subtracted.dimCount() + " instead of " + this.dimCount);
        }
        Set<Point> subtractedPoints = subtracted.points();
        Point minimal = null;
        double minimalDistance = Double.POSITIVE_INFINITY;
        for (Point p : subtractedPoints) {
            double distance = p.distanceFromOrigin();
            if (minimal != null && !(distance < minimalDistance)) continue;
            minimal = p;
            minimalDistance = distance;
        }
        assert (minimal != null) : "Empty subtracted.points()";
        boolean containsOrigin = minimal.isOrigin();
        Set<Point> points = this.points();
        HashSet<Point> resultPoints = new HashSet<Point>();
        block1: for (Point p : points) {
            if (!containsOrigin) {
                p = p.subtract(minimal);
            }
            for (Point q : subtractedPoints) {
                if (q.equals(minimal) || points.contains(p.add(q))) continue;
                continue block1;
            }
            resultPoints.add(p);
        }
        return resultPoints.isEmpty() ? null : Patterns.newPattern(resultPoints);
    }

    @Override
    public List<Pattern> minkowskiDecomposition(int minimalPointCount) {
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        return Collections.singletonList(this);
    }

    @Override
    public boolean hasMinkowskiDecomposition() {
        return false;
    }

    @Override
    public List<Pattern> unionDecomposition(int minimalPointCount) {
        return this.allUnionDecompositions(minimalPointCount).get(0);
    }

    @Override
    public List<List<Pattern>> allUnionDecompositions(int minimalPointCount) {
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        return Collections.singletonList(Collections.singletonList(this));
    }

    public static boolean isAllowedPoint(Point point) {
        Objects.requireNonNull(point, "Null point");
        int n = point.coordCount();
        for (int k = 0; k < n; ++k) {
            double coord = point.coord(k);
            if (!(coord < -4.503599627370496E15) && !(coord > 4.503599627370496E15)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowedCoordRange(Range range) {
        Objects.requireNonNull(range, "Null range");
        double min = range.min();
        double max = range.max();
        assert (min <= max);
        return min >= -4.503599627370496E15 && max <= 4.503599627370496E15 && Patterns.isAllowedDifference(min, max);
    }

    protected final void checkCoordIndex(int coordIndex) {
        if (coordIndex < 0 || coordIndex >= this.dimCount) {
            throw new IndexOutOfBoundsException("Coordinate index " + coordIndex + " is out of range 0.." + (this.dimCount - 1));
        }
    }

    static void checkPoint(Point point) throws TooLargePatternCoordinatesException {
        if (!AbstractPattern.isAllowedPoint(point)) {
            throw new TooLargePatternCoordinatesException("Point " + String.valueOf(point) + " has one of coordinates  out of -4503599627370496..4503599627370496 range and cannot be used for building a pattern");
        }
    }

    static void checkCoordRange(Range range) throws TooLargePatternCoordinatesException {
        Objects.requireNonNull(range, "Null range");
        double min = range.min();
        double max = range.max();
        assert (min <= max);
        if (min < -4.503599627370496E15 || max > 4.503599627370496E15) {
            throw new TooLargePatternCoordinatesException("Coordinate range " + String.valueOf(range) + " is out of -4503599627370496..4503599627370496 range and cannot be used for building a pattern");
        }
        if (!Patterns.isAllowedDifference(min, max)) {
            throw new TooLargePatternCoordinatesException("Coordinate range " + String.valueOf(range) + " has a size larger than 4503599627370496 and cannot be used for building a pattern");
        }
    }

    final void fillCoordRangesWithCheck(Collection<Point> points) {
        double[] minCoord = new double[this.dimCount];
        double[] maxCoord = new double[this.dimCount];
        Arrays.fill(minCoord, Double.POSITIVE_INFINITY);
        Arrays.fill(maxCoord, Double.NEGATIVE_INFINITY);
        for (Point p : points) {
            AbstractPattern.checkPoint(p);
            for (int k = 0; k < this.dimCount; ++k) {
                double coordinate = p.coord(k);
                if (coordinate < minCoord[k]) {
                    minCoord[k] = coordinate;
                }
                if (!(coordinate > maxCoord[k])) continue;
                maxCoord[k] = coordinate;
            }
        }
        for (int k = 0; k < this.dimCount; ++k) {
            this.coordRanges[k] = Range.of(minCoord[k], maxCoord[k]);
            AbstractPattern.checkCoordRange(this.coordRanges[k]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Pattern minBound(int coordIndex, boolean alwaysSimple) {
        this.checkCoordIndex(coordIndex);
        Pattern[] patternArray = this.minBound;
        synchronized (this.minBound) {
            if (this.minBound[coordIndex] == null) {
                Set<Point> points = this.points();
                HashMap<Point, Point> map = new HashMap<Point, Point>();
                for (Point p : points) {
                    Point projection = p.projectionAlongAxis(coordIndex);
                    Point bound = (Point)map.get(projection);
                    if (bound != null && !(p.coord(coordIndex) < bound.coord(coordIndex))) continue;
                    map.put(projection, p);
                }
                this.minBound[coordIndex] = alwaysSimple ? new SimplePattern(map.values()) : Patterns.newPattern(map.values());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.minBound[coordIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Pattern maxBound(int coordIndex, boolean alwaysSimple) {
        this.checkCoordIndex(coordIndex);
        Pattern[] patternArray = this.maxBound;
        synchronized (this.maxBound) {
            if (this.maxBound[coordIndex] == null) {
                Set<Point> points = this.points();
                HashMap<Point, Point> map = new HashMap<Point, Point>();
                for (Point p : points) {
                    Point projection = p.projectionAlongAxis(coordIndex);
                    Point bound = (Point)map.get(projection);
                    if (bound != null && !(p.coord(coordIndex) > bound.coord(coordIndex))) continue;
                    map.put(projection, p);
                }
                this.maxBound[coordIndex] = alwaysSimple ? new SimplePattern(map.values()) : Patterns.newPattern(map.values());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.maxBound[coordIndex];
        }
    }
}

