/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.Arrays;
import net.algart.arrays.PackedBitArrays;
import net.algart.math.IPoint;
import net.algart.math.patterns.BasicDirectPointSetUniformGridPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.TooManyPointsInPatternError;
import net.algart.math.patterns.UniformGridPattern;

class TinyBitMatrix {
    private final long[] array;
    private final int[] dimensions;
    private final long length;

    private TinyBitMatrix(long[] array, int[] dimensions) {
        this.length = TinyBitMatrix.checkDimensions(dimensions);
        long packedLength = PackedBitArrays.packedLength(this.length);
        if (packedLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large bit array: >=2^37 elements");
        }
        if (packedLength > (long)array.length) {
            throw new IllegalArgumentException("Too large bit array: longer than the passed long[] array");
        }
        this.dimensions = (int[])dimensions.clone();
        this.array = array;
    }

    TinyBitMatrix(int[] dimensions) {
        this.length = TinyBitMatrix.checkDimensions(dimensions);
        long packedLength = PackedBitArrays.packedLength(this.length);
        if (packedLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large bit array: >=2^37 elements");
        }
        this.dimensions = (int[])dimensions.clone();
        this.array = new long[(int)packedLength];
    }

    public long[] array() {
        return this.array;
    }

    public int[] dimensions() {
        return (int[])this.dimensions.clone();
    }

    public int dimCount() {
        return this.dimensions.length;
    }

    public int dim(int n) {
        return n < this.dimensions.length ? this.dimensions[n] : 1;
    }

    public boolean isEmpty() {
        return this.length == 0L;
    }

    public boolean dimEquals(TinyBitMatrix m) {
        Objects.requireNonNull(m, "Null matrix");
        int dimCount = this.dimCount();
        if (m.dimCount() != dimCount) {
            return false;
        }
        for (int k = 0; k < dimCount; ++k) {
            if (m.dim(k) == this.dim(k)) continue;
            return false;
        }
        return true;
    }

    public long pseudoCyclicIndex(long ... coordinates) {
        int n = coordinates.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinates array");
        }
        --n;
        if (this.isEmpty()) {
            return 0L;
        }
        long limit = this.dim(n);
        long result = coordinates[n] % limit;
        if (result < 0L) {
            result += limit;
        }
        while (n > 0) {
            long dim;
            if ((dim = (long)this.dim(--n)) == 0L) {
                return 0L;
            }
            long coord = coordinates[n] % (limit *= dim);
            if (coord < 0L) {
                coord += limit;
            }
            assert ((result *= dim) >= 0L) : "cyclic index becomes " + result + ", n=" + n + " in " + String.valueOf(this);
            if ((result += coord) < 0L || result >= limit) assert ((result -= limit) >= 0L) : "cyclic index becomes " + result + ", n=" + n + " in " + String.valueOf(this);
        }
        return result;
    }

    public TinyBitMatrix reDim(int[] newDimensions) {
        return new TinyBitMatrix(this.array, newDimensions);
    }

    public void putPattern(Pattern pattern) {
        if (pattern.dimCount() != this.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the bit matrix mismatch");
        }
        for (IPoint ip : pattern.roundedPoints()) {
            PackedBitArrays.setBit(this.array, this.pseudoCyclicIndex(ip.coordinates()), true);
        }
    }

    public UniformGridPattern getIntegerPattern() {
        HashSet<IPoint> points = new HashSet<IPoint>();
        this.addPoints(points, new long[this.dimCount()], new boolean[this.dim(0)], 0, null);
        return Patterns.newIntegerPattern(points);
    }

    public UniformGridPattern getPattern(IPoint shift) {
        HashSet<IPoint> points = new HashSet<IPoint>();
        this.addPoints(points, new long[this.dimCount()], new boolean[this.dim(0)], 0, shift);
        return new BasicDirectPointSetUniformGridPattern(shift.coordCount(), points);
    }

    public void simpleDilation(TinyBitMatrix src, Pattern pattern) {
        Objects.requireNonNull(src, "Null src bit matrix");
        if (!this.dimEquals(src)) {
            throw new IllegalArgumentException("Bit matrix dimensions mismatch");
        }
        if (pattern.dimCount() != this.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions mismatch of the pattern and the bit matrix");
        }
        Set<IPoint> points = pattern.roundedPoints();
        boolean first = true;
        for (IPoint ip : points) {
            long shift = this.pseudoCyclicIndex(ip.coordinates());
            if (first) {
                PackedBitArrays.copyBits(this.array, shift, src.array, 0L, this.length - shift);
                PackedBitArrays.copyBits(this.array, 0L, src.array, this.length - shift, shift);
            } else {
                PackedBitArrays.orBits(this.array, shift, src.array, 0L, this.length - shift);
                PackedBitArrays.orBits(this.array, 0L, src.array, this.length - shift, shift);
            }
            first = false;
        }
    }

    public long cardinality() {
        return PackedBitArrays.cardinality(this.array, 0L, this.length);
    }

    private void addPoints(Set<IPoint> points, long[] coordinates, boolean[] temp, int lastCoordinatesCount, IPoint shift) {
        int currentCoordIndex = coordinates.length - 1 - lastCoordinatesCount;
        if (currentCoordIndex == 0) {
            coordinates[0] = 0L;
            int n = this.dim(0);
            PackedBitArrays.unpackBits(temp, 0, this.array, this.pseudoCyclicIndex(coordinates), n);
            for (int i = 0; i < n; ++i) {
                if (!temp[i]) continue;
                coordinates[0] = i;
                IPoint p = IPoint.of(coordinates);
                if (shift != null) {
                    p = p.add(shift);
                }
                points.add(p);
            }
        } else {
            int n = this.dim(currentCoordIndex);
            for (int i = 0; i < n; ++i) {
                coordinates[currentCoordIndex] = i;
                this.addPoints(points, coordinates, temp, lastCoordinatesCount + 1, shift);
            }
        }
    }

    private static long checkDimensions(int[] dim) throws IllegalArgumentException {
        Objects.requireNonNull(dim, "Null dimensions Java array");
        if (dim.length == 0) {
            throw new IllegalArgumentException("Empty dimensions Java array");
        }
        for (int n = 0; n < dim.length; ++n) {
            if (dim[n] >= 0) continue;
            throw new IllegalArgumentException("Negative matrix dimension #" + n + ": " + dim[n]);
        }
        long[] lDim = new long[dim.length];
        for (int k = 0; k < dim.length; ++k) {
            lDim[k] = dim[k];
        }
        long len = Arrays.longMul(lDim);
        if (len == Long.MIN_VALUE) {
            throw new TooManyPointsInPatternError("Illegal dimensions: dim[0] * dim[1] * ... > Long.MAX_VALUE");
        }
        return len;
    }
}

