/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import net.algart.math.rectangles.IBracket;
import net.algart.math.rectangles.IRectanglesUnion;

class HorizontalIBracketSet<H extends IRectanglesUnion.Side> {
    private final List<H> allHorizontals;
    private final int numberOfHorizontals;
    private final boolean onlyStrictIntersections;
    int horizontalIndex;
    H horizontal;
    long coord;
    private final NavigableSet<IBracket> intersectingSides = new TreeSet<IBracket>();
    private final List<IRectanglesUnion.FrameSide> sidesBuffer = new ArrayList<IRectanglesUnion.FrameSide>();

    public HorizontalIBracketSet(List<H> allHorizontals, boolean onlyStrictIntersections) {
        assert (allHorizontals != null);
        assert (!allHorizontals.isEmpty());
        this.allHorizontals = allHorizontals;
        this.numberOfHorizontals = allHorizontals.size();
        this.onlyStrictIntersections = onlyStrictIntersections;
        this.horizontalIndex = -1;
        this.horizontal = null;
        if (IRectanglesUnion.DEBUG_LEVEL >= 2) {
            int n = allHorizontals.size();
            for (int k = 1; k < n; ++k) {
                assert (((IRectanglesUnion.Side)allHorizontals.get(k - 1)).coord() <= ((IRectanglesUnion.Side)allHorizontals.get(k)).coord());
            }
        }
    }

    public boolean next() {
        long newCoord;
        if (this.horizontalIndex == this.numberOfHorizontals) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " should not be used more");
        }
        assert (this.horizontalIndex < this.numberOfHorizontals);
        IRectanglesUnion.Side newHorizontal = this.horizontalIndex + 1 < this.numberOfHorizontals ? (IRectanglesUnion.Side)this.allHorizontals.get(this.horizontalIndex + 1) : null;
        long l = newCoord = newHorizontal == null ? -157L : newHorizontal.coord();
        if (this.onlyStrictIntersections) {
            if (this.horizontal == null || newHorizontal == null || newHorizontal.coord() != ((IRectanglesUnion.Side)this.horizontal).coord() || newHorizontal.first != ((IRectanglesUnion.Side)this.horizontal).first) {
                IRectanglesUnion.Side h;
                int index;
                if (this.horizontal != null) {
                    for (index = this.horizontalIndex; index >= 0 && (h = (IRectanglesUnion.Side)this.allHorizontals.get(index)).coord() == this.coord && h.first == ((IRectanglesUnion.Side)this.horizontal).first; --index) {
                        if (!h.isFirstOfTwoParallelSides()) continue;
                        this.addHorizontal(h);
                    }
                }
                if (newHorizontal != null) {
                    for (index = this.horizontalIndex + 1; index < this.numberOfHorizontals && (h = (IRectanglesUnion.Side)this.allHorizontals.get(index)).coord() == newCoord && h.first == newHorizontal.first; ++index) {
                        if (!h.isSecondOfTwoParallelSides()) continue;
                        this.removeHorizontal(h);
                    }
                }
            }
        } else if (this.horizontal == null || newHorizontal == null || newHorizontal.coord() != ((IRectanglesUnion.Side)this.horizontal).coord()) {
            IRectanglesUnion.Side h;
            int index;
            if (this.horizontal != null) {
                for (index = this.horizontalIndex; index >= 0 && (h = (IRectanglesUnion.Side)this.allHorizontals.get(index)).coord() == this.coord; --index) {
                    if (!h.isSecondOfTwoParallelSides()) continue;
                    this.removeHorizontal(h);
                }
            }
            if (newHorizontal != null) {
                for (index = this.horizontalIndex + 1; index < this.numberOfHorizontals && (h = (IRectanglesUnion.Side)this.allHorizontals.get(index)).coord() == newCoord; ++index) {
                    if (!h.isFirstOfTwoParallelSides()) continue;
                    this.addHorizontal(h);
                }
            }
        }
        ++this.horizontalIndex;
        this.horizontal = newHorizontal;
        this.coord = newCoord;
        if (newHorizontal == null && !this.intersectingSides.isEmpty()) {
            throw new AssertionError((Object)"Non-empty intersection set at the end of the loop");
        }
        if (IRectanglesUnion.DEBUG_LEVEL >= 3) {
            IRectanglesUnion.debug(3, "  Horizontal #%d, y=%d%s, %s; brackets:%s", this.horizontalIndex, this.coord, this.horizontal == null ? " (LOOP FINISHED)" : (((IRectanglesUnion.Side)this.horizontal).first ? " (starting)" : " (ending)"), this.horizontal, HorizontalIBracketSet.toDebugString(this.intersectingSides));
        }
        return this.horizontal != null;
    }

    public Set<IBracket> currentIntersections() {
        IBracket bracketFrom = new IBracket(((IRectanglesUnion.Side)this.horizontal).transversalFrameSideFrom(), true);
        IBracket bracketTo = new IBracket(((IRectanglesUnion.Side)this.horizontal).transversalFrameSideTo(), false);
        if (IRectanglesUnion.DEBUG_LEVEL >= 1 && !this.onlyStrictIntersections) {
            assert (this.intersectingSides.contains(bracketFrom));
            assert (this.intersectingSides.contains(bracketTo));
        }
        NavigableSet<IBracket> result = this.intersectingSides.subSet(bracketFrom, true, bracketTo, true);
        if (IRectanglesUnion.DEBUG_LEVEL >= 3) {
            IRectanglesUnion.debug(3, "  Intersections with %s; brackets:%s", this.horizontal, HorizontalIBracketSet.toDebugString(result));
        }
        return result;
    }

    public IBracket lastIntersectionBeforeLeft() {
        IBracket bracketFrom = new IBracket(((IRectanglesUnion.Side)this.horizontal).transversalFrameSideFrom(), true);
        return this.intersectingSides.lower(bracketFrom);
    }

    public IRectanglesUnion.FrameSide maxLeftBeloningToUnion() {
        assert (!this.onlyStrictIntersections) : "strict version is not supported in this method";
        IBracket bracketFrom = new IBracket(((IRectanglesUnion.Side)this.horizontal).transversalFrameSideFrom(), true);
        NavigableSet<IBracket> headSet = this.intersectingSides.headSet(bracketFrom, false).descendingSet();
        IRectanglesUnion.FrameSide last = bracketFrom.intersectingSide;
        for (IBracket bracket : headSet) {
            assert (bracket.followingCoveringDepth >= 0);
            if (bracket.followingCoveringDepth == 0) {
                return last;
            }
            last = bracket.intersectingSide;
        }
        return last;
    }

    public IRectanglesUnion.FrameSide minRightBeloningToUnion() {
        assert (!this.onlyStrictIntersections) : "strict version is not supported in this method";
        IBracket bracketTo = new IBracket(((IRectanglesUnion.Side)this.horizontal).transversalFrameSideTo(), false);
        NavigableSet<IBracket> tailSet = this.intersectingSides.tailSet(bracketTo, true);
        for (IBracket bracket : tailSet) {
            assert (bracket.followingCoveringDepth >= 0);
            if (bracket.followingCoveringDepth != 0) continue;
            return bracket.intersectingSide;
        }
        return bracketTo.intersectingSide;
    }

    private void addHorizontal(IRectanglesUnion.Side h) {
        h.allContainedFrameSides(this.sidesBuffer);
        for (IRectanglesUnion.FrameSide horizontalSide : this.sidesBuffer) {
            int nesting;
            IBracket bracketFrom = new IBracket(horizontalSide.transversalFrameSideFrom(), true);
            IBracket bracketTo = new IBracket(horizontalSide.transversalFrameSideTo(), false);
            IBracket previousBracket = this.intersectingSides.lower(bracketFrom);
            bracketFrom.followingCoveringDepth = nesting = previousBracket == null ? 1 : previousBracket.followingCoveringDepth + 1;
            for (IBracket bracket : this.intersectingSides.subSet(bracketFrom, false, bracketTo, false)) {
                nesting = ++bracket.followingCoveringDepth;
            }
            bracketTo.followingCoveringDepth = nesting - 1;
            this.intersectingSides.add(bracketFrom);
            this.intersectingSides.add(bracketTo);
        }
    }

    private void removeHorizontal(IRectanglesUnion.Side h) {
        h.allContainedFrameSides(this.sidesBuffer);
        for (IRectanglesUnion.FrameSide horizontalSide : this.sidesBuffer) {
            IBracket bracketFrom = new IBracket(horizontalSide.transversalFrameSideFrom(), true);
            IBracket bracketTo = new IBracket(horizontalSide.transversalFrameSideTo(), false);
            for (IBracket bracket : this.intersectingSides.subSet(bracketFrom, false, bracketTo, false)) {
                --bracket.followingCoveringDepth;
            }
            boolean containedFrom = this.intersectingSides.remove(bracketFrom);
            boolean containedTo = this.intersectingSides.remove(bracketTo);
            assert (containedFrom);
            assert (containedTo);
        }
    }

    private static String toDebugString(Collection<IBracket> brackets) {
        if (brackets.isEmpty()) {
            return String.format(" NONE%n", new Object[0]);
        }
        StringBuilder sb = new StringBuilder(String.format("%n", new Object[0]));
        for (IBracket bracket : brackets) {
            sb.append(String.format("    %s%n", bracket));
        }
        return sb.toString();
    }
}

