/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import java.util.Arrays;
import net.algart.math.IRectangularArea;

class SearchIRectangleInHypograph {
    private final long[] x;
    private final long[] y;
    private long currentFromY;
    private double maxRectangleArea = Double.NEGATIVE_INFINITY;
    private long largestRectangleFromX = Long.MAX_VALUE;
    private long largestRectangleToX = Long.MIN_VALUE;
    private long largestRectangleFromY = Long.MAX_VALUE;
    private long largestRectangleToY = Long.MIN_VALUE;
    private boolean maxRectangleCorrected = false;

    public SearchIRectangleInHypograph(long[] x) {
        this.x = x;
        this.y = new long[x.length - 1];
        assert (x.length == this.y.length + 1) : "number of function values must be 1 less than number of x values";
        this.currentFromY = Long.MAX_VALUE;
        Arrays.fill(this.y, Long.MIN_VALUE);
    }

    public void setY(int index, long value) {
        this.y[index] = value;
    }

    public void resetAlreadyFoundRectangle() {
        this.maxRectangleArea = Double.NEGATIVE_INFINITY;
    }

    public boolean isMaxRectangleCorrected() {
        return this.maxRectangleCorrected;
    }

    public void resetMaxRectangleCorrected() {
        this.maxRectangleCorrected = false;
    }

    public void setCurrentFromY(long currentFromY) {
        this.currentFromY = currentFromY;
    }

    public IRectangularArea largestRectangle() {
        assert (this.largestRectangleFromX < this.largestRectangleToX);
        assert (this.largestRectangleFromY < this.largestRectangleToY);
        return IRectangularArea.of(this.largestRectangleFromX, this.largestRectangleFromY, this.largestRectangleToX - 1L, this.largestRectangleToY - 1L);
    }

    public void correctMaximalRectangle(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && toIndex <= this.y.length && fromIndex <= toIndex) : "index out of ranges 0.." + this.y.length + ": " + fromIndex + ".." + toIndex;
        if (fromIndex == toIndex) {
            return;
        }
        int[] stack = new int[128];
        int stackTop = 2;
        stack[0] = fromIndex;
        stack[1] = toIndex;
        long iterationCount = 0L;
        while (true) {
            if (iterationCount > 16L * (long)this.y.length + 16L) {
                throw new AssertionError((Object)"Infinite loop detected");
            }
            assert (stackTop % 2 == 0);
            long maxY = this.currentFromY;
            for (int k = fromIndex; k < toIndex; ++k) {
                if (this.y[k] <= maxY) continue;
                maxY = this.y[k];
            }
            if (maxY == this.currentFromY || SearchIRectangleInHypograph.area(this.x[fromIndex], this.currentFromY, this.x[toIndex], maxY) <= this.maxRectangleArea) {
                if (stackTop == 0) break;
                fromIndex = stack[stackTop -= 2];
                toIndex = stack[stackTop + 1];
            } else {
                assert (fromIndex < toIndex);
                long minY = this.y[fromIndex];
                int minIndex = fromIndex;
                for (int k = fromIndex + 1; k < toIndex; ++k) {
                    if (this.y[k] >= minY) continue;
                    minY = this.y[k];
                    minIndex = k;
                }
                this.correctMaxRectangle(this.x[fromIndex], this.currentFromY, this.x[toIndex], minY);
                if (minIndex - fromIndex >= toIndex - (minIndex + 1)) {
                    stack[stackTop++] = fromIndex;
                    stack[stackTop++] = minIndex;
                    fromIndex = minIndex + 1;
                } else {
                    stack[stackTop++] = minIndex + 1;
                    stack[stackTop++] = toIndex;
                    toIndex = minIndex;
                }
            }
            ++iterationCount;
        }
    }

    private void correctMaxRectangle(long fromX, long fromY, long toX, long toY) {
        double area = SearchIRectangleInHypograph.area(fromX, fromY, toX, toY);
        if (area > this.maxRectangleArea) {
            this.largestRectangleFromX = fromX;
            this.largestRectangleFromY = fromY;
            this.largestRectangleToX = toX;
            this.largestRectangleToY = toY;
            this.maxRectangleArea = area;
            this.maxRectangleCorrected = true;
        }
    }

    static double area(long fromX, long fromY, long toX, long toY) {
        assert (fromX <= toX);
        assert (fromY <= toY);
        return (double)(toX - fromX) * (double)(toY - fromY);
    }
}

