/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.StreamingApertureProcessor;

public class ContinuedStreamingApertureProcessor
extends StreamingApertureProcessor {
    private final StreamingApertureProcessor parent;
    private final Matrix.ContinuationMode continuationMode;

    private ContinuedStreamingApertureProcessor(StreamingApertureProcessor parent, Matrix.ContinuationMode continuationMode) {
        super(parent.context());
        Objects.requireNonNull(continuationMode, "Null continuationMode derivator");
        if (continuationMode == Matrix.ContinuationMode.NONE) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be used with continuation mode \"" + String.valueOf(continuationMode) + "\"");
        }
        this.parent = parent;
        this.continuationMode = continuationMode;
    }

    public static ContinuedStreamingApertureProcessor getInstance(StreamingApertureProcessor parent, Matrix.ContinuationMode continuationMode) {
        return new ContinuedStreamingApertureProcessor(parent, continuationMode);
    }

    public StreamingApertureProcessor parent() {
        return this.parent;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    @Override
    public StreamingApertureProcessor context(ArrayContext newContext) {
        return new ContinuedStreamingApertureProcessor(this.parent.context(newContext), this.continuationMode);
    }

    @Override
    public boolean isStandardImplementation() {
        return this.parent.isStandardImplementation() && this.continuationMode == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public <T extends PArray> Matrix<T> asProcessed(Class<? extends T> requiredType, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        additionalMatrices = new ArrayList<Matrix<? extends PArray>>(additionalMatrices);
        ContinuedStreamingApertureProcessor.checkArguments(src, src, additionalMatrices, pattern);
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), pattern, false);
        Matrix<? extends PArray> continued = DependenceApertureBuilder.extend(src, a, this.continuationMode);
        additionalMatrices = ContinuedStreamingApertureProcessor.extendAdditionalMatrices(additionalMatrices, a);
        Matrix<? extends T> parentResult = this.parent.asProcessed(requiredType, continued, additionalMatrices, pattern);
        return DependenceApertureBuilder.reduce(parentResult, a);
    }

    @Override
    public void process(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, List<? extends Matrix<? extends PArray>> additionalMatrices, Pattern pattern) {
        Objects.requireNonNull(additionalMatrices, "Null additionalMatrices argument");
        additionalMatrices = new ArrayList<Matrix<? extends PArray>>(additionalMatrices);
        ContinuedStreamingApertureProcessor.checkArguments(dest, src, additionalMatrices, pattern);
        IRectangularArea a = DependenceApertureBuilder.SUM_MAX_0.getAperture(src.dimCount(), pattern, false);
        Matrix<? extends PArray> continued = DependenceApertureBuilder.extend(src, a, this.continuationMode);
        additionalMatrices = ContinuedStreamingApertureProcessor.extendAdditionalMatrices(additionalMatrices, a);
        Matrix<? extends UpdatablePArray> continuedDest = DependenceApertureBuilder.extend(dest, a, Matrix.ContinuationMode.ZERO_CONSTANT);
        this.parent.process(continuedDest, continued, additionalMatrices, pattern);
    }

    private static List<? extends Matrix<? extends PArray>> extendAdditionalMatrices(List<? extends Matrix<? extends PArray>> matrices, IRectangularArea aperture) {
        if (matrices.isEmpty()) {
            return matrices;
        }
        ArrayList<Matrix<? extends PArray>> continued = new ArrayList<Matrix<? extends PArray>>();
        for (Matrix<? extends PArray> matrix : matrices) {
            long[] from = aperture.min().coordinates();
            long[] to = IPoint.of(matrix.dimensions()).add(aperture.max()).coordinates();
            continued.add(matrix.isEmpty() ? matrix : matrix.subMatrix(from, to, Matrix.ContinuationMode.ZERO_CONSTANT));
        }
        return continued;
    }
}

