/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;

public enum DependenceApertureBuilder {
    SUM,
    MAX,
    SUM_MAX_0;

    public static final short DEFAULT_ADDITIONAL_SPACE = 2;

    public IRectangularArea getAperture(int dimCount, Pattern pattern, boolean inverted) {
        return this.getAperture(dimCount, new Pattern[]{pattern}, new boolean[]{inverted});
    }

    public IRectangularArea getAperture(int dimCount, Pattern pattern1, boolean inverted1, Pattern pattern2, boolean inverted2) {
        return this.getAperture(dimCount, new Pattern[]{pattern1, pattern2}, new boolean[]{inverted1, inverted2});
    }

    public IRectangularArea getAperture(int dimCount, Pattern[] patterns, boolean[] inverted) {
        return this.getAperture(dimCount, patterns, inverted, (short)2);
    }

    public IRectangularArea getAperture(int dimCount, Pattern[] patterns, boolean[] inverted, short additionalSpace) {
        Objects.requireNonNull(patterns, "Null patterns argument");
        Objects.requireNonNull(inverted, "Null inverted argument");
        if (dimCount <= 0) {
            throw new IllegalArgumentException("Zero or negative dimCount argument");
        }
        if (patterns.length == 0) {
            throw new IllegalArgumentException("Empty patterns argument");
        }
        if (inverted.length == 0) {
            throw new IllegalArgumentException("Empty inverted argument");
        }
        if (patterns.length != inverted.length) {
            throw new IllegalArgumentException("Different lengths of patterns and inverted arguments");
        }
        if (additionalSpace < 0) {
            throw new IllegalArgumentException("Negative additionalSpace argument");
        }
        patterns = (Pattern[])patterns.clone();
        inverted = (boolean[])inverted.clone();
        for (int i = 0; i < patterns.length; ++i) {
            Objects.requireNonNull(patterns[i], "Null pattern #" + i);
            if (patterns[i].dimCount() >= dimCount) continue;
            throw new IllegalArgumentException("Pattern #" + i + " has insufficient dimensions (<" + dimCount + ")");
        }
        long[] allMin = new long[dimCount];
        long[] allMax = new long[dimCount];
        for (int k = 0; k < dimCount; ++k) {
            block6: for (int i = 0; i < patterns.length; ++i) {
                IRange range = patterns[i].roundedCoordRange(k);
                long min = inverted[i] ? range.min() : -range.max();
                long max = inverted[i] ? range.max() : -range.min();
                switch (this.ordinal()) {
                    case 0: 
                    case 2: {
                        allMin[k] = DependenceApertureBuilder.safelyAdd(allMin[k], min);
                        allMax[k] = DependenceApertureBuilder.safelyAdd(allMax[k], max);
                        continue block6;
                    }
                    case 1: {
                        allMin[k] = Math.min(allMin[k], min);
                        allMax[k] = Math.max(allMax[k], max);
                    }
                }
            }
            if (this == SUM_MAX_0) {
                allMin[k] = Math.min(allMin[k], 0L);
                allMax[k] = Math.max(allMax[k], 0L);
            }
            allMin[k] = DependenceApertureBuilder.safelyAdd(allMin[k], -additionalSpace);
            allMax[k] = DependenceApertureBuilder.safelyAdd(allMax[k], additionalSpace);
        }
        return IRectangularArea.of(IPoint.of(allMin), IPoint.of(allMax));
    }

    public static long[] extendDimensions(long[] matrixDimensions, IRectangularArea aperture) {
        Objects.requireNonNull(matrixDimensions, "Null matrixDimensions");
        Objects.requireNonNull(aperture, "Null aperture");
        if (matrixDimensions.length != aperture.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + matrixDimensions.length + " dimensions in array and " + aperture.coordCount() + "-dimensional aperture");
        }
        for (int k = 0; k < matrixDimensions.length; ++k) {
            if (matrixDimensions[k] >= 0L) continue;
            throw new IllegalArgumentException("Negative matrixDimensions[" + k + "]");
        }
        long[] result = (long[])matrixDimensions.clone();
        long len = Arrays.longMul(result);
        if (len == Long.MIN_VALUE) {
            throw new IndexOutOfBoundsException("Too large matrixDimensions: their product > Long.MAX_VALUE");
        }
        if (len == 0L) {
            return result;
        }
        for (int k = 0; k < result.length; ++k) {
            int n = k;
            result[n] = result[n] + aperture.width(k);
            if (result[k] >= 0L) continue;
            throw new IndexOutOfBoundsException("Too large matrix continuation: the dimension #" + k + " of the matrix, extended to the corresponding aperture " + String.valueOf(aperture) + ", is greater than Long.MAX_VALUE");
        }
        if (Arrays.longMul(result) == Long.MIN_VALUE) {
            throw new IndexOutOfBoundsException("Too large matrix continuation: product of dimensions of the matrix, extended to the corresponding aperture " + String.valueOf(aperture) + ", is greater than Long.MAX_VALUE");
        }
        return result;
    }

    public static <T extends PArray> Matrix<T> extend(Matrix<T> matrix, IRectangularArea aperture, Matrix.ContinuationMode continuationMode) {
        Objects.requireNonNull(matrix, "Null matrix");
        Objects.requireNonNull(aperture, "Null aperture");
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        if (matrix.dimCount() != aperture.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + matrix.dimCount() + "-dimensional matrix and " + aperture.coordCount() + "-dimensional aperture");
        }
        if (matrix.isEmpty()) {
            return matrix;
        }
        long[] from = new long[matrix.dimCount()];
        long[] to = new long[from.length];
        for (int k = 0; k < from.length; ++k) {
            from[k] = aperture.min(k);
            to[k] = matrix.dim(k) + aperture.max(k);
            if (to[k] >= 0L || aperture.max(k) < 0L) continue;
            throw new IndexOutOfBoundsException("Too large matrix continuation: the dimension #" + k + " of the matrix, extended to the corresponding aperture " + String.valueOf(aperture) + ", is greater than Long.MAX_VALUE");
        }
        return matrix.subMatrix(from, to, continuationMode);
    }

    public static <T extends PArray> Matrix<T> reduce(Matrix<T> matrix, IRectangularArea aperture) {
        Objects.requireNonNull(matrix, "Null matrix");
        Objects.requireNonNull(aperture, "Null aperture");
        if (matrix.dimCount() != aperture.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + matrix.dimCount() + "-dimensional matrix and " + aperture.coordCount() + "-dimensional aperture");
        }
        if (matrix.isEmpty()) {
            return matrix;
        }
        long[] from = new long[matrix.dimCount()];
        long[] to = new long[from.length];
        for (int k = 0; k < from.length; ++k) {
            from[k] = -aperture.min(k);
            to[k] = matrix.dim(k) - aperture.max(k);
        }
        return matrix.subMatrix(from, to, Matrix.ContinuationMode.PSEUDO_CYCLIC);
    }

    public static long safelyAdd(long a, long b) throws IndexOutOfBoundsException {
        long result = a + b;
        if (a < 0L != b < 0L) {
            return result;
        }
        if (a < 0L != result < 0L) {
            throw new IndexOutOfBoundsException("Integer overflow while summing two long values " + a + " and " + b + " (maybe, dimensions of some matrices or areas)");
        }
        return result;
    }
}

