/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.AbstractMorphology;
import net.algart.matrices.morphology.RankMorphology;

public abstract class AbstractRankMorphology
extends AbstractMorphology
implements RankMorphology {
    protected AbstractRankMorphology(ArrayContext context) {
        super(context);
    }

    @Override
    public RankMorphology context(ArrayContext newContext) {
        return (RankMorphology)super.context(newContext);
    }

    @Override
    protected abstract Matrix<? extends PArray> asDilationOrErosion(Matrix<? extends PArray> var1, Pattern var2, boolean var3);

    @Override
    protected abstract Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3, boolean var4, boolean var5);

    @Override
    public abstract Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> var1, Matrix<? extends PArray> var2, Pattern var3);

    @Override
    public Matrix<? extends PArray> asPercentile(Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        return this.asPercentile(src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex), pattern);
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes, Pattern pattern) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Matrices.checkDimensionEquality(src, percentileIndexes);
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.percentile(dest, src, percentileIndexes, pattern);
        return dest;
    }

    @Override
    public Matrix<? extends UpdatablePArray> percentile(Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        return this.percentile(src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex), pattern);
    }

    @Override
    public abstract void percentile(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4);

    @Override
    public void percentile(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double percentileIndex, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        this.percentile(dest, src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex), pattern);
    }

    @Override
    public abstract <T extends PArray> Matrix<T> asRank(Class<? extends T> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4);

    @Override
    public <T extends PArray> Matrix<? extends T> rank(Class<? extends T> requiredType, Matrix<? extends PArray> baseMatrix, Matrix<? extends PArray> rankedMatrix, Pattern pattern) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Matrices.checkDimensionEquality(baseMatrix, rankedMatrix);
        if (pattern.dimCount() != baseMatrix.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Class<?> elementType = Arrays.elementType(requiredType);
        Matrices.checkNewMatrixType(requiredType, elementType);
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, elementType, baseMatrix.dimensions());
        this.rank(dest, baseMatrix, rankedMatrix, pattern);
        return dest.cast(requiredType);
    }

    @Override
    public abstract void rank(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4);

    @Override
    public abstract Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4, double var5);

    @Override
    public Matrix<? extends PArray> asMeanBetweenPercentiles(Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Objects.requireNonNull(src, "Null src argument");
        return this.asMeanBetweenPercentiles(src, AbstractRankMorphology.constantPercentileMatrix(src, fromPercentileIndex), AbstractRankMorphology.constantPercentileMatrix(src, toPercentileIndex), pattern, filler);
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, Matrix<? extends PArray> fromPercentileIndexes, Matrix<? extends PArray> toPercentileIndexes, Pattern pattern, double filler) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Matrices.checkDimensionEquality(src, fromPercentileIndexes, toPercentileIndexes);
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.meanBetweenPercentiles(dest, src, fromPercentileIndexes, toPercentileIndexes, pattern, filler);
        return dest;
    }

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenPercentiles(Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Objects.requireNonNull(src, "Null src argument");
        return this.meanBetweenPercentiles(src, AbstractRankMorphology.constantPercentileMatrix(src, fromPercentileIndex), AbstractRankMorphology.constantPercentileMatrix(src, toPercentileIndex), pattern, filler);
    }

    @Override
    public abstract void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Matrix<? extends PArray> var4, Pattern var5, double var6);

    @Override
    public void meanBetweenPercentiles(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double fromPercentileIndex, double toPercentileIndex, Pattern pattern, double filler) {
        Objects.requireNonNull(src, "Null src argument");
        this.meanBetweenPercentiles(dest, src, AbstractRankMorphology.constantPercentileMatrix(src, fromPercentileIndex), AbstractRankMorphology.constantPercentileMatrix(src, toPercentileIndex), pattern, filler);
    }

    @Override
    public abstract Matrix<? extends PArray> asMeanBetweenValues(Matrix<? extends PArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4, double var5);

    @Override
    public Matrix<? extends UpdatablePArray> meanBetweenValues(Matrix<? extends PArray> src, Matrix<? extends PArray> minValues, Matrix<? extends PArray> maxValues, Pattern pattern, double filler) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Matrices.checkDimensionEquality(src, minValues, maxValues);
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.meanBetweenValues(dest, src, minValues, maxValues, pattern, filler);
        return dest;
    }

    @Override
    public abstract void meanBetweenValues(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Matrix<? extends PArray> var4, Pattern var5, double var6);

    @Override
    public Matrix<? extends PArray> asMean(Matrix<? extends PArray> src, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        LinearFunc processingFunc = LinearFunc.getInstance(PFloatingArray.class.isAssignableFrom(src.type()) ? 0.0 : 0.5, 1.0 / (double)pattern.pointCount());
        return this.asFunctionOfSum(src, pattern, processingFunc);
    }

    @Override
    public Matrix<? extends UpdatablePArray> mean(Matrix<? extends PArray> src, Pattern pattern) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.mean(dest, src, pattern);
        return dest;
    }

    @Override
    public void mean(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        LinearFunc processingFunc = LinearFunc.getInstance(PFloatingArray.class.isAssignableFrom(src.type()) ? 0.0 : 0.5, 1.0 / (double)pattern.pointCount());
        this.functionOfSum(dest, src, pattern, processingFunc);
    }

    @Override
    public abstract Matrix<? extends PArray> asFunctionOfSum(Matrix<? extends PArray> var1, Pattern var2, Func var3);

    @Override
    public Matrix<? extends UpdatablePArray> functionOfSum(Matrix<? extends PArray> src, Pattern pattern, Func processingFunc) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Objects.requireNonNull(processingFunc, "Null processingFunc argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.functionOfSum(dest, src, pattern, processingFunc);
        return dest;
    }

    @Override
    public abstract void functionOfSum(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Pattern var3, Func var4);

    @Override
    public abstract Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Pattern var4, Func var5);

    @Override
    public Matrix<? extends PArray> asFunctionOfPercentilePair(Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Objects.requireNonNull(src, "Null src argument");
        return this.asFunctionOfPercentilePair(src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex1), AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex2), pattern, processingFunc);
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, Matrix<? extends PArray> percentileIndexes1, Matrix<? extends PArray> percentileIndexes2, Pattern pattern, Func processingFunc) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        Objects.requireNonNull(processingFunc, "Null processingFunc argument");
        Matrices.checkDimensionEquality(src, percentileIndexes1, percentileIndexes2);
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        Matrix<UpdatablePArray> dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        this.functionOfPercentilePair(dest, src, percentileIndexes1, percentileIndexes2, pattern, processingFunc);
        return dest;
    }

    @Override
    public Matrix<? extends UpdatablePArray> functionOfPercentilePair(Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Objects.requireNonNull(src, "Null src argument");
        return this.functionOfPercentilePair(src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex1), AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex2), pattern, processingFunc);
    }

    @Override
    public abstract void functionOfPercentilePair(Matrix<? extends UpdatablePArray> var1, Matrix<? extends PArray> var2, Matrix<? extends PArray> var3, Matrix<? extends PArray> var4, Pattern var5, Func var6);

    @Override
    public void functionOfPercentilePair(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, double percentileIndex1, double percentileIndex2, Pattern pattern, Func processingFunc) {
        Objects.requireNonNull(src, "Null src argument");
        if (pattern.dimCount() != src.dimCount()) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        this.functionOfPercentilePair(dest, src, AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex1), AbstractRankMorphology.constantPercentileMatrix(src, percentileIndex2), pattern, processingFunc);
    }

    public static Matrix<? extends PArray> constantPercentileMatrix(Matrix<? extends PArray> src, double percentileIndex) {
        return src.matrix(percentileIndex == (double)((long)percentileIndex) ? Arrays.nLongCopies(src.size(), (long)percentileIndex) : Arrays.nDoubleCopies(src.size(), percentileIndex));
    }
}

