/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.Point;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.QuickPointCountPattern;
import net.algart.math.patterns.RectangularPattern;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.AbstractMorphology;
import net.algart.matrices.morphology.Morphology;

public class BasicMorphology
extends AbstractMorphology
implements Morphology {
    private static final int MIN_LENGTH_OF_DECOMPOSITION_FOR_USING_JAVA_MEMORY = 4;
    private static final int MIN_POINT_COUNT_TO_DECOMPOSE = 4;
    private static final boolean QUICK_UNION_DECOMPOSITION_ALGORITHM = true;
    private static final int MAX_NUMBER_OF_RANGES_FOR_CUSTOM_COPIER = 0x100000;
    private static final int MAX_NUMBER_OF_TASKS = 262144;
    private final long maxTempJavaMemory;

    BasicMorphology(ArrayContext context, long maxTempJavaMemory) {
        super(context);
        if (maxTempJavaMemory < 0L) {
            throw new IllegalArgumentException("Negative maxTempJavaMemory argument");
        }
        this.maxTempJavaMemory = maxTempJavaMemory;
    }

    public static BasicMorphology getInstance(ArrayContext context) {
        return new BasicMorphology(context, Arrays.SystemSettings.maxTempJavaMemory());
    }

    public static BasicMorphology getInstance(ArrayContext context, long maxTempJavaMemory) {
        return new BasicMorphology(context, maxTempJavaMemory);
    }

    @Override
    public boolean isPseudoCyclic() {
        return true;
    }

    @Override
    protected Matrix<? extends PArray> asDilationOrErosion(Matrix<? extends PArray> src, Pattern pattern, boolean isDilation) {
        double[] increments;
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (!this.dimensionsAllowed(src, pattern)) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        PArray array = src.array();
        boolean additionalDimension = pattern.dimCount() == src.dimCount() + 1;
        double[] dArray = increments = !additionalDimension ? null : new double[(int)pattern.pointCount()];
        if (additionalDimension) {
            pattern = pattern.maxBound(src.dimCount());
        }
        long[] rightwardShifts = BasicMorphology.toShifts(increments, array.length(), src.dimensions(), pattern, !isDilation);
        PArray[] shifted = new PArray[rightwardShifts.length];
        for (int k = 0; k < rightwardShifts.length; ++k) {
            PArray pArray = shifted[k] = rightwardShifts[k] == 0L ? array : (PArray)Arrays.asShifted(array, rightwardShifts[k]);
            if (increments == null || increments[k] == 0.0) continue;
            shifted[k] = Arrays.asFuncArray(LinearFunc.getInstance(increments[k], 1.0), src.type(PArray.class), shifted[k]);
        }
        if (rightwardShifts.length == 1) {
            return src.matrix(shifted[0]);
        }
        return src.matrix(Arrays.asFuncArray(isDilation ? Func.MAX : Func.MIN, src.type(PArray.class), shifted));
    }

    @Override
    protected Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean isDilation, boolean disableMemoryAllocation) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (!this.dimensionsAllowed(src, pattern)) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        if (dest != null && !dest.dimEquals(src)) {
            throw new SizeMismatchException("Destination and source matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
        }
        Matrix<? extends UpdatablePArray> castDest = dest == null || dest.elementType() == src.elementType() ? dest : Matrices.asUpdatableFuncMatrix(true, Func.UPDATABLE_IDENTITY, src.updatableType(UpdatablePArray.class), dest);
        Matrix<? extends UpdatablePArray> result = this.dilationOrErosion(castDest, src, null, pattern, isDilation, disableMemoryAllocation);
        if (dest != null) {
            if (result.array() != castDest.array()) {
                Matrices.copy(null, castDest, result);
            }
            result = dest;
        }
        return result;
    }

    @Override
    protected boolean dimensionsAllowed(Matrix<? extends PArray> matrix, Pattern pattern) {
        int matrixDimCount;
        int patternDimCount = pattern.dimCount();
        return patternDimCount == (matrixDimCount = matrix.dimCount()) || patternDimCount == matrixDimCount + 1;
    }

    static long[] toShifts(double[] resultLastCoordinateIncrements, long totalLength, long[] dimensions, Pattern pattern, boolean symmetric) {
        Set<Point> points = pattern.points();
        long[] result = new long[points.size()];
        int k = 0;
        for (Point p : points) {
            double v = 0.0;
            if (p.coordCount() != dimensions.length) {
                v = p.coord(dimensions.length);
                p = p.projectionAlongAxis(dimensions.length);
            }
            long shift = p.toRoundedPoint().toOneDimensional(dimensions, true);
            assert (shift >= 0L && (shift < totalLength || totalLength == 0L && shift == 0L)) : "illegal result of toOneDimensional(" + JArrays.toString(dimensions, ", ", 100) + ", true) for point " + String.valueOf(p) + ": " + shift;
            if (symmetric && shift != 0L) {
                shift = totalLength - shift;
            }
            if (symmetric) {
                v = -v;
            }
            if (resultLastCoordinateIncrements != null) {
                resultLastCoordinateIncrements[k] = v;
            }
            result[k] = shift;
            ++k;
        }
        assert (k == result.length);
        return result;
    }

    private Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> possibleDest, Matrix<? extends PArray> src, ArrayPool pool, Pattern pattern, boolean isDilation, boolean disableMemoryAllocation) {
        boolean additionalDimension;
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        assert (possibleDest == null || possibleDest.elementType() == src.elementType());
        PArray array = src.array();
        long length = array.length();
        long[] dimensions = src.dimensions();
        boolean bl = additionalDimension = pattern.dimCount() == dimensions.length + 1;
        boolean simpleAlgorithm = disableMemoryAllocation || BasicMorphology.isSmall(pattern) || length == 0L || !(additionalDimension ? pattern.projectionAlongAxis(dimensions.length) : pattern).isSurelyInteger();
        List<Pattern> minkowskiDecomposition = !simpleAlgorithm ? pattern.minkowskiDecomposition(4) : Collections.singletonList(pattern);
        int minkSize = minkowskiDecomposition.size();
        assert (minkSize >= 1) : "illegal Minkowski decomposition length";
        List<Pattern> unionDecomposition = null;
        int unionSize = 1;
        if (minkSize == 1 && !simpleAlgorithm && !additionalDimension) {
            assert (pattern.isSurelyInteger()) : "non-integer pattern must not be used for union decomposition";
            List<List<Pattern>> all = pattern.allUnionDecompositions(4);
            assert (!all.isEmpty()) : "illegal length of the list of union decompositions";
            unionDecomposition = all.size() == 1 || !(array instanceof BitArray) ? all.get(0) : all.get(1);
            unionSize = unionDecomposition.size();
            assert (unionSize >= 1) : "illegal union decomposition length";
        }
        if (minkSize == 1 && unionSize == 1) {
            if (possibleDest == null) {
                possibleDest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
            }
            if (length > 0L) {
                if (additionalDimension) {
                    pattern = pattern.maxBound(dimensions.length);
                }
                double[] decrements = !additionalDimension ? null : new double[(int)pattern.pointCount()];
                long[] leftwardShifts = BasicMorphology.toShifts(decrements, length, dimensions, pattern, isDilation);
                this.simpleDilationOrErosion(possibleDest.array(), array, leftwardShifts, decrements, isDilation);
            }
            return possibleDest;
        }
        assert (!simpleAlgorithm);
        MemoryModel mm = this.memoryModel();
        int numberOfTasks = Math.max(1, Arrays.getThreadPoolFactory(this.context()).recommendedNumberOfTasks(array));
        int numberOfRanges = (numberOfTasks = Math.min(numberOfTasks, 262144)) == 1 ? 1 : (int)Math.min(Arrays.Copier.recommendedNumberOfRanges(array, false), 0x100000L);
        numberOfRanges = (int)Arrays.Copier.correctNumberOfRanges(numberOfRanges, numberOfTasks);
        if (minkSize >= 2) {
            long bufferLength = BasicMorphology.getBufferLengthForMinkowskiDecomposition(src, minkowskiDecomposition, isDilation, numberOfRanges);
            if (minkSize >= 4) {
                mm = this.mm(src, BasicMorphology.hasComplexPatterns(dimensions.length, minkowskiDecomposition) ? 3 : 1, bufferLength);
            }
            if (possibleDest == null) {
                possibleDest = mm.newMatrix(UpdatablePArray.class, src);
            }
            if (pool == null) {
                pool = ArrayPool.getInstance(mm, src.elementType(), src.size());
            }
            UpdatablePArray buffer = (UpdatablePArray)mm.newUnresizableArray(src.elementType(), bufferLength);
            UpdatablePArray result = this.minkowskiDilationOrErosionWithoutAllocation(possibleDest.array(), src, buffer, pool, minkowskiDecomposition, isDilation, numberOfTasks);
            return src.matrix(result);
        }
        assert (!additionalDimension);
        assert (unionSize >= 2);
        long bufferLength = BasicMorphology.estimateBufferLengthForUnionDecomposition(src, pattern, unionDecomposition, numberOfRanges);
        if (unionSize >= 4) {
            mm = this.mm(src, 3, bufferLength);
        }
        if (possibleDest == null) {
            possibleDest = mm.newMatrix(UpdatablePArray.class, src);
        }
        if (pool == null) {
            pool = ArrayPool.getInstance(mm, src.elementType(), length);
        }
        UpdatablePArray tempForAccumulator = (UpdatablePArray)pool.requestArray();
        UpdatablePArray tempForMorph = null;
        UpdatablePArray buffer = bufferLength == length ? (UpdatablePArray)pool.requestArray() : (UpdatablePArray)mm.newUnresizableArray(array.elementType(), bufferLength);
        List<MinkowskiPair> compactedDecomposition = BasicMorphology.compactUnionDecomposition(unionDecomposition, isDilation);
        int n = compactedDecomposition.size();
        for (int k = 0; k < n; ++k) {
            MinkowskiPair pair = compactedDecomposition.get(k);
            if (pair.incrementFromPrevious != null) {
                assert (tempForMorph != null) : "Null tempForMorph";
                long[][] leftwardShifts = BasicMorphology.toShifts(length, src.dimensions(), pair.incrementFromPrevious, isDilation);
                this.subTask(k, 0.125, n).simpleMinkowskiDilationOrErosionInPlace(tempForMorph, buffer, leftwardShifts, isDilation, numberOfTasks);
                this.subTask((double)k + 0.125, 0.875, n).accumulateDilationOrErosionWithoutAllocation(possibleDest.array(), src.matrix(tempForMorph), pair.shifts, tempForAccumulator, buffer, pool, isDilation, k == 0, numberOfTasks);
                continue;
            }
            if (pair.incrementToNext != null) {
                UpdatablePArray result;
                if (tempForMorph == null) {
                    tempForMorph = (UpdatablePArray)pool.requestArray();
                }
                if ((result = this.subTask(k, 0.5, n).dilationOrErosionWithoutAllocation(tempForMorph, src, pair.main, tempForAccumulator, pool, isDilation, numberOfTasks)) != tempForMorph) {
                    assert (result == tempForAccumulator);
                    tempForAccumulator = tempForMorph;
                    tempForMorph = result;
                }
                this.subTask((double)k + 0.5, 0.5, n).accumulateDilationOrErosionWithoutAllocation(possibleDest.array(), src.matrix(tempForMorph), pair.shifts, tempForAccumulator, buffer, pool, isDilation, k == 0, numberOfTasks);
                continue;
            }
            if (tempForMorph == null) {
                tempForMorph = (UpdatablePArray)pool.requestArray();
            }
            this.subTask(k, 1.0, n).accumulateDilationOrErosionWithoutAllocation(possibleDest.array(), src, pair.shifts.isSurelyOriginPoint() ? pair.main : Patterns.newMinkowskiSum(pair.main, pair.shifts), tempForAccumulator, tempForMorph, pool, isDilation, k == 0, numberOfTasks);
        }
        pool.releaseArray(tempForAccumulator);
        pool.releaseArray(tempForMorph);
        if (bufferLength == length) {
            pool.releaseArray(buffer);
        }
        return possibleDest;
    }

    private UpdatablePArray dilationOrErosionWithoutAllocation(UpdatablePArray possibleDest, Matrix<? extends PArray> src, Pattern pattern, UpdatablePArray buffer, ArrayPool pool, boolean isDilation, int numberOfTasks) {
        if (pattern.dimCount() != src.dimCount()) {
            throw new AssertionError((Object)"dilationOrErosionWithoutAllocation must not be called for patterns with additional dimension");
        }
        List<Pattern> md = pattern.minkowskiDecomposition(4);
        int m = md.size();
        if (m >= 2) {
            return this.minkowskiDilationOrErosionWithoutAllocation(possibleDest, src, buffer, pool, md, isDilation, numberOfTasks);
        }
        PArray array = src.array();
        long length = array.length();
        this.simpleDilationOrErosion(possibleDest, array, BasicMorphology.toShifts(null, length, src.dimensions(), pattern, isDilation), null, isDilation);
        return possibleDest;
    }

    private void accumulateDilationOrErosionWithoutAllocation(UpdatablePArray accumulator, Matrix<? extends PArray> src, Pattern pattern, UpdatablePArray temp, UpdatablePArray buffer, ArrayPool pool, boolean isDilation, boolean accumulatorIsEmpty, int numberOfTasks) {
        if (pattern.dimCount() != src.dimCount()) {
            throw new AssertionError((Object)"accumulateDilationOrErosionWithoutAllocation must not be called for patterns with additional dimension");
        }
        List<Pattern> md = pattern.minkowskiDecomposition(4);
        int m = md.size();
        if (m >= 2) {
            if (accumulatorIsEmpty) {
                UpdatablePArray result = this.minkowskiDilationOrErosionWithoutAllocation(accumulator, src, buffer, pool, md, isDilation, numberOfTasks);
                if (result != accumulator) {
                    accumulator.copy(result);
                }
            } else {
                UpdatablePArray result = this.subTask(0.0, m, m + 1).minkowskiDilationOrErosionWithoutAllocation(temp, src, buffer, pool, md, isDilation, numberOfTasks);
                this.subTask(m, 1.0, m + 1).minOrMax(accumulator, result, isDilation);
            }
        } else {
            PArray array = src.array();
            long length = array.length();
            if (accumulatorIsEmpty) {
                this.simpleDilationOrErosion(accumulator, array, BasicMorphology.toShifts(null, length, src.dimensions(), pattern, isDilation), null, isDilation);
            } else {
                Set<IPoint> points = pattern.roundedPoints();
                if (points.size() == 1) {
                    long rightwardShift = BasicMorphology.toShifts(null, length, src.dimensions(), pattern, !isDilation)[0];
                    PArray a = rightwardShift == 0L ? array : (PArray)Arrays.asShifted(array, rightwardShift);
                    this.minOrMax(accumulator, a, isDilation);
                } else {
                    PArray[] arrays = new PArray[points.size() + 1];
                    arrays[0] = accumulator;
                    long[] rightwardShifts = BasicMorphology.toShifts(null, length, src.dimensions(), pattern, !isDilation);
                    for (int k = 0; k < rightwardShifts.length; ++k) {
                        arrays[k + 1] = rightwardShifts[k] == 0L ? array : (PArray)Arrays.asShifted(array, rightwardShifts[k]);
                    }
                    this.minOrMax(accumulator, arrays, isDilation);
                }
            }
        }
    }

    private UpdatablePArray minkowskiDilationOrErosionWithoutAllocation(UpdatablePArray possibleDest, Matrix<? extends PArray> src, UpdatablePArray buffer, ArrayPool pool, List<Pattern> minkowskiDecomposition, boolean isDilation, int numberOfTasks) {
        int minkSize = minkowskiDecomposition.size();
        if (minkSize == 0) {
            throw new AssertionError((Object)"This method must not be called for empty minkowskiDecomposition list");
        }
        ArrayList<Pattern> goodPatterns = new ArrayList<Pattern>(minkowskiDecomposition);
        List<Pattern> complexPatterns = BasicMorphology.extractComplexPatterns(src.dimCount(), goodPatterns);
        int goodSize = goodPatterns.size();
        int complexSize = complexPatterns.size();
        assert (goodSize + complexSize == minkSize);
        PArray array = src.array();
        long length = array.length();
        assert (possibleDest.length() == length);
        long[][] leftwardShifts = BasicMorphology.toShifts(length, src.dimensions(), goodPatterns, isDilation);
        leftwardShifts = BasicMorphology.optimizeMinkowskiDecomposition(length, leftwardShifts);
        int totalSize = leftwardShifts.length + complexSize;
        int complexIndex = 0;
        if (complexSize > 0) assert (buffer.length() == array.length()) : "Illegal buffer length for complex Minkowski decomposition";
        if (leftwardShifts.length > 0) {
            this.subTask(0.0, leftwardShifts.length, totalSize).simpleMinkowskiDilationOrErosion(possibleDest, array, buffer, leftwardShifts, isDilation, numberOfTasks);
        } else if (complexSize == 0) {
            Arrays.copy(this.context(), possibleDest, src.array());
        } else {
            this.subTask(0.0, 1.0, totalSize).dilationOrErosion(src.matrix(possibleDest), src, pool, complexPatterns.get(0), isDilation, false);
            complexIndex = 1;
        }
        while (complexIndex < complexSize) {
            this.subTask(leftwardShifts.length + complexIndex, 1.0, totalSize).dilationOrErosion(src.matrix(buffer), src.matrix(possibleDest), pool, complexPatterns.get(complexIndex), isDilation, false);
            UpdatablePArray temp = buffer;
            buffer = possibleDest;
            possibleDest = temp;
            ++complexIndex;
        }
        return possibleDest;
    }

    private void simpleMinkowskiDilationOrErosion(UpdatablePArray dest, PArray src, UpdatablePArray buffer, long[][] leftwardShifts, boolean isMax, int numberOfTasks) {
        int m = leftwardShifts.length;
        if (m == 0) {
            throw new AssertionError((Object)"This method must not be called for empty leftwardShifts array");
        }
        this.subTask(0.0, 1.0, m).simpleDilationOrErosion(dest, src, leftwardShifts[leftwardShifts.length - 1], null, isMax);
        if (m == 1) {
            return;
        }
        for (int k = 1; k < m; ++k) {
            this.subTask(k, 1.0, m).simpleDilationOrErosionInPlace(dest, buffer, leftwardShifts[k - 1], isMax, true, numberOfTasks);
        }
    }

    private void simpleMinkowskiDilationOrErosionInPlace(UpdatablePArray array, UpdatablePArray buffer, long[][] leftwardShifts, boolean isMax, int numberOfTasks) {
        int m = leftwardShifts.length;
        for (int k = 0; k < m; ++k) {
            this.subTask(k, 1.0, m).simpleDilationOrErosionInPlace(array, buffer, leftwardShifts[k], isMax, false, numberOfTasks);
        }
    }

    private void simpleDilationOrErosion(UpdatablePArray dest, PArray src, long[] leftwardShifts, double[] decrements, boolean isMax) {
        boolean additionalDimension;
        long length = src.length();
        assert (length == dest.length()) : "src/dest array lengths mismatch";
        boolean bl = additionalDimension = decrements != null;
        if (!additionalDimension) {
            Arrays.sort(SimpleMemoryModel.asUpdatableLongArray(leftwardShifts), (firstIndex, secondIndex) -> {
                long first = leftwardShifts[(int)firstIndex] - length >> 2;
                long second = leftwardShifts[(int)secondIndex] - length >> 2;
                return Math.abs(first) < Math.abs(second);
            });
        }
        PArray[] shifted = new PArray[leftwardShifts.length];
        for (int k = 0; k < leftwardShifts.length; ++k) {
            PArray pArray = shifted[k] = leftwardShifts[k] == 0L ? src : (PArray)Arrays.asShifted(src, -leftwardShifts[k]);
            if (!additionalDimension || decrements[k] == 0.0) continue;
            shifted[k] = Arrays.asFuncArray(LinearFunc.getInstance(-decrements[k], 1.0), dest.type(), shifted[k]);
        }
        PArray lazy = leftwardShifts.length == 1 ? shifted[0] : Arrays.asFuncArray(isMax ? Func.MAX : Func.MIN, dest.type(), shifted);
        Arrays.copy(this.context(), dest, lazy);
    }

    private void simpleDilationOrErosionInPlace(UpdatablePArray array, UpdatablePArray buffer, long[] leftwardShifts, boolean isMax, boolean shiftsAreSorted, int numberOfTasks) {
        PArray lazy;
        long length = array.length();
        for (int k = 1; k < leftwardShifts.length; ++k) {
            if (leftwardShifts[k] < 0L || leftwardShifts[k] >= length) {
                throw new AssertionError((Object)("Illegal shift: not in 0.." + (length - 1L) + " range"));
            }
            if (shiftsAreSorted && leftwardShifts[k] < leftwardShifts[k - 1]) {
                throw new AssertionError((Object)("Shifts are not sorted: " + JArrays.toString(leftwardShifts, ", ", 1000)));
            }
        }
        if (leftwardShifts.length == 0 && leftwardShifts[0] == 0L) {
            return;
        }
        long maxShift = Long.MIN_VALUE;
        for (long sh : leftwardShifts) {
            maxShift = Math.max(sh, maxShift);
        }
        if (maxShift > buffer.length()) {
            throw new AssertionError((Object)("Buffer length is less than maximal shift " + maxShift + ": buffer is " + String.valueOf(buffer)));
        }
        if (shiftsAreSorted) assert (maxShift == leftwardShifts[leftwardShifts.length - 1]);
        buffer.copy(array.subArr(0L, maxShift));
        long mainLength = length - maxShift;
        PArray[] shifted = new PArray[leftwardShifts.length];
        for (int k = 0; k < leftwardShifts.length; ++k) {
            shifted[k] = array.subArr(leftwardShifts[k], mainLength);
        }
        PArray pArray = leftwardShifts.length == 1 ? shifted[0] : (lazy = Arrays.asFuncArray(isMax ? Func.MAX : Func.MIN, array.type(), shifted));
        assert (lazy.length() == mainLength);
        if (numberOfTasks == 1) {
            Arrays.copy(this.contextPart(0.0, 0.95), array, lazy);
        } else {
            int m;
            assert (numberOfTasks > 1) : "invalid numberOfTasks = " + numberOfTasks;
            final long endGap = maxShift;
            Arrays.Copier copier = new Arrays.Copier(this, this.contextPart(0.05, 0.9), array, lazy, numberOfTasks, Math.min(Arrays.Copier.recommendedNumberOfRanges(array, false), 0x100000L)){

                @Override
                public long endGap(long rangeIndex) {
                    return rangeIndex < this.numberOfRanges - 1L ? endGap : 0L;
                }
            };
            long nr = copier.numberOfRanges();
            assert (nr == (long)((int)nr));
            int numberOfSavings = (int)nr - 1;
            long[] savingRangesLengths = new long[numberOfSavings + 1];
            long[] savingRangesFrom = new long[numberOfSavings + 1];
            long[] savingPosInBuffer = new long[numberOfSavings + 1];
            savingPosInBuffer[0] = maxShift;
            for (int m2 = 0; m2 < numberOfSavings; ++m2) {
                long gap;
                savingRangesLengths[m2] = gap = Math.min(maxShift, copier.rangeLength(m2));
                savingRangesFrom[m2] = copier.rangeTo(m2) - gap;
                savingPosInBuffer[m2 + 1] = savingPosInBuffer[m2] + gap;
            }
            if (savingPosInBuffer[numberOfSavings] > buffer.length()) {
                throw new AssertionError((Object)("Too short buffer for multithread saving: " + buffer.length() + " < " + savingPosInBuffer[numberOfSavings]));
            }
            UpdatablePArray[] savingBuffers = new UpdatablePArray[numberOfSavings];
            for (m = 0; m < numberOfSavings; ++m) {
                savingBuffers[m] = buffer.subArray(savingPosInBuffer[m], savingPosInBuffer[m + 1]);
                Arrays.copy(this.contextPart(0.05 * (double)m / (double)numberOfSavings, 0.05 * (double)(m + 1) / (double)numberOfSavings), savingBuffers[m], lazy.subArr(savingRangesFrom[m], savingRangesLengths[m]));
            }
            copier.process();
            for (m = 0; m < numberOfSavings; ++m) {
                Arrays.copy(this.contextPart(0.9 + 0.05 * (double)m / (double)numberOfSavings, 0.9 + 0.05 * (double)(m + 1) / (double)numberOfSavings), array.subArr(savingRangesFrom[m], savingRangesLengths[m]), savingBuffers[m]);
            }
        }
        PArray expanded = (PArray)Arrays.asConcatenation(array, buffer);
        for (int k = 0; k < leftwardShifts.length; ++k) {
            shifted[k] = (PArray)expanded.subArr(mainLength + leftwardShifts[k], maxShift);
        }
        PArray pArray2 = leftwardShifts.length == 1 ? shifted[0] : (lazy = Arrays.asFuncArray(isMax ? Func.MAX : Func.MIN, array.type(), shifted));
        assert (lazy.length() == maxShift);
        Arrays.copy(this.contextPart(0.95, 1.0), array.subArr(mainLength, maxShift), lazy, 1);
    }

    private void minOrMax(UpdatablePArray dest, PArray src, boolean isMax) {
        Arrays.applyFunc(this.context(), isMax ? Func.MAX : Func.MIN, dest, dest, src);
    }

    private void minOrMax(UpdatablePArray dest, PArray[] src, boolean isMax) {
        Arrays.applyFunc(this.context(), isMax ? Func.MAX : Func.MIN, dest, src);
    }

    private static boolean isSmall(Pattern pattern) {
        if (pattern instanceof QuickPointCountPattern) {
            return pattern.pointCount() <= 4L;
        }
        return false;
    }

    private static boolean isRectangularOrVerySmall(Pattern pattern) {
        return pattern instanceof RectangularPattern || pattern instanceof QuickPointCountPattern && pattern.pointCount() <= 2L;
    }

    private static boolean isComplex(int matrixDimCount, Pattern pattern) {
        if (pattern.dimCount() != matrixDimCount || pattern.hasMinkowskiDecomposition()) {
            return true;
        }
        List<List<Pattern>> ud = pattern.allUnionDecompositions(4);
        return ud.size() > 1 || ud.get(0).size() > 1;
    }

    private static boolean hasComplexPatterns(int matrixDimCount, List<Pattern> patterns) {
        for (Pattern ptn : patterns) {
            if (!BasicMorphology.isComplex(matrixDimCount, ptn)) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> extractComplexPatterns(int matrixDimCount, List<Pattern> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        int newLength = 0;
        int n = patterns.size();
        for (int k = 0; k < n; ++k) {
            Pattern ptn = patterns.get(k);
            if (BasicMorphology.isComplex(matrixDimCount, ptn)) {
                result.add(ptn);
                continue;
            }
            patterns.set(newLength++, ptn);
        }
        patterns.subList(newLength, n).clear();
        return result;
    }

    private static long getBufferLengthForMinkowskiDecomposition(Matrix<? extends PArray> src, List<Pattern> minkowskiDecomposition, boolean isDilation, int numberOfRanges) {
        long length = src.size();
        if (BasicMorphology.hasComplexPatterns(src.dimCount(), minkowskiDecomposition)) {
            return length;
        }
        long[][] leftwardShifts = BasicMorphology.toShifts(length, src.dimensions(), minkowskiDecomposition, isDilation);
        leftwardShifts = BasicMorphology.optimizeMinkowskiDecomposition(length, leftwardShifts);
        long maxShift = 0L;
        for (long[] ptn : leftwardShifts) {
            if (ptn.length <= 1) continue;
            maxShift = Math.max(maxShift, ptn[ptn.length - 1]);
        }
        assert (maxShift < length);
        if (maxShift >= length / (long)numberOfRanges) {
            return length;
        }
        return maxShift * (long)numberOfRanges;
    }

    private static long estimateBufferLengthForUnionDecomposition(Matrix<?> src, Pattern pattern, List<Pattern> unionDecomposition, int numberOfRanges) {
        long length = src.size();
        for (Pattern ptn : unionDecomposition) {
            List<Pattern> md = ptn.minkowskiDecomposition(4);
            if (!BasicMorphology.hasComplexPatterns(src.dimCount(), md)) continue;
            return length;
        }
        long[] rightBottomCorner = new long[pattern.dimCount()];
        for (int k = 0; k < rightBottomCorner.length; ++k) {
            rightBottomCorner[k] = pattern.roundedCoordRange(k).size() - 1L;
            if (rightBottomCorner[k] < src.dim(k)) continue;
            return length;
        }
        for (Pattern ptn : unionDecomposition) {
            for (int k = 0; k < rightBottomCorner.length; ++k) {
                long ptnDimK = ptn.roundedCoordRange(k).size() - 1L;
                if (ptnDimK > rightBottomCorner[k]) {
                    throw new AssertionError((Object)("Invalid union decomposition of " + String.valueOf(pattern) + ": element " + String.valueOf(ptn) + " of the union is larger than the full pattern; the union decomposition is " + String.valueOf(unionDecomposition)));
                }
            }
        }
        long shift = IPoint.of(rightBottomCorner).toOneDimensional(src.dimensions(), true);
        assert (shift <= length);
        if (shift >= length / (long)numberOfRanges) {
            return length;
        }
        return shift * (long)numberOfRanges;
    }

    private static long[][] optimizeMinkowskiDecomposition(long totalLength, long[][] shifts) {
        ArrayList<long[]> result = new ArrayList<long[]>();
        long summaryCorrection = 0L;
        for (long[] ptn : shifts) {
            assert (ptn.length > 0);
            if (ptn.length == 1) {
                summaryCorrection += ptn[0];
                continue;
            }
            summaryCorrection += Arrays.compactCyclicPositions(totalLength, ptn);
            result.add(ptn);
        }
        if (summaryCorrection != 0L) {
            result.add(new long[]{summaryCorrection});
        }
        return (long[][])result.toArray((T[])new long[result.size()][]);
    }

    private static List<Pattern> optimizeUnionDecomposition(List<Pattern> patterns) {
        int maxDimCount = 0;
        for (Pattern ptn : patterns) {
            maxDimCount = Math.max(maxDimCount, ptn.dimCount());
        }
        LinkedList<Pattern> source = new LinkedList<Pattern>(patterns);
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (int k = maxDimCount - 1; k >= 0; --k) {
            int before = result.size();
            Iterator iterator = source.iterator();
            while (iterator.hasNext()) {
                Pattern ptn = (Pattern)iterator.next();
                if (!BasicMorphology.isSegmentAlongTheAxis(ptn, k)) continue;
                iterator.remove();
                result.add(Patterns.newRectangularIntegerPattern(ptn.roundedCoordArea().ranges()));
            }
            int after = result.size();
            Collections.sort(result.subList(before, after), (o1, o2) -> {
                long count2;
                long count1 = o1.pointCount();
                return count1 < (count2 = o2.pointCount()) ? -1 : (count1 == count2 ? 0 : 1);
            });
        }
        result.addAll(source);
        return result;
    }

    private static List<MinkowskiPair> compactUnionDecomposition(List<Pattern> patterns, boolean negativeSegments) {
        patterns = BasicMorphology.optimizeUnionDecomposition(patterns);
        ArrayList<MinkowskiPair> result = new ArrayList<MinkowskiPair>();
        Pattern lastNormalized = null;
        HashSet<IPoint> shiftsOfEqualSegments = new HashSet<IPoint>();
        for (Pattern ptn : patterns) {
            boolean equalSegments;
            List minkowskiIncrement;
            Pattern normalized;
            IPoint rectEndOrStart;
            if (!BasicMorphology.isRectangularOrVerySmall(ptn)) {
                rectEndOrStart = IPoint.origin(ptn.dimCount());
                normalized = ptn;
                minkowskiIncrement = null;
            } else {
                Point preciseRectEndOrStart;
                Point point = preciseRectEndOrStart = negativeSegments ? ptn.coordMax() : ptn.coordMin();
                assert (preciseRectEndOrStart.isInteger());
                rectEndOrStart = preciseRectEndOrStart.toRoundedPoint();
                normalized = ptn.shift(rectEndOrStart.symmetric().toPoint());
                minkowskiIncrement = lastNormalized == null ? null : BasicMorphology.minkowskiSubtractSegment(normalized, lastNormalized);
            }
            boolean bl = equalSegments = minkowskiIncrement != null && minkowskiIncrement.size() == 1 && ((Pattern)minkowskiIncrement.get(0)).isSurelyOriginPoint();
            if (!(minkowskiIncrement != null && equalSegments || lastNormalized == null)) {
                result.add(new MinkowskiPair(lastNormalized, shiftsOfEqualSegments, minkowskiIncrement));
                shiftsOfEqualSegments.clear();
            }
            shiftsOfEqualSegments.add(rectEndOrStart);
            lastNormalized = normalized;
        }
        if (lastNormalized != null) {
            result.add(new MinkowskiPair(lastNormalized, shiftsOfEqualSegments, null));
        }
        int n = result.size();
        for (int k = 0; k < n; ++k) {
            IPoint shift;
            List<Pattern> incrementFromPrevious;
            MinkowskiPair pair = (MinkowskiPair)result.get(k);
            List<Pattern> list = incrementFromPrevious = k == 0 ? null : ((MinkowskiPair)result.get((int)(k - 1))).incrementToNext;
            if (incrementFromPrevious == null && pair.incrementToNext == null && pair.shifts.pointCount() == 1L && !(shift = pair.shifts.roundedPoints().iterator().next()).isOrigin()) {
                pair = new MinkowskiPair(pair.main.shift(shift.toPoint()), Collections.singleton(IPoint.origin(shift.coordCount())), null);
            }
            pair.incrementFromPrevious = incrementFromPrevious;
            result.set(k, pair);
        }
        return result;
    }

    private static boolean isSegmentAlongTheAxis(Pattern pattern, int coordIndex) {
        if (!(pattern instanceof QuickPointCountPattern)) {
            return false;
        }
        if (pattern.pointCount() == 1L) {
            return true;
        }
        return pattern instanceof UniformGridPattern && ((UniformGridPattern)pattern).isActuallyRectangular() && !((QuickPointCountPattern)pattern).isPointCountVeryLarge() && pattern.roundedCoordRange(coordIndex).size() == pattern.pointCount();
    }

    private static List<Pattern> minkowskiSubtractSegment(Pattern larger, Pattern smaller) {
        long smallerLength;
        int dimCount = larger.dimCount();
        if (smaller.dimCount() != dimCount) {
            return null;
        }
        int axis = -1;
        for (int k = 0; k < dimCount; ++k) {
            if (!BasicMorphology.isSegmentAlongTheAxis(larger, k)) continue;
            axis = k;
            break;
        }
        if (axis == -1) {
            return null;
        }
        if (!BasicMorphology.isSegmentAlongTheAxis(smaller, axis)) {
            return null;
        }
        long largerLength = larger.pointCount();
        if (largerLength < (smallerLength = smaller.pointCount())) {
            return null;
        }
        long[] rightShift = new long[dimCount];
        boolean sameRightEnd = true;
        for (int k = 0; k < dimCount; ++k) {
            rightShift[k] = larger.roundedCoordRange(k).max() - smaller.roundedCoordRange(k).max();
            sameRightEnd &= rightShift[k] == 0L;
        }
        if (largerLength == smallerLength) {
            return Collections.singletonList(Patterns.newIntegerPattern(IPoint.of(rightShift)));
        }
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        long[] leftShift = rightShift;
        boolean sameLeftEnd = true;
        for (int k = 0; k < dimCount; ++k) {
            leftShift[k] = larger.roundedCoordRange(k).min() - smaller.roundedCoordRange(k).min();
            sameLeftEnd &= leftShift[k] == 0L;
        }
        boolean negativeSegments = sameRightEnd;
        if (!negativeSegments && !sameLeftEnd) {
            result.add(Patterns.newIntegerPattern(IPoint.of(leftShift)));
        }
        IPoint origin = IPoint.origin(dimCount);
        long len = largerLength - smallerLength;
        while (len > 0L) {
            if (len <= smallerLength) {
                result.add(Patterns.newIntegerPattern(origin, origin.shiftAlongAxis(axis, negativeSegments ? -len : len)));
                break;
            }
            long newLen = len >> 1;
            result.add(Patterns.newIntegerPattern(origin, origin.shiftAlongAxis(axis, negativeSegments ? newLen - len : len - newLen)));
            len = newLen;
        }
        return result;
    }

    private static long[][] toShifts(long totalLength, long[] dimensions, List<Pattern> patterns, boolean symmetric) {
        long[][] result = new long[patterns.size()][];
        int k = 0;
        for (Pattern ptn : patterns) {
            result[k++] = BasicMorphology.toShifts(null, totalLength, dimensions, ptn, symmetric);
        }
        assert (k == result.length);
        return result;
    }

    private BasicMorphology subTask(double fromPart, double subTaskSize, double totalTaskSize) {
        if (totalTaskSize < 0.0) {
            throw new IllegalArgumentException("Negative totalTaskSize");
        }
        if (subTaskSize < 0.0) {
            throw new IllegalArgumentException("Negative subTaskSize");
        }
        double from = fromPart / totalTaskSize;
        double to = (fromPart + subTaskSize) / totalTaskSize;
        if (to > 1.0 && to <= 1.001) {
            to = 1.0;
        }
        return (BasicMorphology)this.context(this.contextPart(from, to));
    }

    private MemoryModel mm(Matrix<? extends PArray> matrix, int numberOfMatrices, long bufferLength) {
        long matrixMemory = Arrays.longMul(Matrices.sizeOf(matrix), (long)numberOfMatrices);
        if (matrixMemory == Long.MIN_VALUE) {
            return this.memoryModel();
        }
        assert (matrixMemory >= 0L);
        long bufferMemory = Arrays.sizeOf(matrix.elementType(), bufferLength);
        if (matrixMemory > this.maxTempJavaMemory - bufferMemory) {
            return this.memoryModel();
        }
        return SimpleMemoryModel.getInstance();
    }

    private static class MinkowskiPair {
        final Pattern main;
        final Pattern shifts;
        final List<Pattern> incrementToNext;
        List<Pattern> incrementFromPrevious = null;

        MinkowskiPair(Pattern main, Set<IPoint> shifts, List<Pattern> incrementToNext) {
            Objects.requireNonNull(main, "Null main argument");
            Objects.requireNonNull(shifts, "Null shifts argument");
            this.main = main;
            this.shifts = Patterns.newIntegerPattern(shifts);
            this.incrementToNext = incrementToNext;
        }

        public String toString() {
            return "Main pattern [" + String.valueOf(this.main) + "] (+) shifts [" + String.valueOf(this.shifts) + "]" + (this.incrementFromPrevious == null && this.incrementToNext == null ? ", isolated" : "") + (String)(this.incrementFromPrevious == null ? "" : ", good element increment from the previous: Minkowski sum of " + String.valueOf(this.incrementFromPrevious)) + (String)(this.incrementToNext == null ? "" : ", good element increment to the next: Minkowski sum of " + String.valueOf(this.incrementToNext));
        }
    }
}

