/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.scanning;

import java.util.EnumSet;
import java.util.Objects;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DWrapper;
import net.algart.matrices.scanning.ContourLineType;

public class Boundary2DSimpleMeasurer
extends Boundary2DWrapper {
    private static final boolean DEBUG_MODE = false;
    private final ContourLineType contourLineType;
    private final boolean contourStrictBoundary;
    private final boolean contourPixelCenters;
    private final boolean contourSegmentCenters;
    private final EnumSet<ObjectParameter> measuredParameters;
    private final boolean measureCoordRanges;
    private final boolean measureCentroid;
    private long minX = Long.MAX_VALUE;
    private long minY = Long.MAX_VALUE;
    private long minXPlusY = Long.MAX_VALUE;
    private long minXMinusY = Long.MAX_VALUE;
    private long maxX = Long.MIN_VALUE;
    private long maxY = Long.MIN_VALUE;
    private long maxXPlusY = Long.MIN_VALUE;
    private long maxXMinusY = Long.MIN_VALUE;
    double integralXSqr = 0.0;
    double integralYSqr = 0.0;
    private double integralXSqrForCheck = 0.0;
    private double integralYSqrForCheck = 0.0;

    Boundary2DSimpleMeasurer(Boundary2DScanner parent, ContourLineType contourLineType, EnumSet<ObjectParameter> measuredParameters) {
        super(parent);
        Objects.requireNonNull(contourLineType, "Null contourLineType");
        switch (contourLineType) {
            case STRICT_BOUNDARY: {
                this.contourStrictBoundary = true;
                this.contourPixelCenters = false;
                this.contourSegmentCenters = false;
                break;
            }
            case PIXEL_CENTERS_POLYLINE: {
                this.contourStrictBoundary = false;
                this.contourPixelCenters = true;
                this.contourSegmentCenters = false;
                break;
            }
            case SEGMENT_CENTERS_POLYLINE: {
                this.contourStrictBoundary = false;
                this.contourPixelCenters = false;
                this.contourSegmentCenters = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported contourLineType=" + String.valueOf((Object)contourLineType)));
            }
        }
        this.contourLineType = contourLineType;
        this.measuredParameters = measuredParameters.clone();
        this.measureCoordRanges = measuredParameters.contains((Object)ObjectParameter.COORD_RANGES);
        this.measureCentroid = measuredParameters.contains((Object)ObjectParameter.CENTROID);
    }

    public static Boundary2DSimpleMeasurer getInstance(Boundary2DScanner parent, ContourLineType contourLineType, EnumSet<ObjectParameter> measuredParameters) {
        Objects.requireNonNull(parent, "Null parent argument");
        Objects.requireNonNull(measuredParameters, "Null measuredParameters argument");
        Objects.requireNonNull(contourLineType, "Null contourLineType argument");
        return new Boundary2DSimpleMeasurer(parent, contourLineType, measuredParameters);
    }

    public ContourLineType contourLineType() {
        return this.contourLineType;
    }

    public final EnumSet<ObjectParameter> measuredParameters() {
        return this.measuredParameters.clone();
    }

    @Override
    public void resetCounters() {
        super.resetCounters();
        this.minXMinusY = Long.MAX_VALUE;
        this.minXPlusY = Long.MAX_VALUE;
        this.minY = Long.MAX_VALUE;
        this.minX = Long.MAX_VALUE;
        this.maxXMinusY = Long.MIN_VALUE;
        this.maxXPlusY = Long.MIN_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.maxX = Long.MIN_VALUE;
        this.integralYSqr = 0.0;
        this.integralXSqr = 0.0;
        this.integralYSqrForCheck = 0.0;
        this.integralXSqrForCheck = 0.0;
    }

    @Override
    public void next() {
        this.parent.next();
        long x = this.parent.x();
        long y = this.parent.y();
        Boundary2DScanner.Step step = this.parent.lastStep();
        if (this.measureCoordRanges) {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (x + y < this.minXPlusY) {
                this.minXPlusY = x + y;
            }
            if (x + y > this.maxXPlusY) {
                this.maxXPlusY = x + y;
            }
            if (x - y < this.minXMinusY) {
                this.minXMinusY = x - y;
            }
            if (x - y > this.maxXMinusY) {
                this.maxXMinusY = x - y;
            }
        }
        if (this.measureCentroid) {
            block0 : switch (this.contourLineType.code) {
                case 0: {
                    switch (this.parent.side().code) {
                        case 0: {
                            this.integralXSqr -= ((double)x - 0.5) * ((double)x - 0.5);
                            break;
                        }
                        case 2: {
                            this.integralXSqr += ((double)x + 0.5) * ((double)x + 0.5);
                            break;
                        }
                        case 1: {
                            this.integralYSqr -= ((double)y - 0.5) * ((double)y - 0.5);
                            break;
                        }
                        case 3: {
                            this.integralYSqr += ((double)y + 0.5) * ((double)y + 0.5);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (step.code) {
                        case 0: {
                            this.integralXSqr -= 3.0 * (double)x * (double)x;
                            break;
                        }
                        case 1: {
                            this.integralYSqr -= 3.0 * (double)y * (double)y;
                            break;
                        }
                        case 2: {
                            this.integralXSqr += 3.0 * (double)x * (double)x;
                            break;
                        }
                        case 3: {
                            this.integralYSqr += 3.0 * (double)y * (double)y;
                            break;
                        }
                        case 4: {
                            this.integralXSqr -= 1.0 + 3.0 * (double)x * (1.0 + (double)x);
                            this.integralYSqr += 1.0 + 3.0 * (double)y * (1.0 + (double)y);
                            break;
                        }
                        case 5: {
                            this.integralXSqr -= 1.0 - 3.0 * (double)x * (1.0 - (double)x);
                            this.integralYSqr -= 1.0 + 3.0 * (double)y * (1.0 + (double)y);
                            break;
                        }
                        case 7: {
                            this.integralXSqr += 1.0 + 3.0 * (double)x * (1.0 + (double)x);
                            this.integralYSqr += 1.0 - 3.0 * (double)y * (1.0 - (double)y);
                            break;
                        }
                        case 6: {
                            this.integralXSqr += 1.0 - 3.0 * (double)x * (1.0 - (double)x);
                            this.integralYSqr -= 1.0 - 3.0 * (double)y * (1.0 - (double)y);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (step.code) {
                        case 0: {
                            this.integralXSqr -= 3.0 * ((double)x - 0.5) * ((double)x - 0.5);
                            break block0;
                        }
                        case 1: {
                            this.integralYSqr -= 3.0 * ((double)y - 0.5) * ((double)y - 0.5);
                            break block0;
                        }
                        case 2: {
                            this.integralXSqr += 3.0 * ((double)x + 0.5) * ((double)x + 0.5);
                            break block0;
                        }
                        case 3: {
                            this.integralYSqr += 3.0 * ((double)y + 0.5) * ((double)y + 0.5);
                            break block0;
                        }
                        case 4: {
                            this.integralXSqr -= 0.125 + 1.5 * (double)x * (0.5 + (double)x);
                            this.integralYSqr += 0.875 + 1.5 * (double)y * (1.5 + (double)y);
                            break block0;
                        }
                        case 5: {
                            this.integralXSqr -= 0.875 - 1.5 * (double)x * (1.5 - (double)x);
                            this.integralYSqr -= 0.125 + 1.5 * (double)y * (0.5 + (double)y);
                            break block0;
                        }
                        case 7: {
                            this.integralXSqr += 0.875 + 1.5 * (double)x * (1.5 + (double)x);
                            this.integralYSqr += 0.125 - 1.5 * (double)y * (0.5 - (double)y);
                            break block0;
                        }
                        case 6: {
                            this.integralXSqr += 0.125 - 1.5 * (double)x * (0.5 - (double)x);
                            this.integralYSqr -= 0.875 - 1.5 * (double)y * (1.5 - (double)y);
                            break block0;
                        }
                        case 8: {
                            this.integralXSqr -= 0.125 - 1.5 * (double)x * (0.5 - (double)x);
                            this.integralYSqr -= 0.125 - 1.5 * (double)y * (0.5 - (double)y);
                            break block0;
                        }
                        case 9: {
                            this.integralXSqr += 0.125 + 1.5 * (double)x * (0.5 + (double)x);
                            this.integralYSqr -= 0.125 - 1.5 * (double)y * (0.5 - (double)y);
                            break block0;
                        }
                        case 10: {
                            this.integralXSqr += 0.125 + 1.5 * (double)x * (0.5 + (double)x);
                            this.integralYSqr += 0.125 + 1.5 * (double)y * (0.5 + (double)y);
                            break block0;
                        }
                        case 11: {
                            this.integralXSqr -= 0.125 - 1.5 * (double)x * (0.5 - (double)x);
                            this.integralYSqr += 0.125 + 1.5 * (double)y * (0.5 + (double)y);
                        }
                    }
                }
            }
        }
    }

    public double area() {
        return this.area(this.contourLineType);
    }

    public double perimeter() {
        return this.perimeter(this.contourLineType);
    }

    public double minX() {
        return this.contourPixelCenters ? (double)this.minX : (double)this.minX - 0.5;
    }

    public double maxX() {
        return this.contourPixelCenters ? (double)this.maxX : (double)this.maxX + 0.5;
    }

    public double minY() {
        return this.contourPixelCenters ? (double)this.minY : (double)this.minY - 0.5;
    }

    public double maxY() {
        return this.contourPixelCenters ? (double)this.maxY : (double)this.maxY + 0.5;
    }

    public double minXPlusY() {
        return this.contourPixelCenters ? (double)this.minXPlusY : (this.contourSegmentCenters ? (double)this.minXPlusY - 0.5 : (double)this.minXPlusY - 1.0);
    }

    public double maxXPlusY() {
        return this.contourPixelCenters ? (double)this.maxXPlusY : (this.contourSegmentCenters ? (double)this.maxXPlusY + 0.5 : (double)this.maxXPlusY + 1.0);
    }

    public double minXMinusY() {
        return this.contourPixelCenters ? (double)this.minXMinusY : (this.contourSegmentCenters ? (double)this.minXMinusY - 0.5 : (double)this.minXMinusY - 1.0);
    }

    public double maxXMinusY() {
        return this.contourPixelCenters ? (double)this.maxXMinusY : (this.contourSegmentCenters ? (double)this.maxXMinusY + 0.5 : (double)this.maxXMinusY + 1.0);
    }

    public double centroidX() {
        return this.integralXSqr / ((this.contourStrictBoundary ? 2.0 : 6.0) * this.area());
    }

    public double centroidY() {
        return this.integralYSqr / ((this.contourStrictBoundary ? 2.0 : 6.0) * this.area());
    }

    @Override
    public String toString() {
        return "simple measurer (" + String.valueOf((Object)this.contourLineType) + " mode) " + String.valueOf(this.parent);
    }

    public static enum ObjectParameter {
        AREA,
        PERIMETER,
        COORD_RANGES,
        CENTROID;

    }
}

