/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.skeletons;

import java.util.ArrayList;
import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PIntegerArray;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.matrices.skeletons.SkeletonPixelClassifier;

public abstract class ApertureBasedSkeletonPixelClassifier
extends SkeletonPixelClassifier {
    private final long[][] neighbourOffsets;
    private final int[] reverseNeighbourIndexes;

    protected ApertureBasedSkeletonPixelClassifier(int dimCount, long[][] neighbourOffsets) {
        super(dimCount);
        int k;
        Objects.requireNonNull(neighbourOffsets, "Null neighbourOffsets array");
        if (dimCount > 3) {
            throw new IllegalArgumentException("This class " + this.getClass().getName() + " cannot process " + dimCount + "-dimensional apertures (maximum 3-dimensional ones are allowed)");
        }
        if (this.numberOfNeighbours != neighbourOffsets.length) {
            throw new IllegalArgumentException("Number of passed neighbour offsets " + neighbourOffsets.length + " does not match the number of neighbours in 3x3x... aperture " + this.numberOfNeighbours);
        }
        if (this.numberOfNeighbours > 30) {
            throw new AssertionError((Object)("This class " + this.getClass().getName() + " cannot process more than 30 elements in the aperture (besides the central element)"));
        }
        this.neighbourOffsets = new long[neighbourOffsets.length][dimCount];
        for (k = 0; k < neighbourOffsets.length; ++k) {
            long[] neighbourOffset = neighbourOffsets[k];
            Objects.requireNonNull(neighbourOffset, "Null neighbourOffsets[" + k + "]");
            if (neighbourOffset.length != dimCount) {
                throw new IllegalArgumentException("Illegal neighbourOffsets[" + k + "].length = " + neighbourOffset.length + ": does not match to the number of dimensions " + dimCount);
            }
            System.arraycopy(neighbourOffset, 0, this.neighbourOffsets[k], 0, dimCount);
        }
        this.reverseNeighbourIndexes = new int[this.neighbourOffsets.length];
        for (k = 0; k < this.neighbourOffsets.length; ++k) {
            int reverseIndex = -1;
            boolean allZero = true;
            for (int j = 0; j < dimCount; ++j) {
                if (Math.abs(this.neighbourOffsets[k][j]) > 1L) {
                    throw new IllegalArgumentException("Illegal neighbourOffsets: the offset #" + k + " (" + JArrays.toString(this.neighbourOffsets[k], ",", 1000) + " describes not a neighbour, because some of its components is not in -1..1 range");
                }
                allZero &= this.neighbourOffsets[k][j] == 0L;
            }
            if (allZero) {
                throw new IllegalArgumentException("Illegal neighbourOffsets: the offset #" + k + " is zero");
            }
            for (int i = 0; i < this.neighbourOffsets.length; ++i) {
                if (i == k) continue;
                boolean matchThis = true;
                for (int j = 0; j < dimCount; ++j) {
                    matchThis &= this.neighbourOffsets[i][j] == this.neighbourOffsets[k][j];
                }
                if (matchThis) {
                    throw new IllegalArgumentException("Illegal neighbourOffsets: the offsets #" + k + " and # " + i + " are equal");
                }
                boolean matchNegative = true;
                for (int j = 0; j < dimCount; ++j) {
                    matchNegative &= this.neighbourOffsets[i][j] == -this.neighbourOffsets[k][j];
                }
                if (!matchNegative) continue;
                reverseIndex = i;
                break;
            }
            if (reverseIndex == -1) {
                throw new IllegalArgumentException("Illegal neighbourOffsets: the offset #" + k + " (" + JArrays.toString(this.neighbourOffsets[k], ",", 1000) + ") has no corresponding reverse offset (the same but with negative sign)");
            }
            this.reverseNeighbourIndexes[k] = reverseIndex;
        }
    }

    @Override
    public void neighbourOffset(long[] coordinateIncrements, int neighbourIndex) {
        Objects.requireNonNull(coordinateIncrements, "Null list of coordinates");
        if (coordinateIncrements.length != this.dimCount) {
            throw new IllegalArgumentException("Number of coordinates " + coordinateIncrements.length + " is not equal to the number of matrix dimensions " + this.dimCount());
        }
        if (neighbourIndex < 0 || neighbourIndex >= this.numberOfNeighbours) {
            throw new IndexOutOfBoundsException("Illegal neighbourIndex = " + neighbourIndex + ": must be in 0.." + (this.numberOfNeighbours - 1) + " range");
        }
        System.arraycopy(this.neighbourOffsets[neighbourIndex], 0, coordinateIncrements, 0, this.dimCount);
    }

    @Override
    public int reverseNeighbourIndex(int neighbourIndex) {
        return this.reverseNeighbourIndexes[neighbourIndex];
    }

    @Override
    public Matrix<? extends PIntegerArray> asPixelTypes(Matrix<? extends BitArray> skeleton, SkeletonPixelClassifier.AttachmentInformation attachmentInformation) {
        Objects.requireNonNull(attachmentInformation, "Null attachmentInformation");
        Matrix<? extends PIntegerArray> packed = this.asNeighbourhoodBitMaps(skeleton);
        return switch (attachmentInformation) {
            case SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHING_BRANCH -> Matrices.asFuncMatrix(false, (Func)new AbstractFunc(){

                @Override
                public double get(double ... x) {
                    return this.get(x[0]);
                }

                @Override
                public double get(double x0) {
                    int apertureBits = (int)x0;
                    if ((apertureBits & 1) == 0) {
                        return -6.0;
                    }
                    return ApertureBasedSkeletonPixelClassifier.this.pixelTypeOrAttachingBranch(apertureBits >>> 1);
                }
            }, IntArray.class, packed);
            case SkeletonPixelClassifier.AttachmentInformation.NEIGHBOUR_INDEX_OF_ATTACHED_NODE -> Matrices.asFuncMatrix(false, (Func)new AbstractFunc(){

                @Override
                public double get(double ... x) {
                    return this.get(x[0]);
                }

                @Override
                public double get(double x0) {
                    int apertureBits = (int)x0;
                    if ((apertureBits & 1) == 0) {
                        return -6.0;
                    }
                    return ApertureBasedSkeletonPixelClassifier.this.pixelTypeOrAttachedNode(apertureBits >>> 1);
                }
            }, IntArray.class, packed);
            default -> throw new AssertionError((Object)("Unknown attachmentInformation: " + String.valueOf((Object)attachmentInformation)));
        };
    }

    @Override
    public void markNeighbouringNodesNotConnectedViaDegeneratedBranches(int[] pixelTypesOfAllNeighbours) {
        if (pixelTypesOfAllNeighbours.length < this.numberOfNeighbours) {
            throw new IllegalArgumentException("Too short pixelTypesOfAllNeighbours array");
        }
        if (this.dimCount != 2) {
            return;
        }
        for (int neighbourIndex = 0; neighbourIndex < this.numberOfNeighbours; ++neighbourIndex) {
            if (neighbourIndex % 2 != 0 || pixelTypesOfAllNeighbours[neighbourIndex + 1 & 7] != -1 && pixelTypesOfAllNeighbours[neighbourIndex + 7 & 7] != -1) continue;
            pixelTypesOfAllNeighbours[neighbourIndex] = Integer.MIN_VALUE;
        }
    }

    public final Matrix<? extends PIntegerArray> asNeighbourhoodBitMaps(Matrix<? extends BitArray> skeleton) {
        Objects.requireNonNull(skeleton, "Null skeleton");
        if (skeleton.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("This object (" + String.valueOf(this) + ") can process " + this.dimCount + "-dimensional matrices only");
        }
        ArrayList<Matrix<PArray>> shifted = new ArrayList<Matrix<PArray>>();
        shifted.add(skeleton);
        long[] shift = new long[this.dimCount];
        for (long[] apertureOffset : this.neighbourOffsets) {
            for (int k = 0; k < this.dimCount; ++k) {
                shift[k] = -apertureOffset[k];
            }
            shifted.add(Matrices.asShifted(skeleton, shift).cast(PArray.class));
        }
        double[] weights = new double[shifted.size()];
        assert (weights.length <= 31);
        for (int k = 0; k < weights.length; ++k) {
            weights[k] = 1L << k;
        }
        LinearFunc packingShiftedBits = LinearFunc.getInstance(0.0, weights);
        return Matrices.asFuncMatrix((Func)packingShiftedBits, IntArray.class, shifted);
    }

    protected abstract int pixelTypeOrAttachingBranch(int var1);

    protected abstract int pixelTypeOrAttachedNode(int var1);
}

