/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.concurrent.atomic.AtomicLong;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.math.functions.Func;
import net.algart.matrices.spectra.AbstractSpectralTransform;

class Conversions {
    private static final boolean OPTIMIZE_1D_FOURIER_CONVERSION = true;
    private static final boolean OPTIMIZE_2D_FOURIER_CONVERSION = true;
    private static final int BUF_CAP = 8192;

    Conversions() {
    }

    static void separableHartleyToFourierRecoursive(ArrayContext context, long maxTempJavaMemory, UpdatablePNumberArray fRe, UpdatablePNumberArray fIm, PNumberArray hRe, PNumberArray hIm, long[] dimensions, int numberOfTasks) {
        assert (fRe != null && fIm != null && hRe != null);
        long n = dimensions[dimensions.length - 1];
        assert (n >= 0L);
        if (n == 0L) {
            return;
        }
        if (dimensions.length == 1) {
            assert (n == fRe.length());
            if (Conversions.allFloat(fRe, fIm, hRe, hIm)) {
                Conversions.separableHartleyToFourierFloatArray(context, fRe, fIm, hRe, hIm, n);
                return;
            }
            if (Conversions.allDouble(fRe, fIm, hRe, hIm)) {
                Conversions.separableHartleyToFourierDoubleArray(context, fRe, fIm, hRe, hIm, n);
                return;
            }
            Conversions.separableHartleyToFourierArray(context, fRe, fIm, hRe, hIm, n);
            return;
        }
        long nDiv2 = n / 2L;
        long[] layerDims = JArrays.copyOfRange(dimensions, 0, dimensions.length - 1);
        long layerLen = Arrays.longMul(layerDims);
        long totalLen = layerLen * n;
        double layerSize = (double)layerLen * (double)(fRe.bitsPerElement() + fIm.bitsPerElement()) / 8.0;
        long progressMask = layerLen >= 128L ? 255L : (layerLen >= 16L ? 4095L : 65535L);
        boolean fDirect = AbstractSpectralTransform.areDirect(fRe, fIm);
        boolean hDirect = AbstractSpectralTransform.areDirect(hRe, hIm);
        int n2 = numberOfTasks = fDirect && hDirect ? (int)Math.min((long)numberOfTasks, nDiv2 + 1L) : 1;
        SimpleMemoryModel mm = context == null ? Arrays.SMM : (layerSize * (hDirect ? 8.0 * (double)numberOfTasks : (hIm == null ? 10.0 : 12.0)) <= (double)Math.max(maxTempJavaMemory, 0L) ? Arrays.SMM : context.getMemoryModel());
        boolean fast2D = dimensions.length == 2 && (fDirect && hDirect || mm instanceof SimpleMemoryModel) && (Conversions.allFloat(fRe, fIm, hRe, hIm) || Conversions.allDouble(fRe, fIm, hRe, hIm));
        UpdatablePNumberArray hRe1 = hDirect ? null : Conversions.newArr(mm, hRe, layerLen);
        UpdatablePNumberArray hIm1 = hDirect || hIm == null ? null : Conversions.newArr(mm, hIm, layerLen);
        UpdatablePNumberArray hRe2 = hDirect ? null : Conversions.newArr(mm, hRe, layerLen);
        UpdatablePNumberArray hIm2 = hDirect || hIm == null ? null : Conversions.newArr(mm, hIm, layerLen);
        Runnable[] tasks = new Runnable[numberOfTasks];
        AtomicLong readyLayers = new AtomicLong(0L);
        int threadIndex = 0;
        while (threadIndex < tasks.length) {
            UpdatablePNumberArray wRe1 = fast2D && fDirect ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray wIm1 = fast2D && fDirect ? null : Conversions.newArr(mm, fIm, layerLen);
            UpdatablePNumberArray wRe2 = fast2D && fDirect ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray wIm2 = fast2D && fDirect ? null : Conversions.newArr(mm, fIm, layerLen);
            UpdatablePNumberArray sRe = fast2D ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray sIm = fast2D ? null : Conversions.newArr(mm, fIm, layerLen);
            UpdatablePNumberArray dRe = fast2D ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray dIm = fast2D ? null : Conversions.newArr(mm, fIm, layerLen);
            int ti = threadIndex++;
            tasks[ti] = () -> {
                long layerStep = (long)tasks.length * layerLen;
                long k1 = ti;
                long disp1 = (long)ti * layerLen;
                while (k1 <= nDiv2) {
                    long rl;
                    long disp2 = k1 == 0L ? 0L : totalLen - disp1;
                    PNumberArray hRe1Local = Conversions.subArrOrCopy(hDirect ? null : hRe1, hRe, disp1, layerLen);
                    PNumberArray hIm1Local = Conversions.subArrOrCopy(hDirect ? null : hIm1, hIm, disp1, layerLen);
                    PNumberArray hRe2Local = Conversions.subArrOrCopy(hDirect ? null : hRe2, hRe, disp2, layerLen);
                    PNumberArray hIm2Local = Conversions.subArrOrCopy(hDirect ? null : hIm2, hIm, disp2, layerLen);
                    if (fast2D) {
                        if (fDirect) {
                            Conversions.separableHartleyToFourierDirect2D((UpdatablePArray)fRe.subArr(disp1, layerLen), (UpdatablePArray)fIm.subArr(disp1, layerLen), (UpdatablePArray)fRe.subArr(disp2, layerLen), (UpdatablePArray)fIm.subArr(disp2, layerLen), hRe1Local, hIm1Local, hRe2Local, hIm2Local, fRe.elementType());
                        } else {
                            Conversions.separableHartleyToFourierDirect2D(wRe1, wIm1, wRe2, wIm2, hRe1Local, hIm1Local, hRe2Local, hIm2Local, fRe.elementType());
                            fRe.subArr(disp1, layerLen).copy(wRe1);
                            fIm.subArr(disp1, layerLen).copy(wIm1);
                            fRe.subArr(disp2, layerLen).copy(wRe2);
                            fIm.subArr(disp2, layerLen).copy(wIm2);
                        }
                    } else {
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wRe1, wIm1, hRe1Local, hIm1Local, layerDims, 1);
                        Conversions.separableHartleyToFourierRecoursive(null, maxTempJavaMemory, wRe2, wIm2, hRe2Local, hIm2Local, layerDims, 1);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sRe, wRe1, wRe2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sIm, wIm1, wIm2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dRe, wRe1, wRe2);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dIm, wIm1, wIm2);
                        UpdatablePNumberArray fRe1 = (UpdatablePNumberArray)fRe.subArr(disp1, layerLen);
                        UpdatablePNumberArray fIm1 = (UpdatablePNumberArray)fIm.subArr(disp1, layerLen);
                        UpdatablePNumberArray fRe2 = (UpdatablePNumberArray)fRe.subArr(disp2, layerLen);
                        UpdatablePNumberArray fIm2 = (UpdatablePNumberArray)fIm.subArr(disp2, layerLen);
                        Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, fRe1, sRe, dIm);
                        Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, fIm1, sIm, dRe);
                        Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, fRe2, sRe, dIm);
                        Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, fIm2, sIm, dRe);
                    }
                    long l = rl = context == null ? 0L : readyLayers.getAndIncrement();
                    if (context != null && (rl & progressMask) == 0L) {
                        context.checkInterruptionAndUpdateProgress(fRe.elementType(), rl + 1L, nDiv2 + 1L);
                    }
                    k1 += (long)tasks.length;
                    disp1 += layerStep;
                }
            };
        }
        Arrays.getThreadPoolFactory(context).performTasks(tasks);
    }

    static void fourierToSeparableHartleyRecursive(ArrayContext context, long maxTempJavaMemory, UpdatablePNumberArray hRe, UpdatablePNumberArray hIm, PNumberArray fRe, PNumberArray fIm, long[] dimensions, int numberOfTasks) {
        assert (fRe != null && fIm != null && hRe != null);
        long n = dimensions[dimensions.length - 1];
        long nDiv2 = n / 2L;
        assert (n >= 0L);
        if (n == 0L) {
            return;
        }
        if (dimensions.length == 1) {
            assert (n == fRe.length());
            if (Conversions.allFloat(fRe, fIm, hRe, hIm)) {
                Conversions.fourierToSeparableHartleyFloatArray(context, hRe, hIm, fRe, fIm, n);
                return;
            }
            if (Conversions.allDouble(fRe, fIm, hRe, hIm)) {
                Conversions.fourierToSeparableHartleyDoubleArray(context, hRe, hIm, fRe, fIm, n);
                return;
            }
            Conversions.fourierToSeparableHartleyArray(context, hRe, hIm, fRe, fIm, n);
            return;
        }
        long[] layerDims = JArrays.copyOfRange(dimensions, 0, dimensions.length - 1);
        long layerLen = Arrays.longMul(layerDims);
        long totalLen = layerLen * n;
        double layerSize = (double)layerLen * (double)(fRe.bitsPerElement() + fIm.bitsPerElement()) / 8.0;
        long progressMask = layerLen >= 128L ? 255L : (layerLen >= 16L ? 4095L : 65535L);
        boolean fDirect = AbstractSpectralTransform.areDirect(fRe, fIm);
        boolean hDirect = AbstractSpectralTransform.areDirect(hRe, hIm);
        int n2 = numberOfTasks = fDirect && hDirect ? (int)Math.min((long)numberOfTasks, nDiv2 + 1L) : 1;
        SimpleMemoryModel mm = context == null ? Arrays.SMM : (layerSize * (fDirect ? (hIm == null ? 6.0 : 8.0) * (double)numberOfTasks : (hIm == null ? 10.0 : 12.0)) <= (double)Math.max(maxTempJavaMemory, 0L) ? Arrays.SMM : context.getMemoryModel());
        boolean fast2D = dimensions.length == 2 && (fDirect && hDirect || mm instanceof SimpleMemoryModel) && (Conversions.allFloat(fRe, fIm, hRe, hIm) || Conversions.allDouble(fRe, fIm, hRe, hIm));
        UpdatablePNumberArray fRe1 = fDirect ? null : Conversions.newArr(mm, fRe, layerLen);
        UpdatablePNumberArray fIm1 = fDirect ? null : Conversions.newArr(mm, fIm, layerLen);
        UpdatablePNumberArray fRe2 = fDirect ? null : Conversions.newArr(mm, fRe, layerLen);
        UpdatablePNumberArray fIm2 = fDirect ? null : Conversions.newArr(mm, fIm, layerLen);
        Runnable[] tasks = new Runnable[numberOfTasks];
        AtomicLong readyLayers = new AtomicLong(0L);
        int threadIndex = 0;
        while (threadIndex < tasks.length) {
            UpdatablePNumberArray wRe2;
            UpdatablePNumberArray wRe1;
            UpdatablePNumberArray updatablePNumberArray = wRe1 = fast2D && hDirect ? null : Conversions.newArr(mm, hRe, layerLen);
            UpdatablePNumberArray wIm1 = fast2D && hDirect ? null : Conversions.newArr(mm, hIm == null ? hRe : hIm, layerLen);
            UpdatablePNumberArray updatablePNumberArray2 = wRe2 = fast2D && hDirect ? null : Conversions.newArr(mm, hRe, layerLen);
            UpdatablePNumberArray wIm2 = fast2D && hDirect ? null : Conversions.newArr(mm, hIm == null ? hRe : hIm, layerLen);
            UpdatablePNumberArray sRe = fast2D ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray sIm = fast2D || hIm == null ? null : Conversions.newArr(mm, fIm, layerLen);
            UpdatablePNumberArray dRe = fast2D || hIm == null ? null : Conversions.newArr(mm, fRe, layerLen);
            UpdatablePNumberArray dIm = fast2D ? null : Conversions.newArr(mm, fIm, layerLen);
            int ti = threadIndex++;
            tasks[ti] = () -> {
                long layerStep = (long)tasks.length * layerLen;
                long k1 = ti;
                long disp1 = (long)ti * layerLen;
                while (k1 <= nDiv2) {
                    long disp2 = k1 == 0L ? 0L : totalLen - disp1;
                    PNumberArray fRe1Local = Conversions.subArrOrCopy(fDirect ? null : fRe1, fRe, disp1, layerLen);
                    PNumberArray fIm1Local = Conversions.subArrOrCopy(fDirect ? null : fIm1, fIm, disp1, layerLen);
                    PNumberArray fRe2Local = Conversions.subArrOrCopy(fDirect ? null : fRe2, fRe, disp2, layerLen);
                    PNumberArray fIm2Local = Conversions.subArrOrCopy(fDirect ? null : fIm2, fIm, disp2, layerLen);
                    if (fast2D) {
                        if (hDirect) {
                            Conversions.fourierToSeparableHartleyDirect2D((UpdatablePArray)hRe.subArr(disp1, layerLen), (UpdatablePArray)(hIm == null ? null : hIm.subArr(disp1, layerLen)), (UpdatablePArray)hRe.subArr(disp2, layerLen), (UpdatablePArray)(hIm == null ? null : hIm.subArr(disp2, layerLen)), fRe1Local, fIm1Local, fRe2Local, fIm2Local, fRe.elementType());
                        } else {
                            Conversions.fourierToSeparableHartleyDirect2D(wRe1, hIm == null ? null : wIm1, wRe2, hIm == null ? null : wIm2, fRe1Local, fIm1Local, fRe2Local, fIm2Local, fRe.elementType());
                            hRe.subArr(disp1, layerLen).copy(wRe1);
                            hRe.subArr(disp2, layerLen).copy(wRe2);
                            if (hIm != null) {
                                hIm.subArr(disp1, layerLen).copy(wIm1);
                                hIm.subArr(disp2, layerLen).copy(wIm2);
                            }
                        }
                    } else {
                        long rl;
                        Conversions.fourierToSeparableHartleyRecursive(null, maxTempJavaMemory, wRe1, wIm1, fRe1Local, fIm1Local, layerDims, 1);
                        Conversions.fourierToSeparableHartleyRecursive(null, maxTempJavaMemory, wRe2, wIm2, fRe2Local, fIm2Local, layerDims, 1);
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sRe, wRe1, wRe2);
                        if (hIm != null) {
                            Arrays.applyFunc(null, false, 1, true, Func.HALF_X_PLUS_Y, sIm, wIm1, wIm2);
                            Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dRe, wRe1, wRe2);
                        }
                        Arrays.applyFunc(null, false, 1, true, Func.HALF_X_MINUS_Y, dIm, wIm1, wIm2);
                        Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, (UpdatablePArray)hRe.subArr(disp1, layerLen), sRe, dIm);
                        if (hIm != null) {
                            Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, (UpdatablePArray)hIm.subArr(disp1, layerLen), sIm, dRe);
                        }
                        Arrays.applyFunc(null, false, 1, true, Func.X_PLUS_Y, (UpdatablePArray)hRe.subArr(disp2, layerLen), sRe, dIm);
                        if (hIm != null) {
                            Arrays.applyFunc(null, false, 1, true, Func.X_MINUS_Y, (UpdatablePArray)hIm.subArr(disp2, layerLen), sIm, dRe);
                        }
                        long l = rl = context == null ? 0L : readyLayers.getAndIncrement();
                        if (context != null && (rl & progressMask) == 0L) {
                            context.checkInterruptionAndUpdateProgress(fRe.elementType(), rl + 1L, nDiv2 + 1L);
                        }
                    }
                    k1 += (long)tasks.length;
                    disp1 += layerStep;
                }
            };
        }
        Arrays.getThreadPoolFactory(context).performTasks(tasks);
    }

    static boolean allFloat(PArray ... arrays) {
        for (PArray array : arrays) {
            if (array == null || array instanceof FloatArray) continue;
            return false;
        }
        return true;
    }

    static boolean allDouble(PArray ... arrays) {
        for (PArray array : arrays) {
            if (array == null || array instanceof DoubleArray) continue;
            return false;
        }
        return true;
    }

    static UpdatablePNumberArray newArr(MemoryModel mm, PNumberArray example, long length) {
        return (UpdatablePNumberArray)mm.newUnresizableArray(example.elementType(), length);
    }

    static PNumberArray subArrOrCopy(UpdatablePNumberArray dest, PNumberArray src, long position, long count) {
        if (src == null) {
            return null;
        }
        if (dest == null) {
            return (PNumberArray)src.subArr(position, count);
        }
        dest.copy(src.subArr(position, count));
        return dest;
    }

    private static void separableHartleyToFourierArray(ArrayContext context, UpdatablePNumberArray fRe, UpdatablePNumberArray fIm, PNumberArray hRe, PNumberArray hIm, long n) {
        fRe.setDouble(0L, hRe.getDouble(0L));
        fIm.setDouble(0L, hIm == null ? 0.0 : hIm.getDouble(0L));
        long nDiv2 = n / 2L;
        for (long k1 = 1L; k1 <= nDiv2; ++k1) {
            long k2 = n - k1;
            double hRe1 = hRe.getDouble(k1);
            double hRe2 = hRe.getDouble(k2);
            if (hIm == null) {
                double s = 0.5 * (hRe1 + hRe2);
                double d = 0.5 * (hRe1 - hRe2);
                fRe.setDouble(k1, s);
                fIm.setDouble(k1, -d);
                fRe.setDouble(k2, s);
                fIm.setDouble(k2, d);
            } else {
                double hIm1 = hIm.getDouble(k1);
                double hIm2 = hIm.getDouble(k2);
                double sRe = 0.5 * (hRe1 + hRe2);
                double sIm = 0.5 * (hIm1 + hIm2);
                double dRe = 0.5 * (hRe1 - hRe2);
                double dIm = 0.5 * (hIm1 - hIm2);
                fRe.setDouble(k1, sRe + dIm);
                fIm.setDouble(k1, sIm - dRe);
                fRe.setDouble(k2, sRe - dIm);
                fIm.setDouble(k2, sIm + dRe);
            }
            if (context == null || (k1 & 0xFFFFL) != 0L) continue;
            context.checkInterruptionAndUpdateProgress(fRe.elementType(), k1 + 1L, nDiv2 + 1L);
        }
    }

    private static void separableHartleyToFourierDirect2D(UpdatablePArray fRe1, UpdatablePArray fIm1, UpdatablePArray fRe2, UpdatablePArray fIm2, PArray hRe1, PArray hIm1, PArray hRe2, PArray hIm2, Class<?> elementType) {
        if (elementType == Float.TYPE) {
            Conversions.separableHartleyToFourierDirect2DFloat((DirectAccessible)((Object)fRe1), (DirectAccessible)((Object)fIm1), (DirectAccessible)((Object)fRe2), (DirectAccessible)((Object)fIm2), (DirectAccessible)((Object)hRe1), (DirectAccessible)((Object)hIm1), (DirectAccessible)((Object)hRe2), (DirectAccessible)((Object)hIm2));
        } else if (elementType == Double.TYPE) {
            Conversions.separableHartleyToFourierDirect2DDouble((DirectAccessible)((Object)fRe1), (DirectAccessible)((Object)fIm1), (DirectAccessible)((Object)fRe2), (DirectAccessible)((Object)fIm2), (DirectAccessible)((Object)hRe1), (DirectAccessible)((Object)hIm1), (DirectAccessible)((Object)hRe2), (DirectAccessible)((Object)hIm2));
        } else {
            throw new AssertionError((Object)"Unsupported element type for 2D optimization");
        }
    }

    private static void separableHartleyToFourierFloatArray(ArrayContext context, UpdatablePNumberArray fRe, UpdatablePNumberArray fIm, PNumberArray hRe, PNumberArray hIm, long n) {
        block15: {
            assert (n > 0L);
            fRe.setDouble(0L, hRe.getDouble(0L));
            fIm.setDouble(0L, hIm == null ? 0.0 : hIm.getDouble(0L));
            if (n == 1L) {
                return;
            }
            DataFloatBuffer fReBuf1 = (DataFloatBuffer)fRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer fReBuf2 = (DataFloatBuffer)fRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer fImBuf1 = (DataFloatBuffer)fIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer fImBuf2 = (DataFloatBuffer)fIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer hReBuf1 = (DataFloatBuffer)hRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer hReBuf2 = (DataFloatBuffer)hRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer hImBuf1 = hIm == null ? null : (DataFloatBuffer)hIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer hImBuf2 = hIm == null ? null : (DataFloatBuffer)hIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "sh2f bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                fReBuf1.map(disp1, len);
                fReBuf2.map(disp2, len);
                fImBuf1.map(disp1, len);
                fImBuf2.map(disp2, len);
                hReBuf1.map(disp1, len);
                hReBuf2.map(disp2, len);
                if (hIm != null) {
                    hImBuf1.map(disp1, len);
                    hImBuf2.map(disp2, len);
                }
                float[] fReJA1 = fReBuf1.data();
                float[] fReJA2 = fReBuf2.data();
                float[] fImJA1 = fImBuf1.data();
                float[] fImJA2 = fImBuf2.data();
                float[] hReJA1 = hReBuf1.data();
                float[] hReJA2 = hReBuf2.data();
                float[] hImJA1 = hIm == null ? null : hImBuf1.data();
                float[] hImJA2 = hIm == null ? null : hImBuf2.data();
                int fReOfs1 = fReBuf1.from();
                int fReOfs2 = fReBuf2.from();
                int fImOfs1 = fImBuf1.from();
                int fImOfs2 = fImBuf2.from();
                int hReOfs1 = hReBuf1.from();
                int hReOfs2 = hReBuf2.from();
                int hImOfs1 = hIm == null ? 0 : hImBuf1.from();
                int hImOfs2 = hIm == null ? 0 : hImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double hRe1 = hReJA1[hReOfs1 + k1];
                    double hRe2 = hReJA2[hReOfs2 + k2];
                    if (hIm == null) {
                        double s = 0.5 * (hRe1 + hRe2);
                        double d = 0.5 * (hRe1 - hRe2);
                        fReJA1[fReOfs1 + k1] = (float)s;
                        fImJA1[fReOfs1 + k1] = (float)(-d);
                        fReJA2[fReOfs2 + k2] = (float)s;
                        fImJA2[fReOfs2 + k2] = (float)d;
                        continue;
                    }
                    double hIm1 = hImJA1[hImOfs1 + k1];
                    double hIm2 = hImJA2[hImOfs2 + k2];
                    double sRe = 0.5 * (hRe1 + hRe2);
                    double sIm = 0.5 * (hIm1 + hIm2);
                    double dRe = 0.5 * (hRe1 - hRe2);
                    double dIm = 0.5 * (hIm1 - hIm2);
                    fReJA1[fReOfs1 + k1] = (float)(sRe + dIm);
                    fImJA1[fImOfs1 + k1] = (float)(sIm - dRe);
                    fReJA2[fReOfs2 + k2] = (float)(sRe - dIm);
                    fImJA2[fImOfs2 + k2] = (float)(sIm + dRe);
                }
                count += disp1 + (long)len == disp2 + 1L ? 2L * (long)len - 1L : 2L * (long)len;
                fReBuf1.force();
                fImBuf1.force();
                fReBuf2.force();
                fImBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(fRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block15;
                }
                if (disp2 - disp1 >= 3L * (long)len) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "sh2f bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("sh2f bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleyToFourierDirect2DFloat(DirectAccessible fRe1, DirectAccessible fIm1, DirectAccessible fRe2, DirectAccessible fIm2, DirectAccessible hRe1, DirectAccessible hIm1, DirectAccessible hRe2, DirectAccessible hIm2) {
        assert (hIm1 == null == (hIm2 == null));
        float[] fReJA1 = (float[])fRe1.javaArray();
        float[] fReJA2 = (float[])fRe2.javaArray();
        float[] fImJA1 = (float[])fIm1.javaArray();
        float[] fImJA2 = (float[])fIm2.javaArray();
        float[] hReJA1 = (float[])hRe1.javaArray();
        float[] hReJA2 = (float[])hRe2.javaArray();
        float[] hImJA1 = hIm1 == null ? null : (float[])hIm1.javaArray();
        float[] hImJA2 = hIm2 == null ? null : (float[])hIm2.javaArray();
        int fReOfs1 = fRe1.javaArrayOffset();
        int fReOfs2 = fRe2.javaArrayOffset();
        int fImOfs1 = fIm1.javaArrayOffset();
        int fImOfs2 = fIm2.javaArrayOffset();
        int hReOfs1 = hRe1.javaArrayOffset();
        int hReOfs2 = hRe2.javaArrayOffset();
        int hImOfs1 = hIm1 == null ? 0 : hIm1.javaArrayOffset();
        int hImOfs2 = hIm2 == null ? 0 : hIm2.javaArrayOffset();
        int n = fRe1.javaArrayLength();
        assert (fRe2.javaArrayLength() == n);
        assert (fIm1.javaArrayLength() == n);
        assert (fIm2.javaArrayLength() == n);
        assert (hRe1.javaArrayLength() == n);
        assert (hRe2.javaArrayLength() == n);
        assert (hIm1 == null || hIm1.javaArrayLength() == n);
        assert (hIm2 == null || hIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double hLRe1 = hReJA1[hReOfs1 + kL];
            double hRRe1 = hReJA1[hReOfs1 + kR];
            double hLRe2 = hReJA2[hReOfs2 + kL];
            double hRRe2 = hReJA2[hReOfs2 + kR];
            if (hIm1 == null) {
                double s12 = 0.5 * (hLRe1 + hRRe2);
                double s21 = 0.5 * (hLRe2 + hRRe1);
                double d12 = 0.5 * (hLRe1 - hRRe2);
                double d21 = 0.5 * (hLRe2 - hRRe1);
                fReJA1[fReOfs1 + kL] = (float)s21;
                fImJA1[fImOfs1 + kL] = (float)(-d12);
                fReJA1[fReOfs1 + kR] = (float)s12;
                fImJA1[fImOfs1 + kR] = (float)d21;
                fReJA2[fReOfs2 + kL] = (float)s12;
                fImJA2[fImOfs2 + kL] = (float)(-d21);
                fReJA2[fReOfs2 + kR] = (float)s21;
                fImJA2[fImOfs2 + kR] = (float)d12;
                continue;
            }
            double hLIm1 = hImJA1[hImOfs1 + kL];
            double hRIm1 = hImJA1[hImOfs1 + kR];
            double hLIm2 = hImJA2[hImOfs2 + kL];
            double hRIm2 = hImJA2[hImOfs2 + kR];
            double sRe12 = 0.5 * (hLRe1 + hRRe2);
            double sIm12 = 0.5 * (hLIm1 + hRIm2);
            double sRe21 = 0.5 * (hLRe2 + hRRe1);
            double sIm21 = 0.5 * (hLIm2 + hRIm1);
            double dRe12 = 0.5 * (hLRe1 - hRRe2);
            double dIm12 = 0.5 * (hLIm1 - hRIm2);
            double dRe21 = 0.5 * (hLRe2 - hRRe1);
            double dIm21 = 0.5 * (hLIm2 - hRIm1);
            fReJA1[fReOfs1 + kL] = (float)(sRe21 + dIm12);
            fImJA1[fImOfs1 + kL] = (float)(sIm21 - dRe12);
            fReJA1[fReOfs1 + kR] = (float)(sRe12 - dIm21);
            fImJA1[fImOfs1 + kR] = (float)(sIm12 + dRe21);
            fReJA2[fReOfs2 + kL] = (float)(sRe12 + dIm21);
            fImJA2[fImOfs2 + kL] = (float)(sIm12 - dRe21);
            fReJA2[fReOfs2 + kR] = (float)(sRe21 - dIm12);
            fImJA2[fImOfs2 + kR] = (float)(sIm21 + dRe12);
        }
    }

    private static void separableHartleyToFourierDoubleArray(ArrayContext context, UpdatablePNumberArray fRe, UpdatablePNumberArray fIm, PNumberArray hRe, PNumberArray hIm, long n) {
        block15: {
            assert (n > 0L);
            fRe.setDouble(0L, hRe.getDouble(0L));
            fIm.setDouble(0L, hIm == null ? 0.0 : hIm.getDouble(0L));
            if (n == 1L) {
                return;
            }
            DataDoubleBuffer fReBuf1 = (DataDoubleBuffer)fRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer fReBuf2 = (DataDoubleBuffer)fRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer fImBuf1 = (DataDoubleBuffer)fIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer fImBuf2 = (DataDoubleBuffer)fIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer hReBuf1 = (DataDoubleBuffer)hRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer hReBuf2 = (DataDoubleBuffer)hRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer hImBuf1 = hIm == null ? null : (DataDoubleBuffer)hIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer hImBuf2 = hIm == null ? null : (DataDoubleBuffer)hIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "sh2f bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                fReBuf1.map(disp1, len);
                fReBuf2.map(disp2, len);
                fImBuf1.map(disp1, len);
                fImBuf2.map(disp2, len);
                hReBuf1.map(disp1, len);
                hReBuf2.map(disp2, len);
                if (hIm != null) {
                    hImBuf1.map(disp1, len);
                    hImBuf2.map(disp2, len);
                }
                double[] fReJA1 = fReBuf1.data();
                double[] fReJA2 = fReBuf2.data();
                double[] fImJA1 = fImBuf1.data();
                double[] fImJA2 = fImBuf2.data();
                double[] hReJA1 = hReBuf1.data();
                double[] hReJA2 = hReBuf2.data();
                double[] hImJA1 = hIm == null ? null : hImBuf1.data();
                double[] hImJA2 = hIm == null ? null : hImBuf2.data();
                int fReOfs1 = fReBuf1.from();
                int fReOfs2 = fReBuf2.from();
                int fImOfs1 = fImBuf1.from();
                int fImOfs2 = fImBuf2.from();
                int hReOfs1 = hReBuf1.from();
                int hReOfs2 = hReBuf2.from();
                int hImOfs1 = hIm == null ? 0 : hImBuf1.from();
                int hImOfs2 = hIm == null ? 0 : hImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double hRe1 = hReJA1[hReOfs1 + k1];
                    double hRe2 = hReJA2[hReOfs2 + k2];
                    if (hIm == null) {
                        double s = 0.5 * (hRe1 + hRe2);
                        double d = 0.5 * (hRe1 - hRe2);
                        fReJA1[fReOfs1 + k1] = s;
                        fImJA1[fReOfs1 + k1] = -d;
                        fReJA2[fReOfs2 + k2] = s;
                        fImJA2[fReOfs2 + k2] = d;
                        continue;
                    }
                    double hIm1 = hImJA1[hImOfs1 + k1];
                    double hIm2 = hImJA2[hImOfs2 + k2];
                    double sRe = 0.5 * (hRe1 + hRe2);
                    double sIm = 0.5 * (hIm1 + hIm2);
                    double dRe = 0.5 * (hRe1 - hRe2);
                    double dIm = 0.5 * (hIm1 - hIm2);
                    fReJA1[fReOfs1 + k1] = sRe + dIm;
                    fImJA1[fImOfs1 + k1] = sIm - dRe;
                    fReJA2[fReOfs2 + k2] = sRe - dIm;
                    fImJA2[fImOfs2 + k2] = sIm + dRe;
                }
                count += disp1 + (long)len == disp2 + 1L ? 2L * (long)len - 1L : 2L * (long)len;
                fReBuf1.force();
                fImBuf1.force();
                fReBuf2.force();
                fImBuf2.force();
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(fRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block15;
                }
                if (disp2 - disp1 >= 3L * (long)len) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "sh2f bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("sh2f bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void separableHartleyToFourierDirect2DDouble(DirectAccessible fRe1, DirectAccessible fIm1, DirectAccessible fRe2, DirectAccessible fIm2, DirectAccessible hRe1, DirectAccessible hIm1, DirectAccessible hRe2, DirectAccessible hIm2) {
        assert (hIm1 == null == (hIm2 == null));
        double[] fReJA1 = (double[])fRe1.javaArray();
        double[] fReJA2 = (double[])fRe2.javaArray();
        double[] fImJA1 = (double[])fIm1.javaArray();
        double[] fImJA2 = (double[])fIm2.javaArray();
        double[] hReJA1 = (double[])hRe1.javaArray();
        double[] hReJA2 = (double[])hRe2.javaArray();
        double[] hImJA1 = hIm1 == null ? null : (double[])hIm1.javaArray();
        double[] hImJA2 = hIm2 == null ? null : (double[])hIm2.javaArray();
        int fReOfs1 = fRe1.javaArrayOffset();
        int fReOfs2 = fRe2.javaArrayOffset();
        int fImOfs1 = fIm1.javaArrayOffset();
        int fImOfs2 = fIm2.javaArrayOffset();
        int hReOfs1 = hRe1.javaArrayOffset();
        int hReOfs2 = hRe2.javaArrayOffset();
        int hImOfs1 = hIm1 == null ? 0 : hIm1.javaArrayOffset();
        int hImOfs2 = hIm2 == null ? 0 : hIm2.javaArrayOffset();
        int n = fRe1.javaArrayLength();
        assert (fRe2.javaArrayLength() == n);
        assert (fIm1.javaArrayLength() == n);
        assert (fIm2.javaArrayLength() == n);
        assert (hRe1.javaArrayLength() == n);
        assert (hRe2.javaArrayLength() == n);
        assert (hIm1 == null || hIm1.javaArrayLength() == n);
        assert (hIm2 == null || hIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double hLRe1 = hReJA1[hReOfs1 + kL];
            double hRRe1 = hReJA1[hReOfs1 + kR];
            double hLRe2 = hReJA2[hReOfs2 + kL];
            double hRRe2 = hReJA2[hReOfs2 + kR];
            if (hIm1 == null) {
                double s12 = 0.5 * (hLRe1 + hRRe2);
                double s21 = 0.5 * (hLRe2 + hRRe1);
                double d12 = 0.5 * (hLRe1 - hRRe2);
                double d21 = 0.5 * (hLRe2 - hRRe1);
                fReJA1[fReOfs1 + kL] = s21;
                fImJA1[fImOfs1 + kL] = -d12;
                fReJA1[fReOfs1 + kR] = s12;
                fImJA1[fImOfs1 + kR] = d21;
                fReJA2[fReOfs2 + kL] = s12;
                fImJA2[fImOfs2 + kL] = -d21;
                fReJA2[fReOfs2 + kR] = s21;
                fImJA2[fImOfs2 + kR] = d12;
                continue;
            }
            double hLIm1 = hImJA1[hImOfs1 + kL];
            double hRIm1 = hImJA1[hImOfs1 + kR];
            double hLIm2 = hImJA2[hImOfs2 + kL];
            double hRIm2 = hImJA2[hImOfs2 + kR];
            double sRe12 = 0.5 * (hLRe1 + hRRe2);
            double sIm12 = 0.5 * (hLIm1 + hRIm2);
            double sRe21 = 0.5 * (hLRe2 + hRRe1);
            double sIm21 = 0.5 * (hLIm2 + hRIm1);
            double dRe12 = 0.5 * (hLRe1 - hRRe2);
            double dIm12 = 0.5 * (hLIm1 - hRIm2);
            double dRe21 = 0.5 * (hLRe2 - hRRe1);
            double dIm21 = 0.5 * (hLIm2 - hRIm1);
            fReJA1[fReOfs1 + kL] = sRe21 + dIm12;
            fImJA1[fImOfs1 + kL] = sIm21 - dRe12;
            fReJA1[fReOfs1 + kR] = sRe12 - dIm21;
            fImJA1[fImOfs1 + kR] = sIm12 + dRe21;
            fReJA2[fReOfs2 + kL] = sRe12 + dIm21;
            fImJA2[fImOfs2 + kL] = sIm12 - dRe21;
            fReJA2[fReOfs2 + kR] = sRe21 - dIm12;
            fImJA2[fImOfs2 + kR] = sIm21 + dRe12;
        }
    }

    private static void fourierToSeparableHartleyArray(ArrayContext context, UpdatablePNumberArray hRe, UpdatablePNumberArray hIm, PNumberArray fRe, PNumberArray fIm, long n) {
        hRe.setDouble(0L, fRe.getDouble(0L));
        if (hIm != null) {
            hIm.setDouble(0L, fIm.getDouble(0L));
        }
        long nDiv2 = n / 2L;
        for (long k1 = 1L; k1 <= nDiv2; ++k1) {
            long k2 = n - k1;
            double fRe1 = fRe.getDouble(k1);
            double fRe2 = fRe.getDouble(k2);
            double fIm1 = fIm.getDouble(k1);
            double fIm2 = fIm.getDouble(k2);
            double sRe = 0.5 * (fRe1 + fRe2);
            double sIm = 0.5 * (fIm1 + fIm2);
            double dRe = 0.5 * (fRe1 - fRe2);
            double dIm = 0.5 * (fIm1 - fIm2);
            hRe.setDouble(k1, sRe - dIm);
            hRe.setDouble(k2, sRe + dIm);
            if (hIm != null) {
                hIm.setDouble(k1, sIm + dRe);
                hIm.setDouble(k2, sIm - dRe);
            }
            if (context == null || (k1 & 0xFFFFL) != 0L) continue;
            context.checkInterruptionAndUpdateProgress(fRe.elementType(), k1 + 1L, nDiv2 + 1L);
        }
    }

    private static void fourierToSeparableHartleyDirect2D(UpdatablePArray hRe1, UpdatablePArray hIm1, UpdatablePArray hRe2, UpdatablePArray hIm2, PArray fRe1, PArray fIm1, PArray fRe2, PArray fIm2, Class<?> elementType) {
        if (elementType == Float.TYPE) {
            Conversions.fourierToSeparableHartleyDirect2DFloat((DirectAccessible)((Object)hRe1), (DirectAccessible)((Object)hIm1), (DirectAccessible)((Object)hRe2), (DirectAccessible)((Object)hIm2), (DirectAccessible)((Object)fRe1), (DirectAccessible)((Object)fIm1), (DirectAccessible)((Object)fRe2), (DirectAccessible)((Object)fIm2));
        } else if (elementType == Double.TYPE) {
            Conversions.fourierToSeparableHartleyDirect2DDouble((DirectAccessible)((Object)hRe1), (DirectAccessible)((Object)hIm1), (DirectAccessible)((Object)hRe2), (DirectAccessible)((Object)hIm2), (DirectAccessible)((Object)fRe1), (DirectAccessible)((Object)fIm1), (DirectAccessible)((Object)fRe2), (DirectAccessible)((Object)fIm2));
        } else {
            throw new AssertionError((Object)"Unsupported element type for 2D optimization");
        }
    }

    private static void fourierToSeparableHartleyFloatArray(ArrayContext context, UpdatablePNumberArray hRe, UpdatablePNumberArray hIm, PNumberArray fRe, PNumberArray fIm, long n) {
        block17: {
            assert (n > 0L);
            hRe.setDouble(0L, fRe.getDouble(0L));
            if (hIm != null) {
                hIm.setDouble(0L, fIm.getDouble(0L));
            }
            if (n == 1L) {
                return;
            }
            DataFloatBuffer hReBuf1 = (DataFloatBuffer)hRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer hReBuf2 = (DataFloatBuffer)hRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer hImBuf1 = hIm == null ? null : (DataFloatBuffer)hIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer hImBuf2 = hIm == null ? null : (DataFloatBuffer)hIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataFloatBuffer fReBuf1 = (DataFloatBuffer)fRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer fReBuf2 = (DataFloatBuffer)fRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer fImBuf1 = (DataFloatBuffer)fIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataFloatBuffer fImBuf2 = (DataFloatBuffer)fIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "f2sh bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                hReBuf1.map(disp1, len);
                hReBuf2.map(disp2, len);
                if (hIm != null) {
                    hImBuf1.map(disp1, len);
                    hImBuf2.map(disp2, len);
                }
                fReBuf1.map(disp1, len);
                fReBuf2.map(disp2, len);
                fImBuf1.map(disp1, len);
                fImBuf2.map(disp2, len);
                float[] hReJA1 = hReBuf1.data();
                float[] hReJA2 = hReBuf2.data();
                float[] hImJA1 = hIm == null ? null : hImBuf1.data();
                float[] hImJA2 = hIm == null ? null : hImBuf2.data();
                float[] fReJA1 = fReBuf1.data();
                float[] fReJA2 = fReBuf2.data();
                float[] fImJA1 = fImBuf1.data();
                float[] fImJA2 = fImBuf2.data();
                int hReOfs1 = hReBuf1.from();
                int hReOfs2 = hReBuf2.from();
                int hImOfs1 = hIm == null ? 0 : hImBuf1.from();
                int hImOfs2 = hIm == null ? 0 : hImBuf2.from();
                int fReOfs1 = fReBuf1.from();
                int fReOfs2 = fReBuf2.from();
                int fImOfs1 = fImBuf1.from();
                int fImOfs2 = fImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double fRe1 = fReJA1[fReOfs1 + k1];
                    double fRe2 = fReJA2[fReOfs2 + k2];
                    double fIm1 = fImJA1[fImOfs1 + k1];
                    double fIm2 = fImJA2[fImOfs2 + k2];
                    double sRe = 0.5 * (fRe1 + fRe2);
                    double sIm = 0.5 * (fIm1 + fIm2);
                    double dRe = 0.5 * (fRe1 - fRe2);
                    double dIm = 0.5 * (fIm1 - fIm2);
                    hReJA1[hReOfs1 + k1] = (float)(sRe - dIm);
                    hReJA2[hReOfs2 + k2] = (float)(sRe + dIm);
                    if (hIm == null) continue;
                    hImJA1[hImOfs1 + k1] = (float)(sIm + dRe);
                    hImJA2[hImOfs2 + k2] = (float)(sIm - dRe);
                }
                count += disp1 + (long)len == disp2 + 1L ? 2L * (long)len - 1L : 2L * (long)len;
                hReBuf1.force();
                if (hIm != null) {
                    hImBuf1.force();
                }
                hReBuf2.force();
                if (hIm != null) {
                    hImBuf2.force();
                }
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(fRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block17;
                }
                if (disp2 - disp1 >= 3L * (long)len) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "f2sh bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("f2sh bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void fourierToSeparableHartleyDirect2DFloat(DirectAccessible hRe1, DirectAccessible hIm1, DirectAccessible hRe2, DirectAccessible hIm2, DirectAccessible fRe1, DirectAccessible fIm1, DirectAccessible fRe2, DirectAccessible fIm2) {
        assert (hIm1 == null == (hIm2 == null));
        float[] hReJA1 = (float[])hRe1.javaArray();
        float[] hReJA2 = (float[])hRe2.javaArray();
        float[] hImJA1 = hIm1 == null ? null : (float[])hIm1.javaArray();
        float[] hImJA2 = hIm2 == null ? null : (float[])hIm2.javaArray();
        float[] fReJA1 = (float[])fRe1.javaArray();
        float[] fReJA2 = (float[])fRe2.javaArray();
        float[] fImJA1 = (float[])fIm1.javaArray();
        float[] fImJA2 = (float[])fIm2.javaArray();
        int hReOfs1 = hRe1.javaArrayOffset();
        int hReOfs2 = hRe2.javaArrayOffset();
        int hImOfs1 = hIm1 == null ? 0 : hIm1.javaArrayOffset();
        int hImOfs2 = hIm2 == null ? 0 : hIm2.javaArrayOffset();
        int fReOfs1 = fRe1.javaArrayOffset();
        int fReOfs2 = fRe2.javaArrayOffset();
        int fImOfs1 = fIm1.javaArrayOffset();
        int fImOfs2 = fIm2.javaArrayOffset();
        int n = fRe1.javaArrayLength();
        assert (fRe2.javaArrayLength() == n);
        assert (fIm1.javaArrayLength() == n);
        assert (fIm2.javaArrayLength() == n);
        assert (hRe1.javaArrayLength() == n);
        assert (hRe2.javaArrayLength() == n);
        assert (hIm1 == null || hIm1.javaArrayLength() == n);
        assert (hIm2 == null || hIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double fLRe1 = fReJA1[fReOfs1 + kL];
            double fRRe1 = fReJA1[fReOfs1 + kR];
            double fLRe2 = fReJA2[fReOfs2 + kL];
            double fRRe2 = fReJA2[fReOfs2 + kR];
            double fLIm1 = fImJA1[fImOfs1 + kL];
            double fRIm1 = fImJA1[fImOfs1 + kR];
            double fLIm2 = fImJA2[fImOfs2 + kL];
            double fRIm2 = fImJA2[fImOfs2 + kR];
            double sRe12 = 0.5 * (fLRe1 + fRRe2);
            double sIm12 = 0.5 * (fLIm1 + fRIm2);
            double sRe21 = 0.5 * (fLRe2 + fRRe1);
            double sIm21 = 0.5 * (fLIm2 + fRIm1);
            double dRe12 = 0.5 * (fLRe1 - fRRe2);
            double dIm12 = 0.5 * (fLIm1 - fRIm2);
            double dRe21 = 0.5 * (fLRe2 - fRRe1);
            double dIm21 = 0.5 * (fLIm2 - fRIm1);
            hReJA1[hReOfs1 + kL] = (float)(sRe21 - dIm12);
            hReJA1[hReOfs1 + kR] = (float)(sRe12 + dIm21);
            hReJA2[hReOfs2 + kL] = (float)(sRe12 - dIm21);
            hReJA2[hReOfs2 + kR] = (float)(sRe21 + dIm12);
            if (hIm1 == null) continue;
            hImJA1[hImOfs1 + kL] = (float)(sIm21 + dRe12);
            hImJA1[hImOfs1 + kR] = (float)(sIm12 - dRe21);
            hImJA2[hImOfs2 + kL] = (float)(sIm12 + dRe21);
            hImJA2[hImOfs2 + kR] = (float)(sIm21 - dRe12);
        }
    }

    private static void fourierToSeparableHartleyDoubleArray(ArrayContext context, UpdatablePNumberArray hRe, UpdatablePNumberArray hIm, PNumberArray fRe, PNumberArray fIm, long n) {
        block17: {
            assert (n > 0L);
            hRe.setDouble(0L, fRe.getDouble(0L));
            if (hIm != null) {
                hIm.setDouble(0L, fIm.getDouble(0L));
            }
            if (n == 1L) {
                return;
            }
            DataDoubleBuffer hReBuf1 = (DataDoubleBuffer)hRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer hReBuf2 = (DataDoubleBuffer)hRe.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer hImBuf1 = hIm == null ? null : (DataDoubleBuffer)hIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer hImBuf2 = hIm == null ? null : (DataDoubleBuffer)hIm.buffer(DataBuffer.AccessMode.READ_WRITE, 8192L);
            DataDoubleBuffer fReBuf1 = (DataDoubleBuffer)fRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer fReBuf2 = (DataDoubleBuffer)fRe.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer fImBuf1 = (DataDoubleBuffer)fIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            DataDoubleBuffer fImBuf2 = (DataDoubleBuffer)fIm.buffer(DataBuffer.AccessMode.READ, 8192L);
            int len = (int)Math.min(8192L, (n + 1L) / 2L);
            long disp1 = 1L;
            long disp2 = n - (long)len;
            long count = 0L;
            while (true) {
                assert (len >= 1);
                assert (disp1 >= 1L);
                assert (disp1 + (long)len <= ((n & 1L) == 0L ? disp2 + 1L : disp2)) : "f2sh bug 1: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                assert (disp2 + (long)len <= n);
                hReBuf1.map(disp1, len);
                hReBuf2.map(disp2, len);
                if (hIm != null) {
                    hImBuf1.map(disp1, len);
                    hImBuf2.map(disp2, len);
                }
                fReBuf1.map(disp1, len);
                fReBuf2.map(disp2, len);
                fImBuf1.map(disp1, len);
                fImBuf2.map(disp2, len);
                double[] hReJA1 = hReBuf1.data();
                double[] hReJA2 = hReBuf2.data();
                double[] hImJA1 = hIm == null ? null : hImBuf1.data();
                double[] hImJA2 = hIm == null ? null : hImBuf2.data();
                double[] fReJA1 = fReBuf1.data();
                double[] fReJA2 = fReBuf2.data();
                double[] fImJA1 = fImBuf1.data();
                double[] fImJA2 = fImBuf2.data();
                int hReOfs1 = hReBuf1.from();
                int hReOfs2 = hReBuf2.from();
                int hImOfs1 = hIm == null ? 0 : hImBuf1.from();
                int hImOfs2 = hIm == null ? 0 : hImBuf2.from();
                int fReOfs1 = fReBuf1.from();
                int fReOfs2 = fReBuf2.from();
                int fImOfs1 = fImBuf1.from();
                int fImOfs2 = fImBuf2.from();
                for (int k1 = 0; k1 < len; ++k1) {
                    int k2 = len - 1 - k1;
                    double fRe1 = fReJA1[fReOfs1 + k1];
                    double fRe2 = fReJA2[fReOfs2 + k2];
                    double fIm1 = fImJA1[fImOfs1 + k1];
                    double fIm2 = fImJA2[fImOfs2 + k2];
                    double sRe = 0.5 * (fRe1 + fRe2);
                    double sIm = 0.5 * (fIm1 + fIm2);
                    double dRe = 0.5 * (fRe1 - fRe2);
                    double dIm = 0.5 * (fIm1 - fIm2);
                    hReJA1[hReOfs1 + k1] = sRe - dIm;
                    hReJA2[hReOfs2 + k2] = sRe + dIm;
                    if (hIm == null) continue;
                    hImJA1[hImOfs1 + k1] = sIm + dRe;
                    hImJA2[hImOfs2 + k2] = sIm - dRe;
                }
                count += disp1 + (long)len == disp2 + 1L ? 2L * (long)len - 1L : 2L * (long)len;
                hReBuf1.force();
                if (hIm != null) {
                    hImBuf1.force();
                }
                hReBuf2.force();
                if (hIm != null) {
                    hImBuf2.force();
                }
                if (context != null) {
                    context.checkInterruptionAndUpdateProgress(fRe.elementType(), count, n);
                }
                if (disp1 + (long)len >= disp2) {
                    assert (disp1 + (long)len == disp2 || disp1 + (long)len == disp2 + 1L);
                    break block17;
                }
                if (disp2 - disp1 >= 3L * (long)len) {
                    disp1 += (long)len;
                    disp2 -= (long)len;
                    continue;
                }
                len = (int)((disp2 - (disp1 += (long)len) + 1L) / 2L);
                assert (len > 0) : "f2sh bug 2: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n;
                if (!$assertionsDisabled && disp1 + (long)len != (disp2 -= (long)len) && disp1 + (long)len != disp2 + 1L) break;
            }
            throw new AssertionError((Object)("f2sh bug 3: disp1=" + disp1 + ", disp2=" + disp2 + ", len=" + len + ", n=" + n));
        }
    }

    private static void fourierToSeparableHartleyDirect2DDouble(DirectAccessible hRe1, DirectAccessible hIm1, DirectAccessible hRe2, DirectAccessible hIm2, DirectAccessible fRe1, DirectAccessible fIm1, DirectAccessible fRe2, DirectAccessible fIm2) {
        assert (hIm1 == null == (hIm2 == null));
        double[] hReJA1 = (double[])hRe1.javaArray();
        double[] hReJA2 = (double[])hRe2.javaArray();
        double[] hImJA1 = hIm1 == null ? null : (double[])hIm1.javaArray();
        double[] hImJA2 = hIm2 == null ? null : (double[])hIm2.javaArray();
        double[] fReJA1 = (double[])fRe1.javaArray();
        double[] fReJA2 = (double[])fRe2.javaArray();
        double[] fImJA1 = (double[])fIm1.javaArray();
        double[] fImJA2 = (double[])fIm2.javaArray();
        int hReOfs1 = hRe1.javaArrayOffset();
        int hReOfs2 = hRe2.javaArrayOffset();
        int hImOfs1 = hIm1 == null ? 0 : hIm1.javaArrayOffset();
        int hImOfs2 = hIm2 == null ? 0 : hIm2.javaArrayOffset();
        int fReOfs1 = fRe1.javaArrayOffset();
        int fReOfs2 = fRe2.javaArrayOffset();
        int fImOfs1 = fIm1.javaArrayOffset();
        int fImOfs2 = fIm2.javaArrayOffset();
        int n = fRe1.javaArrayLength();
        assert (fRe2.javaArrayLength() == n);
        assert (fIm1.javaArrayLength() == n);
        assert (fIm2.javaArrayLength() == n);
        assert (hRe1.javaArrayLength() == n);
        assert (hRe2.javaArrayLength() == n);
        assert (hIm1 == null || hIm1.javaArrayLength() == n);
        assert (hIm2 == null || hIm2.javaArrayLength() == n);
        int nDiv2 = n / 2;
        for (int kL = 0; kL <= nDiv2; ++kL) {
            int kR = kL == 0 ? 0 : n - kL;
            double fLRe1 = fReJA1[fReOfs1 + kL];
            double fRRe1 = fReJA1[fReOfs1 + kR];
            double fLRe2 = fReJA2[fReOfs2 + kL];
            double fRRe2 = fReJA2[fReOfs2 + kR];
            double fLIm1 = fImJA1[fImOfs1 + kL];
            double fRIm1 = fImJA1[fImOfs1 + kR];
            double fLIm2 = fImJA2[fImOfs2 + kL];
            double fRIm2 = fImJA2[fImOfs2 + kR];
            double sRe12 = 0.5 * (fLRe1 + fRRe2);
            double sIm12 = 0.5 * (fLIm1 + fRIm2);
            double sRe21 = 0.5 * (fLRe2 + fRRe1);
            double sIm21 = 0.5 * (fLIm2 + fRIm1);
            double dRe12 = 0.5 * (fLRe1 - fRRe2);
            double dIm12 = 0.5 * (fLIm1 - fRIm2);
            double dRe21 = 0.5 * (fLRe2 - fRRe1);
            double dIm21 = 0.5 * (fLIm2 - fRIm1);
            hReJA1[hReOfs1 + kL] = sRe21 - dIm12;
            hReJA1[hReOfs1 + kR] = sRe12 + dIm21;
            hReJA2[hReOfs2 + kL] = sRe12 - dIm21;
            hReJA2[hReOfs2 + kR] = sRe21 + dIm12;
            if (hIm1 == null) continue;
            hImJA1[hImOfs1 + kL] = sIm21 + dRe12;
            hImJA1[hImOfs1 + kR] = sIm12 - dRe21;
            hImJA2[hImOfs2 + kL] = sIm12 + dRe21;
            hImJA2[hImOfs2 + kR] = sIm21 - dRe12;
        }
    }
}

