/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrix;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.matrices.spectra.AbstractSpectralTransform;
import net.algart.matrices.spectra.ComplexScalarSampleArray;
import net.algart.matrices.spectra.ReverseBits;
import net.algart.matrices.spectra.RootsOfUnity;
import net.algart.matrices.spectra.SampleArray;
import net.algart.matrices.spectra.SpectraOfConvolution;
import net.algart.matrices.spectra.SpectralTransform;

public class FastFourierTransform
extends AbstractSpectralTransform
implements SpectralTransform {
    static final boolean DEFAULT_NORMALIZE_DIRECT_TRANSFORM = false;
    final boolean normalizeDirectTransform;

    public FastFourierTransform() {
        this.normalizeDirectTransform = false;
    }

    public FastFourierTransform(long maxTempJavaMemory) {
        super(maxTempJavaMemory);
        this.normalizeDirectTransform = false;
    }

    public FastFourierTransform(boolean normalizeDirectTransform) {
        this.normalizeDirectTransform = normalizeDirectTransform;
    }

    public FastFourierTransform(boolean normalizeDirectTransform, long maxTempJavaMemory) {
        super(maxTempJavaMemory);
        this.normalizeDirectTransform = normalizeDirectTransform;
    }

    public void spectrumOfConvolution(ArrayContext context, Matrix<? extends UpdatablePNumberArray> cRe, Matrix<? extends UpdatablePNumberArray> cIm, Matrix<? extends PNumberArray> pRe, Matrix<? extends PNumberArray> pIm, Matrix<? extends PNumberArray> qRe, Matrix<? extends PNumberArray> qIm) {
        long[] tileDimensions;
        Objects.requireNonNull(cRe, "Null cRe argument");
        Objects.requireNonNull(cIm, "Null cIm argument");
        Objects.requireNonNull(pRe, "Null pRe argument");
        Objects.requireNonNull(pIm, "Null pIm argument");
        Objects.requireNonNull(qRe, "Null qRe argument");
        Objects.requireNonNull(qIm, "Null qIm argument");
        if (!cRe.dimEquals(cIm)) {
            throw new SizeMismatchException("cRe and cIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", cIm " + String.valueOf(cIm));
        }
        if (!pRe.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and pRe dimensions mismatch: cRe is " + String.valueOf(cRe) + ", pRe " + String.valueOf(pRe));
        }
        if (!pIm.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and pIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", pIm " + String.valueOf(pIm));
        }
        if (!qRe.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and qRe dimensions mismatch: cRe is " + String.valueOf(cRe) + ", qRe " + String.valueOf(qRe));
        }
        if (!qIm.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and qIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", qIm " + String.valueOf(qIm));
        }
        if (cRe.isTiled() && cIm.isTiled() && pRe.isTiled() && pIm.isTiled() && qRe.isTiled() && qIm.isTiled() && Arrays.equals(tileDimensions = cRe.tileDimensions(), cIm.tileDimensions()) && Arrays.equals(tileDimensions, pRe.tileDimensions()) && Arrays.equals(tileDimensions, pIm.tileDimensions()) && Arrays.equals(tileDimensions, qRe.tileDimensions()) && Arrays.equals(tileDimensions, qIm.tileDimensions())) {
            cRe = cRe.tileParent();
            cIm = cIm.tileParent();
            pRe = pRe.tileParent();
            pIm = pIm.tileParent();
            qRe = qRe.tileParent();
            qIm = qIm.tileParent();
        }
        SpectraOfConvolution.fourierSpectrumOfConvolution(context, cRe.array(), cIm.array(), pRe.array(), pIm.array(), qRe.array(), qIm.array());
    }

    @Override
    public final boolean isLengthAllowed(long length) {
        return (length & length - 1L) == 0L;
    }

    @Override
    public boolean areComplexSamplesRequired() {
        return true;
    }

    @Override
    protected String unallowedLengthMessage() {
        return "FFT algorithm can process only 2^k elements";
    }

    @Override
    protected final void transform(ArrayContext context, SampleArray samples, boolean inverse) {
        assert (samples.isComplex());
        assert (this.isLengthAllowed(samples.length()));
        boolean normalize = this.normalizeDirectTransform ? !inverse : inverse;
        ReverseBits.reorderForButterfly(context == null ? null : context.part(0.0, 0.2), samples);
        FastFourierTransform.fftMainLoop(context == null ? null : context.part(0.2, normalize ? 0.95 : 1.0), samples, inverse);
        if (normalize) {
            FastFourierTransform.fftNormalize(context == null ? null : context.part(0.95, 1.0), samples);
        }
    }

    static void fftMainLoop(ArrayContext context, SampleArray samples, boolean inverse) {
        if (samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray || samples instanceof ComplexScalarSampleArray.DirectComplexFloatSampleArray) {
            FastFourierTransform.fftJavaFloatMainLoop(context, samples, inverse);
        } else if (samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray || samples instanceof ComplexScalarSampleArray.DirectComplexDoubleSampleArray) {
            FastFourierTransform.fftJavaDoubleMainLoop(context, samples, inverse);
        } else {
            FastFourierTransform.fftCommonMainLoop(context, samples, inverse);
        }
    }

    static void fftNormalize(ArrayContext context, SampleArray samples) {
        long n = samples.length();
        double mult = 1.0 / (double)n;
        long step = samples instanceof ComplexScalarSampleArray ? 16384L : 512L;
        long i = 0L;
        while (i < n) {
            long iMax = i > n - step ? n : i + step;
            samples.multiplyRangeByRealScalar(i, iMax, mult);
            i = iMax;
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(null, iMax, n);
        }
    }

    private static void fftCommonMainLoop(ArrayContext context, SampleArray samples, boolean inverse) {
        long n = samples.length();
        if (n == 0L) {
            return;
        }
        int logN = 63 - Long.numberOfLeadingZeros(n);
        SampleArray work = samples.newCompatibleSamplesArray(1L);
        long step = 1L;
        for (int bitIndex = 0; bitIndex < logN; ++bitIndex) {
            boolean allAnglesInCache;
            long halfStep = step;
            step *= 2L;
            boolean bl = allAnglesInCache = halfStep <= 0x100000L;
            if (allAnglesInCache) {
                int angleStep = (int)(0x100000L / halfStep);
                for (long i = 0L; i < n; i += step) {
                    int j = 0;
                    int angleIndex = 0;
                    while ((long)j < halfStep) {
                        double wIm;
                        double wRe = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                        double d = wIm = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                        if (!inverse) {
                            wIm = -wIm;
                        }
                        long l = i + (long)j;
                        long r = l + halfStep;
                        work.multiplyByScalar(0L, samples, r, wRe, wIm);
                        samples.sub(r, l, work, 0L);
                        samples.add(l, l, work, 0L);
                        ++j;
                        angleIndex += angleStep;
                    }
                }
            } else {
                double rotationAngle = inverse ? Math.PI / (double)halfStep : -Math.PI / (double)halfStep;
                double rootSinHalf = Math.sin(0.5 * rotationAngle);
                double rootReM1 = -2.0 * rootSinHalf * rootSinHalf;
                double rootIm = Math.sin(rotationAngle);
                for (long i = 0L; i < n; i += step) {
                    double wRe = 1.0;
                    double wIm = 0.0;
                    for (long j = 0L; j < halfStep; ++j) {
                        long l = i + j;
                        long r = l + halfStep;
                        work.multiplyByScalar(0L, samples, r, wRe, wIm);
                        samples.sub(r, l, work, 0L);
                        samples.add(l, l, work, 0L);
                        if ((l & 0xFL) == 15L) {
                            double angle = (double)(j + 1L) * rotationAngle;
                            double sinHalf = Math.sin(0.5 * angle);
                            wRe = 1.0 - 2.0 * sinHalf * sinHalf;
                            wIm = Math.sin(angle);
                            continue;
                        }
                        double re = wRe * rootReM1 - wIm * rootIm;
                        double im = wRe * rootIm + wIm * rootReM1;
                        wRe += re;
                        wIm += im;
                    }
                }
            }
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(null, bitIndex, logN);
        }
        assert (step == n) : "step = " + step + ", n = " + n;
    }

    private static void fftJavaFloatMainLoop(ArrayContext context, SampleArray samples, boolean inverse) {
        long n = samples.length();
        assert (n <= Integer.MAX_VALUE);
        if (n == 0L) {
            return;
        }
        int logN = 63 - Long.numberOfLeadingZeros(n);
        float[] samplesRe = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray ? ((ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray)samples).samplesRe : ((ComplexScalarSampleArray.DirectComplexFloatSampleArray)samples).samplesRe;
        int ofsRe = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray ? 0 : ((ComplexScalarSampleArray.DirectComplexFloatSampleArray)samples).ofsRe;
        float[] samplesIm = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray ? ((ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray)samples).samplesIm : ((ComplexScalarSampleArray.DirectComplexFloatSampleArray)samples).samplesIm;
        int ofsIm = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexFloatSampleArray ? 0 : ((ComplexScalarSampleArray.DirectComplexFloatSampleArray)samples).ofsIm;
        int step = 1;
        for (int bitIndex = 0; bitIndex < logN; ++bitIndex) {
            boolean allAnglesInCache;
            int halfStep = step;
            step *= 2;
            boolean bl = allAnglesInCache = halfStep <= 0x100000;
            if (allAnglesInCache) {
                int angleStep = 0x100000 / halfStep;
                int i = 0;
                while ((long)i < n) {
                    int j = 0;
                    int angleIndex = 0;
                    while (j < halfStep) {
                        double wIm;
                        double wRe = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                        double d = wIm = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                        if (!inverse) {
                            wIm = -wIm;
                        }
                        int lRe = ofsRe + i + j;
                        int lIm = ofsIm + i + j;
                        int rRe = lRe + halfStep;
                        int rIm = lIm + halfStep;
                        double re = samplesRe[rRe];
                        double im = samplesIm[rIm];
                        float workRe = (float)(re * wRe - im * wIm);
                        float workIm = (float)(re * wIm + im * wRe);
                        samplesRe[rRe] = samplesRe[lRe] - workRe;
                        samplesIm[rIm] = samplesIm[lIm] - workIm;
                        int n2 = lRe;
                        samplesRe[n2] = samplesRe[n2] + workRe;
                        int n3 = lIm;
                        samplesIm[n3] = samplesIm[n3] + workIm;
                        ++j;
                        angleIndex += angleStep;
                    }
                    i += step;
                }
            } else {
                double rotationAngle = inverse ? Math.PI / (double)halfStep : -Math.PI / (double)halfStep;
                double rootSinHalf = Math.sin(0.5 * rotationAngle);
                double rootReM1 = -2.0 * rootSinHalf * rootSinHalf;
                double rootIm = Math.sin(rotationAngle);
                int i = 0;
                while ((long)i < n) {
                    double wRe = 1.0;
                    double wIm = 0.0;
                    for (int j = 0; j < halfStep; ++j) {
                        int lRe = ofsRe + i + j;
                        int lIm = ofsIm + i + j;
                        int rRe = lRe + halfStep;
                        int rIm = lIm + halfStep;
                        double re = samplesRe[rRe];
                        double im = samplesIm[rIm];
                        float workRe = (float)(re * wRe - im * wIm);
                        float workIm = (float)(re * wIm + im * wRe);
                        samplesRe[rRe] = samplesRe[lRe] - workRe;
                        samplesIm[rIm] = samplesIm[lIm] - workIm;
                        int n4 = lRe;
                        samplesRe[n4] = samplesRe[n4] + workRe;
                        int n5 = lIm;
                        samplesIm[n5] = samplesIm[n5] + workIm;
                        if ((i + j & 0xF) == 15) {
                            double angle = (double)(j + 1) * rotationAngle;
                            double sinHalf = Math.sin(0.5 * angle);
                            wRe = 1.0 - 2.0 * sinHalf * sinHalf;
                            wIm = Math.sin(angle);
                            continue;
                        }
                        re = wRe * rootReM1 - wIm * rootIm;
                        im = wRe * rootIm + wIm * rootReM1;
                        wRe += re;
                        wIm += im;
                    }
                    i += step;
                }
            }
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(null, bitIndex, logN);
        }
        assert ((long)step == n) : "step = " + step + ", n = " + n;
    }

    private static void fftJavaDoubleMainLoop(ArrayContext context, SampleArray samples, boolean inverse) {
        long n = samples.length();
        assert (n <= Integer.MAX_VALUE);
        if (n == 0L) {
            return;
        }
        int logN = 63 - Long.numberOfLeadingZeros(n);
        double[] samplesRe = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray ? ((ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray)samples).samplesRe : ((ComplexScalarSampleArray.DirectComplexDoubleSampleArray)samples).samplesRe;
        int ofsRe = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray ? 0 : ((ComplexScalarSampleArray.DirectComplexDoubleSampleArray)samples).ofsRe;
        double[] samplesIm = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray ? ((ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray)samples).samplesIm : ((ComplexScalarSampleArray.DirectComplexDoubleSampleArray)samples).samplesIm;
        int ofsIm = samples instanceof ComplexScalarSampleArray.DirectZeroOffsetsComplexDoubleSampleArray ? 0 : ((ComplexScalarSampleArray.DirectComplexDoubleSampleArray)samples).ofsIm;
        int step = 1;
        for (int bitIndex = 0; bitIndex < logN; ++bitIndex) {
            boolean allAnglesInCache;
            int halfStep = step;
            step *= 2;
            boolean bl = allAnglesInCache = halfStep <= 0x100000;
            if (allAnglesInCache) {
                int angleStep = 0x100000 / halfStep;
                int i = 0;
                while ((long)i < n) {
                    int j = 0;
                    int angleIndex = 0;
                    while (j < halfStep) {
                        double wIm;
                        double wRe = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                        double d = wIm = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                        if (!inverse) {
                            wIm = -wIm;
                        }
                        int lRe = ofsRe + i + j;
                        int lIm = ofsIm + i + j;
                        int rRe = lRe + halfStep;
                        int rIm = lIm + halfStep;
                        double re = samplesRe[rRe];
                        double im = samplesIm[rIm];
                        double workRe = re * wRe - im * wIm;
                        double workIm = re * wIm + im * wRe;
                        samplesRe[rRe] = samplesRe[lRe] - workRe;
                        samplesIm[rIm] = samplesIm[lIm] - workIm;
                        int n2 = lRe;
                        samplesRe[n2] = samplesRe[n2] + workRe;
                        int n3 = lIm;
                        samplesIm[n3] = samplesIm[n3] + workIm;
                        ++j;
                        angleIndex += angleStep;
                    }
                    i += step;
                }
            } else {
                double rotationAngle = inverse ? Math.PI / (double)halfStep : -Math.PI / (double)halfStep;
                double rootSinHalf = Math.sin(0.5 * rotationAngle);
                double rootReM1 = -2.0 * rootSinHalf * rootSinHalf;
                double rootIm = Math.sin(rotationAngle);
                int i = 0;
                while ((long)i < n) {
                    double wRe = 1.0;
                    double wIm = 0.0;
                    for (int j = 0; j < halfStep; ++j) {
                        int lRe = ofsRe + i + j;
                        int lIm = ofsIm + i + j;
                        int rRe = lRe + halfStep;
                        int rIm = lIm + halfStep;
                        double re = samplesRe[rRe];
                        double im = samplesIm[rIm];
                        double workRe = re * wRe - im * wIm;
                        double workIm = re * wIm + im * wRe;
                        samplesRe[rRe] = samplesRe[lRe] - workRe;
                        samplesIm[rIm] = samplesIm[lIm] - workIm;
                        int n4 = lRe;
                        samplesRe[n4] = samplesRe[n4] + workRe;
                        int n5 = lIm;
                        samplesIm[n5] = samplesIm[n5] + workIm;
                        if ((i + j & 0xF) == 15) {
                            double angle = (double)(j + 1) * rotationAngle;
                            double sinHalf = Math.sin(0.5 * angle);
                            wRe = 1.0 - 2.0 * sinHalf * sinHalf;
                            wIm = Math.sin(angle);
                            continue;
                        }
                        re = wRe * rootReM1 - wIm * rootIm;
                        im = wRe * rootIm + wIm * rootReM1;
                        wRe += re;
                        wIm += im;
                    }
                    i += step;
                }
            }
            if (context == null) continue;
            context.checkInterruptionAndUpdateProgress(null, bitIndex, logN);
        }
        assert ((long)step == n) : "step = " + step + ", n = " + n;
    }
}

