/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.spectra;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.matrices.spectra.AbstractSpectralTransform;
import net.algart.matrices.spectra.Conversions;
import net.algart.matrices.spectra.FastFourierTransform;
import net.algart.matrices.spectra.RealScalarSampleArray;
import net.algart.matrices.spectra.RealVectorSampleArray;
import net.algart.matrices.spectra.ReverseBits;
import net.algart.matrices.spectra.RootsOfUnity;
import net.algart.matrices.spectra.SampleArray;
import net.algart.matrices.spectra.SpectraOfConvolution;
import net.algart.matrices.spectra.SpectralTransform;

public class SeparableFastHartleyTransform
extends AbstractSpectralTransform
implements SpectralTransform {
    final boolean normalizeDirectTransform;
    private static final int LOG_ANGLE_STEP = 4;
    private static final int ANGLE_STEP = 16;
    private static final double SQRT2 = StrictMath.sqrt(2.0);
    private static final double HALF_SQRT2 = 0.5 * SQRT2;
    private static final int S01 = 0;
    private static final int D01 = 1;
    private static final int S23 = 2;
    private static final int D23 = 3;
    private static final int S45 = 0;
    private static final int D45 = 1;
    private static final int S67 = 2;
    private static final int D67 = 3;
    private static final int SS0123 = 4;
    private static final int SD0123 = 5;
    private static final int DS0123 = 6;
    private static final int DD0123 = 7;
    private static final int SS4567 = 8;
    private static final int DS4567 = 9;
    private static final int R1 = 0;
    private static final int R2 = 1;
    private static final int L1 = 2;
    private static final int L2 = 2;
    private static final int CAS = 3;
    private static final int NUMBER_OF_WORK_VARIABLES = 10;

    public SeparableFastHartleyTransform() {
        this.normalizeDirectTransform = false;
    }

    public SeparableFastHartleyTransform(long maxTempJavaMemory) {
        super(maxTempJavaMemory);
        this.normalizeDirectTransform = false;
    }

    public SeparableFastHartleyTransform(boolean normalizeDirectTransform) {
        this.normalizeDirectTransform = normalizeDirectTransform;
    }

    public SeparableFastHartleyTransform(boolean normalizeDirectTransform, long maxTempJavaMemory) {
        super(maxTempJavaMemory);
        this.normalizeDirectTransform = normalizeDirectTransform;
    }

    public void separableHartleyToFourier(ArrayContext context, Matrix<? extends UpdatablePNumberArray> fRe, Matrix<? extends UpdatablePNumberArray> fIm, Matrix<? extends PNumberArray> h) {
        Objects.requireNonNull(fRe, "Null fRe argument");
        Objects.requireNonNull(fIm, "Null fIm argument");
        Objects.requireNonNull(h, "Null h argument");
        if (!fRe.dimEquals(fIm)) {
            throw new SizeMismatchException("fRe and fIm dimensions mismatch: fRe is " + String.valueOf(fRe) + ", fIm " + String.valueOf(fIm));
        }
        if (!h.dimEquals(fRe)) {
            throw new SizeMismatchException("h and fRe dimensions mismatch: h is " + String.valueOf(h) + ", fRe " + String.valueOf(fRe));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        Conversions.separableHartleyToFourierRecoursive(context, this.maxTempJavaMemory(), fRe.array(), fIm.array(), h.array(), null, fRe.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    public void separableHartleyToFourier(ArrayContext context, Matrix<? extends UpdatablePNumberArray> fRe, Matrix<? extends UpdatablePNumberArray> fIm, Matrix<? extends PNumberArray> hRe, Matrix<? extends PNumberArray> hIm) {
        Objects.requireNonNull(fRe, "Null fRe argument");
        Objects.requireNonNull(fIm, "Null fIm argument");
        Objects.requireNonNull(hRe, "Null hRe argument");
        Objects.requireNonNull(hIm, "Null hIm argument");
        if (!fRe.dimEquals(fIm)) {
            throw new SizeMismatchException("fRe and fIm dimensions mismatch: fRe is " + String.valueOf(fRe) + ", fIm " + String.valueOf(fIm));
        }
        if (!hRe.dimEquals(fRe)) {
            throw new SizeMismatchException("hRe and fRe dimensions mismatch: hRe is " + String.valueOf(hRe) + ", fRe " + String.valueOf(fRe));
        }
        if (!hIm.dimEquals(fRe)) {
            throw new SizeMismatchException("hIm and fRe dimensions mismatch: hIm is " + String.valueOf(hIm) + ", fRe " + String.valueOf(fRe));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        Conversions.separableHartleyToFourierRecoursive(context, this.maxTempJavaMemory(), fRe.array(), fIm.array(), hRe.array(), hIm.array(), fRe.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    public void fourierToSeparableHartley(ArrayContext context, Matrix<? extends UpdatablePNumberArray> h, Matrix<? extends PNumberArray> fRe, Matrix<? extends PNumberArray> fIm) {
        Objects.requireNonNull(h, "Null h argument");
        Objects.requireNonNull(fRe, "Null fRe argument");
        Objects.requireNonNull(fIm, "Null fIm argument");
        if (!fRe.dimEquals(fIm)) {
            throw new SizeMismatchException("fRe and fIm dimensions mismatch: fRe is " + String.valueOf(fRe) + ", fIm " + String.valueOf(fIm));
        }
        if (!h.dimEquals(fRe)) {
            throw new SizeMismatchException("h and fRe dimensions mismatch: h is " + String.valueOf(h) + ", fRe " + String.valueOf(fRe));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        Conversions.fourierToSeparableHartleyRecursive(context, this.maxTempJavaMemory(), h.array(), null, fRe.array(), fIm.array(), fRe.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    public void fourierToSeparableHartley(ArrayContext context, Matrix<? extends UpdatablePNumberArray> hRe, Matrix<? extends UpdatablePNumberArray> hIm, Matrix<? extends PNumberArray> fRe, Matrix<? extends PNumberArray> fIm) {
        Objects.requireNonNull(hRe, "Null hRe argument");
        Objects.requireNonNull(fRe, "Null fRe argument");
        Objects.requireNonNull(fIm, "Null fIm argument");
        Objects.requireNonNull(hIm, "Null hIm argument");
        if (!fRe.dimEquals(fIm)) {
            throw new SizeMismatchException("fRe and fIm dimensions mismatch: fRe is " + String.valueOf(fRe) + ", fIm " + String.valueOf(fIm));
        }
        if (!hRe.dimEquals(fRe)) {
            throw new SizeMismatchException("hRe and fRe dimensions mismatch: hRe is " + String.valueOf(hRe) + ", fRe " + String.valueOf(fRe));
        }
        if (!hIm.dimEquals(fRe)) {
            throw new SizeMismatchException("hIm and fRe dimensions mismatch: hIm is " + String.valueOf(hIm) + ", fRe " + String.valueOf(fRe));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        Conversions.fourierToSeparableHartleyRecursive(context, this.maxTempJavaMemory(), hRe.array(), hIm.array(), fRe.array(), fIm.array(), fRe.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    public void spectrumOfConvolution(ArrayContext context, Matrix<? extends UpdatablePNumberArray> c, Matrix<? extends PNumberArray> p, Matrix<? extends PNumberArray> q) {
        Objects.requireNonNull(c, "Null c argument");
        Objects.requireNonNull(p, "Null p argument");
        Objects.requireNonNull(q, "Null q argument");
        if (!p.dimEquals(c)) {
            throw new SizeMismatchException("c and p dimensions mismatch: c is " + String.valueOf(c) + ", p " + String.valueOf(p));
        }
        if (!q.dimEquals(c)) {
            throw new SizeMismatchException("c and q dimensions mismatch: c is " + String.valueOf(c) + ", q " + String.valueOf(q));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        SpectraOfConvolution.separableHartleySpectrumOfConvolution(context, this.maxTempJavaMemory(), c.array(), null, p.array(), null, q.array(), null, c.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    public void spectrumOfConvolution(ArrayContext context, Matrix<? extends UpdatablePNumberArray> cRe, Matrix<? extends UpdatablePNumberArray> cIm, Matrix<? extends PNumberArray> pRe, Matrix<? extends PNumberArray> pIm, Matrix<? extends PNumberArray> qRe, Matrix<? extends PNumberArray> qIm) {
        Objects.requireNonNull(cRe, "Null cRe argument");
        Objects.requireNonNull(cIm, "Null cIm argument");
        Objects.requireNonNull(pRe, "Null pRe argument");
        Objects.requireNonNull(pIm, "Null pIm argument");
        Objects.requireNonNull(qRe, "Null qRe argument");
        Objects.requireNonNull(qIm, "Null qIm argument");
        if (!cRe.dimEquals(cIm)) {
            throw new SizeMismatchException("cRe and cIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", cIm " + String.valueOf(cIm));
        }
        if (!pRe.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and pRe dimensions mismatch: cRe is " + String.valueOf(cRe) + ", pRe " + String.valueOf(pRe));
        }
        if (!pIm.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and pIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", pIm " + String.valueOf(pIm));
        }
        if (!qRe.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and qRe dimensions mismatch: cRe is " + String.valueOf(cRe) + ", qRe " + String.valueOf(qRe));
        }
        if (!qIm.dimEquals(cRe)) {
            throw new SizeMismatchException("cRe and qIm dimensions mismatch: cRe is " + String.valueOf(cRe) + ", qIm " + String.valueOf(qIm));
        }
        ThreadPoolFactory tpf = Arrays.getThreadPoolFactory(context);
        SpectraOfConvolution.separableHartleySpectrumOfConvolution(context, this.maxTempJavaMemory(), cRe.array(), cIm.array(), pRe.array(), pIm.array(), qRe.array(), qIm.array(), cRe.dimensions(), Math.max(1, tpf.recommendedNumberOfTasks()));
    }

    @Override
    public final boolean isLengthAllowed(long length) {
        return (length & length - 1L) == 0L;
    }

    @Override
    public boolean areComplexSamplesRequired() {
        return false;
    }

    @Override
    protected String unallowedLengthMessage() {
        return "FHT algorithm can process only 2^k elements";
    }

    @Override
    protected final void transform(ArrayContext context, SampleArray samples, boolean inverse) {
        assert (this.isLengthAllowed(samples.length()));
        boolean normalize = this.normalizeDirectTransform ? !inverse : inverse;
        ReverseBits.reorderForButterfly(context == null ? null : context.part(0.0, 0.2), samples);
        SeparableFastHartleyTransform.fhtMainLoop(context == null ? null : context.part(0.2, normalize ? 0.95 : 1.0), samples);
        if (normalize) {
            FastFourierTransform.fftNormalize(context == null ? null : context.part(0.95, 1.0), samples);
        }
    }

    private static void fhtMainLoop(ArrayContext context, SampleArray samples) {
        int logN = 63 - Long.numberOfLeadingZeros(samples.length());
        if (logN <= 0) {
            return;
        }
        if (samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealFloatSampleArray || samples instanceof RealScalarSampleArray.DirectRealFloatSampleArray) {
            SeparableFastHartleyTransform.fhtJavaFloatMainLoop(context, samples, 0, logN, logN);
        } else if (samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealDoubleSampleArray || samples instanceof RealScalarSampleArray.DirectRealDoubleSampleArray) {
            SeparableFastHartleyTransform.fhtJavaDoubleMainLoop(context, samples, 0, logN, logN);
        } else {
            SeparableFastHartleyTransform.fhtCommonMainLoop(context, samples, 0L, logN, logN, samples.newCompatibleSamplesArray(10L));
        }
    }

    private static void fhtCommonMainLoop(ArrayContext context, SampleArray samples, long pos, int logN, int originalLogN, SampleArray work) {
        switch (logN) {
            case 1: {
                work.sub(0L, samples, pos, pos + 1L);
                samples.add(pos, pos, pos + 1L);
                samples.copy(pos + 1L, work, 0L);
                break;
            }
            case 2: {
                work.sub(1L, samples, pos, pos + 1L);
                work.add(0L, samples, pos, pos + 1L);
                work.sub(3L, samples, pos + 2L, pos + 3L);
                work.add(2L, samples, pos + 2L, pos + 3L);
                samples.add(pos, work, 0L, 2L);
                samples.add(pos + 1L, work, 1L, 3L);
                samples.sub(pos + 2L, work, 0L, 2L);
                samples.sub(pos + 3L, work, 1L, 3L);
                break;
            }
            case 3: {
                work.sub(1L, samples, pos, pos + 1L);
                work.add(0L, samples, pos, pos + 1L);
                work.sub(3L, samples, pos + 2L, pos + 3L);
                work.add(2L, samples, pos + 2L, pos + 3L);
                work.sub(6L, 0L, 2L);
                work.add(4L, 0L, 2L);
                work.sub(7L, 1L, 3L);
                work.add(5L, 1L, 3L);
                work.add(0L, samples, pos + 4L, pos + 5L);
                work.add(2L, samples, pos + 6L, pos + 7L);
                work.sub(1L, samples, pos + 4L, pos + 5L);
                work.sub(3L, samples, pos + 6L, pos + 7L);
                work.sub(9L, 0L, 2L);
                work.add(8L, 0L, 2L);
                samples.sub(pos + 4L, work, 4L, 8L);
                samples.add(pos, work, 4L, 8L);
                samples.sub(pos + 6L, work, 6L, 9L);
                samples.add(pos + 2L, work, 6L, 9L);
                work.multiplyByRealScalar(1L, SQRT2);
                work.multiplyByRealScalar(3L, SQRT2);
                samples.sub(pos + 5L, work, 5L, 1L);
                samples.add(pos + 1L, work, 5L, 1L);
                samples.sub(pos + 7L, work, 7L, 3L);
                samples.add(pos + 3L, work, 7L, 3L);
                break;
            }
            default: {
                long j2;
                long j1;
                assert (logN > 3);
                long nDiv8 = 1L << logN - 3;
                long nDiv4 = nDiv8 * 2L;
                long nDiv2 = nDiv4 * 2L;
                SeparableFastHartleyTransform.fhtCommonMainLoop(context, samples, pos, logN - 1, originalLogN, work);
                SeparableFastHartleyTransform.fhtCommonMainLoop(context, samples, pos + nDiv2, logN - 1, originalLogN, work);
                boolean allAnglesInCache = logN - 1 <= 24;
                double rotationAngle = Math.PI / (double)nDiv2;
                double sin0Half = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN];
                double cos0M1 = -2.0 * sin0Half * sin0Half;
                double sin0 = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN - 1];
                double cos = 1.0 + cos0M1;
                double sin = sin0;
                for (long j = 1L; j < nDiv8; ++j) {
                    j1 = pos + j;
                    j2 = pos + nDiv2 - j;
                    work.copy(0L, samples, nDiv2 + j1);
                    work.copy(1L, samples, nDiv2 + j2);
                    work.combineWithRealMultipliers(3L, 0L, cos, 1L, sin);
                    work.copy(2L, samples, j1);
                    samples.add(j1, work, 2L, 3L);
                    samples.sub(nDiv2 + j1, work, 2L, 3L);
                    work.combineWithRealMultipliers(3L, 0L, sin, 1L, -cos);
                    work.copy(2L, samples, j2);
                    samples.add(j2, work, 2L, 3L);
                    samples.sub(nDiv2 + j2, work, 2L, 3L);
                    j1 = pos + nDiv4 - j;
                    j2 = pos + nDiv4 + j;
                    work.copy(0L, samples, nDiv2 + j1);
                    work.copy(1L, samples, nDiv2 + j2);
                    work.combineWithRealMultipliers(3L, 0L, sin, 1L, cos);
                    work.copy(2L, samples, j1);
                    samples.add(j1, work, 2L, 3L);
                    samples.sub(nDiv2 + j1, work, 2L, 3L);
                    work.combineWithRealMultipliers(3L, 0L, cos, 1L, -sin);
                    work.copy(2L, samples, j2);
                    samples.add(j2, work, 2L, 3L);
                    samples.sub(nDiv2 + j2, work, 2L, 3L);
                    if ((j & 0xFL) == 15L) {
                        if (allAnglesInCache) {
                            int angleIndex = (int)(j + 1L) >> 4 << 20 - (logN - 1) + 4;
                            cos = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                            sin = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                            continue;
                        }
                        double angle = (double)(j + 1L) * rotationAngle;
                        double sinHalf = Math.sin(0.5 * angle);
                        cos = 1.0 - 2.0 * sinHalf * sinHalf;
                        sin = Math.sin(angle);
                        continue;
                    }
                    double temp = cos;
                    cos = cos * cos0M1 - sin * sin0 + cos;
                    sin = sin * cos0M1 + temp * sin0 + sin;
                }
                j1 = pos + nDiv8;
                j2 = pos + nDiv2 - nDiv8;
                work.copy(0L, samples, nDiv2 + j1);
                work.copy(1L, samples, nDiv2 + j2);
                work.combineWithRealMultipliers(3L, 0L, HALF_SQRT2, 1L, HALF_SQRT2);
                work.copy(2L, samples, j1);
                samples.add(j1, work, 2L, 3L);
                samples.sub(nDiv2 + j1, work, 2L, 3L);
                work.combineWithRealMultipliers(3L, 0L, HALF_SQRT2, 1L, -HALF_SQRT2);
                work.copy(2L, samples, j2);
                samples.add(j2, work, 2L, 3L);
                samples.sub(nDiv2 + j2, work, 2L, 3L);
                work.sub(0L, samples, pos, pos + nDiv2);
                samples.add(pos, pos, pos + nDiv2);
                samples.copy(pos + nDiv2, work, 0L);
                work.sub(0L, samples, pos + nDiv4, pos + nDiv2 + nDiv4);
                samples.add(pos + nDiv4, pos + nDiv4, pos + nDiv2 + nDiv4);
                samples.copy(pos + nDiv2 + nDiv4, work, 0L);
                if (context == null || pos + (long)(1 << logN) != samples.length()) break;
                context.checkInterruptionAndUpdateProgress(null, logN, originalLogN);
            }
        }
    }

    private static void fhtJavaFloatMainLoop(ArrayContext context, SampleArray samples, int pos, int logN, int originalLogN) {
        float[] values = samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealFloatSampleArray ? ((RealScalarSampleArray.DirectZeroOffsetsRealFloatSampleArray)samples).samples : ((RealScalarSampleArray.DirectRealFloatSampleArray)samples).samples;
        int ofs = pos + (samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealFloatSampleArray ? 0 : ((RealScalarSampleArray.DirectRealFloatSampleArray)samples).ofs);
        switch (logN) {
            case 1: {
                float temp = values[ofs] - values[ofs + 1];
                int n = ofs;
                values[n] = values[n] + values[ofs + 1];
                values[ofs + 1] = temp;
                break;
            }
            case 2: {
                float d01 = values[ofs] - values[ofs + 1];
                float s01 = values[ofs] + values[ofs + 1];
                float d23 = values[ofs + 2] - values[ofs + 3];
                float s23 = values[ofs + 2] + values[ofs + 3];
                values[ofs] = s01 + s23;
                values[ofs + 1] = d01 + d23;
                values[ofs + 2] = s01 - s23;
                values[ofs + 3] = d01 - d23;
                break;
            }
            case 3: {
                float d01 = values[ofs] - values[ofs + 1];
                float s01 = values[ofs] + values[ofs + 1];
                float d23 = values[ofs + 2] - values[ofs + 3];
                float s23 = values[ofs + 2] + values[ofs + 3];
                float ds0123 = s01 - s23;
                float ss0123 = s01 + s23;
                float dd0123 = d01 - d23;
                float sd0123 = d01 + d23;
                float s45 = values[ofs + 4] + values[ofs + 5];
                float s67 = values[ofs + 6] + values[ofs + 7];
                float d45 = values[ofs + 4] - values[ofs + 5];
                float d67 = values[ofs + 6] - values[ofs + 7];
                float ds4567 = s45 - s67;
                float ss4567 = s45 + s67;
                values[ofs + 4] = ss0123 - ss4567;
                values[ofs] = ss0123 + ss4567;
                values[ofs + 6] = ds0123 - ds4567;
                values[ofs + 2] = ds0123 + ds4567;
                d45 = (float)((double)d45 * SQRT2);
                d67 = (float)((double)d67 * SQRT2);
                values[ofs + 5] = sd0123 - d45;
                values[ofs + 1] = sd0123 + d45;
                values[ofs + 7] = dd0123 - d67;
                values[ofs + 3] = dd0123 + d67;
                break;
            }
            default: {
                float l2;
                float l1;
                float cas;
                float r2;
                float r1;
                int j2;
                int j1;
                assert (logN > 3);
                int nDiv8 = 1 << logN - 3;
                int nDiv4 = nDiv8 * 2;
                int nDiv2 = nDiv4 * 2;
                SeparableFastHartleyTransform.fhtJavaFloatMainLoop(context, samples, pos, logN - 1, originalLogN);
                SeparableFastHartleyTransform.fhtJavaFloatMainLoop(context, samples, pos + nDiv2, logN - 1, originalLogN);
                boolean allAnglesInCache = logN - 1 <= 24;
                double rotationAngle = Math.PI / (double)nDiv2;
                double sin0Half = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN];
                double cos0M1 = -2.0 * sin0Half * sin0Half;
                double sin0 = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN - 1];
                double cos = 1.0 + cos0M1;
                double sin = sin0;
                for (int j = 1; j < nDiv8; ++j) {
                    j1 = ofs + j;
                    j2 = ofs + nDiv2 - j;
                    r1 = values[nDiv2 + j1];
                    r2 = values[nDiv2 + j2];
                    cas = (float)((double)r1 * cos + (double)r2 * sin);
                    l1 = values[j1];
                    values[j1] = l1 + cas;
                    values[nDiv2 + j1] = l1 - cas;
                    cas = (float)((double)r1 * sin - (double)r2 * cos);
                    l2 = values[j2];
                    values[j2] = l2 + cas;
                    values[nDiv2 + j2] = l2 - cas;
                    j1 = ofs + nDiv4 - j;
                    j2 = ofs + nDiv4 + j;
                    r1 = values[nDiv2 + j1];
                    r2 = values[nDiv2 + j2];
                    cas = (float)((double)r1 * sin + (double)r2 * cos);
                    l1 = values[j1];
                    values[j1] = l1 + cas;
                    values[nDiv2 + j1] = l1 - cas;
                    cas = (float)((double)r1 * cos - (double)r2 * sin);
                    l2 = values[j2];
                    values[j2] = l2 + cas;
                    values[nDiv2 + j2] = l2 - cas;
                    if ((j & 0xF) == 15) {
                        if (allAnglesInCache) {
                            int angleIndex = j + 1 >> 4 << 20 - (logN - 1) + 4;
                            cos = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                            sin = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                            continue;
                        }
                        double angle = (double)(j + 1) * rotationAngle;
                        double sinHalf = Math.sin(0.5 * angle);
                        cos = 1.0 - 2.0 * sinHalf * sinHalf;
                        sin = Math.sin(angle);
                        continue;
                    }
                    double temp = cos;
                    cos = cos * cos0M1 - sin * sin0 + cos;
                    sin = sin * cos0M1 + temp * sin0 + sin;
                }
                j1 = ofs + nDiv8;
                j2 = ofs + nDiv2 - nDiv8;
                r1 = values[nDiv2 + j1];
                r2 = values[nDiv2 + j2];
                cas = (float)((double)r1 * HALF_SQRT2 + (double)r2 * HALF_SQRT2);
                l1 = values[j1];
                values[j1] = l1 + cas;
                values[nDiv2 + j1] = l1 - cas;
                cas = (float)((double)r1 * HALF_SQRT2 - (double)r2 * HALF_SQRT2);
                l2 = values[j2];
                values[j2] = l2 + cas;
                values[nDiv2 + j2] = l2 - cas;
                float temp = values[ofs] - values[ofs + nDiv2];
                int n = ofs;
                values[n] = values[n] + values[ofs + nDiv2];
                values[ofs + nDiv2] = temp;
                temp = values[ofs + nDiv4] - values[ofs + nDiv2 + nDiv4];
                int n2 = ofs + nDiv4;
                values[n2] = values[n2] + values[ofs + nDiv2 + nDiv4];
                values[ofs + nDiv2 + nDiv4] = temp;
                if (context == null || (long)pos + (1L << logN) != samples.length()) break;
                context.checkInterruptionAndUpdateProgress(null, logN, originalLogN);
            }
        }
    }

    private static void fhtJavaDoubleMainLoop(ArrayContext context, SampleArray samples, int pos, int logN, int originalLogN) {
        double[] values = samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealDoubleSampleArray ? ((RealScalarSampleArray.DirectZeroOffsetsRealDoubleSampleArray)samples).samples : ((RealScalarSampleArray.DirectRealDoubleSampleArray)samples).samples;
        int ofs = pos + (samples instanceof RealScalarSampleArray.DirectZeroOffsetsRealDoubleSampleArray ? 0 : ((RealScalarSampleArray.DirectRealDoubleSampleArray)samples).ofs);
        switch (logN) {
            case 1: {
                double temp = values[ofs] - values[ofs + 1];
                int n = ofs;
                values[n] = values[n] + values[ofs + 1];
                values[ofs + 1] = temp;
                break;
            }
            case 2: {
                double d01 = values[ofs] - values[ofs + 1];
                double s01 = values[ofs] + values[ofs + 1];
                double d23 = values[ofs + 2] - values[ofs + 3];
                double s23 = values[ofs + 2] + values[ofs + 3];
                values[ofs] = s01 + s23;
                values[ofs + 1] = d01 + d23;
                values[ofs + 2] = s01 - s23;
                values[ofs + 3] = d01 - d23;
                break;
            }
            case 3: {
                double d01 = values[ofs] - values[ofs + 1];
                double s01 = values[ofs] + values[ofs + 1];
                double d23 = values[ofs + 2] - values[ofs + 3];
                double s23 = values[ofs + 2] + values[ofs + 3];
                double ds0123 = s01 - s23;
                double ss0123 = s01 + s23;
                double dd0123 = d01 - d23;
                double sd0123 = d01 + d23;
                double s45 = values[ofs + 4] + values[ofs + 5];
                double s67 = values[ofs + 6] + values[ofs + 7];
                double d45 = values[ofs + 4] - values[ofs + 5];
                double d67 = values[ofs + 6] - values[ofs + 7];
                double ds4567 = s45 - s67;
                double ss4567 = s45 + s67;
                values[ofs + 4] = ss0123 - ss4567;
                values[ofs] = ss0123 + ss4567;
                values[ofs + 6] = ds0123 - ds4567;
                values[ofs + 2] = ds0123 + ds4567;
                values[ofs + 5] = sd0123 - (d45 *= SQRT2);
                values[ofs + 1] = sd0123 + d45;
                values[ofs + 7] = dd0123 - (d67 *= SQRT2);
                values[ofs + 3] = dd0123 + d67;
                break;
            }
            default: {
                double l2;
                double l1;
                double cas;
                double r2;
                double r1;
                int j2;
                int j1;
                assert (logN > 3);
                int nDiv8 = 1 << logN - 3;
                int nDiv4 = nDiv8 * 2;
                int nDiv2 = nDiv4 * 2;
                SeparableFastHartleyTransform.fhtJavaDoubleMainLoop(context, samples, pos, logN - 1, originalLogN);
                SeparableFastHartleyTransform.fhtJavaDoubleMainLoop(context, samples, pos + nDiv2, logN - 1, originalLogN);
                boolean allAnglesInCache = logN - 1 <= 24;
                double rotationAngle = Math.PI / (double)nDiv2;
                double sin0Half = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN];
                double cos0M1 = -2.0 * sin0Half * sin0Half;
                double sin0 = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN - 1];
                double cos = 1.0 + cos0M1;
                double sin = sin0;
                for (int j = 1; j < nDiv8; ++j) {
                    j1 = ofs + j;
                    j2 = ofs + nDiv2 - j;
                    r1 = values[nDiv2 + j1];
                    r2 = values[nDiv2 + j2];
                    cas = r1 * cos + r2 * sin;
                    l1 = values[j1];
                    values[j1] = l1 + cas;
                    values[nDiv2 + j1] = l1 - cas;
                    cas = r1 * sin - r2 * cos;
                    l2 = values[j2];
                    values[j2] = l2 + cas;
                    values[nDiv2 + j2] = l2 - cas;
                    j1 = ofs + nDiv4 - j;
                    j2 = ofs + nDiv4 + j;
                    r1 = values[nDiv2 + j1];
                    r2 = values[nDiv2 + j2];
                    cas = r1 * sin + r2 * cos;
                    l1 = values[j1];
                    values[j1] = l1 + cas;
                    values[nDiv2 + j1] = l1 - cas;
                    cas = r1 * cos - r2 * sin;
                    l2 = values[j2];
                    values[j2] = l2 + cas;
                    values[nDiv2 + j2] = l2 - cas;
                    if ((j & 0xF) == 15) {
                        if (allAnglesInCache) {
                            int angleIndex = j + 1 >> 4 << 20 - (logN - 1) + 4;
                            cos = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                            sin = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                            continue;
                        }
                        double angle = (double)(j + 1) * rotationAngle;
                        double sinHalf = Math.sin(0.5 * angle);
                        cos = 1.0 - 2.0 * sinHalf * sinHalf;
                        sin = Math.sin(angle);
                        continue;
                    }
                    double temp = cos;
                    cos = cos * cos0M1 - sin * sin0 + cos;
                    sin = sin * cos0M1 + temp * sin0 + sin;
                }
                j1 = ofs + nDiv8;
                j2 = ofs + nDiv2 - nDiv8;
                r1 = values[nDiv2 + j1];
                r2 = values[nDiv2 + j2];
                cas = r1 * HALF_SQRT2 + r2 * HALF_SQRT2;
                l1 = values[j1];
                values[j1] = l1 + cas;
                values[nDiv2 + j1] = l1 - cas;
                cas = r1 * HALF_SQRT2 - r2 * HALF_SQRT2;
                l2 = values[j2];
                values[j2] = l2 + cas;
                values[nDiv2 + j2] = l2 - cas;
                double temp = values[ofs] - values[ofs + nDiv2];
                int n = ofs;
                values[n] = values[n] + values[ofs + nDiv2];
                values[ofs + nDiv2] = temp;
                temp = values[ofs + nDiv4] - values[ofs + nDiv2 + nDiv4];
                int n2 = ofs + nDiv4;
                values[n2] = values[n2] + values[ofs + nDiv2 + nDiv4];
                values[ofs + nDiv2 + nDiv4] = temp;
                if (context == null || (long)pos + (1L << logN) != samples.length()) break;
                context.checkInterruptionAndUpdateProgress(null, logN, originalLogN);
            }
        }
    }

    private static void fhtJavaFloatMultidimensionalMainLoop(ArrayContext context, RealVectorSampleArray.DirectRealFloatVectorSampleArray samples, int pos, int logN, int originalLogN, RealVectorSampleArray.DirectRealFloatVectorSampleArray work) {
        float[] values = samples.samples;
        int step = (int)samples.vectorStep;
        int ofs = pos * step + samples.ofs;
        switch (logN) {
            case 1: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    float temp = values[k] - values[k + step];
                    int n = k;
                    values[n] = values[n] + values[k + step];
                    values[k + step] = temp;
                }
                break;
            }
            case 2: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    float d01 = values[k] - values[k + step];
                    float s01 = values[k] + values[k + step];
                    float d23 = values[k + 2 * step] - values[k + 3 * step];
                    float s23 = values[k + 2 * step] + values[k + 3 * step];
                    values[k] = s01 + s23;
                    values[k + step] = d01 + d23;
                    values[k + 2 * step] = s01 - s23;
                    values[k + 3 * step] = d01 - d23;
                }
                break;
            }
            case 3: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    float d01 = values[k] - values[k + step];
                    float s01 = values[k] + values[k + step];
                    float d23 = values[k + 2 * step] - values[k + 3 * step];
                    float s23 = values[k + 2 * step] + values[k + 3 * step];
                    float ds0123 = s01 - s23;
                    float ss0123 = s01 + s23;
                    float dd0123 = d01 - d23;
                    float sd0123 = d01 + d23;
                    float s45 = values[k + 4 * step] + values[k + 5 * step];
                    float s67 = values[k + 6 * step] + values[k + 7 * step];
                    float d45 = values[k + 4 * step] - values[k + 5 * step];
                    float d67 = values[k + 6 * step] - values[k + 7 * step];
                    float ds4567 = s45 - s67;
                    float ss4567 = s45 + s67;
                    values[k + 4 * step] = ss0123 - ss4567;
                    values[k] = ss0123 + ss4567;
                    values[k + 6 * step] = ds0123 - ds4567;
                    values[k + 2 * step] = ds0123 + ds4567;
                    d45 = (float)((double)d45 * SQRT2);
                    d67 = (float)((double)d67 * SQRT2);
                    values[k + 5 * step] = sd0123 - d45;
                    values[k + step] = sd0123 + d45;
                    values[k + 7 * step] = dd0123 - d67;
                    values[k + 3 * step] = dd0123 + d67;
                }
                break;
            }
            default: {
                int k;
                float l2;
                float l1;
                float cas;
                float r2;
                float r1;
                assert (logN > 3);
                int nDiv8 = 1 << logN - 3;
                int nDiv4 = nDiv8 * 2;
                int nDiv2 = nDiv4 * 2;
                int nDiv8Step = nDiv8 * step;
                int nDiv4Step = nDiv8Step * 2;
                int nDiv2Step = nDiv4Step * 2;
                SeparableFastHartleyTransform.fhtJavaFloatMultidimensionalMainLoop(context, samples, pos, logN - 1, originalLogN, work);
                SeparableFastHartleyTransform.fhtJavaFloatMultidimensionalMainLoop(context, samples, pos + nDiv2, logN - 1, originalLogN, work);
                boolean allAnglesInCache = logN - 1 <= 24;
                double rotationAngle = Math.PI / (double)nDiv2;
                double sin0Half = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN];
                double cos0M1 = -2.0 * sin0Half * sin0Half;
                double sin0 = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN - 1];
                double cos = 1.0 + cos0M1;
                double sin = sin0;
                int j = 1;
                int jStep = step;
                while (j < nDiv8) {
                    int k2;
                    int kMax = k2 + samples.vectorLen;
                    for (k2 = ofs; k2 < kMax; ++k2) {
                        int j1Step1 = k2 + jStep;
                        int j2Step1 = k2 + nDiv2Step - jStep;
                        r1 = values[nDiv2Step + j1Step1];
                        r2 = values[nDiv2Step + j2Step1];
                        cas = (float)((double)r1 * cos + (double)r2 * sin);
                        l1 = values[j1Step1];
                        values[j1Step1] = l1 + cas;
                        values[nDiv2Step + j1Step1] = l1 - cas;
                        cas = (float)((double)r1 * sin - (double)r2 * cos);
                        l2 = values[j2Step1];
                        values[j2Step1] = l2 + cas;
                        values[nDiv2Step + j2Step1] = l2 - cas;
                        j1Step1 = k2 + nDiv4Step - jStep;
                        j2Step1 = k2 + nDiv4Step + jStep;
                        r1 = values[nDiv2Step + j1Step1];
                        r2 = values[nDiv2Step + j2Step1];
                        cas = (float)((double)r1 * sin + (double)r2 * cos);
                        l1 = values[j1Step1];
                        values[j1Step1] = l1 + cas;
                        values[nDiv2Step + j1Step1] = l1 - cas;
                        cas = (float)((double)r1 * cos - (double)r2 * sin);
                        l2 = values[j2Step1];
                        values[j2Step1] = l2 + cas;
                        values[nDiv2Step + j2Step1] = l2 - cas;
                    }
                    if ((j & 0xF) == 15) {
                        if (allAnglesInCache) {
                            int angleIndex = j + 1 >> 4 << 20 - (logN - 1) + 4;
                            cos = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                            sin = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                        } else {
                            double angle = (double)(j + 1) * rotationAngle;
                            double sinHalf = Math.sin(0.5 * angle);
                            cos = 1.0 - 2.0 * sinHalf * sinHalf;
                            sin = Math.sin(angle);
                        }
                    } else {
                        double temp = cos;
                        cos = cos * cos0M1 - sin * sin0 + cos;
                        sin = sin * cos0M1 + temp * sin0 + sin;
                    }
                    ++j;
                    jStep += step;
                }
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    int j1Step = k + nDiv8Step;
                    int j2Step = k + nDiv2Step - nDiv8Step;
                    r1 = values[nDiv2Step + j1Step];
                    r2 = values[nDiv2Step + j2Step];
                    cas = (float)((double)r1 * HALF_SQRT2 + (double)r2 * HALF_SQRT2);
                    l1 = values[j1Step];
                    values[j1Step] = l1 + cas;
                    values[nDiv2Step + j1Step] = l1 - cas;
                    cas = (float)((double)r1 * HALF_SQRT2 - (double)r2 * HALF_SQRT2);
                    l2 = values[j2Step];
                    values[j2Step] = l2 + cas;
                    values[nDiv2Step + j2Step] = l2 - cas;
                    float temp = values[k] - values[k + nDiv2Step];
                    int n = k;
                    values[n] = values[n] + values[k + nDiv2Step];
                    values[k + nDiv2Step] = temp;
                    temp = values[k + nDiv4Step] - values[k + nDiv2Step + nDiv4Step];
                    int n2 = k + nDiv4Step;
                    values[n2] = values[n2] + values[k + nDiv2Step + nDiv4Step];
                    values[k + nDiv2Step + nDiv4Step] = temp;
                }
                if (context == null || (long)(pos + (1 << logN)) != samples.length()) break;
                context.checkInterruptionAndUpdateProgress(null, logN, originalLogN);
            }
        }
    }

    private static void fhtJavaDoubleMultidimensionalMainLoop(ArrayContext context, RealVectorSampleArray.DirectRealDoubleVectorSampleArray samples, int pos, int logN, int originalLogN, RealVectorSampleArray.DirectRealDoubleVectorSampleArray work) {
        double[] values = samples.samples;
        int step = (int)samples.vectorStep;
        int ofs = pos * step + samples.ofs;
        switch (logN) {
            case 1: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    double temp = values[k] - values[k + step];
                    int n = k;
                    values[n] = values[n] + values[k + step];
                    values[k + step] = temp;
                }
                break;
            }
            case 2: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    double d01 = values[k] - values[k + step];
                    double s01 = values[k] + values[k + step];
                    double d23 = values[k + 2 * step] - values[k + 3 * step];
                    double s23 = values[k + 2 * step] + values[k + 3 * step];
                    values[k] = s01 + s23;
                    values[k + step] = d01 + d23;
                    values[k + 2 * step] = s01 - s23;
                    values[k + 3 * step] = d01 - d23;
                }
                break;
            }
            case 3: {
                int k;
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    double d01 = values[k] - values[k + step];
                    double s01 = values[k] + values[k + step];
                    double d23 = values[k + 2 * step] - values[k + 3 * step];
                    double s23 = values[k + 2 * step] + values[k + 3 * step];
                    double ds0123 = s01 - s23;
                    double ss0123 = s01 + s23;
                    double dd0123 = d01 - d23;
                    double sd0123 = d01 + d23;
                    double s45 = values[k + 4 * step] + values[k + 5 * step];
                    double s67 = values[k + 6 * step] + values[k + 7 * step];
                    double d45 = values[k + 4 * step] - values[k + 5 * step];
                    double d67 = values[k + 6 * step] - values[k + 7 * step];
                    double ds4567 = s45 - s67;
                    double ss4567 = s45 + s67;
                    values[k + 4 * step] = ss0123 - ss4567;
                    values[k] = ss0123 + ss4567;
                    values[k + 6 * step] = ds0123 - ds4567;
                    values[k + 2 * step] = ds0123 + ds4567;
                    values[k + 5 * step] = sd0123 - (d45 *= SQRT2);
                    values[k + step] = sd0123 + d45;
                    values[k + 7 * step] = dd0123 - (d67 *= SQRT2);
                    values[k + 3 * step] = dd0123 + d67;
                }
                break;
            }
            default: {
                int k;
                double l2;
                double l1;
                double cas;
                double r2;
                double r1;
                assert (logN > 3);
                int nDiv8 = 1 << logN - 3;
                int nDiv4 = nDiv8 * 2;
                int nDiv2 = nDiv4 * 2;
                int nDiv8Step = nDiv8 * step;
                int nDiv4Step = nDiv8Step * 2;
                int nDiv2Step = nDiv4Step * 2;
                SeparableFastHartleyTransform.fhtJavaDoubleMultidimensionalMainLoop(context, samples, pos, logN - 1, originalLogN, work);
                SeparableFastHartleyTransform.fhtJavaDoubleMultidimensionalMainLoop(context, samples, pos + nDiv2, logN - 1, originalLogN, work);
                boolean allAnglesInCache = logN - 1 <= 24;
                double rotationAngle = Math.PI / (double)nDiv2;
                double sin0Half = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN];
                double cos0M1 = -2.0 * sin0Half * sin0Half;
                double sin0 = RootsOfUnity.LOGARITHMICAL_SINE_CACHE[logN - 1];
                double cos = 1.0 + cos0M1;
                double sin = sin0;
                int j = 1;
                int jStep = step;
                while (j < nDiv8) {
                    int k2;
                    int kMax = k2 + samples.vectorLen;
                    for (k2 = ofs; k2 < kMax; ++k2) {
                        int j1Step1 = k2 + jStep;
                        int j2Step1 = k2 + nDiv2Step - jStep;
                        r1 = values[nDiv2Step + j1Step1];
                        r2 = values[nDiv2Step + j2Step1];
                        cas = r1 * cos + r2 * sin;
                        l1 = values[j1Step1];
                        values[j1Step1] = l1 + cas;
                        values[nDiv2Step + j1Step1] = l1 - cas;
                        cas = r1 * sin - r2 * cos;
                        l2 = values[j2Step1];
                        values[j2Step1] = l2 + cas;
                        values[nDiv2Step + j2Step1] = l2 - cas;
                        j1Step1 = k2 + nDiv4Step - jStep;
                        j2Step1 = k2 + nDiv4Step + jStep;
                        r1 = values[nDiv2Step + j1Step1];
                        r2 = values[nDiv2Step + j2Step1];
                        cas = r1 * sin + r2 * cos;
                        l1 = values[j1Step1];
                        values[j1Step1] = l1 + cas;
                        values[nDiv2Step + j1Step1] = l1 - cas;
                        cas = r1 * cos - r2 * sin;
                        l2 = values[j2Step1];
                        values[j2Step1] = l2 + cas;
                        values[nDiv2Step + j2Step1] = l2 - cas;
                    }
                    if ((j & 0xF) == 15) {
                        if (allAnglesInCache) {
                            int angleIndex = j + 1 >> 4 << 20 - (logN - 1) + 4;
                            cos = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[524288 - angleIndex] : -RootsOfUnity.SINE_CACHE[angleIndex - 524288];
                            sin = angleIndex < 524288 ? RootsOfUnity.SINE_CACHE[angleIndex] : RootsOfUnity.SINE_CACHE[0x100000 - angleIndex];
                        } else {
                            double angle = (double)(j + 1) * rotationAngle;
                            double sinHalf = Math.sin(0.5 * angle);
                            cos = 1.0 - 2.0 * sinHalf * sinHalf;
                            sin = Math.sin(angle);
                        }
                    } else {
                        double temp = cos;
                        cos = cos * cos0M1 - sin * sin0 + cos;
                        sin = sin * cos0M1 + temp * sin0 + sin;
                    }
                    ++j;
                    jStep += step;
                }
                int kMax = k + samples.vectorLen;
                for (k = ofs; k < kMax; ++k) {
                    int j1Step = k + nDiv8Step;
                    int j2Step = k + nDiv2Step - nDiv8Step;
                    r1 = values[nDiv2Step + j1Step];
                    r2 = values[nDiv2Step + j2Step];
                    cas = r1 * HALF_SQRT2 + r2 * HALF_SQRT2;
                    l1 = values[j1Step];
                    values[j1Step] = l1 + cas;
                    values[nDiv2Step + j1Step] = l1 - cas;
                    cas = r1 * HALF_SQRT2 - r2 * HALF_SQRT2;
                    l2 = values[j2Step];
                    values[j2Step] = l2 + cas;
                    values[nDiv2Step + j2Step] = l2 - cas;
                    double temp = values[k] - values[k + nDiv2Step];
                    int n = k;
                    values[n] = values[n] + values[k + nDiv2Step];
                    values[k + nDiv2Step] = temp;
                    temp = values[k + nDiv4Step] - values[k + nDiv2Step + nDiv4Step];
                    int n2 = k + nDiv4Step;
                    values[n2] = values[n2] + values[k + nDiv2Step + nDiv4Step];
                    values[k + nDiv2Step + nDiv4Step] = temp;
                }
                if (context == null || (long)(pos + (1 << logN)) != samples.length()) break;
                context.checkInterruptionAndUpdateProgress(null, logN, originalLogN);
            }
        }
    }
}

