/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.stitching;

import java.util.Objects;
import net.algart.math.IPoint;
import net.algart.math.Point;
import net.algart.math.RectangularArea;
import net.algart.math.functions.LinearOperator;
import net.algart.matrices.stitching.FramePosition;
import net.algart.matrices.stitching.UniversalFramePosition;

public final class ShiftFramePosition
extends UniversalFramePosition
implements FramePosition {
    ShiftFramePosition(RectangularArea area) {
        super(area, LinearOperator.getShiftInstance(area.min().symmetric().coordinates()));
    }

    public static ShiftFramePosition of(Point offset, long ... dimensions) {
        Objects.requireNonNull(offset, "Null offset argument");
        Objects.requireNonNull(dimensions, "Null dimensions argument");
        return new ShiftFramePosition(ShiftFramePosition.area(offset, dimensions));
    }

    public static ShiftFramePosition of(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        return new ShiftFramePosition(area);
    }

    public static RectangularArea area(Point offset, long[] dimensions) {
        return RectangularArea.of(offset, offset.add(IPoint.of(dimensions).toPoint()));
    }

    @Override
    public String toString() {
        return "shift frame position " + String.valueOf(this.area());
    }
}

