export function buildByteArray(dimX, dimY, numberOfChannels) {
    console.log("-- buildByteArray: " + dimX + "x" + dimY + "x" + numberOfChannels)
    // let arr = new (Java.type('byte[]'))(dimX * dimY * numberOfChannels)
    // - slow version
    const arr = new Int8Array(dimX * dimY * numberOfChannels)
    const multX = 255.0 / (dimX - 1);
    const multY = 255.0 / (dimY - 1);
    for (let y = 0, index = 0; y < dimY; y++) {
        for (let x = 0; x < dimX; x++, index += numberOfChannels) {
            let r = Math.floor(x  * multX);
            let g = Math.floor(y * multY);
            if (r > 127) r -= 256;
            if (g > 127) g -= 256;
            let b = 0;
            arr[index] = b;
            if (numberOfChannels >= 2) arr[index + 1] = g;
            if (numberOfChannels >= 3) arr[index + 2] = r;
        }
    }
    return arr;
}

export function buildMat(dimX, dimY, numberOfChannels) {
    dimX = !dimX ? 1000 : parseInt(dimX)
    dimY = !dimY ? 1000 : parseInt(dimY)
    numberOfChannels = numberOfChannels == null ? 3 : parseInt(numberOfChannels)
    console.log("-- buildMat: " + dimX + "x" + dimY + "x" + numberOfChannels)
    let SMatC = Java.type('net.algart.executors.api.data.SMat')
    let mat = new SMatC()
    console.log("New SMat: " + mat)
    let arr = buildByteArray(dimX, dimY, numberOfChannels);
    mat.setAll2DBytes(dimX, dimY, numberOfChannels, arr);
    console.log("-- Filled SMat: " + mat)
    return mat;
}

export function execute(params, inputs, outputs) {
    outputs.m1 = buildMat(params.a, params.b, 3)
    return "Hello, see results in \"m1\" output"
}

