# Made by ChatGPT
import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d.art3d import Poly3DCollection
from matplotlib.backends.backend_agg import FigureCanvasAgg as FigureCanvas

def make_dodecahedron(angle_x=0, angle_y=0, angle_z=0, img_size=400, alpha=0.9):
    angle_x = float(angle_x)
    angle_y = float(angle_y)
    angle_z = float(angle_z)
    phi = (1 + np.sqrt(5)) / 2.0

    verts = np.array([
        ( 1/phi,  0.0,   phi), (-1/phi,  0.0,   phi),
        ( 1.0,    1.0,   1.0), (-1.0,   1.0,   1.0),
        (-1.0,   -1.0,   1.0), ( 1.0,  -1.0,   1.0),
        ( 0.0,    phi,  1/phi), ( 0.0,   -phi,  1/phi),
        ( phi,  1/phi,   0.0), (-phi,  1/phi,   0.0),
        (-phi, -1/phi,   0.0), ( phi, -1/phi,   0.0),
        ( 0.0,    phi, -1/phi), ( 0.0,   -phi, -1/phi),
        ( 1.0,    1.0,  -1.0), (-1.0,   1.0,  -1.0),
        (-1.0,  -1.0,  -1.0), ( 1.0,  -1.0,  -1.0),
        ( 1/phi,  0.0,  -phi), (-1/phi,  0.0,  -phi),
    ], dtype=float)

    faces = [
        (0, 2, 6, 3, 1),
        (0, 1, 4, 7, 5),
        (0, 5, 11, 8, 2),
        (2, 8, 14, 12, 6),
        (3, 6, 12, 15, 9),
        (1, 3, 9, 10, 4),
        (4, 10, 16, 13, 7),
        (5, 7, 13, 17, 11),
        (8, 11, 17, 18, 14),
        (12, 14, 18, 19, 15),
        (9, 15, 19, 16, 10),
        (13, 16, 19, 18, 17),
    ]

    ax = np.radians(angle_x)
    ay = np.radians(angle_y)
    az = np.radians(angle_z)

    Rx = np.array([[1, 0, 0],
                   [0, np.cos(ax), -np.sin(ax)],
                   [0, np.sin(ax),  np.cos(ax)]])
    Ry = np.array([[ np.cos(ay), 0, np.sin(ay)],
                   [0, 1, 0],
                   [-np.sin(ay), 0, np.cos(ay)]])
    Rz = np.array([[np.cos(az), -np.sin(az), 0],
                   [np.sin(az),  np.cos(az), 0],
                   [0, 0, 1]])
    R = Rz @ Ry @ Rx
    verts_rot = (R @ verts.T).T

    dpi = 100
    fig = plt.figure(figsize=(img_size / dpi, img_size / dpi), dpi=dpi)
    fig.patch.set_alpha(0.0)  # transparent
    canvas = FigureCanvas(fig)
    ax3 = fig.add_subplot(111, projection='3d')
    ax3.set_facecolor((0, 0, 0, 0))

    poly_verts = [[verts_rot[idx] for idx in face] for face in faces]

    # Calculation of normals and setting the color according to the direction of normals
    # (illumination imitation)
    face_colors = []
    for face in poly_verts:
        v1, v2, v3 = np.array(face[0]), np.array(face[1]), np.array(face[2])
        normal = np.cross(v2 - v1, v3 - v1)
        normal /= np.linalg.norm(normal)
        intensity = 0.3 + 0.7 * max(0, normal[2])
        color = (1.0 * intensity, 1.0 * intensity, 0.0 * intensity, alpha)
        # R, G, B, Alpha: yellow
        face_colors.append(color)

    collection = Poly3DCollection(poly_verts, linewidths=0.8, edgecolors='k', alpha=alpha)
    collection.set_facecolor(face_colors)
    ax3.add_collection3d(collection)

    scale = verts_rot.flatten()
    ax3.auto_scale_xyz(scale, scale, scale)
    ax3.set_box_aspect([1,1,1])
    ax3.set_axis_off()
    plt.subplots_adjust(left=0, right=1, bottom=0, top=1)
    fig.canvas.draw()

    width, height = fig.canvas.get_width_height()
    rgba = np.frombuffer(fig.canvas.buffer_rgba(), dtype=np.uint8).reshape((height, width, 4))
    plt.close(fig)

    # RGBA -> BGRA
    bgra = rgba[:, :, [2,1,0,3]].copy()
    return bgra

def execute(params, inputs, outputs):
    outputs.m1 = make_dodecahedron(params.a, params.b, params.c)
    return "Hello! figure is in m1"


# Example
if __name__ == "__main__":
    img = make_dodecahedron(30, 30, 30)
    from PIL import Image
    Image.fromarray(img).show()
