import numpy as np
from PIL import Image, ImageDraw

# Made by ChatGPT
def make_spiral_3d_pillow(angle_x=0, angle_y=0, angle_z=0, img_size=600):
    angle_x = float(angle_x)
    angle_y = float(angle_y)
    angle_z = float(angle_z)

    ax, ay, az = np.deg2rad([angle_x, angle_y, angle_z])

    t = np.linspace(9, 13, 400)
    growth_rate = 0.4
    radius = np.exp(growth_rate * t)
    x = radius * np.cos(2 * np.pi * t)
    y = radius * np.sin(2 * np.pi * t)
    z = t - 2
    points = np.vstack([x, y, z]).T

    Rx = np.array([
        [1, 0, 0],
        [0, np.cos(ax), -np.sin(ax)],
        [0, np.sin(ax), np.cos(ax)]
    ])

    Ry = np.array([
        [np.cos(ay), 0, np.sin(ay)],
        [0, 1, 0],
        [-np.sin(ay), 0, np.cos(ay)]
    ])

    Rz = np.array([
        [np.cos(az), -np.sin(az), 0],
        [np.sin(az), np.cos(az), 0],
        [0, 0, 1]
    ])

    R = Rz @ Ry @ Rx
    points_rot = points @ R.T

    d = 10
    z_shift = points_rot[:, 2].min()
    zs = points_rot[:, 2] - z_shift + 1e-5

    proj_x = (points_rot[:, 0] * d) / (d + zs)
    proj_y = (points_rot[:, 1] * d) / (d + zs)

    proj_points = np.vstack([proj_x, proj_y]).T

    margin = 40
    min_xy = proj_points.min(axis=0)
    max_xy = proj_points.max(axis=0)
    scale = (img_size - 2 * margin) / (max_xy - min_xy).max()
    proj_points_scaled = (proj_points - min_xy) * scale + margin

    img = Image.new("RGB", (img_size, img_size), (255, 255, 255))
    draw = ImageDraw.Draw(img)

    for i in range(len(proj_points_scaled) - 1):
        p1 = tuple(proj_points_scaled[i])
        p2 = tuple(proj_points_scaled[i+1])

        thickness = int(5 * (1 - (zs[i] - zs.min()) / (zs.max() - zs.min()))) + 1
        blue_intensity = int(255 * (1 - (zs[i] - zs.min()) / (zs.max() - zs.min())))
        color = (30, 60, max(100, blue_intensity))

        draw.line([p1, p2], fill=color, width=thickness)

    # Convert Pillow image to numpy array
    image_array = np.array(img)
    return image_array

def execute(params, inputs, outputs):
    outputs.m1 = make_spiral_3d_pillow(params.a, params.b, params.c)
    return "Hello! figure is in m1"

# Example usage:
if __name__ == "__main__":
    img_np = make_spiral_3d_pillow(30, 20, 10)
    # Now img_np is numpy array (H,W,3), can be used in OpenCV etc.
    from PIL import Image
    Image.fromarray(img_np).save("spiral_3d_pillow.png")
