@echo off
rem =========================================================================================================
rem Starts the server part of SciChains using your own Python and Java installations:
rem     - your Java installation (such as Oracle GraalVM or another JDK) instead of the built-in "jdk" folder
rem     - your Python installation instead of the built-in "python" folder
rem =========================================================================================================

rem The following call starts the SciChains server with:
rem     - JDK specified by the JAVA_HOME system variable; if not set ("--jdk="), the built-in JDK will be used
rem     - Python specified by the PYTHONHOME system variable; if not set, Python will be UNAVAILABLE

cmd /C ""%~dp0bin\start-server.cmd" -x "--jdk=%JAVA_HOME%" "--python=" "-Dnet.algart.jep.numpyIntegrationRequired=false" %*"

rem You may edit this line and directly specify the path to your JDK or Python installation, for example:
rem
rem     cmd /C ""%~dp0bin\start-server.cmd" -x "--jdk=C:\Program Files\Java\jdk-24" %*"
rem     [ custom JDK at "C:\Program Files\Java\jdk-24", default Python ]
rem
rem     cmd /C ""%~dp0bin\start-server.cmd" -x "--python=%LOCALAPPDATA%\Programs\Python\Python313" %*"
rem     [ default JDK, custom Python at <your_user_directory>\AppData\Local\Programs\Python\Python313 ]
rem
rem     cmd /C ""%~dp0bin\start-server.cmd" -x "--python=" %*"
rem     [ default JDK, custom Python defined by the PYTHONHOME environment variable 
rem       this is the default behavior when the "python" argument is an empty string (i.e. "--python=") ]
rem
rem The -x flag is optional: it enables additional features for developers or administrators (see start-server-x.cmd).

rem IMPORTANT! Before using Python with SciChains, you MUST install 
rem the following Python packages, typically by running these commands:
rem
rem python -m pip install --upgrade pip setuptools wheel numpy
rem python -m pip install opencv-python scipy pandas openpyxl imageio pillow requests lxml matplotlib seaborn
rem python -m pip install --no-cache-dir --force-reinstall --no-build-isolation jep
rem
rem The "jep" package is required for Java integration. For details, see: https://github.com/ninia/jep
rem The "numpy" package is also required, and it MUST be installed BEFORE "jep" to ensure proper integration.
rem The libraries listed in the last line ("opencv-python", "scipy", etc.) are recommended for use with SciChains.
rem Note: functions using "matplotlib" and "seaborn" should be used ONLY in the "JVM-global" interpretation mode.
rem
rem Before installing "jep", make sure the JAVA_HOME environment variable points to a valid JDK installation.

rem Note: the "--python=" argument (or the equivalent "-Dpython.home=" with a trailing "=") removes the system property 
rem defined in conf/jvm.json and forces SciChains to use the PYTHONHOME environment variable instead.

rem Note: the "-Dnet.algart.jep.numpyIntegrationRequired=false" option relaxes the requirements for "jep"/"numpy" integration: 
rem even if they are installed in the wrong order, SciChains will still use Python, 
rem although some Python-based functions may not work correctly. 
rem When using the built-in Python (from the "python" folder), this property should be set to true (default value). 

rem Note: double quotes in the "cmd /C..." call are required to ensure that "-Dkey=value" options are passed as a single argument, 
rem because the '=' character may otherwise cause incorrect argument splitting by cmd.exe.
